<?php

// Don't use this for these url's:
// ftp.kuehne-nagel.com
// mft.kuehne-nagel.com


class Ftp
{
    /** @var string $ftpName */
    private $ftpName;

    /** @var string $proxyUrl */
    private $proxyUrl = 'https://hktkosl291.int.kn:8443/';

    /** @var array $curlOptions */
    private $curlOptions = [];

    public function __construct(array $params)
    {
        $this->ftpName = $params['ftpName'];
        $this->ci = & get_instance();
    }

    /**
     * Upload to the given path.
     *
     * @param $destinationPath
     * @param $localPath
     * @param bool $binaryMode
     * @return bool|string
     */
    public function upload($destinationPath, $localPath, $binaryMode = true)
    {
        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' initialized upload from "' . $localPath . '" to "' . $destinationPath . '"');

        $response = $this->handleRequest(
            $this
                ->getDefaultCurlOptions('upload', 'POST')
                ->addCurlOption(CURLOPT_POSTFIELDS, [
                    'fileName' => $destinationPath,
                    'file' => new CURLFile($localPath),
                    'ftpName' => $this->ftpName,
                    'binaryMode' => $binaryMode ? 'yes' : 'no'
                ])
                ->getCurlOptions()
        );

        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' upload completed from "' . $localPath . '" to "' . $destinationPath . '"');

        return $response;
    }

    /**
     * Download from the given path.
     *
     * @param $destinationPath
     * @return bool|string
     */
    public function download($destinationPath)
    {
        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' initialized download from "' . $destinationPath . '"');

        $response = $this->handleRequest($this->getDefaultCurlOptions(
            'download/' . $this->ftpName . '?binaryMode=true&fileName=' . $destinationPath,
            'GET'
        )->getCurlOptions());

        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' download completed from "' . $destinationPath . '"');

        return $response;
    }

    /**
     * Delete the given path.
     *
     * @param $destinationPath
     * @return bool|string
     */
    public function delete($destinationPath)
    {
        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' initialized delete from "' . $destinationPath . '"');

        $response = $this->handleRequest($this->getDefaultCurlOptions(
            'delete/' . $this->ftpName . '?fileName=' . $destinationPath,
            'DELETE'
        )->getCurlOptions());

        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' delete completed from "' . $destinationPath . '"');

        return $response;
    }

    /**
     * Retrieve a file list for the given path.
     *
     * @param $destinationPath
     * @return bool|string
     */
    public function retrieveList($destinationPath)
    {
        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' initialized retrieveList from "' . $destinationPath . '"');

        $response = $this->handleRequest($this->getDefaultCurlOptions(
            'list/' . $this->ftpName . '?fileName=' . $destinationPath,
            'GET'
        )->getCurlOptions());

        log_message('error', 'User ' . $this->ci->session->userdata['user_id'] . ' retrieveList completed from "' . $destinationPath . '"');

        return $response;
    }

    /**
     * Handle the cURL request.
     *
     * @param array $options Options for cURL request
     * @return bool|string
     * @throws Exception
     */
    private function handleRequest(array $options)
    {
        $curl = curl_init();
        curl_setopt_array($curl, $options);

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            throw new Exception(curl_error($curl), curl_getinfo($curl, CURLINFO_HTTP_CODE));
        } elseif (isset($response['error'])) {
            throw new Exception('Something went wrong: ' . $response['error'], $response['status']);
        } elseif ($response === 'false' || $response === false) {
            throw new Exception('Something went wrong: Server responded with false');
        }

        if (json_decode($response, true) === null) {
            $response = ['body' => $response];
        } else {
            $response = json_decode($response, true);
        }

        return $response;
    }

    /**
     * Set and retrieve default cURL options.
     *
     * @param string $urlPath The url path for the request
     * @param string $customRequest Should be one of: "GET", "DELETE" or "POST"
     * @return $this
     */
    private function getDefaultCurlOptions(string $urlPath, string $customRequest): Ftp
    {
        $this->curlOptions = [
            CURLOPT_URL => $this->proxyUrl . $urlPath,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => $customRequest
        ];

        return $this;
    }

    /**
     * Adds to the existing array of $this->curlOptions
     *
     * @param mixed $key The key of the cURL option
     * @param mixed $value The value of the cURL option
     * @return $this
     */
    private function addCurlOption($key, $value): Ftp
    {
        $this->curlOptions = $this->curlOptions + [$key => $value];

        return $this;
    }

    /**
     * Getter for $this->curloptions
     *
     * @return array
     */
    private function getCurlOptions(): array
    {
        return $this->curlOptions;
    }
}
