<?php 

class Allroundbigreportmodel extends CI_Model
{

  function __construct() 
  {
      parent::__construct();
  }
  
  public function getorderdata($userid,$searchsts,$custid,$countryuids,$whr,$subcusts,$searchids = array())
  {
    $result = array();
    $this->db->select("o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,o.createdon,d.delivery_note,d.department_code, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.volumetric_weight Else 0 End) as totvweight,o.pickup_address1,o.delivery_address1,o.pickup_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_country,o.delivery_pincode,o.pickup_company,o.delivery_company,o.pickup_address2,o.delivery_address2,o.vendor_id,o.shipmentid,o.goods_value,o.product,o.customer_id,d.service,d.incoterm,d.delivery_term,d.delivery_note,d.order_type,d.purchase_order,d.docs_received_datetime,d.docs_sent_datetime");
    $this->db->from("tb_orders o");
    $this->db->join("tb_order_details d","o.id=d.order_row_id","LEFT");
    $this->db->join("tb_order_cargodetails c","o.id=c.order_id","LEFT");
    $this->db->where("o.status !=",0);
    if(!empty($searchids)){
      $this->db->where_in("o.order_id",$searchids);
    }
    if($userid != '0'){
      if(!empty($countryuids)){
      $this->db->where_in("o.user_id",$countryuids);
      }else{
        $this->db->where("o.user_id",$userid);
      }
    }
    if($searchsts == 'PENDING'){
      $this->db->where("o.trip_id",0);
    }

    if($searchsts == 'ACTIVE'){
      $this->db->where("o.trip_id !=",0);
      $this->db->where("o.trip_sts",0);
    }

    if($searchsts == 'CLOSED'){
      $this->db->where("o.trip_id !=",0);
      $this->db->where("o.trip_sts",1);
    }

    if(!empty($subcusts)){
        $this->db->where_in("o.customer_id",$subcusts);
    } else { 
        if($custid != ""){
          $this->db->where('o.customer_id',$custid);
        }
    }

    $this->db->where($whr);
    $this->db->group_by("o.id");
    $this->db->order_by("o.createdon",'DESC');
    $getorder = $this->db->get();
    if($getorder->num_rows() >0){
      $result = $getorder->result_array();
    }
    return $result;
  }

  public function getvasdata($order_id)
  {
    $result = array();
    $this->db->select('vs.vas_name,vs.vas_id,v.quantity');
    $this->db->from('tb_order_vas v');
    $this->db->join('tb_vas_master vs','vs.id=v.vas_id','LEFT');
    $this->db->where('v.order_id',$order_id);
    $this->db->where('v.status',1);
    $this->db->group_by('v.id');
    $this->db->order_by("v.id",'DESC');
    $res = $this->db->get();
    if($res->num_rows() >0){
      $result = $res->result_array();
    }
    return $result;
  }

  public function get_revenue_amount($type,$order_id,$invoice_status)
  {
    $result = array();
    $this->db->select('sum(amount) as total_amount');
    $this->db->from('tb_reveneus');
    $this->db->where('order_id',$order_id);
    $this->db->where('status',1);
    $this->db->where('type',$type);
    $this->db->where('invoice_status',$invoice_status);
    $this->db->order_by("id",'DESC');
    $res = $this->db->get();
    if($res->num_rows() >0){
      $result = $res->row_array();
    }
    return $result;
  }
   public function getchargesbyordid($order_id,$type){
    $result = array();
    $this->db->select("c.*,cc.charge_code as chargecode,cc.name as chargecodename");
    $this->db->from("tb_charges c");
    $this->db->join("tb_reveneus r", "c.revenue_id=r.id", "INNER");
    $this->db->join("tb_charge_codes cc", "c.charge_code=cc.id", "INNER");
    $this->db->where("r.order_id", $order_id);
    $this->db->where("r.type", $type);
    $this->db->where("r.status", 1);
    $this->db->where("c.status", 1);
    $getcharges = $this->db->get();
    if($getcharges->num_rows() > 0){
      $result = $getcharges->result_array();
    }
    return $result;
  }

}