<?php

class AmChartModel extends CI_Model
{
    public function getPendingOrders(array $yearInfo, array $where): int
    {
        $this->db->select("COUNT(*) as orders_count");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        $wherePending = "(`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0)";
        $this->db->where($wherePending);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("status !=", 0);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->orders_count : 0;
    }

    public function getActiveOrders(array $yearInfo, array $where): int
    {
        $this->db->select("COUNT(*) as orders_count");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        $wherePending = "(o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0))";
        $this->db->where($wherePending);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.trip_sts ", 0);
        $this->db->where("status !=", 0);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->orders_count : 0;
    }

    public function getDeliveryTypeOrder(array $yearInfo, array $where): array
    {
        $this->db->select("(CASE WHEN o.`drop_endtime`<tss.`createdon` THEN 'Delayed' ELSE 'OnTime' END) AS OrderType, COUNT(*) AS order_count");
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status tss", "o.id = tss.order_id", "INNER");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        $this->db->where("tss.stop_type", "D");
        $this->db->where("tss.status_id", 1);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }
        $this->db->group_by('OrderType');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getPodNotAvailableOrders(array $yearInfo, array $where): array
    {
        $this->db->select("(CASE WHEN tpd.doc_type=3  THEN 'POD' ELSE 'NOPOD' END) AS PODtype,COUNT(*) AS order_count");
        $this->db->from("tb_orders o");
        $this->db->join("tb_pod_uploads tpd", "tpd.order_id=o.id", "INNER");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }

        $this->db->group_by('PODtype');
        $getResult = $this->db->get();

        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getActiveBookingsCount(string $whr): int
    {
        $query = $this->db->query("SELECT e.order_id FROM tb_orders e WHERE e.status!=? AND (e.trip_id!=? OR (e.trip_id=? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=e.order_id)>?)) AND e.trip_sts=? $whr GROUP BY e.order_id",[0,0,0,0,0]);
        return !empty($query) ? $query->num_rows() : 0;
    }

    public function getPendingBookingCount(string $whr): int
    {
        $query = $this->db->query("SELECT e.id FROM tb_orders e WHERE e.status!=? AND e.trip_id=? AND (e.`trip_id` =? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=e.order_id) =?) AND e.trip_sts=? $whr GROUP BY e.order_id",[0,0,0,0,0]);
        return !empty($query) ? $query->num_rows() : 0;
    }

    public function getCompletedBookingCount(string $whr): int
    {
        $query = $this->db->query("SELECT e.id FROM tb_orders e WHERE e.trip_sts=? $whr",[1]);
        return !empty($query) ? $query->num_rows() : 0;
    }

    public function getMapVechicles(int $where): array
    {
        $this->db->select("d.id, d.name, t.id as vehicle_id,t.register_number, tr.id as trip_id");
        $this->db->from("tb_shifts s");
        $this->db->join("tb_trips tr", "tr.shift_id = s.id", "INNER");
        $this->db->join("tb_trucks_data t", "t.id = tr.vehicle_id", "LEFT");
        $this->db->join("tb_truck_drivers d", "d.id = tr.driver_id", "LEFT");
        $this->db->where("s.customer_id", $where);
        $this->db->where("s.status",1);
        $this->db->where("tr.status",1);
        $this->db->where("t.status","Active");
        $this->db->group_by('t.id');
        $this->db->order_by('t.register_number');
        $query=$this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getLatLongData(int $whr): array
    {
        $this->db->select("o.id,o.order_id as orderid,o.plat as latitude,o.plng as longitude,o.trip_sts");
        $this->db->from("tb_orders o");
        $where = "o.customer_id IN (" . $whr . ") AND o.trip_id=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.status!=0 AND o.trip_sts=0 AND o.plat!='' AND o.plng!=''";
        $this->db->where($where);
        $this->db->group_by('o.order_id');
        $this->db->order_by('o.pickup_datetime', 'DESC');
        $results = $this->db->get();
        return $results->num_rows() > 0 ? $results->result_array() : [];
    }
}
