<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Amazonexceldtomodel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('Log');
    }

    public function checkOrder(string $containerNumber, string $sourceCode, string $destinationCode): int
    {
        $shipperInfo = $this->getPartyDetails($sourceCode);
        $consigneeInfo = $this->getPartyDetails($destinationCode);
        $getBookingId = $this->db->query("SELECT o.id FROM tb_orders o INNER JOIN tb_order_references tor ON tor.order_id=o.id WHERE o.pickup_custid=? AND o.pickup_partyid=? AND o.drop_custid=? AND o.drop_partyid=? AND (tor.reference_id=? AND tor.ref_value = ? AND tor.status=1) GROUP BY o.id DESC LIMIT 1", [$shipperInfo['id'], $shipperInfo['id'], $consigneeInfo['id'], $consigneeInfo['id'], "CTR", $containerNumber]);
        return $getBookingId->num_rows() > 0 ? $getBookingId->row()->id : 0;
    }

    public function checkOrderType(string $orderType, string $company_code, string $branch_code): string
    {
        $getOrderType = $this->common->gettblrowdata(
            [
                'type_name' => $orderType,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1,
            ],
            'id',
            'tb_order_types',
            0,
            0
        );
        return $getOrderType['id'] ?? "";
    }

    public function checkModeOfTransport(string $modeOfTransport): string
    {
        $modeOfTransport = $this->common->gettblrowdata(
            ['code' => $modeOfTransport, 'status' => 1],
            'code',
            'tb_transportmode',
            0,
            0
        );
        return $modeOfTransport['code'] ?? "";
    }

    public function checkProduct(string $product): string
    {
        $productRes = $this->common->gettblrowdata(
            ['name' => $product, 'status' => 1],
            'name',
            'tb_products_master',
            0,
            0
        );
        return $productRes['name'] ?? "";
    }

    public function checkServiceType(string $serviceType): string
    {
        $serviceTypeRes = $this->common->gettblrowdata(
            ['name' => $serviceType, 'status' => 1],
            'id',
            'tb_service_master',
            0,
            0
        );
        return $serviceTypeRes['id'] ?? "";
    }

    public function getBranchCompanyCodes(string $logicalReceiver): array
    {
        $checkBranchCompanyCodes = $this->db->select("branch_code,company_code")->get_where(
            "tb_branch_master",
            [
                "logical_sender" => $logicalReceiver,
                "status" => 1
            ],
            1,
            0
        );
        return $checkBranchCompanyCodes->num_rows() > 0 ? $checkBranchCompanyCodes->row_array() : [];
    }

    public function getUserId(array $orderData): int
    {
        $ci =& get_instance();
        $currentDate = date('Y-m-d H:i:s');
        $company_code = $orderData['company_code'];
        $branch_code = $orderData['branch_code'];
        $logicalReceiver = $orderData['logicalReceiver'];
        $logicalSender = $orderData['logicalSender'];
        if (strlen($logicalSender) > 2) {
            $firstTwoChars = substr($logicalSender, 0, 2);
        } else {
            $firstTwoChars = $logicalSender;
        }
        if ($logicalReceiver != "") {
            $checkBranchCompanyCodes = $this->getBranchCompanyCodes($logicalReceiver);
            if (!empty($checkBranchCompanyCodes)) {
                $company_code = $checkBranchCompanyCodes['company_code'];
                $branch_code = $checkBranchCompanyCodes['branch_code'];
            }
        }
        $checkUser = $ci->db->query(
            "SELECT id FROM tb_users WHERE company_code=? AND branch_code=? AND status='Active' LIMIT 1", [$company_code, $branch_code]
        );
        if ($checkUser->num_rows() > 0) {
            $userId = $checkUser->row()->id;
        } else {
            $checkUserCompany = $ci->db->query(
                "SELECT user_id FROM tb_user_companies WHERE company_code=? AND branch_code=? AND status=1 LIMIT 1", [$company_code, $branch_code]
            );
            if ($checkUserCompany->num_rows() > 0) {
                $userId = $checkUserCompany->row()->user_id;
            } else {
                $adminPhone = time();
                $adminPassword = password_hash($adminPhone,PASSWORD_DEFAULT);
                $userData = [
                    'country_code' => $firstTwoChars,
                    'name' => $firstTwoChars . "_Admin",
                    'company_indv_name' => $company_code,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminPhone,
                    'password' => $adminPassword,
                    'emailid' => 'svkonekt@kuehne-nagel.com',
                    'domain_name' => $branch_code,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => $currentDate,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                ];
                $userId = $ci->common->insertTableData('tb_users', $userData);
            }
        }
        return $userId ?? 0;
    }

    public function getcustomerId(string $customerCode): int
    {
        $getCustomer = $this->db->select("id")->get_where("tb_customers", ["code" => $customerCode, "status" => 1], 1, 0);
        return $getCustomer->num_rows() > 0 ? $getCustomer->row()->id : 0;
    }

    public function getPartyDetails(string $partyCode): array
    {
        $getCustomer = $this->db->select("id,name,email,mobile,code,location_id,address,country,state,street,pincode,latitude,longitude")->get_where("tbl_party_master", ["code" => $partyCode, "status" => 1], 1, 0);
        return $getCustomer->num_rows() > 0 ? $getCustomer->row_array() : [];
    }

    public function getUserTimeZone(int $user_id): string
    {
        $checkUser = $this->db->query("SELECT country_code FROM tb_users WHERE id=? AND status='Active' LIMIT 1", [$user_id]);
        if ($checkUser->num_rows() > 0) {
            $country_code = $checkUser->row()->country_code;
            $getqry = $this->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE (country_code=? OR country_name=?) AND status=1 LIMIT 1", [$country_code, $country_code]);
            if ($getqry && $getqry->num_rows() > 0) {
                $timeZone = $getqry->row()->cntry_timezone;
            } else {
                throw new RuntimeException("login user's timezone is undefined.");
            }
        }
        return $timeZone ?? "Asia/Singapore";
    }

    public function generateOrderBookingId(int $order_id, int $user_id): string
    {
        $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
        $country_code = $get_country->row()->country_code;
        $company_code = $get_country->row()->company_code;
        $genord = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
        return generatebookingid($genord);
    }

    public function getBookingId(int $orderId): int
    {
        $getBookingId = $this->db->select("order_id")->get_where("tb_orders", ["id" => $orderId], 1, 0);
        return $getBookingId->num_rows() > 0 ? $getBookingId->row()->order_id : 0;
    }

    public function getTransportModeName(string $modeOfTransport): array
    {
        $modeOfTransportName = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE  ?", [$modeOfTransport]);
        return $modeOfTransportName->num_rows() > 0 ? $modeOfTransportName->row_array() : [];
    }

    public function checkOrderDetails(int $orderId, int $bookingId): int
    {
        $checkOrderDetails = $this->db->select("id")->get_where("tb_order_details", ["order_row_id" => $orderId, "order_id" => $bookingId, "status" => 1], 1, 0);
        return $checkOrderDetails->num_rows() ?? 0;
    }

    public function insertCargoInfo(array $orderCargo, int $order_id, int $user_id): int
    {
        $cargoType = is_array($orderCargo['CargoType']) ? "" : $orderCargo['CargoType'];
        $GoodsDescription = is_array($orderCargo['GoodsDescription']) ? "" : $orderCargo['GoodsDescription'];
        $MarksandNumbers = is_array($orderCargo['MarksandNumbers']) ? "" : $orderCargo['MarksandNumbers'];
        $ValueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "" : $orderCargo['ValueOfGoods'];
        $HandlingUnit = is_array($orderCargo['HandlingUnit']) ? "" : $orderCargo['HandlingUnit'];
        $LengthValue = is_array($orderCargo['Length']['Value']) ? "" : $orderCargo['Length']['Value'];
        $LengthUom = is_array($orderCargo['Length']['UOM']) ? "" : $orderCargo['Length']['UOM'];
        $WidthValue = is_array($orderCargo['Width']['Value']) ? "" : $orderCargo['Width']['Value'];
        $WidthUom = is_array($orderCargo['Width']['UOM']) ? "" : $orderCargo['Width']['UOM'];
        $HeightValue = is_array($orderCargo['Height']['Value']) ? "" : $orderCargo['Height']['Value'];
        $HeightUom = is_array($orderCargo['Height']['UOM']) ? "" : $orderCargo['Height']['UOM'];
        $ActualWeightValue = is_array($orderCargo['ActualWeight']['Value']) ? "" : $orderCargo['ActualWeight']['Value'];
        $ActualWeightUom = is_array($orderCargo['ActualWeight']['UOM']) ? "" : $orderCargo['ActualWeight']['UOM'];
        $WeightValue = is_array($orderCargo['Weight']['Value']) ? "" : $orderCargo['Weight']['Value'];
        $WeightUom = is_array($orderCargo['Weight']['UOM']) ? "" : $orderCargo['Weight']['UOM'];
        $VolumetricWeightValue = is_array($orderCargo['VolumetricWeight']['Value']) ? "" : $orderCargo['VolumetricWeight']['Value'];
        $VolumetricWeightUom = is_array($orderCargo['VolumetricWeight']['UOM']) ? "" : $orderCargo['VolumetricWeight']['UOM'];
        $VolumeValue = is_array($orderCargo['Volume']['Value']) ? "" : $orderCargo['Volume']['Value'];
        $VolumetUom = is_array($orderCargo['Volume']['UOM']) ? "" : $orderCargo['Volume']['UOM'];
        $ActualVolumeValue = is_array($orderCargo['ActualVolume']['Value']) ? "" : $orderCargo['ActualVolume']['Value'];
        $ActualVolumeUom = is_array($orderCargo['ActualVolume']['UOM']) ? "" : $orderCargo['ActualVolume']['UOM'];
        $cargoQuantity = is_array($orderCargo['Quantity']) ? "" : $orderCargo['Quantity'];
        $ScannedQuantity = is_array($orderCargo['ScannedQuantity']) ? "" : $orderCargo['ScannedQuantity'];
        $ldm = is_array($orderCargo['ldm']) ? "" : $orderCargo['ldm'];
        $GroundedFlag = is_array($orderCargo['GroundedFlag']) ? "" : $orderCargo['GroundedFlag'];
        $StackableFlag = is_array($orderCargo['StackableFlag']) ? "" : $orderCargo['StackableFlag'];
        $SplittableFlag = is_array($orderCargo['SplittableFlag']) ? "" : $orderCargo['SplittableFlag'];
        $DangerousGoodsFlag = is_array($orderCargo['DangerousGoodsFlag']) ? "" : $orderCargo['DangerousGoodsFlag'];
        $DangerousGoods = is_array($orderCargo['TotalPackagesOfDangerousGoods']) ? "" : $orderCargo['TotalPackagesOfDangerousGoods'];
        $currentDate = date('Y-m-d H:i:s');
        $cargoData = [
            'cargo_type' => $cargoType,
            'handling_unit' => ($HandlingUnit != 0) ?? $cargoType,
            'length' => $LengthValue,
            'length_unit' => $LengthUom,
            'width' => $WidthValue,
            'width_unit' => $WidthUom,
            'height' => $HeightValue,
            'height_unit' => $HeightUom,
            'weight' => $ActualWeightValue,
            'weight_unit' => $WeightUom,
            'volumetric_weight' => $VolumetricWeightValue,
            'volweight_uom' => $VolumetricWeightUom,
            'ldm' => $ldm,
            'volume' => $ActualVolumeValue,
            'volume_unit' => $VolumetUom,
            'second_weight' => $WeightValue,
            'secondweight_uom' => $ActualWeightUom,
            'second_volume' => $VolumeValue,
            'secondvolume_uom' => $ActualVolumeUom,
            'goods_description' => $GoodsDescription,
            'stackable' => $StackableFlag,
            'grounded' => $GroundedFlag,
            'splittable' => $SplittableFlag,
            'dg_goods' => $DangerousGoodsFlag,
            'marks_numbers' => $MarksandNumbers
        ];

        $checkCargoData = $this->db->select("id")->get_where("tb_cargo_details", $cargoData, 1, 0);
        if ($checkCargoData->num_rows() > 0) {
            $cargoId = $checkCargoData->row()->id;
            $cargoData['updatedon'] = $currentDate;
            $cargoData['updatedby'] = $user_id;
            $this->common->updatetbledata("tb_cargo_details", $cargoData, ["id" => $cargoId]);
        } else {
            $cargoData['createdon'] = $currentDate;
            $cargoData['createdby'] = $user_id;
            $cargoId = $this->common->insertTableData('tb_cargo_details', $cargoData);
        }

        $orderCargoData = [
            'order_id' => $order_id,
            'cargo_id' => $cargoId,
            'handling_unit' => ($HandlingUnit != "" && $HandlingUnit != 0) ?? $cargoType,
            'length' => $LengthValue,
            'width' => $WidthValue,
            'height' => $HeightValue,
            'weight' => $ActualWeightValue,
            'second_weight' => $WeightValue,
            'volumetric_weight' => $VolumetricWeightValue,
            'volweight_uom' => $VolumetricWeightUom,
            'ldm' => $ldm,
            'volume' => $ActualVolumeValue,
            'second_volume' => $VolumeValue,
            'quantity' => $cargoQuantity,
            'marks_numbers' => $MarksandNumbers
        ];
        $checkOrderCargoData = $this->db->select("id")->get_where("tb_order_cargodetails", ['order_id' => $order_id, 'cargo_id' => $cargoId, 'weight' => $ActualWeightValue, 'volume' => $ActualVolumeValue, 'quantity' => $cargoQuantity]);
        if ($checkOrderCargoData->num_rows() > 0) {
            $orderCargoId = $checkOrderCargoData->row()->id;
            $orderCargoData['updatedon'] = $currentDate;
            $this->common->updatetbledata("tb_order_cargodetails", $orderCargoData, ["id" => $orderCargoId]);
        } else {
            $cargoData['createdon'] = $currentDate;
            $orderCargoId = $this->common->insertTableData('tb_order_cargodetails', $orderCargoData);
        }
        return $orderCargoId;
    }

    public function getPartyID(string $partyCode): int
    {
        $businessPartyId = $this->db->select("id")->get_where("tbl_party_master", ["code" => $partyCode, "status" => 1], 1, 0);
        return $businessPartyId->num_rows() > 0 ? $businessPartyId->row()->id : 0;
    }

    public function getPartyTypeId(
        string $company_code,
        string $branch_code,
        string $partyDataType
    ): int {
        $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", [
            "name" => $partyDataType,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
        ], 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $party_type_id = $checkPartyType->row()->id;
        } else {
            $partyTypeInfo = [
                "name" => $partyDataType,
                'company_code' => $company_code,
                'branch_code' => $branch_code
            ];
            $party_type_id = $this->common->insertTableData('tbl_party_types', $partyTypeInfo);
        }
        return $party_type_id ?? 0;
    }

    public function insertOrderParties(array $orderParty): void
    {
        if (!empty($orderParty)) {
            $checkOrderParty = $this->db->select("id")->get_where("tb_order_parties", $orderParty, 1, 0);
            if ($checkOrderParty->num_rows() == 0) {
                $this->common->insertTableData('tb_order_parties', $orderParty);
            }
        }
    }

    public function insertOrderReferences(int $orderId, array $references): void
    {
        $orderReferenceData = [
            'order_id' => $orderId,
            'reference_id' => $references['RefType']['Code'],
            'ref_value' => $references['RefType']['Value'],
        ];
        $checkReference = $this->db->select("id")->get_where("tb_order_references", $orderReferenceData);
        if ($checkReference->num_rows() == 0) {
            $this->common->insertTableData('tb_order_references', $orderReferenceData);
        }
    }

}

