<?php

class Archiveddocumentsmodel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function getDocumentsData(int $docId, array $orderIds, array $referenceValues, int $customerId): array
    {
        $sessionTimezone = $this->session->userdata("usr_tzone")['timezone'];
        $companyCode = $this->session->userdata("company_code");
        $branchCode = $this->session->userdata("branch_code");
        $where = [];
        $sql = "SELECT
                p.id,
                p.imgpath,
                convertToClientTZ(p.createdon, '" . $sessionTimezone . "') as createdon,
                o.order_id,
                dt.type_name,
                d.name as drivername,
                u.name as username,
                GROUP_CONCAT(DISTINCT CONCAT(r.reference_id,' - ',r.ref_value) SEPARATOR '<br>') AS reference_values
            FROM
                tb_pod_uploads p
                INNER JOIN tb_orders o ON o.id = p.order_id
                LEFT JOIN tb_document_types dt ON dt.id = p.doc_type
                LEFT JOIN tb_truck_drivers d ON d.id = p.createdby AND p.createdby > 0
                LEFT JOIN tb_users u ON u.id = p.user_id AND p.createdby = 0
                LEFT JOIN tb_order_references r ON r.order_id = o.id AND r.reference_id in ('DQ','PO') AND r.status = 1
                WHERE";
        if ($docId > 0) {
            $sql .= " p.doc_type = ? AND ";
            $where[] = $docId;
        }
        if ($customerId > 0) {
            $sql .= " o.customer_id = ? AND ";
            $where[] = $customerId;
        }
        if (!empty($orderIds)) {
            $sql .= " o.order_id in ? AND ";
            $where[] = $orderIds;
        }
        if (!empty($referenceValues)) {
            $sql .= " r.ref_value in ? AND ";
            $where[] = $referenceValues;
        }
        $sql .= "p.createdon < NOW() - INTERVAL 90 DAY
                AND o.company_code = ?
                AND o.branch_code = ?
                AND o.status != ?
                AND p.status = ?
                GROUP by p.id
                ORDER BY
                o.id DESC";
        array_push($where, $companyCode, $branchCode, 0, 1);
        $query = $this->db->query($sql, $where);
        return $query ? $query->result_array() : [];
    }

    public function getDocumentsMasterData(): array
    {
        $query = $this->db->query("SELECT id,type_name FROM tb_document_types WHERE status = ?", [1]);
        return $query ? $query->result_array() : [];
    }

    public function getCompanyCodes(): array
    {
        $query = $this->db->query("SELECT company_code FROM `tb_company_master` WHERE status = ?", [1]);
        return $query ? $query->result_array() : [];
    }

    public function getCustomerCodes(): array
    {
        $query = $this->db->query("SELECT code FROM `tb_customers` WHERE status = ?", [1]);
        return $query ? $query->result_array() : [];
    }

    public function searchCustomerCodes(string $searchTerm): array
    {
        if ($searchTerm != '') {
            $query = $this->db->query("SELECT code FROM `tb_customers` WHERE code like concat('%', ?, '%') AND status = ? ORDER BY id DESC  limit 20", [$searchTerm, 1]);
        } else {
            $query = $this->db->query("SELECT code FROM `tb_customers` WHERE status = ? ORDER BY id DESC limit 20", [1]);
        }
        return $query ? $query->result_array() : [];
    }

    public function getDocumentsAndCount(array $whereData): array
    {
        if ($whereData['condition'] == "for_count") {
            $sql = "SELECT count(p.id) as document_count ";
        } else {
            $sql = "SELECT p.imgpath,o.order_id ";
        }
        $sql .= "from tb_pod_uploads p
                INNER JOIN tb_orders o ON o.id = p.order_id
                INNER JOIN tb_customers c ON o.customer_id = c.id
                WHERE p.doc_type = ?
                AND p.createdon between ? AND ?
                AND p.createdon < NOW() - INTERVAL 90 DAY
                AND p.status = ?
                AND o.company_code = ?
                AND o.status != ?
                AND c.code IN ?";
        if ($whereData['condition'] == "for_documents") {
            $sql .= " ORDER BY p.id DESC ";
        }
        $query = $this->db->query($sql, [$whereData['document_id'], $whereData['from_date'], $whereData['to_date'], 1, $whereData['company_code'], 0, $whereData['customer_codes']]);
        if ($whereData['condition'] == "for_count") {
            return $query->num_rows() > 0 ? ['document_count' => $query->row()->document_count] : ['document_count' => 0];
        } else {
            return $query ? $query->result_array() : [];
        }
    }

    public function documentsExistsFor(array $bookingIds): bool
    {
        $sql = "SELECT p.id
                FROM tb_pod_uploads p
                INNER JOIN tb_orders o ON o.id = p.order_id
                WHERE p.createdon < NOW() - INTERVAL 90 DAY
                    AND p.status = 1
                    AND o.order_id IN ?
                    AND o.status != 0";

        $query = $this->db->query($sql, [$bookingIds]);

        return $query->num_rows() > 0;
    }

    public function documentsExistsForReferenceValues(array $referenceIds): bool
    {
        $sql = "SELECT p.id
                FROM tb_pod_uploads p
                INNER JOIN tb_orders o ON o.id = p.order_id
                INNER JOIN tb_order_references r ON r.order_id = p.order_id
                WHERE p.createdon < NOW() - INTERVAL 90 DAY
                    AND p.status = 1
                    AND r.ref_value IN ?
                    AND o.status != 0";

        $query = $this->db->query($sql, [$referenceIds]);

        return $query->num_rows() > 0;
    }

    public function searchBookingIds(string $searchTerm, string $companyCode, int $customerId, string $branchCode): array
    {
        $searchCondition = "";
        $where = [];
        if ($searchTerm) {
            $searchCondition = "o.order_id LIKE CONCAT('%', ?, '%') AND ";
            $where[] = $searchTerm;
        }
        if ($customerId > 0) {
            $searchCondition .= "o.customer_id = ? AND ";
            $where[] = $customerId;
        }
        array_push($where, $companyCode, $branchCode);
        $sql = "SELECT DISTINCT(o.order_id)
                    FROM   tb_orders o
                           INNER JOIN tb_pod_uploads p
                                   ON p.order_id = o.id
                    WHERE  {$searchCondition}
                           o.company_code = ?
                           AND o.branch_code = ?
                           AND p.createdon < Now() - INTERVAL 90 day
                           AND p.status = 1
                           AND o.status != 0
                    ORDER  BY o.id DESC
                    LIMIT  20";
        $query = $this->db->query($sql, $where);
        return $query ? $query->result_array() : [];
    }

    public function getDocumentPathsWithIds(array $documentIds): array
    {
        $sql = "SELECT p.imgpath,o.order_id from tb_pod_uploads p
                INNER JOIN tb_orders o ON o.id = p.order_id
                WHERE p.id in ?";
        $query = $this->db->query($sql, [$documentIds]);
        return $query ? $query->result_array() : [];
    }

    public function searchReferenceValues(string $searchTerm, string $companyCode, int $customerId): array
    {
        $searchCondition = "";
        $where = [];
        if (strlen($searchTerm) > 3) {
            $searchCondition = "r.ref_value LIKE CONCAT('%', ?, '%') AND ";
            $where[] = $searchTerm;
        }
        if ($customerId > 0) {
            $searchCondition .= "o.customer_id = ? AND ";
            $where[] = $customerId;
        }
        $where[] = $companyCode;
        $sql = "SELECT DISTINCT(r.ref_value)
                    FROM   tb_order_references r
                           INNER JOIN tb_orders o  ON r.order_id = o.id
                           INNER JOIN tb_pod_uploads p  ON o.id = p.order_id
                    WHERE  {$searchCondition}
                           r.reference_id in ('DQ','PO')
                           AND o.company_code = ?
                           AND p.createdon < Now() - INTERVAL 90 day
                           AND p.status = 1
                           AND o.status != 0
                    ORDER  BY o.id DESC
                    LIMIT  10";
        $query = $this->db->query($sql, $where);
        return $query ? $query->result_array() : [];
    }

}
