<?php defined('BASEPATH') or exit('No direct script access allowed');

class Aumanifestmodel extends CI_Model
{
   
    public function aupublicholidays_list($state, $pickupdate, $delivery_date)
    {
        $pickupdate = date('Y-m-d', strtotime($pickupdate)); //converting datetime to date
        $delivery_date = date('Y-m-d', strtotime($delivery_date)); //converting datetime to date
        $this->db->select('count(*) AS count');
        $this->db->from('tb_au_public_holidays_list');
        $this->db->where('state', $state);
        $this->db->where('date >=', $pickupdate);
        $this->db->where('date <=', $delivery_date);
        $this->db->where_not_in('weekday(date)', array(5, 6)); //donot select weekends from table
        $res =  $this->db->get()->row_array();
        $count_no = $res['count'];
        if(!empty($delivery_date) && !empty($count_no)){
            $delivery_date = date('Y-m-d', strtotime($delivery_date . ' + ' . $count_no . 'Weekday'));
        }
        $delivery_date = date('Y-m-d h:i:s', strtotime($delivery_date)); //converting date to date time 
        return $delivery_date;
    }

    public function checkMacpacCustomer($order_id)
    {
        $sql = "SELECT cc.id AS order_id , cc.customer_id, cc.name as cname, sc.name as scname FROM 
        (SELECT o.id, o.customer_id, c.name , c.parent_id, c.code FROM `tb_orders`o 
        JOIN tb_customers c ON  (o.customer_id=c.id  ) 
        WHERE  o.company_code='KNAU' AND o.id = ?) AS cc
        LEFT  JOIN tb_customers AS sc  ON ( cc.parent_id=sc.id )
        WHERE (cc.code = '1004154238' OR  sc.code = '1004154238') ";
        $res = $this->db->query($sql, array($order_id));
        return $res->row_array();
    }

    
   /**
     * This method gets the service code
     * @param array $whr
     * @return array
     */
    public function getBondsServiceCode($whr)
    {
        $select='s.service_code';
		$result = array();
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "r.order_id=o.id AND r.reference_id='CTR'", "INNER");
        $this->db->join("tb_au_bonds_servicecode s", "s.container_num=r.ref_value AND s.status =1", "INNER");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }
    
}