<?php
class Aureportsmodel extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	public function getcontainers($whr){
        $select = '`r`.`order_id`,CONCAT(`r`.`reference_id`,"=====",`r`.`ref_value`) AS `ref_data`,sum(c.quantity) as total_cartons,r.createdon';
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "r.order_id=o.id AND r.reference_id IN('CTR','POS')", "INNER");
        $this->db->join("tb_order_cargodetails c", "c.order_id=o.id AND c.status =1", "INNER");
        $this->db->where($whr);
        $this->db->group_by("r.ref_value");
        $this->db->order_by("o.createdon", 'ASC');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            foreach ($res->result_array() as $response) {
                $queryResult[$response['order_id']][] = $response;
            }
        }
        if (!empty($queryResult)) {
            foreach ($queryResult as $eachResult) {
                foreach ($eachResult as $eachRow) {
                    $containerValue = explode("=====", $eachRow['ref_data']);
                    if ($containerValue[0] == 'CTR') {
                        $container = $containerValue[1];
                    }
                    if ($containerValue[0] == 'POS') {
                        $knOriginReference =$containerValue[1];
                    }
                }
                $result[] = [
                    'container_no' => $container ?? "",
                    'kn_origin_ref' => $knOriginReference ?? "",
                    'total_cartons' => $eachResult[0]['total_cartons'] ?? "",
                    'createdon' => $eachResult[0]['createdon'] ?? ""
                ];
            }
        }
        return $result ?? [];
    }
    
    public function checkbarcode_basedonconsignmentnote($whr){
        $this->db->select("bar_code");
        $this->db->from("tb_order_cargo_labels");
        $this->db->where($whr);
        $this->db->order_by("id","DESC");
        $this->db->limit(1);
        $qry = $this->db->get();
        return $qry;
    }
    
	public function getcontainerinfo($whr){

		$select='o.user_id,o.branch_code';
		$result = array();
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "r.order_id=o.id AND r.reference_id='CTR'", "INNER");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
	}

	public function getorderinfo($whr){
		$select='count(o.id) as num_of_orders,sum(o.quantity) as Total_cartons';
		$result = array();
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "r.order_id=o.id AND r.reference_id='CTR'", "INNER");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
	}

    /**
     * This method get customer data
     * @param $where,$select,$table,$limit,$start
     * @return array
     */
    public function getcustdata($where,$select,$table,$limit,$start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->LIKE($where);
        $this->db->limit(1);
        $res = $this->db->get();
        if($res){
            if($res->num_rows() > 0){
                $result = $res->row_array();
            }
        }
        return $result;
    }

    public function getsrgknum($where,$select,$table,$limit,$start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->limit(1);
         $this->db->order_by("consignment_note",'DESC');
        $res = $this->db->get();
        if($res){
            if($res->num_rows() > 0){
                $result = $res->row_array();
            }
        }
        return $result;
    }


}
