<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class Billingmodel extends CI_Model
{

	function gettblrowdata($where,$select,$table,$limit,$start)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from($table);
		$this->db->where($where);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$result = $res->row_array();
		}
		return $result;
	}
	function updatedata($table,$id,$data)
	{
		$this->db->where('id',$id);
		return $this->db->update($table,$data);
	}
	function getbillmasters($table){
		$this->db->select("id,name");
		$this->db->from($table);
		$this->db->where("status", 1);
		return $this->db->get();
	}

	function getbilldata($uid,$bill_ids,$whr){
		$company_code = $this->session->userdata('company_code');
		$result = array();
		$this->db->select("b.*,g.name as billgroup,s.name as billstatus");
		$this->db->from("tbl_bills b");
		$this->db->join('tb_billgroup_master g', 'g.id = b.bill_group', 'left');
		$this->db->join('tb_billstatus_master s', 's.id = b.invoice_status', 'left');
		$this->db->where($whr);
		if($company_code == "RUKN"){
          $this->db->where("b.company_code",$company_code);
		}else{
			$this->db->where("b.user_id",$uid);
		}
		if(!empty($bill_ids)){
			$this->db->where_in('b.id',$bill_ids);
		}
		$this->db->where_in("b.status", [1,2,3,4]);
		$this->db->order_by("b.id", "DESC");
		$getbills = $this->db->get();
		if($getbills->num_rows() >0){
			$result = $getbills->result_array();
		}
		return $result;

	}
	function getbilleddata($id,$userid){
		$company_code = $this->session->userdata('company_code');
		$result = array();
		$this->db->select("id,revenue_id,tracking_no,bill_party,bill_type,bill_group,recipient_type,invoice_no,invoice_date,invoice_status,acon_code,total_amount,currency,customer_code,code,company_code,branch_code,department_code,parent_billid,status,invoice_description");
		$this->db->from("tbl_bills");
		$this->db->where("id",$id);
		if($company_code == "RUKN"){
          $this->db->where("company_code",$company_code);
		}else{
			$this->db->where("user_id",$userid);
		}
		$this->db->where("status !=",0);
		$this->db->limit(1);
		$getbill = $this->db->get();
		if($getbill->num_rows() >0){
			$result = array('id'=>$getbill->row()->id,'revenue_id'=>$getbill->row()->revenue_id,'tracking_no'=>$getbill->row()->tracking_no,'bill_party'=>$getbill->row()->bill_party,'bill_type'=>$getbill->row()->bill_type,'bill_group'=>$getbill->row()->bill_group,'recipient_type'=>$getbill->row()->recipient_type,'invoice_no'=>$getbill->row()->invoice_no,'invoice_date'=>$getbill->row()->invoice_date,'invoice_status'=>$getbill->row()->invoice_status,'acon_code'=>$getbill->row()->acon_code,'total_amount'=>$getbill->row()->total_amount,'currency'=>$getbill->row()->currency,'customer_code'=>$getbill->row()->customer_code,'code'=>$getbill->row()->code,'company_code'=>$getbill->row()->company_code,'branch_code'=>$getbill->row()->branch_code,'department_code'=>$getbill->row()->department_code,'parent_billid'=>$getbill->row()->parent_billid,'status'=>$getbill->row()->status,'invoice_description'=>$getbill->row()->invoice_description);
		}
		return $result;
	}
	function gettobebilled($userid,$whr,$whr2=array(), $branch_code = '' ) 
	{
		$company_code = $this->session->userdata('company_code');
		$result = $statuscode = $dates = $ord_ref = $pickup = $delivery = $bookingid = array();
		$doc = "";
		if(!empty($whr2)){
			if(isset($whr2['doc'])){
				$doc = $whr2['doc'];
			}
			if(isset($whr2['stop_type'])){
				$statuscode = array('tps.stop_type'=>$whr2['stop_type'],'tps.status_code'=>$whr2['status_code']);
			}
			if(isset($whr2['pickup'])){
				$pickup = $whr2['pickup'];
			}
			if(isset($whr2['delivery'])){
				$delivery = $whr2['delivery'];
			}
			if(isset($whr2['bookingid'])){
				$bookingid = $whr2['bookingid'];
			}
			if(isset($whr2['dates'])){
				$dates = $whr2['dates'];
			}
			if(isset($whr2['order_reftype'])){
				$ord_ref = array('rf.reference_id'=>$whr2['order_reftype'],'rf.ref_value'=>$whr2['ref_val']);
			}
		}
		$this->db->select("r.id as revcosid,r.recipient_role,r.recipient_code,r.recipient_name,r.debtor_jfr,r.amount,r.currency,r.invoice_status,r.status,o.order_id,o.pickup_company as shipper,o.pickup_city,o.delivery_city,o.delivery_company as consignee,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.transport_mode,o.company_code,o.branch_code,o.shift_id,o.trip_id,o.createdon");
		$this->db->from("tb_reveneus r");
		$this->db->join("tb_orders o","r.order_id=o.id","INNER");
		$this->db->join("tb_order_details d","o.id=d.order_row_id","INNER");
		$this->db->join("tb_order_references rf","o.id=rf.order_id","INNER");
		$this->db->join("tb_shifts ts","o.shift_id=ts.id","INNER");
		$this->db->join("tb_stop_status tps","ts.id=tps.shipment_id","INNER");
		if(!empty($ord_ref)){
			$this->db->where("rf.reference_id",$ord_ref['rf.reference_id']);
			$this->db->like("rf.ref_value",$ord_ref['rf.ref_value']);
		}
		if(!empty($bookingid)){
		 $this->db->where_in("o.order_id",$bookingid);
	    }
		$this->db->where("o.status!=",0);
		$this->db->where("r.invoice_status ",'1');
		$this->db->where("r.status ",'1');
		$this->db->where($whr);
		if($doc != ""){
			$this->db->where($doc);
		}
		if(!empty($dates)){
			$this->db->where($dates);
		}
		if(!empty($statuscode)){
			$this->db->where($statuscode);
		}else{
			if(!empty($pickup) && !empty($delivery)){
			$this->db->where($pickup);
			$this->db->or_where($delivery);
		    }else{
		    	if(!empty($pickup)){
				$this->db->where($pickup);
			   }
		    	if(!empty($delivery)){
				$this->db->where($delivery);
			   }
		    }
		}
		if ( $company_code == "RUKN" ) {
			$this->db->where( "o.company_code", $company_code );
			if ( $branch_code ) { 
				$this->db->where( "o.branch_code", $branch_code );
			}
		} else {
			$this->db->where( "o.user_id", $userid );
		}
		$this->db->group_by('r.id');
		$this->db->order_by("r.createdon",'DESC');
		$getbills = $this->db->get();
		if($getbills->num_rows() >0){
			$result = $getbills->result_array();
		}
		return $result;
	}
	function gettobebilledandbilled($userid,$custid,$countryuids,$whr)
	{
		$company_code = $this->session->userdata('company_code');
		$result = $statuscodes = $pickup  = $delivery = $bookingid =array();
		$department_code = "";
		$billid = $whr['bill_id'];
		$revstatus = $whr['status'];
		$code = $whr['code'];
		$dates = $ord_ref =array();
		if (isset($whr['earlypickupfrom']) && $whr['earlypickupfrom'] != "") {
			$earlypickupfrom                                      = date('Y-m-d', strtotime($whr['earlypickupfrom']));
			$dates["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $earlypickupfrom;
		}
		if (isset($whr['earlypickupto']) &&  $whr['earlypickupto'] != "") {
			$earlypickupto                                      = date('Y-m-d', strtotime($whr['earlypickupto']));
			$dates["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $earlypickupto;
		}
		if (isset($whr['earlydeliveryfrom']) &&  $whr['earlydeliveryfrom'] != "") {
			$earlydeliveryfrom                                      = date('Y-m-d', strtotime($whr['earlydeliveryfrom']));
			$dates["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') >="] = $earlydeliveryfrom;
		}
		if (isset($whr['earlydeliveryto']) &&  $whr['earlydeliveryto'] != "") {
			$earlydeliveryto                                      = date('Y-m-d', strtotime($whr['earlydeliveryto']));
			$dates["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') <="] = $earlydeliveryto;
		}
		if (isset($whr['pickupfrom']) && $whr['pickupfrom'] != "") {
			$pickupfrom                                      = date('Y-m-d', strtotime($whr['pickupfrom']));
			$dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') >="] = $pickupfrom;
			$pickup = array('tps.stop_type'=>"P",'tps.status_code'=>"0500");
		}
		if (isset($whr['pickupto']) &&  $whr['pickupto'] != "") {
			$pickupto                                      = date('Y-m-d', strtotime($whr['pickupto']));
			$dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') <="] = $pickupto;
			$pickup = array('tps.stop_type'=>"P",'tps.status_code'=>"0500");
		}
		if (isset($whr['deliveryfrom']) &&  $whr['deliveryfrom'] != "") {
			$deliveryfrom                                      = date('Y-m-d', strtotime($whr['deliveryfrom']));
			$dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') >="] = $deliveryfrom;
			$delivery = array('tps.stop_type'=>"D",'tps.status_code'=>"2300");
		}
		if (isset($whr['deliveryto']) &&  $whr['deliveryto'] != "") {
			$deliveryto                                      = date('Y-m-d', strtotime($whr['deliveryto']));
			$dates["DATE_FORMAT(tps.createdon,'%Y-%m-%d') <="] = $deliveryto;
			$delivery = array('tps.stop_type'=>"D",'tps.status_code'=>"2300");

		}
		if (isset($whr['order_reftype']) &&  $whr['order_reftype'] != "") {
        if (isset($whr['ref_val']) &&  $whr['ref_val'] != "") {
            $ord_ref = array('rf.reference_id'=>$whr['order_reftype'],'rf.ref_value'=>$whr['ref_val']);
        }
		}
        if(isset($whr['department_code']) &&  $whr['department_code'] != ""){
           $department_code = $whr['department_code'];
        }
        if(isset($whr['bookingid']) &&  !empty($whr['bookingid'])){
           $bookingid = $whr['bookingid'];
        }
        if(isset($whr['order_status']) && $whr['order_status'] != ""){
			if($whr['order_status'] == "pickup"){
				$stop_type = "P";
				$status_code = "0500";
			}else{
				$stop_type = "D";
				$status_code = "2300";
			}
			$statuscodes = array('tps.stop_type'=>$stop_type,'tps.status_code'=>$status_code);
		}
		if(!empty($statuscodes)){
			$this->db->where($statuscodes);
		}else{
			if(!empty($pickup) && !empty($delivery)){
			$this->db->where($pickup);
			$this->db->or_where($delivery);
		    }else{
		    	if(!empty($pickup)){
				$this->db->where($pickup);
			   }
		    	if(!empty($delivery)){
				$this->db->where($delivery);
			   }
		    }
		}
		$this->db->select("r.id as revcosid,r.recipient_role,r.recipient_code,r.recipient_name,r.debtor_jfr,r.amount,r.currency,r.invoice_status,r.bill_id,o.order_id,o.pickup_company as shipper,o.pickup_city,o.delivery_city,o.delivery_company as consignee,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.transport_mode,o.company_code,o.branch_code,o.shift_id,o.trip_id,o.createdon");
		$this->db->from("tb_reveneus r");
		$this->db->join("tb_orders o","r.order_id=o.id","INNER");
		$this->db->join("tb_order_details d","o.id=d.order_row_id","INNER");
		$this->db->join("tb_order_references rf","o.id=rf.order_id","INNER");
		$this->db->join("tb_shifts ts","o.shift_id=ts.id","INNER");
		$this->db->join("tb_stop_status tps","ts.id=tps.shipment_id","INNER");
		if(!empty($bookingid)){
          $this->db->where_in("o.order_id",$bookingid);
		}
		$this->db->where("o.status!=",0);
		if($department_code !=""){
		$this->db->where("d.department_code",$department_code);
	    }
		if(!empty($ord_ref)){
			$this->db->where("rf.reference_id",$ord_ref['rf.reference_id']);
			$this->db->like("rf.ref_value",$ord_ref['rf.ref_value']);
		}
		$this->db->where_in("r.bill_id",[$billid,0]);
		if($revstatus == 1){
			$this->db->where_in("r.bill_id",[$billid,0]);
			$this->db->where_in("r.invoice_status",[1,2]);
			/*$this->db->or_where("r.recipient_code ",$code);*/
		}else{
			$this->db->where("r.bill_id",$billid);
			$this->db->where("r.invoice_status",2);
		}
		if($company_code == "RUKN"){
          $this->db->where("o.company_code",$company_code);
		}else{
			$this->db->where("o.user_id",$userid);
		}
		if(isset($whr['doc_status']) && $whr['doc_status'] !=""){
			$doc_status = $whr['doc_status'];
			if($doc_status == 'yes'){
				$doc = "d.docs_received_datetime  IS NOT NULL AND d.docs_received_datetime !=''";
				$this->db->where($doc);
			}
			if($doc_status == 'no'){
				$doc = "d.docs_received_datetime  IS NULL OR d.docs_received_datetime =''";
				$this->db->where($doc);
			}
		}
		$this->db->where($dates);
		if(!empty($statuscodes)){
			$this->db->where($statuscodes);
		}else{
			if(!empty($pickup) && !empty($delivery)){
			$this->db->where($pickup);
			$this->db->or_where($delivery);
		    }else{
		    	if(!empty($pickup)){
				$this->db->where($pickup);
			   }
		    	if(!empty($delivery)){
				$this->db->where($delivery);
			   }
		    }
		}
		$this->db->where("r.recipient_code",$code);
		$this->db->where("r.status ",'1');
		$this->db->group_by('r.id');
		$this->db->order_by("r.invoice_status",'DESC');
		$getbills = $this->db->get();
		if($getbills->num_rows() >0){
			$result = $getbills->result_array();
		}
		return $result;
	}
	function getcharges($rev_costid){
		$result = array();
		$this->db->select("c.*,c.charge_code as chargecodeid,cd.id as chargecodeid,cd.charge_code");
		$this->db->from("tb_charges c");
		$this->db->join('tb_charge_codes cd', 'cd.id = c.charge_code', 'left');
		$this->db->where("c.revenue_id", $rev_costid);
		$this->db->where("c.status", 1);
		$getcharges = $this->db->get();
		if($getcharges->num_rows() >0){
			$result = $getcharges->result_array();
		}
		return $result;


	}
	function getcountrycode($uid){
		$countryphonecode = 91;
		$this->db->select("c.phone_code");
		$this->db->from("tbl_country_master c");
		$this->db->join('tb_users u', 'u.country_code = c.country_code', 'left');
		$this->db->where("u.id",$uid);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$countryphonecode = $res->row()->phone_code;
		}
		return $countryphonecode;
	}
	function getchildnoteid($id){
		$cid = 0;
		$this->db->select("id");
		$this->db->from("tbl_bills");
		$this->db->where("parent_billid",$id);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$cid = $res->row()->id;
		}
		return $cid;
	}
	function chkparentbillid($id){
		$cid = 0;
		$this->db->select("id");
		$this->db->from("tbl_bills");
		$this->db->where("id",$id);
		$this->db->where("parent_billid",0);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$cid = $res->row()->id;
		}
		return $cid;
	}
	function getparentbillid($id){
		$pid = 0;
		$this->db->select("parent_billid");
		$this->db->from("tbl_bills");
		$this->db->where("id",$id);
		$this->db->where("parent_billid !=",0);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$pid = $res->row()->parent_billid;
		}
		return $pid;
	}
	function getinvoiceno($id){
		$invoice_no = 0;
		$this->db->select("invoice_no");
		$this->db->from("tbl_bills");
		$this->db->where("id",$id);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$invoice_no = $res->row()->invoice_no;
		}
		return $invoice_no;
	}

	function getgroupname($bill_group){
		$groupname = "";
		$this->db->select("name");
		$this->db->from("tb_billgroup_master");
		$this->db->where("id",$bill_group);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$name = $res->row()->name;
			if($name == "Invoice" || $name == "Debit Note"){
				$groupname = "Carrier";
			}else if($name == "Bill" || $name == "Credit Note"){
				$groupname = "Customer";
			}
		}
		return $groupname;
	}

	function gettbldata($where,$select,$table,$limit,$start)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from($table);
		$this->db->where($where);
		if($table == 'tb_shipment_locations'){
			$this->db->order_by('id','ASC');
		}
		if($limit > 0){
			$this->db->limit($limit,$start);
		}
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$result = $res->result_array();
		}
		return $result;
	}

	function insertTableData($tablename,$data)
	{
		$res = 0;
		$qry = $this->db->insert($tablename,$data);
		if($qry){
			$res = $this->db->insert_id();
		}
		return $res;
	}
	function chkpartytype($partytypesary,$partyname){
		$this->db->select("id");
		$this->db->from("tbl_party_types");
		$this->db->where_in("id", $partytypesary);
		$this->db->where("name", $partyname);
		return $this->db->get();
	}
   /* public function getrevenuedata($id)
	{
		$this->db->select("r.order_id,r.debtor_jfr,r.invoice_number,SUM(c.amount) as totamt,SUM(c.revised_amount) as totrevamt,");
		$this->db->from("tb_reveneus r");
		$this->db->join("tb_charges c","c.revenue_id=r.id","LEFT");
		$this->db->where("r.bill_id",$id);
		$this->db->where("c.status",1);
		$this->db->where("r.status",1);
		$this->db->limit(1);
		$revenuedata = $this->db->get();
		return $revenuedata;
	}*/
/*	function getchargeamts($billid){
		$result = array();
        $this->db->select("r.order_id,sum(c.amount) as amount,sum(c.revised_amount) as revised_amount");
		$this->db->from("tb_reveneus r");
		$this->db->join("tb_charges c","c.revenue_id=r.id","LEFT");
		$this->db->where("r.bill_id",$billid);
		$this->db->where("c.revised_amount >",0);
		$this->db->where("c.status",1);
		$this->db->where("r.status",1);
		$chargeamts =  $this->db->get();
		if($chargeamts->num_rows() > 0 ){
		  $result = array('order_id'=>$chargeamts->row()->order_id,'totamt'=>$chargeamts->row()->amount,'totrevamt'=>$chargeamts->row()->revised_amount);

		}
		return $result;
	}*/
	function getchargeamts($revenueid){
		$result = array();
		$this->db->select("r.order_id,sum(c.amount) as amount,sum(c.revised_amount) as revised_amount");
		$this->db->from("tb_reveneus r");
		$this->db->join("tb_charges c","c.revenue_id=r.id","LEFT");
		$this->db->where("r.id",$revenueid);
		$this->db->where("c.revised_amount >",0);
		$this->db->where("c.status",1);
		$this->db->where("r.status",1);
		$chargeamts =  $this->db->get();
		if($chargeamts->num_rows() > 0 ){
			$result = array('order_id'=>$chargeamts->row()->order_id,'totamt'=>$chargeamts->row()->amount,'totrevamt'=>$chargeamts->row()->revised_amount);
		}
		return $result;
	}
	function getchargecodeid(){
		$id = 0;
		$this->db->select("id");
		$this->db->from("tb_charge_codes");
		$this->db->like('charge_code','FRT');
		$this->db->where('status', 1);
		$chkqry = $this->db->get();
		if ($chkqry->num_rows() > 0) {
			$id = $chkqry->row()->id;
		}
		return $id;
	}
	function getroletypelist(\App\Models\BillingmodelGetroletypelistInput $info){
		$company_code=$info->getCompanyCode();
		$xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $company_code ) );
		if ( $xborderdetails->num_rows() > 0 ) {
			 $xborder_code= $xborderdetails->row()->xborder_code;
			 if($xborder_code!=""){
				$xborder_company=explode(",",$xborder_code);
				$user_whr = " m.company_code IN ('" . $company_code . "','" . implode( "','", $xborder_company ) . "')";
			 }else{
				$user_whr = " m.company_code LIKE '" . $company_code . "' ";
			 }
		}else{
			$user_whr = " m.company_code LIKE '" . $company_code . "' ";
		}
		$result = array();
		$this->db->select("m.id,m.name,m.email,m.code,m.customeridentifier,m.company_code,m.branch_code");
		$this->db->from("tbl_party_master m");
		$this->db->join("tbl_party_types p","p.id=m.party_type_id","LEFT");
		$this->db->where("p.name",$info->getType());

		if($company_code == "RUKN" || $company_code == "AUKN" ){
			$this->db->where("m.company_code",$company_code);
			$this->db->where("p.company_code",$company_code);
        } elseif (checkAccessConditions('RELATED_2_SG_MY', $company_code)) {
			$this->db->where($user_whr);
		}else{
			$this->db->where("m.user_id",$info->getUserId());
			$whr = "( p.company_code LIKE '".$company_code."' OR p.user_id ='".$info->getUserId()."')";
			$this->db->where($whr);
		}
		$getresult = $this->db->get();
		if($getresult->num_rows() >0){
			$result = $getresult->result_array();
		}
		return $result;
	}
	function getpartnerdetailsbycode($code,$customer_company){
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$user_whr='';
		$xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $company_code) );
		if ( $xborderdetails->num_rows() > 0 ) {
			 $xborder_code= $xborderdetails->row()->xborder_code;
			 if($xborder_code!=""){
				$xborder_company=explode(",",$xborder_code);
				$user_whr = " company_code IN ('" . $company_code . "','" . implode( "','", $xborder_company ) . "')";
			 }else{
				$user_whr = " company_code LIKE '" . $company_code . "' ";
			 }
		}else{
			$user_whr = " company_code LIKE '" . $company_code . "' ";
		}
		$result = array();
		$this->db->select("id,name,code,company_code,branch_code,acon_debitor_code,customeridentifier,invoice_type");
		$this->db->from("tbl_party_master");
		$this->db->where("code",$code);
		$this->db->where("company_code",$customer_company);
		 /*$this->db->where("branch_code",$branch_code); */
		$this->db->where("status",1);
		$getresult =  $this->db->get();
		if($getresult->num_rows() >0){
			$result = $getresult->row_array();
		}
		return $result;
	}
	
	function getbookingids($ids){
		$result = array();
		if(!empty($ids)){
			$this->db->select("id,order_id");
			$this->db->from("tb_orders");
			$this->db->where_in('id',$ids);
			$this->db->where('status !=0');
			$this->db->group_by('id');
			$getresult = $this->db->get();
			if(!empty($getresult)){
				$result = $getresult->result_array();
			}
		}
		return $result;
	}
	function getrecentorinvoiceid($company_code,$invoice_no){
		$qry = "";
		if($company_code != ""){
			$whr = " invoice_no LIKE '".$invoice_no."' AND company_code LIKE '".$company_code."'";
			$this->db->select("invoice_no");
			$this->db->from("tbl_bills");
			$this->db->where($whr);
			$this->db->order_by('id','DESC');
			$this->db->limit(1);
			$qry = $this->db->get();
		}
		return $qry;
	}
	
	function checkdriveracceptsfornewtrips($legids){
		$result = array();
		if(!empty($legids)){
			$this->db->select("trip_id");
			$this->db->from("tb_employee");
			$this->db->where_in("shift_id",$legids);
			$this->db->where('status','1');
			$qry = $this->db->get();
			if($qry->num_rows() > 0){
				$result = $qry->result_array();
			}
			return $result;
		}
	}
	
	function getchargeswithorder_ids($ids){
		$result = array();
		if(!empty($ids)){
			$this->db->select("c.description,c.amount,c.revised_amount,c.currency,c.local_amount,c.local_currency,c.local_vat_amount,c.local_total_amount,c.vat_percentage,c.vat_amount,c.total_amount,c.charge_code as chargecodeid,cd.id as chargecodeid,cd.charge_code,o.order_id");
			$this->db->from("tb_charges c");
			$this->db->join('tb_charge_codes cd', 'cd.id = c.charge_code', 'left');
			$this->db->join('tb_reveneus r', 'r.id = c.revenue_id', 'left');
			$this->db->join('tb_orders o', 'o.id = r.order_id', 'left');
			$this->db->where_in("c.revenue_id", $ids);
			$this->db->where("c.status", 1);
			$getcharges = $this->db->get();
			if($getcharges->num_rows() >0){
				$result = $getcharges->result_array();
			}
			return $result;
		}
	}
	
	public function getcoststatusfromrevenuetbl($billid){
		$sts = "";
		$order_ids = $sent = $notsent = array();
		$whr = "type='0' AND bill_id ='".$billid."' AND status !='0' ";
		$this->db->select("order_id");
		$this->db->from("tb_reveneus");
		$this->db->where($whr);
		$this->db->group_by('order_id');
		$qry = $this->db->get();
		if($qry->num_rows() > 0){
			foreach($qry->result() as $res){
				$order_ids[] = $res->order_id;
			}
		}
		if(!empty($order_ids)){
			$cst_whr = "type='1' AND recipient_role LIKE 'Carrier' AND status !='0'";
			$this->db->select("id,invoice_status");
			$this->db->from("tb_reveneus");
			$this->db->where($cst_whr);
			$this->db->where_in("order_id", $order_ids);
			$cst_qry = $this->db->get();
			if($cst_qry->num_rows() >0){
				foreach($cst_qry->result() as $cst){
					$invoice_status = $cst->invoice_status;
					if($invoice_status =='2'){
						$sent[] = $cst->id;
					}else{
						$notsent[] = $cst->id;
					}
				}
			}
		}
		$sts = "No Accruals";
		if(!empty($sent) && !empty($notsent)){
			$sts = 'Accrual Partially sent to ACON';
		}
		if(!empty($sent) && empty($notsent)){
			$sts = "Accrual Sent to ACON";
		}
		if(empty($sent) && !empty($notsent)){
			$sts = "Accrual Not sent to ACON";
		}
		return $sts;

	}	
}
