<?php

defined('BASEPATH') or exit('No direct script access allowed');

class CalculateDistanceModel extends CI_Model
{
    public function getOrderData(string $orderId): array
    {
        $getResult = $this->db->query("SELECT * FROM tb_orders WHERE order_id = ? ", [$orderId]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getTripDetails(string $tripId): array
    {
        $result = $this->db->query("SELECT MAX(id) AS act_loc, MIN(id) ini_loc FROM tb_rtdrive_locations WHERE trip_id = ? ", [$tripId])->row();
        if ($result && $result->ini_loc > 0 && $result->act_loc > 0) {
            $initLocDetails = $this->db->query("SELECT latitude, longitude FROM tb_rtdrive_locations WHERE id = ? ", [$result->ini_loc])->row();
            $actLocDetails = $this->db->query("SELECT latitude, longitude FROM tb_rtdrive_locations WHERE id = ? ", [$result->act_loc])->row();
            return [
                'init_lat' => $initLocDetails->latitude,
                'init_lng' => $initLocDetails->latitude,
                'act_lat' => $actLocDetails->latitude,
                'act_lng' => $actLocDetails->latitude
            ];
        }
        return ['init_lat' => 0, 'init_lng' => 0, 'act_lat' => 0, 'act_lng' => 0];
    }

    public function getCountryCodeByName(string $countryName): string
    {
        $country = $this->db->query("SELECT country_code FROM tbl_country_master WHERE LOWER(country_name) = ? AND status = ?", [strtolower($countryName), 1])->row();
        if ($country) {
            return $country->country_code;
        }
        return "";
    }

    public function getOrderOriginGateOutTime(string $orderId, string $tripId): array
    {
        $getResult = $this->db->query(
            "SELECT s.createdon FROM tb_stop_status AS s
		INNER JOIN tb_orders o ON o.id = s.order_id AND o.trip_id = s.trip_id
		WHERE s.order_id = ? AND s.stop_type = ? AND s.trip_id = ? AND s.status_id = ? AND s.status_code = ?",
            [$orderId, 'P', $tripId, 3, '0191']
        );
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getOrderDestinationGateInTime(string $orderId, string $tripId): array
    {
        $getResult = $this->db->query(
            "SELECT s.createdon FROM tb_stop_status AS s
		INNER JOIN tb_orders o ON o.id = s.order_id AND o.trip_id = s.trip_id
		WHERE s.order_id = ? AND s.stop_type = ? AND s.trip_id = ? AND s.status_id = ? AND s.status_code = ?",
            [$orderId, 'D', $tripId, 2, '0192']
        );
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getActualTripMinId(string $tripId, string $createdOn): array
    {
        $getResult = $this->db->query("SELECT MIN(id) AS id, latitude, longitude FROM tb_rtdrive_locations WHERE trip_id = ? AND `createdon` >= ? ", [$tripId, $createdOn]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getTransitTripMaxId(string $tripId): array
    {
        $getResult = $this->db->query("SELECT MAX(id) AS id, latitude, longitude FROM tb_rtdrive_locations WHERE trip_id = ? ", [$tripId]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getActualTripMaxId(string $tripId, string $createdOn): array
    {
        $getResult = $this->db->query("SELECT  id, latitude, longitude FROM tb_rtdrive_locations WHERE trip_id = ? AND `createdon` <= ? order by id DESC limit 0,1 ", [$tripId, $createdOn]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }
}
