<?php
class CarrierLiveKPIModel extends CI_Model
{
    private const  TRIP_ACCEPTED_STATUS_CODE = '0212';
    private const  ORIGIN_GATEIN_STATUS_CODE = '0420';
    private const  PICKUP_STATUS_CODE = '0500';
    private const  DEPARTURE_STATUS_CODE = '0191';
    private const  INTRASIT_STATUS_CODE = '1550';
    private const  DESTINATION_GATEIN_STATUS_CODE = '0192';
    private const  DELIVERY_STATUS_CODE = '2300';
    private const  GATEOUT_STATUS_CODE = '3000';
    private const  SUPPLIER_ACCEPTED_STATUS_CODE = '0100';

    public function getReports(array $post, int $limit, int $offset): array {
        $userTimeZone = $post['timezone'];
        $companyCode = $post['company_code'];
        $bindParams = [];
        $bindParams[] = $userTimeZone;
        $bindParams[] = 0;
        $bindParams[] = 0;
        $bindParams[] = 0;
        $bindParams[] = 0;
        $bindParams[] = 1;
        $bindParams[] = 0;
        $bindParams[] = 'DQ';
        $bindParams[] = 1;
        $bindParams[] = 'XSR';
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = SELF::SUPPLIER_ACCEPTED_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = SELF::TRIP_ACCEPTED_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = SELF::ORIGIN_GATEIN_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'P';
        $bindParams[] = SELF::PICKUP_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'P';
        $bindParams[] = SELF::DEPARTURE_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'P';
        $bindParams[] = SELF::INTRASIT_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'D';
        $bindParams[] = SELF::DESTINATION_GATEIN_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'D';
        $bindParams[] = SELF::DELIVERY_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = 'D';
        $bindParams[] = SELF::GATEOUT_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = $userTimeZone;
        $bindParams[] = SELF::TRIP_ACCEPTED_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = SELF::ORIGIN_GATEIN_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'P';
        $bindParams[] = SELF::PICKUP_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'P';
        $bindParams[] = SELF::DEPARTURE_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'P';
        $bindParams[] = SELF::INTRASIT_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'D';
        $bindParams[] = SELF::DESTINATION_GATEIN_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'D';
        $bindParams[] = SELF::DELIVERY_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'D';
        $bindParams[] = SELF::GATEOUT_STATUS_CODE;
        $bindParams[] = 1;
        $bindParams[] = 1;
        $bindParams[] = 'D';
        $bindParams[] = 3;
        $whereCondition = " o.company_code = ? ";
        $bindParams[] = $companyCode;
        $limitCondition = "";
        if ($limit > 0 && $offset > 0) {
            $limitCondition = " LIMIT {$limit} OFFSET {$offset}";
        } elseif ($limit > 0) {
            $limitCondition = " LIMIT {$limit}";
        }
        $fromDate = $post['fromdate_search'] ?? '';
        $toDate = $post['todate_search'] ?? '';
        if (!empty($fromDate) && !empty($toDate)) {
            $whereCondition .= " AND date(o.createdon) >= ? AND date(o.createdon) <= ? ";
            $bindParams[] = $fromDate;
            $bindParams[] = $toDate;
        } elseif (!empty($fromDate)) {
            $whereCondition .= " AND date(o.createdon) = ? ";
            $bindParams[] = $fromDate;
        } elseif (!empty($toDate)) {
            $whereCondition .= " AND date(o.createdon) = ? ";
            $bindParams[] = $toDate;
        }
        if (isset($post['carrier_search']) && trim($post['carrier_search']) != "") {
            $whereCondition .= " AND o.vendor_id = ?";
            $bindParams[] = $post['carrier_search'];
        }

        $sql = "SELECT
        			convertToClientTZ(o.createdon,?) AS createdon,
					o.id,
					o.order_id,
					o.trip_id,
					o.shipmentid,
					o.branch_code,
					CASE WHEN (
				    	o.trip_sts = ?
				    	AND o.trip_id = ?
				  	) THEN 'Pending' WHEN (
				    o.trip_sts = ?
				    AND o.trip_id > ?
				  ) THEN 'Active' WHEN (
				    o.trip_sts = ?
				    AND o.trip_id > ?
				  ) THEN 'Closed' ELSE '' END AS order_status,
				  (
				    SELECT
				      tor.ref_value
				    FROM
				      tb_order_references tor
				    WHERE
				      tor.reference_id = ?
				      AND tor.status = ?
				      AND tor.order_id = o.id
				    GROUP BY
				      tor.order_id
				  ) AS delivery_note,
				  (
				    SELECT
				      tor.ref_value
				    FROM
				      tb_order_references tor
				    WHERE
				      tor.reference_id = ?
				      AND tor.status = ?
				      AND tor.order_id = o.id
				    GROUP BY
				      tor.order_id
				  ) AS salog_ref,
				  o.pickup_company,
				  o.delivery_company,
				  CONCAT(
				    o.pickup_address1, ', ', o.pickup_address2
				  ) AS pickup_address,
				  CONCAT(
				    o.delivery_address1, ', ', o.delivery_address2
				  ) AS delivery_address,
				  c.name AS customer_name,
				  v.name AS carrier_name,
				  td.register_number AS truck,
				  sv.register_number,
				  driver.name AS driver_name,
				  (
				    SELECT
				    convertToClientTZ(tss.createdon, ?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS supplier_booked,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS accepted_date,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS o_gatein,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS pickup_date,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS pickup_gateout,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS in_transit,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS d_gatein,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS delivery,
				  (
				    SELECT
				      convertToClientTZ(tss.createdon,?)
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				      LIMIT ?
				  ) AS d_gateout,
				  convertToClientTZ(pod.createdon,?) AS pod_uploaded,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT
				      ?
				  ) AS accepted_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT
				      ?
				  ) AS o_gatein_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS pickup_date_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS pickup_gateout_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS in_transit_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS d_gatein_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS delivery_reason,
				  (
				    SELECT reason
				    FROM
				      tb_stop_status tss
				    WHERE
				      tss.stop_type = ?
				      AND tss.order_id = o.id
				      AND tss.status_code = ?
				      AND tss.status = ?
				    LIMIT ?
				  ) AS d_gateout_reason
				FROM
				  tb_orders o
				  INNER JOIN tb_customers c ON (c.id = o.customer_id)
				  LEFT JOIN tb_vendors v ON (v.id = o.vendor_id)
				  LEFT JOIN tb_trips t ON (t.id = o.trip_id)
				  LEFT JOIN tb_trucks_data td ON (td.id = t.vehicle_id)
				  LEFT JOIN tb_shft_veh sv ON (sv.shft_id = t.shift_id)
				  LEFT JOIN tb_truck_drivers driver ON (driver.id = t.driver_id)
				  LEFT JOIN tb_pod_uploads pod ON (
				    pod.trip_id = t.id
				    AND t.shift_id = pod.shipment_id
				    AND pod.stop_type = ?
				    AND pod.doc_type = ?
				  )
				WHERE
				  {$whereCondition}
				GROUP BY o.id
				ORDER BY
				  o.id DESC {$limitCondition}";
        $orderQuery = $this->db->query($sql, $bindParams);
        return $orderQuery->num_rows() ? $orderQuery->result_array() : [];
    }

    public function getVNKNCarriers(string $companyCode, string $fromDate,string $toDate): array {
    	$getResults = $this->db->query("SELECT DISTINCT(v.id) AS id, v.name, LOWER(v.email) AS email 
    		FROM tb_vendors AS v 
    		INNER JOIN tb_orders AS o ON (v.id = o.vendor_id)
    		WHERE v.company_code = ? AND v.status = ? AND v.email != '' AND DATE(o.createdon) >= ? AND DATE(o.createdon) <= ? ",
    		[$companyCode, 1, $fromDate, $toDate]);
    	return $getResults->num_rows() ? $getResults->result_array() : [];
    }
}