<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Carriertripnotificationmodel extends CI_Model
{
    private $shift_id = 0;
    private $order_remarks = [];
    private $pickupInstructions = '';
    private $DeliveryInstructions = '';

    public function __construct()
    {
        parent::__construct();
    }

    public function setShiftId(int $shift_id): void
    {
        $this->shift_id = $shift_id;
    }

    public function getShiftId(): int
    {
        return $this->shift_id;
    }

    public function setPickupInstructions(string $pickupInstructions): void
    {
        $this->pickupInstructions = $pickupInstructions;
    }

    public function getPickupInstructions(): string
    {
        return $this->pickupInstructions;
    }

    public function setDeliveryInstructions(string $DeliveryInstructions): void
    {
        $this->DeliveryInstructions = $DeliveryInstructions;
    }

    public function getDeliveryInstructions(): string
    {
        return $this->DeliveryInstructions;
    }

    public function getOrderDetails(int $shift_id): array
    {
        $result = [];
        $this->setShiftId($shift_id);
        $select = ['tb_orders.company_code', 'tb_orders.branch_code', 'tb_orders.physicalreceiver', 'tb_orders.logicalreceiver', 'tb_orders.physicalsender', 'tb_orders.goods_value', 'tb_orders.currency'
            , 'tb_orders.logicalsender', 'tb_orders.id order_row_id', 'tb_orders.order_id', 'tb_orders.external_order_id', 'tb_orders.shipmentid', 'pickup_datetime', 'pickup_endtime'
            , 'delivery_datetime', 'drop_endtime', 'pickup_company', 'delivery_company', 'pickup_country'
            , 'delivery_country', 'pickup_city', 'delivery_city', 'pickup_pincode', 'delivery_pincode'
            , 'pickup_address1', 'delivery_address1', 'pickup_address2', 'delivery_address2', 'tb_orders.transport_mode'
            , 'tb_order_details.department_code', 'tb_order_details.incoterm', 'tb_order_types.type_name', 'tb_order_details.service', 'tb_service_master.service_id', 'tb_service_master.name as service_name', 'tb_order_details.delivery_term'
            , 'tb_incoterms_master.name incoterm_name', 'tb_shipments.freight_term', 'tb_shipments.freight_termname', 'tb_delivery_terms.term_id as delivery_term_id', 'tb_delivery_terms.name as delivery_term_name', 'tb_shifts.border_type', 'tb_shifts.carrier_instructions'
            , 'tb_shifts.additional_conditions', 'tb_shifts.temperature_regime', 'tb_shifts.time_for_loading_penality_rate'];
        $result_set = $this->db->select($select)
            ->from('tb_orders')
            ->join('tb_order_details', 'tb_orders.order_id = tb_order_details.order_id  AND tb_orders.id = tb_order_details.order_row_id  AND tb_order_details.status=1')
            ->join('tb_delivery_terms', 'tb_delivery_terms.term_id = tb_order_details.delivery_term  AND tb_delivery_terms.status=1', 'left')
            ->join('tb_order_types', 'tb_order_types.id = tb_order_details.order_type  AND tb_order_details.status=1', 'left')
            ->join('tb_service_master', 'tb_service_master.id = tb_order_details.service  AND tb_service_master.status=1', 'left')
            ->join('tb_incoterms_master', 'tb_incoterms_master.id = tb_order_details.incoterm  AND tb_incoterms_master.status=1', 'left')
            ->join('tb_shipments', 'tb_shipments.id = tb_orders.shipment_id  AND tb_shipments.status=1', 'left')
            ->join('tb_shifts', 'tb_shifts.id = tb_orders.shift_id  AND tb_shifts.status=1', 'left')
            ->where(['tb_orders.shift_id' => $this->getShiftId(), 'tb_orders.status>' => 1])
            ->order_by('tb_orders.id')
            ->group_by('tb_orders.order_id')
            ->get();
        if ($result_set && $result_set->num_rows() > 0) {
            $result = $result_set->result_array();
        }
        return $result;
    }

    public function getOrderCargoDetails(string $order_ids): array
    {
        $result = [];
        $select = ['tb_cargo_details.cargo_type', 'tb_cargo_details.dg_goods', 'tb_cargo_details.handling_unit'
            , 'tb_order_cargodetails.quantity', 'tb_order_cargodetails.length', 'tb_cargo_details.length_unit'
            , 'tb_order_cargodetails.width', 'tb_cargo_details.width_unit', 'tb_order_cargodetails.height'
            , 'tb_cargo_details.height_unit', 'tb_order_cargodetails.weight', 'tb_cargo_details.weight_unit'
            , 'tb_order_cargodetails.volume', 'tb_cargo_details.volume_unit', 'tb_order_cargodetails.order_id', 'tb_cargo_details.stackable'
            , 'tb_cargo_details.grounded', 'tb_cargo_details.splittable', 'tb_cargo_details.dg_goods', 'tb_cargo_details.ldm'
            , 'tb_cargo_details.ldm_uom', 'tb_cargo_details.goods_description', 'tb_cargo_details.volumetric_weight', 'tb_cargo_details.volweight_uom', 'tb_order_cargodetails.second_weight'];
        $result_set = $this->db->select($select)
            ->from('tb_order_cargodetails')
            ->join('tb_cargo_details', 'tb_order_cargodetails.cargo_id = tb_cargo_details.id')
            ->where_in('order_id', $order_ids)->get();
        if ($result_set && $result_set->num_rows() > 0) {
            $result = $result_set->result_array();
        }
        return $result;
    }

    public function getOrderParties(string $order_id): array
    {
        $resultList = $resultRows = [];
        $select = ['party_id','tbl_party_types.name'];
        $result_set = $this->db->select($select)
            ->from('tb_order_parties')
            ->join('tbl_party_types', 'tb_order_parties.party_type = `tbl_party_types`.id')
            ->where(['tb_order_parties.order_id' => $order_id, 'tb_order_parties.status' => '1'])
            ->get();
        if ($result_set && $result_set->num_rows() > 0) {
            $resultRows = $result_set->result_array();
        }

        foreach ($resultRows as $resultRow) {
            $select = ['tbl_party_master.code', 'tbl_party_master.name', 'tbl_party_master.mobile', 'tbl_party_master.email', 'tbl_party_master.country'];
            $result_set = $this->db->select($select)
                ->from('tbl_party_master')
                ->where(['tbl_party_master.id' => $resultRow['party_id']])->limit(1)
                ->get();
            if ($result_set && $result_set->num_rows() > 0) {
                $result = $result_set->row_array();
                $result['party_type'] = $resultRow['name'];
                $resultList[] = $result;
            }
        }
        return $resultList;
    }

    public function getTripDriverAndVehicle(int $shift_id): array
    {

        $vehicle_driver_info = [];
        $this->db->select(['tb_shft_veh.vehicle_id', 'tb_shft_veh.register_number', 'tbl_assigned_drivers.driver_id',
            'tb_trucks_data.truck_brand', 'tb_shft_veh.shft_id', 'tb_trucks_data.truck_number', 'tb_trucks_data.register_number as vehicle_register_number',
            'tb_trucks_data.truck_weight', 'tb_trucks_data.weight_unit', 'tb_trucks_data.breadth', 'tb_trucks_data.breadth_unit',
            'tb_trucks_data.truck_volume', 'tb_trucks_data.volume_unit', 'tb_trucks_data.height', 'tb_trucks_data.height_unit', 'tb_trucks_data.length',
            'tb_trucks_data.length_unit', 'tb_trucktypes.trucktype', 'tb_trucktypes.description', 'tb_truck_drivers.name', 'tb_truck_drivers.contact_num', 'tb_truck_drivers.name driver_name', 'tb_truck_drivers.contact_num driver_contact_number',
            'tb_truck_drivers.address1 driver_address1', 'tb_truck_drivers.address2 driver_address2', 'tb_truck_drivers.street street', 'tb_truck_drivers.state driver_state', 'tb_truck_drivers.pincode driver_pincode',
            'tb_truck_drivers.country driver_country', 'tb_truck_drivers.email driver_email', 'tb_truck_drivers.driving_licence_num'])
            ->from('tb_shft_veh')
            ->join('tbl_assigned_drivers', 'tb_shft_veh.vehicle_id =tbl_assigned_drivers.vehicle_id') // AND tbl_assigned_drivers.status=1')
            ->join('tb_truck_drivers', "tb_truck_drivers.id = tbl_assigned_drivers.driver_id AND `tb_truck_drivers`.`status`='active'")
            ->join('tb_trucks_data', "tb_trucks_data.id = tb_shft_veh.vehicle_id AND tb_trucks_data.status='Active'")
            ->join('tb_trucktypes', 'tb_trucktypes.id = tb_trucks_data.truck_type', 'left')
            ->where(['tb_shft_veh.shft_id' => $shift_id, 'tb_shft_veh.status' => 1])->limit(1);
        $vehicle_driver_info = $this->db->get();
        if ($vehicle_driver_info && $vehicle_driver_info->num_rows() > 0) {
            $vehicle_driver_info = $vehicle_driver_info->row_array();
        }
        return (array) $vehicle_driver_info;
    }

    public function getOrderReferences(string $order_id): array
    {
        $result = [];
        $select = ['reference_id as refTypeCode', 'ref_value as refTypeValue'];
        $result_set = $this->db->select($select)
            ->from('tb_order_references')
            ->where(['order_id' => $order_id, 'status' => 1])
            ->get();
        if ($result_set && $result_set->num_rows()) {
            $result = $result_set->result_array();
            foreach ($result as $key => $row) {
                if ($row['refTypeCode'] == 'REM') {
                    $this->order_remarks[] = ['remarkCode' => $row['refTypeCode'], 'remarkValue' => $row['refTypeValue']];
                    unset($result[$key]);
                }
                if ($row['refTypeCode'] == 'ORD_PIKINST') {
                    $this->setPickupInstructions($row['refTypeValue']);
                    unset($result[$key]);
                }
                if ($row['refTypeCode'] == 'ORD_DLVINST') {
                    $this->setDeliveryInstructions($row['refTypeValue']);
                    unset($result[$key]);
                }
            }
        }
        return $result;
    }

    public function getOrderRemarks(): array
    {
        $remarks_list = $this->order_remarks;
        $this->order_remarks = [];
        return $remarks_list;
    }

    public function getRemarks(string $order_id): array
    {
        $result = [];
        $select = ['remark_id remarkCode', 'description remarkValue'];
        $result_set = $this->db->select($select)
            ->from('tb_order_remarks')
            ->where(['order_id' => $order_id, 'status' => 1])
            ->get();
        if ($result_set && $result_set->num_rows()) {
            $result = $result_set->result_array();
        }
        return $result;
    }

    public function getTripCargoSummary(int $shift_id): array
    {
        $result = [];
        $select = ["GROUP_CONCAT(id) id"];
        $result_set = $this->db->select($select)->from('tb_orders')->where(["shift_id" => $shift_id, 'status>' => 1])->limit(1)->get();
        if ($result_set && $result_set->num_rows()) {
            $result = $result_set->row_array();
        }
        $orderids = explode(',', $result['id']);

        $select = ['SUM(tb_cargo_details.dg_goods) dg_goods', 'tb_cargo_details.handling_unit'
            , 'SUM(tb_order_cargodetails.quantity) quantity', 'SUM(tb_order_cargodetails.length) length', 'tb_cargo_details.length_unit'
            , 'SUM(tb_order_cargodetails.width) width', 'tb_cargo_details.width_unit', 'tb_order_cargodetails.height'
            , 'tb_cargo_details.height_unit', 'SUM(tb_order_cargodetails.weight) as weight', 'tb_cargo_details.weight_unit'
            , 'SUM(tb_order_cargodetails.volume) volume', 'tb_cargo_details.volume_unit'];
        $result_set = $this->db->select($select)
            ->from('tb_order_cargodetails')
            ->join('tb_cargo_details', 'tb_order_cargodetails.cargo_id = tb_cargo_details.id')
            ->where(['tb_order_cargodetails.status' => 1, 'tb_cargo_details.status' => 1])
            ->where_in('order_id', $orderids)
            ->limit(1)
            ->get();
        if ($result_set && $result_set->num_rows()) {
            $result = $result_set->row_array();
        }
        return $result;
    }

    public function getCountryCodeBasedOnCountryName(string $countryName): array
    {

        $result = [];
        $result_set = $this->db->select(['phone_code', 'country_code'])
            ->from('tbl_country_master')
            ->where(['status' => 1, 'country_name' => $countryName])
            ->limit(1)
            ->get();
        if ($result_set && $result_set->num_rows()) {
            $result = $result_set->row_array();
        }
        return $result;
    }
}
