<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Completedordersmodel extends CI_Model
{
    function __construct() {
        parent::__construct();
    }

    function getCompletedOrdersbyTrip($tripid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($tripid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->where_in('o.shipmentid',$tripid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();
            //$qry = $this->db->query("select o.id FROM tb_orders o WHERE o.user_id=$cid AND o.status!=0 AND o.trip_id != 0 AND o.trip_sts=0 AND o.shipmentid IN('".$tripid."')");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyTripandCarrier($tripid,$carrierid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($tripid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_vendors v','v.id=o.vendor_id');
            $this->db->where_in('v.name',$carrierid);

            $this->db->where_in('o.shipmentid',$tripid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();
            //$qry = $this->db->query("select o.id FROM tb_orders o WHERE o.user_id=$cid AND o.status!=0 AND o.trip_id != 0 AND o.trip_sts=0 AND o.shipmentid IN('".$tripid."')");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyTripanddriver($tripid,$driverid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($tripid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_trips t','t.shift_id=o.shift_id');
            $this->db->join('tb_truck_drivers d','d.id=t.driver_id');
            $this->db->where_in('d.name',$driverid);

            $this->db->where_in('o.shipmentid',$tripid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();

            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyTripandCarrieranddriver($tripid,$carrierid,$driverid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($tripid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_vendors v','v.id=o.vendor_id');
            $this->db->where_in('v.name',$carrierid);
            $this->db->join('tb_trips t','t.shift_id=o.shift_id');
            $this->db->join('tb_truck_drivers d','d.id=t.driver_id');
            $this->db->where_in('d.name',$driverid);


            $this->db->where_in('o.shipmentid',$tripid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();
            //$qry = $this->db->query("select o.id FROM tb_orders o WHERE o.user_id=$cid AND o.status!=0 AND o.trip_id != 0 AND o.trip_sts=0 AND o.shipmentid IN('".$tripid."')");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyCarrier($carrierid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($carrierid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_vendors v','v.id=o.vendor_id');
            $this->db->where_in('v.name',$carrierid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();
            //$qry = $this->db->query("select o.id FROM tb_orders o JOIN tb_vendors v ON v.id=o.vendor_id WHERE o.vendor_id IN ('".$carrierid."') AND o.status!=0 AND o.user_id=$cid AND o.trip_id != 0 AND o.trip_sts=0");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyCarrieranddriver($carrierid,$driverid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($carrierid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_vendors v','v.id=o.vendor_id');
             $this->db->join('tb_trips t','t.shift_id=o.shift_id');
            $this->db->join('tb_truck_drivers d','d.id=t.driver_id');
            $this->db->where_in('d.name',$driverid);

            $this->db->where_in('v.name',$carrierid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();

            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    function getCompletedOrdersbyDriver($driverid){

        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($driverid)){

            $this->db->select('o.id');
            $this->db->from('tb_orders o');
            $this->db->join('tb_trips t','t.shift_id=o.shift_id');
            $this->db->join('tb_truck_drivers d','d.id=t.driver_id');
            $this->db->where_in('d.name',$driverid);
            $this->db->where(array('o.status !=' => 0, 'o.user_id' => $cid, 'o.trip_id !=' => 0,'o.trip_sts'=>1));
            $qry=$this->db->get();

            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->id;
                }
            }
        }
        return $res;
    }
    
    public function getOrderDetailsWithLatLngs(int $orderId): array
    {
        $getOrderDetails = $this->db->query("SELECT o.order_id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,o.created_source,o.user_id,o.customer_id,c.sendto_knlogin FROM tb_orders o,tb_customers c WHERE c.id = o.customer_id AND o.id = ?", [$orderId]);
        $orderDetails = $getOrderDetails->num_rows() > 0 ? $getOrderDetails->row_array() : [];
        $customerId = $orderDetails['customer_id'] ?? 0;
        $plat = $orderDetails['plat'] ?? "";
        $plng = $orderDetails['plng'] ?? "";
        $dlat = $orderDetails['dlat'] ?? "";
        $dlng = $orderDetails['dlng'] ?? "";
        $knLoginCustomer = $orderDetails['sendto_knlogin'] ?? 0;
        $bookingId = $orderDetails['order_id'] ?? "";
        $shiftId = $orderDetails['shift_id'] ?? 0;
        $tripId = $orderDetails['trip_id'] ?? 0;
        $userId = $orderDetails['user_id'] ?? $this->session->userdata('user_id');
        $createdSource = $knLoginCustomer === '1' ? "11" : $orderDetails['created_source'];
        if (in_array("", [$plat, $plng, $dlat, $dlng], true)) {
            $getLatLngs = $this->db->query("SELECT latitude,longitude FROM tb_site_settings WHERE user_id = ? ", [$userId]);
            $userLatLngs = $getLatLngs->num_rows() > 0 ? $getLatLngs->row_array() : [];
            $userLat = $userLatLngs['latitude'] ?? "";
            $userLng = $userLatLngs['longitude'] ?? "";
            $plat = $plat ?: $userLat;
            $plng = $plng ?: $userLng;
            $dlat = $dlat ?: $userLng;
            $dlng = $dlng ?: $userLng;
        }
        return ['plat' => $plat, 'plng' => $plng, 'dlat' => $dlat, 'dlng' => $dlng, 'createdSource' => $createdSource, 'userId' => $userId, 'bookingId' => $bookingId, 'shiftId' => $shiftId, 'tripId' => $tripId, 'customer_id' => $customerId];
    }

    public function getOrderAndCustomerDetails(int $orderId): array
    {
        $orderQuery = $this->db->query("SELECT o.id,o.order_id,o.pickup_address1,o.delivery_address1,o.user_id,o.company_code,o.branch_code,c.name,c.phone,c.code FROM tb_orders o,tb_customers c WHERE c.id = o.customer_id AND o.id = ?", [$orderId]);
        $orderData = $orderQuery->num_rows() > 0 ? $orderQuery->row_array() : [];
        $userId = $orderData['user_id'] ?? 0;
        if ($userId > 0) {
            $userQuery = $this->db->query("SELECT c.cntry_timezone,c.country_code FROM tbl_country_master c,tb_users u WHERE u.id = ? AND u.status = ? AND c.country_code = u.country_code AND c.status = ? ", [$userId, 'Active', 1]);
            $userData = $userQuery->num_rows() > 0 ? $userQuery->row_array() : [];
            return [
                'id' => $orderData['id'],
                'order_id' => $orderData['order_id'],
                'pickup_address1' => $orderData['pickup_address1'],
                'delivery_address1' => $orderData['delivery_address1'],
                'user_id' => $orderData['user_id'],
                'company_code' => $orderData['company_code'],
                'branch_code' => $orderData['branch_code'],
                'name' => $orderData['name'],
                'phone' => $orderData['phone'],
                'code' => $orderData['code'],
                'cntry_timezone' => $userData['cntry_timezone'] ?? "",
                'country_code' => $userData['country_code'] ?? ""
            ];
        }
        return [];
    }

    public function getOrderPodsData(int $orderId, int $docType, string $timeZone): object
    {
        if (in_array($docType, [3, 4], true)) {
            $query = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,convertToClientTZ(ts.createdon,?) as createdon, ts.imgpath, ts.hash FROM tb_pod_uploads ts,tb_document_types dt WHERE ts.order_id = ? AND ts.status = ? AND ts.doc_type = dt.id AND ts.doc_type = ? order by ts.createdon ASC", [$timeZone, $orderId, 1, $docType]);
        } else {
            $query = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,convertToClientTZ(ts.createdon,?) as createdon, ts.imgpath, ts.hash FROM tb_pod_uploads ts,tb_document_types dt WHERE ts.order_id = ? AND ts.status = ? AND ts.doc_type = dt.id AND ts.doc_type NOT IN ? order by ts.createdon ASC", [$timeZone, $orderId, 1, ['4', '3']]);
        }
        return $query;
    }

    public function getOrderPickupDeliveryDateTime(int $orderId, string $timeZone, array $data): array
    {
        $query = $this->db->query("SELECT stop_type,convertToClientTZ(createdon, ?) as createdon FROM tb_stop_status WHERE status_id = ? AND order_id = ? AND status = ?", [$timeZone, 1, $orderId, 1]);
        $result = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($result as $eachRow) {
            if ($eachRow['stop_type'] == "P") {
                $pickupDate = $eachRow['createdon'];
            } else {
                $deliveryDate = $eachRow['createdon'];
            }
        }
        $data['pickup_datetime'] = $pickupDate ?? "";
        $data['delivery_datetime'] = $deliveryDate ?? "";
        return $data;
    }
}
