<?php defined('BASEPATH') or exit('No direct script access allowed');
class Consolidationmodel extends CI_Model
{
    
    public function get_order_references($selected_orderids, $reference_codes)
    {
        $result = array();
        $this->db->select("order_id,GROUP_CONCAT(DISTINCT reference_id ORDER BY reference_id ASC SEPARATOR '??') as reference_id");
        $this->db->from("tb_order_references");
        $this->db->where_in("order_id", $selected_orderids);
        if (!empty($reference_codes)) {
            $this->db->where_in("reference_id", $reference_codes);
        }
        $this->db->where("status", 1);
        $this->db->group_by("order_id");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
    
    public function get_cargo_uom($final_ordid, $select_uom)
    {
        $result = array();
        $this->db->select($select_uom);
        $this->db->from("tb_cargo_details cd");
        $this->db->join("tb_order_cargodetails ocd", "cd.id=ocd.cargo_id", "LEFT");
        $this->db->where_in("ocd.order_id", $final_ordid);
        $this->db->where("ocd.status", 1);
        $this->db->group_by("order_id");
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }
   
    /*
	 *  Get filtred order details with bill status
	 *  @param: select string(required columns),array order_ids(id column from tb_orders),int tariff_type(type column from tb_reveneus),int shift_id(shift_id column from tb_orders)
	 *  return : array  (query result)    
	 */
    public function getOrderDetails(string $select, array $orderIds, int $tariffType, int $shiftId = 0): array
    {
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_reveneus r", "o.id=r.order_id", "LEFT");
        $this->db->join("tb_charges c", "c.revenue_id=r.id", "LEFT");
        $this->db->join("tbl_bills b", "r.bill_id=b.id", "LEFT");
        if ($shiftId > 0) {
            $this->db->join("tb_order_details od", "o.id=od.order_row_id ", "LEFT");
            $this->db->join("tb_customers cu", "o.customer_id=cu.id ", "LEFT");
            $this->db->where("shift_id", $shiftId);
            $this->db->where_in("r.recipient_role",['Customer','Carrier']);
        } else {
            $this->db->where("shift_id >", 0);
            $this->db->where_in("o.id", $orderIds);
            $this->db->where("r.type", $tariffType);
            $this->db->like('c.rate_id', 'GT', 'after');
        }
        $this->db->where_in("c.source_created",['RP - Rate Preference','AT - Apply Tariffs']);
        $this->db->where("c.status", 1);
        $this->db->where("r.status", 1);
        $this->db->order_by("o.id desc");
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getgeotierunitcharges($tier_id,$geo_from,$geo_to,$uom)
    {
        $cost = 0;
        $getcost = $this->db->query("SELECT cost FROM tb_geo_tier_sheet WHERE geo_tier_id='".$tier_id."' 
        AND geo_from LIKE '".$geo_from."' AND geo_to LIKE '".$geo_to."' AND uom1_min <= '".$uom."' 
        AND uom1_max >='".$uom."' AND status ='1'");
        if ($getcost->num_rows() > 0) {
			$cost = $getcost->row()->cost;
		}
        return $cost;
    }

    public function get_goods_value($order_ids, $select_uom)
    {
        $result = array();
        $this->db->select($select_uom);
        $this->db->from("tb_orders");
         $this->db->where_in("id", $order_ids);
        $this->db->where("status !=", 0);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }
    
    /*
	 *  Get state value of each party with customeridentifier from tbl_party_master
	 *  @param: string (customeridentifier  from tbl_party_master table)
	 *  return : array  (query result)    
	 */
    public function getPartyStates(string $select, array $partyCodes, string $companyCode): array
    {
        $this->db->select($select);
        $this->db->from("tbl_party_master");
        $this->db->where_in("customeridentifier", $partyCodes);
        $this->db->where("company_code", $companyCode);
        $this->db->where("status !=", 0);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
}
