<?php

class CostauditReportsmodel extends CI_Model
{
    public function getPostedOrders(array $where, array $countryUserIds): array
    {
        $actualAmount = " SUM( (CASE  WHEN ca.doc_type = 'KR'  THEN(ca.amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN ca.doc_type = 'KG'  THEN(ca.amount) ELSE 0  END) )
                        AS actual_amount  ";
        $select = " GROUP_CONCAT(DISTINCT(`ca`.`doc_num`) SEPARATOR ',') as document_no,`ca`.`currency`,
         GROUP_CONCAT(DISTINCT(`ca`.`doc_type`) SEPARATOR ',') as doc_type, " . $actualAmount . ",
         `ca`.`doc_date`,`o`.`order_id`,`c`.`type_name` as cost_center,
         `ot`.`type_name` as order_type,
         `tv`.`name` as vendor_name, `cu`.`code` as customer_code,`r`.`ref_value` as delivery_note";
        $this->db->select($select);
        $this->db->from("tb_carrier_cost_audit ca");
        $this->db->join("tb_orders o", "o.id=ca.order_id", "LEFT");
        $this->db->join("tb_order_details d", "ca.order_id=d.order_row_id", "LEFT");
        $this->db->join("tb_cost_center c", "d.cost_center_id=c.id", "LEFT");
        $this->db->join("tb_order_types ot", "d.order_type=ot.id", "LEFT");
        $this->db->join("tb_vendors tv", "tv.id=ca.vendor_id", "LEFT");
        $this->db->join("tb_customers cu", "cu.id=o.customer_id", "LEFT");
        $this->db->join("tb_order_references r", "r.order_id=o.id", "LEFT");
        if (!empty($countryUserIds)) {
            $this->db->where_in("o.user_id", $countryUserIds);
            unset($where["o.user_id"]);
        }
        $this->db->where($where);
        $this->db->where("ca.status", 3);
        $this->db->group_by("ca.order_id, `ca`.`vendor_id`");
        $this->db->order_by("o.createdon", 'DESC');
        $getData = $this->db->get();
        return $getData->num_rows() > 0 ? $getData->result_array() : [];
    }

}
