<?php

class Costauditmodel extends CI_Model
{
    public function getsearcheddata(array $checking_array, array $whr): array
    {
        $excelAmount = "(SELECT
                        SUM( (CASE  WHEN cac.doc_type = 'KR' THEN(cac.amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN cac.doc_type = 'KG' THEN(cac.amount) ELSE 0  END) )
                        AS excel FROM tb_carrier_cost_audit cac WHERE  `cac`.`order_id` = `o`.`id`) ";
        $select = "`o`.`id`,`o`.`order_id`,`o`.`customer_id`,`o`.`company_code`,`o`.`branch_code`,  " . $excelAmount . " AS excelamount,`pm`.`currency` AS `ecurrency`,
                `ca`.`currency` AS `ccurrency`, `pm`.`amount` AS `order_cost`,`pm`.`accrual_amount`, `tv`.`name`,`tv`.`code`,
                `pm`.`id` AS `business_partner_id`,`o`.`resolution_id`, `ca`.`tcca_id` AS `cost_audit_id`,
                `ca`.`remarks`,`ca`.`status` `audit_status`,  `ca`.`doc_num`,  `ca`.`doc_type`, `ca`.`doc_date`";
        $this->db->select($select);
        $this->db->from("tb_orders o");
        $this->db->join("tb_carrier_cost_audit ca", "ca.order_id=o.id", "LEFT");
        $this->db->join("tb_reveneus pm", "pm.order_id=ca.order_id", "LEFT");
        $this->db->join("tb_vendors tv", "tv.id=ca.vendor_id", "LEFT");
        $whereCond = ["o.status !=" => 0, "ca.vendor_id !=" => '', "pm.TYPE =" => 1,"pm.status =" => 1, "pm.recipient_role =" => 'Carrier'];
        $this->db->where($whereCond);
        $this->db->where($whr);
        if (!empty($checking_array) && isset($checking_array['user_id']) && ($checking_array['user_id'] != '')) {
            $this->db->where("o.user_id", $checking_array['user_id']);
        }
        if (isset($checking_array['order_ids']) && !empty($checking_array['order_ids'])) {
            $this->db->where_in("ca.order_id", $checking_array['order_ids']);
        }
        $this->db->group_by("ca.order_id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        return $getorder->num_rows() > 0 ? $getorder->result_array() : [];
    }

    public function getcostauditbyorder( $whr,$whr_in='')
    {
        $this->db->select("o.order_id,ca.tcca_id,ca.doc_num,ca.doc_type,ca.doc_date,ca.amount,ca.currency,tv.name as vendor_name , pm.id as business_partner_id,`pm`.`currency` AS `ecurrency`,`pm`.`amount` AS `order_cost`,`ca`.`remarks`,`ca`.`status`,`tv`.`code`");
        $this->db->from("tb_carrier_cost_audit ca");
        $this->db->join("tb_orders o","ca.order_id=o.id","LEFT");
        $this->db->join("tb_reveneus pm","pm.order_id=ca.order_id","LEFT");
        $this->db->join("tb_vendors tv","tv.id=ca.vendor_id","LEFT");
        $this->db->group_by("ca.tcca_id");
        $this->db->order_by("ca.tcca_id",'DESC');
        $this->db->where($whr);
        if($whr_in != '') {
            $this->db->where_in("o.id", $whr_in);
        }
        $getorder = $this->db->get();
        if($getorder->num_rows() >0){
            $result = $getorder->result_array();
        }
        return $result;
    }

    public function getauditdata(array $checking_array, array $whr, int $isDocumentNumberSet): array
    {
        if ($isDocumentNumberSet == 1 && empty($checking_array['order_ids'])) {
            return [];
        }
        $excelAmount = " SUM( (CASE  WHEN ca.doc_type = 'KR'  THEN(ca.amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN ca.doc_type = 'KG'  THEN(ca.amount) ELSE 0  END) )
                        AS excelamount  ";
        $approvedAmount = " SUM( (CASE  WHEN ca.doc_type = 'KR' AND ca.status IN (1,3)  THEN(ca.amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN ca.doc_type = 'KG' AND ca.status IN (1,3)  THEN(ca.amount) ELSE 0  END) )
                        AS approved_amount  ";
        $select = "`o`.`id`,`o`.`order_id`,`o`.`customer_id`,`o`.`company_code`,`o`.`branch_code`, " . $excelAmount . ", " . $approvedAmount . ",
                `ca`.`currency` AS `ccurrency`, `tv`.`name`, `tv`.`code`,
                `o`.`resolution_id`, `ca`.`tcca_id` AS `cost_audit_id`,
                `ca`.`remarks`, GROUP_CONCAT(`ca`.`status`) as `audit_status`,  `ca`.`doc_num`,  `ca`.`doc_type`, `ca`.`doc_date`,`ca`.`vendor_id`";
        $this->db->select($select);
        $this->db->from("tb_carrier_cost_audit ca");
        $this->db->join("tb_orders o", "o.id=ca.order_id", "LEFT");
        $this->db->join("tb_vendors tv", "tv.id=ca.vendor_id", "LEFT");
        $whereCond = ["o.status !=" => 0, "ca.vendor_id !=" => ''];
        $this->db->where($whereCond);
        $this->db->where($whr);
        if (!empty($checking_array) && isset($checking_array['user_id']) && ($checking_array['user_id'] != '')) {
            $this->db->where("o.user_id", $checking_array['user_id']);
        }
        if (isset($checking_array['order_ids']) && !empty($checking_array['order_ids'])) {
            $this->db->where_in("ca.order_id", $checking_array['order_ids']);
        }
        $this->db->group_by("ca.order_id, `ca`.`vendor_id`");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        return $getorder->num_rows() > 0 ? $getorder->result_array() : [];
    }

    function getrevenuedata($order_id,$vendor_code)
    {
        $this->db->select("`pm`.`currency` AS `ecurrency`,`pm`.`amount` as `order_cost`,`pm`.`accrual_amount`,`pm`.`id` AS `business_partner_id`");
        $this->db->from("tb_reveneus pm");
        $whereCond = ["pm.TYPE =" => 1,"pm.status =" => 1, "pm.recipient_role =" => 'Carrier',"pm.order_id =" => $order_id,"pm.recipient_code =" => $vendor_code];
        $this->db->where($whereCond);
        $res = $this->db->get();
        $result=[];
        if($res->num_rows() > 0){
            $result = $res->row_array();
        }
        return $result;
    }

    public function batchUpdate($tableName, $data, $key): void
    {
        $this->db->update_batch($tableName, $data, $key);
    }

    public function getOrderIdsByDocumentNo(string $documentNo): array
    {
        $this->db->select("order_id");
        $this->db->from("tb_carrier_cost_audit");
        $this->db->where("doc_num", $documentNo);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $row) {
            $orderIds[] = $row['order_id'];
        }
        return $orderIds ?? [];
    }

    public function getDocumentNosWithOrderIds(array $orderIds, array $vendorIds,): array
    {
        $sql = "SELECT order_id,doc_type,GROUP_CONCAT(DISTINCT(doc_num) SEPARATOR ',') as document_no,GROUP_CONCAT(DISTINCT(doc_date) SEPARATOR ',') as document_date FROM `tb_carrier_cost_audit` WHERE `order_id` IN ? AND `vendor_id` IN ? AND `status` = ? GROUP by doc_type,order_id";
        $query = $this->db->query($sql, [$orderIds, $vendorIds, 3]);
        foreach ($query->result_array() as $eachRow) {
            if ($eachRow['doc_type'] == 'KR') {
                $result[$eachRow['order_id']]['invoice_number'] = $eachRow['document_no'];
                $result[$eachRow['order_id']]['invoice_date'] = $eachRow['document_date'];
            }
            if ($eachRow['doc_type'] == 'KG') {
                $result[$eachRow['order_id']]['credit_note_number'] = $eachRow['document_no'];
                $result[$eachRow['order_id']]['credit_date'] = $eachRow['document_date'];
            }
            $result[$eachRow['order_id']]['order_id'] = $eachRow['order_id'];
        }
        return $result ?? [];
    }

    public function getActualAmountSum(array $costAuditRecordIds): float
    {
        $this->db->select("SUM( (CASE  WHEN doc_type = 'KR'  THEN(amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN doc_type = 'KG'  THEN(amount) ELSE 0  END) )
                        AS actual_amount ");
        $this->db->from("tb_carrier_cost_audit");
        $this->db->where_in("tcca_id", $costAuditRecordIds);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? (float) $getResult->row()->actual_amount : 0.0;
    }

    public function getApprovedAmountSum(int $orderId, int $vendorId): float
    {
        $this->db->select("SUM( (CASE  WHEN doc_type = 'KR'  THEN(amount) ELSE 0  END) ) -
                        SUM( (CASE WHEN doc_type = 'KG'  THEN(amount) ELSE 0  END) )
                        AS actual_amount ");
        $this->db->from("tb_carrier_cost_audit");
        $this->db->where("order_id", $orderId);
        $this->db->where("vendor_id", $vendorId);
        $this->db->where_in("status", [1,3]);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? (float) $getResult->row()->actual_amount : 0.0;
    }

    public function getDocumentStatus(int $orderId, int $vendorId, string $documentNumber): array
    {
        $this->db->select("MAX(status) as status");
        $this->db->from("tb_carrier_cost_audit");
        $this->db->where("order_id", $orderId);
        $this->db->where("vendor_id", $vendorId);
        $this->db->where("doc_num", $documentNumber);
        $getResult = $this->db->get();
        $status = 0;
        if ($getResult->num_rows() > 0) {
            $status = (int)$getResult->row()->status;
        }
        return [$status];
    }

}
