<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Crud extends CI_Model
{
    public $tablename = "";

    public function __construct($table)
    {
        parent::__construct();
        $this->tablename = $table;
    }

    public function validate($data)
    {
        $data['password'] = $this->encrypt($data['password']);
        return $this->db->where($data)->get($this->tablename);
    }

    public function selectOne($data)
    {
        return $this->db->where($data)->get($this->tablename);
    }

    public function selectAll($order_by, $order_type, $whr, $limit = "", $start = "")
    {
        //echo $limit."->".$start."<br>";
        if ($whr != "") {
            $this->db->where($whr);
        }
        if ($order_by != "" && $order_type != "") {
            $this->db->order_by($order_by, $order_type);
        }

        if ($start >= 0 and $limit > 0) {
            $this->db->limit($limit, $start);
        }

        return $this->db->get($this->tablename);
        //echo $this->db->last_query();

    }

    public function insert($data)
    {
        $this->db->insert($this->tablename, $data);
        return $this->db->insert_id();
    }

    public function update($set, $whr)
    {
        $this->db->set($set)->where($whr)->update($this->tablename);
        return true;
    }

    public function delete($data)
    {
        $this->db->where($data)->delete($this->tablename);
        return true;
    }

    public function where_in($whr, $tbname)
    {
        $this->db->where_in($whr);
        return $this->db->get($tbname);
    }
    /** Added by Rushi**/
    public function find($whr, $tbname)
    {
        $this->db->where($whr);
        return $this->db->get($tbname);
    }

    /** End **/
    public function where_not_in()
    {
        $this->db->where_not_in($whr);
        return $this->db->get($tbname);
    }

    public function get_single_data($allSourceTables, $whr, $returnfields)
    {
        $this->db->where($whr);
        return $this->db->get($allSourceTables);
    }

    public function get_count($whr)
    {
        $this->db->select('id');
        $this->db->where($whr);
        return $this->db->get($this->tablename);
    }

    public function passwordEncrypt($password)
    {
        //return $password;
        return password_hash($password,PASSWORD_DEFAULT);
    }

    public function selectAllWherein($order_by, $order_type, $whr, $whrin, $limit = "", $start = "")
    {
        //echo $limit."->".$start."<br>";

        if ($whrin != "") {
            $this->db->where_in("parent_id", $whrin);
        }
        if ($whr != "") {
            /* print_r($whr);
            exit; */
            if (isset($whr['search_by'])) {
                $this->db->like('name', $whr['search_by']);
                $this->db->or_like('mobile_no', $whr['search_by']);
                unset($whr['search_by']);
            }
            if (isset($whr['lids'])) {
                $this->db->where_in("location_id", $whr['lids']);
                unset($whr['lids']);
            }

            $this->db->where($whr);
        }
        if ($order_by != "" && $order_type != "") {
            $this->db->order_by($order_by, $order_type);
        }

        if ($start >= 0 and $limit > 0) {
            $this->db->limit($limit, $start);
        }

        return $this->db->get($this->tablename);
        //echo $this->db->last_query();

    }

}
