<?php

class CustomerDailyReportModel extends CI_Model
{
    public function getCarrierOrdersReport(): array
    {
        $sql = "SELECT
               `o`.`id`,
               `o`.`order_id`,
               `o`.`pickup_company`,
               `o`.`delivery_company`,
               CONCAT_WS(', ',
                            IF(LENGTH(`o`.`pickup_address1`),`o`.`pickup_address1`,NULL),
                            IF(LENGTH(`o`.`pickup_city`),`o`.`pickup_city`,NULL),
                            IF(LENGTH(`o`.`pickup_address2`),`o`.`pickup_address2`,NULL),
                            IF(LENGTH(`o`.`pickup_country`),`o`.`pickup_country`,NULL),
                            IF(LENGTH(`o`.`pickup_pincode`),`o`.`pickup_pincode`,NULL)
                    ) as pickupAddress,
               CONCAT_WS(', ',
                            IF(LENGTH(`o`.`delivery_address1`),`o`.`delivery_address1`,NULL),
                            IF(LENGTH(`o`.`delivery_city`),`o`.`delivery_city`,NULL),
                            IF(LENGTH(`o`.`delivery_address2`),`o`.`delivery_address2`,NULL),
                            IF(LENGTH(`o`.`delivery_country`),`o`.`delivery_country`,NULL),
                            IF(LENGTH(`o`.`delivery_pincode`),`o`.`delivery_pincode`,NULL)
                    ) as deliveryAddress,
               `o`.`shift_id`,
               `o`.`shipmentid`,
               `o`.`shift_id`,
               DATE_FORMAT(convertToClientTZ(`o`.`pickup_datetime` , c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'early_pickup_datetime',
               DATE_FORMAT(convertToClientTZ(`o`.`delivery_datetime` , c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'early_drop_datetime',
              (SELECT GROUP_CONCAT(
                concat(r.reference_id, ' - ', r.ref_value) SEPARATOR '?????'
              ) FROM tb_order_references r
                        WHERE r.order_id = o.id AND reference_id IN ('DQ') AND status = 1) AS order_references,
            cu.name as customer_name,
            cu.code as customer_code,
            cu.email_id as customer_email_id,
            v.code as carrier_code,
            v.email as carrier_email_id,
           DATE_FORMAT(convertToClientTZ(s.createdon, c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'actual_pickup_datetime',
            DATE_FORMAT(convertToClientTZ(s1.createdon, c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'actual_delivery_datetime',
           (IF((SELECT count(id) FROM tb_pod_uploads WHERE order_id=o.id AND status=1 AND doc_type='3' AND stop_type='D' group by order_id) > 0, 'YES', 'NO')) AS 'pod_status'
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_details` `od` ON `o`.`id` = `od`.`order_row_id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
              LEFT JOIN `tb_branch_master` `bm` ON `o`.`branch_code` = `bm`.`branch_code`
              LEFT JOIN `tb_customers` `cu` ON `o`.`customer_id` = `cu`.`id`
              LEFT JOIN `tb_vendors` `v` ON `o`.`vendor_id` = `v`.`id`
              LEFT JOIN `tb_stop_status` `s` ON `o`.`id` = `s`.`order_id` AND `s`.`status_code` = '0500' AND `s`.`status` = 1
              LEFT JOIN `tb_stop_status` `s1` ON `o`.`id` = `s1`.`order_id` AND `s1`.`status_code` = '3000' AND `s1`.`status` = 1
            WHERE  `o`.`customer_id` > ? AND `o`.`company_code` = ? AND `o`.`trip_sts` = ? AND `o`.`status` != ? AND DATE(`o`.`createdon`) BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND `cu`.`code` IN ? GROUP BY o.id ORDER BY o.id DESC";
        $query = $this->db->query($sql, [0, 'PHKN', 0, 0, ['1005751990', '1000612148', '1005202085']]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCargoDetails(array $orderRowIds = []): array
    {
        if (empty($orderRowIds)) {
            return [];
        }
        $this->db->select('ocd.order_id,SUM(cd.quantity) as quantity, GROUP_CONCAT(DISTINCT cd.cargo_type) as cargo_type,SUM(cd.weight) as weight,cd.weight_unit,GROUP_CONCAT(DISTINCT cd.goods_description)as goods_description');
        $this->db->from("tb_cargo_details cd");
        $this->db->join('tb_order_cargodetails ocd', 'cd.id= ocd.cargo_id', 'LEFT');
        $this->db->where_in('ocd.order_id', $orderRowIds);
        $this->db->where('ocd.status', 1);
        $this->db->group_by('ocd.order_id');
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $eachRow) {
            $results[$eachRow['order_id']] = $eachRow;
        }
        return $results ?? [];
    }
}
