<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customeraddress extends CI_Model
{
    function selectlist(string $select, string $table, array $whr, string $group): array
    {
        $getcustcode = [];
        $this->db->select($select);
        $this->db->where($whr);
        $this->db->from($table);
        $this->db->group_by($group);
        $res = $this->db->get();
        $getcustcode = $res->result_array();
        return $getcustcode;
    }
    function selectCountries(): array
    {
        $getcustcode = [];
        $this->db->select('tkg.country as countryCode,tcm.country_name as countryName');
        $this->db->from('tb_kn_geocodes tkg');
        $this->db->join('tbl_country_master tcm', 'tkg.country = tcm.country_code');
        $this->db->group_by('countryCode');
        $this->db->order_by('tcm.country_name');
        $res = $this->db->get();
        $getcustcode = $res->result_array();
        return $getcustcode;
    }

    public function getPartyTypes(string $companyCode, string $branchCode,array $allCustomerIds): array
    {
        $this->db->select("id");
        $this->db->from("tbl_party_types");
        $this->db->where("company_code", $companyCode);
        $this->db->where("branch_code", $branchCode);
        $this->db->where_in("name", $allCustomerIds);
        $this->db->group_by('name');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $type) {
                $dataIds[] = $type->id;
            }
        }
        return $dataIds;
    }

    function getsearchdata(array $whr, array $where): array
    {
        $this->db->select('id,name,email,mobile,street,location_id,state,country,pincode,customer_code,code,company_code,status');
        $this->db->from('tbl_party_master');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    function getData(int $id): array
    {
        $this->db->select('id,name,email,mobile,house_number,street,location_id,state,country,pincode,customer_code,code,latitude,longitude');
        $this->db->from('tbl_party_master as tt');
        $this->db->where('tt.id', $id);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
}

