<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customreferencesmodel extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    public function getStatusCodeId(string $statusCode, string $statusName): int
    {
        $currentDate = date('Y-m-d H:i:s');
        $getStatusCode = $this->db->query("SELECT id FROM tb_status_master WHERE status_code =?", [$statusCode]);
        if ($getStatusCode->num_rows() == 0) {
            $statusCodeData = ['status_name' => $statusName, 'description' => $statusName, 'status_type' => 'yes', 'status_code' => $statusCode, 'status' => 1, 'createdon' => $currentDate, 'updatedon' => $currentDate];
            $this->db->insert("tb_status_master", $statusCodeData);
            $statusId = $this->db->insert_id();
        } else {
            $statusId = $getStatusCode->row()->id;
        }
        return $statusId ?? 0;
    }

    public function getReferenceId(array $orderInformation): int
    {
        $currentDate = date('Y-m-d H:i:s');
        $getReferenceCode = $this->db->query("SELECT id FROM tb_reference_master WHERE name =?", [$orderInformation['statusCode']]);
        if ($getReferenceCode->num_rows() == 0) {
            $statusCodeData = ['name' => $orderInformation['statusCode'], 'description' => $orderInformation['StatusName'], 'status' => 1, 'createdon' => $currentDate, 'updatedon' => $currentDate];
            $this->db->insert("tb_reference_master", $statusCodeData);
            $referenceId = $this->db->insert_id();
        } else {
            $referenceId = $getReferenceCode->row()->id;
        }
        return $referenceId ?? 0;
    }

    public function getUserTimeZone(int $userId): string
    {
        $timeZone = "Asia/Singapore";
        $countryCodeDetails = $this->db->query("SELECT country_code FROM tb_users WHERE id =" . $userId . " ");
        $countryCode = $countryCodeDetails->num_rows() > 0 ? $countryCodeDetails->row()->country_code : "";
        if ($countryCode != "") {
            $countryTimeZone = $this->db->query(
                "SELECT cntry_timezone FROM tbl_country_master WHERE country_code ='" . $countryCode . "' AND status=1 LIMIT 1"
            );
            $timeZone = $countryTimeZone->num_rows() > 0 ? $countryTimeZone->row()->cntry_timezone : "Asia/Singapore";
        }
        return $timeZone;
    }

    public function insertOrderStatus(array $statusData): void
    {
        $currentDate = date('Y-m-d H:i:s');
        $statusData['status'] = 1;
        $getOrderStatus = $this->db->query("SELECT * FROM tb_order_status WHERE order_id =? and status_id=? and status_code= ?", [$statusData['order_id'], $statusData['status_id'], $statusData['status_code']]);
        if ($getOrderStatus->num_rows() == 0) {
            $statusData['createdon'] = $currentDate;
            $this->db->insert("tb_order_status", $statusData);
        } else {
            $statusData['updatedon'] = $currentDate;
            $this->db->where(['id' => $getOrderStatus->row()->id])->update("tb_order_status", $statusData);
        }
    }

    public function addOrderReferences(array $referenceData): void
    {
        $currentDate = date('Y-m-d H:i:s');
        $referenceData['status'] = 1;
        $getReference = $this->db->query("SELECT * FROM tb_order_references WHERE order_id =? and reference_id=? and status= 1", [$referenceData['order_id'], $referenceData['reference_id']]);
        if ($getReference->num_rows() == 0) {
            $referenceData['createdon'] = $currentDate;
            $this->db->insert("tb_order_references", $referenceData);
        } else {
            $referenceData['updatedon'] = $currentDate;
            $this->db->where(['id' => $getReference->row()->id])->update("tb_order_references", $referenceData);
        }
    }

    public function checkOrderCarrier(int $orderId): int
    {
        $this->db->select("tv.name");
        $this->db->from("tb_orders o");
        $this->db->join("tb_vendors tv", "o.vendor_id = tv.id", "INNER");
        $this->db->where("o.id =", $orderId);
        $this->db->where("o.user_id =", 244);
        $this->db->where("tv.name", "BLOWHORN");
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? 1 : 0;
    }
}
