<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DashboardTripViewModel extends CI_Model
{
    /*public function SearchTripData($tripId)
    {
        $this->db->select('slat, slng, elat, elng');
        $this->db->from('tb_shifts');
        $this->db->where('shipmentid', $tripId);
        $query = $this->db->get();
        log_message('error', 'Query executed: ' . $this->db->last_query());
        return $query->row(); // Add this return
    }*/
    /*public function SearchTripData($tripId)
    {
        //log_message('error', 'came to tripData model');
        $this->db->select('id,slat, slng, elat, elng,splace,eplace');
        $this->db->from('tb_shifts');
        $this->db->where('shipmentid', $tripId);
        if ($this->session->userdata('cust_id')) {
            $cid = $this->session->userdata('cust_id');
            $this->db->where('customer_id', $cid);
        }
        $query = $this->db->get();
        $result = $query->row();
        $status = $this->tripStatusData($result->id);
        $reg_no = $status->register_number ?? null;
        return ['trip_data' => $result, 'veh_no' => $reg_no];
    }*/
    public function SearchTripData($tripid)
    {
        $shiftquery = $this->db->select('id')
            ->from('tb_shifts')
            ->where('shipmentid', $tripid)
            ->get();
        $shiftid = $shiftquery->row();
        $leg_ids = $this->multilegcheck($shiftid->id);
        $ids = array_column($leg_ids, 'id');
        if (count($ids) == 0) {
            $this->db->select('id,plat as slat, plng as slng, dlat as elat, dlng as elng,pickup_city as splace,delivery_city as eplace,transport_mode');
            $this->db->from('tb_orders');
            $this->db->where('shift_id', $shiftid->id);
            $this->db->where('shipmentid!=','');
            if ($this->session->userdata('cust_id')) {
                $cid = $this->session->userdata('cust_id');
                $this->db->where('customer_id', $cid);
            }
            $query = $this->db->get();
            $result = $query->result_array();
            $status = $this->tripStatusData($result[0]['id']);
            $reg_no = $status->register_number ?? null;
            //log_message('error', 'stops data:' . print_r($result, true));
            return ['trip_data' => (object)$result, 'veh_no' => $reg_no, 'is_multi_leg' => false, 'shift_id' => $shiftid->id];
        } else {
            $this->db->select('id, slat, slng, elat, elng, splace, eplace,transport_mode')
                ->from('tb_shifts')
                ->where_in('id', $ids);
            if ($this->session->userdata('cust_id')) {
                $cid = $this->session->userdata('cust_id');
                $this->db->where('customer_id', $cid);
            }
            $query = $this->db->get();
            $result = $query->result_array();
            $status = $this->tripStatusData($result[0]['id']);
            $reg_no = $status->register_number ?? null;
            return ['trip_data' => (object)$result, 'veh_no' => $reg_no, 'is_multi_leg' => true, 'shift_id' => $shiftid->id];
        }
    }

    public function multilegcheck($shiftid)
    {
        $legs = $this->db->select('id')
            ->from('tb_shifts')
            ->where('shift_leg_id', $shiftid)
            ->order_by('id', 'ASC')
            ->get();
        $legids = $legs->result_array();
        return $legids;
    }



    public function tripStatusData($shift_id)
    {
        $this->db->select('register_number');
        $this->db->from('tb_shft_veh');
        $this->db->where('shft_id', $shift_id);
        $query = $this->db->get();
        return $query->row();
    }

    public function shiftsdata($vendor_id)
    {
        if ($vendor_id != '') {
            if ($cid = $this->session->userdata('cust_id')) {
                //log_message('error', 'vendor_id:' . $cid);
                $this->db->select('id,shipmentid');
                $this->db->from('tb_shifts');
                $this->db->where('vendor_id', $vendor_id);
                $this->db->where('customer_id', $cid);
                $query = $this->db->get();
                return $query->result_array();
            } else {

                //log_message('error', 'vendor_id:' . $cid);
                $this->db->select('id,shipmentid');
                $this->db->from('tb_shifts');
                $this->db->where('vendor_id', $vendor_id);
                $query = $this->db->get();
                return $query->result_array();
            }
        }
    }

    public function SearchTripDataByVehicle($vehicleId)
    {
        //$cust_id=$this->session->userdata('cust_id');
        $this->db->select('s.id, s.slat, s.slng, s.elat, s.elng, s.splace, s.eplace, v.register_number as veh_no,s.transport_mode');
        $this->db->from('tb_shft_veh v');
        $this->db->join('tb_shifts s', 'v.shft_id = s.id', 'inner');
        $this->db->where('v.register_number', trim($vehicleId));
        $this->db->where('s.status', 1);
        if ($cid = $this->session->userdata('cust_id')) {
            $this->db->where('s.customer_id', $cid);
        }
        $this->db->order_by('s.id', 'DESC');
        $query = $this->db->get();
        $trip_data = $query->num_rows() > 0 ? $query->result_array() : null;
        //log_message('error', 'trip data:' . print_r($trip_data, true));
        return ['trip_data' => $trip_data, 'veh_no' => $trip_data->veh_no ?? null];
    }

    public function getCurrentLocation($vehno)
    {
        $query = $this->db->select('latitude,longitude')
            ->from('tb_trucks_data')
            ->where('truck_number', $vehno)
            ->get();
        $currentLatLng = $query->row();
        //log_message('error', 'currentlatlang:' . print_r($currentLatLng, true));
        return $currentLatLng;
    }

}
