<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class DataArrayFormatter_model extends CI_model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function buildGenericArray($inputArray)
    {
        $finalArray = array();
        if (!empty($inputArray) && sizeof($inputArray) > 0) {
            foreach ($inputArray as $eachInput) {
                $getArray = $this->formatGenericParameters($eachInput);
                if (!empty($getArray) && sizeof($getArray) > 0) {
                    $x = 0;
                    foreach ($getArray as $inner) {
                        foreach ($inner as $key => $value) {
                            //echo $x;
                            $finalArray[$x][$key] = $value;
                            $x++;
                        }
                    }
                }
            }
        }
        return $finalArray;
    }

    public function formatGenericParameters($genericData, $type = '')
    {
        $finalReqArray = array();
        $genericDataArray = explode('?????', $genericData);
        if (!empty($genericDataArray) && sizeof($genericDataArray) > 0) {
            foreach ($genericDataArray as $eachRow) {
                $reqArray = $this->getGenericParameters($eachRow, $type);
                array_push($finalReqArray, $reqArray);
            }
        }
        return $finalReqArray;
    }

    public function getGenericParameters($genericParam, $type = '')
    {
        $finalArray = array();
        if ($type == 'BasicShipment_OrderStatus') {
            $finalArray = array('status_date' => '', 'status_code' => '');
        }

        if (!empty($genericParam) && $genericParam != '') {
            $requiredArray = explode('+++++', $genericParam);
            //echo "<pre>";print_r($requiredArray);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                foreach ($requiredArray as $eachItem) {
                    $eachArray = explode('=====', $eachItem);
                    if (!empty($eachArray) && sizeof($eachArray) > 0) {
                        $key = $value = 0;
                        if (isset($eachArray[0])) {
                            $key = $eachArray[0];
                        }
                        if (isset($eachArray[1])) {
                            $value = $eachArray[1];
                        }
                        $finalArray[$key] = $value;
                    }
                }
            }
        }
        return $finalArray;
    }

    public function formatReferenceParameters($refData)
    {
        $finalReqArray = array();
        $referenceDataArray = explode('?????', $refData);
        if (!empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveReferenceParameters($eachRefData);
                $key = $reqArray['type'];
                $value = $reqArray['value'];
                $finalReqArray[$key] = $value;
            }
        }
        return $finalReqArray;
    }

    public function giveReferenceParameters($referenceParam)
    {
        $finalArray = array();
        if (!empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray['type'] = trim($requiredArray[0]);
                $finalArray['value'] = trim($requiredArray[1]);
            }
        }
        return $finalArray;
    }

    public function getCommaSeparatedFields($reqiredFields = array(), $dataArray = array())
    {
        $finalArray = array();
        if (isset($dataArray) && sizeof($dataArray) > 0) {
            $tempArray = array();
            foreach ($dataArray as $eachRow) {
                if (isset($eachRow['id'])) {
                    $index = $eachRow['id'];
                    $finalArray['orders'][$index] = $eachRow;
                    foreach ($eachRow as $key => $value) {
                        if (in_array($key, $reqiredFields)) {
                            if ($key == 'order_id') {
                                if ($value != '') {
                                    if (isset($tempArray[$key]) && $tempArray[$key] != '') {
                                        $tempArray[$key] = $tempArray[$key] . $value . ',';
                                    } else {
                                        $tempArray[$key] = $value . ',';
                                    }
                                }
                            } else {
                                if ($value != '' && $value > 0) {
                                    if (isset($tempArray[$key]) && $tempArray[$key] != '') {
                                        $tempArray[$key] = $tempArray[$key] . $value . ',';
                                    } else {
                                        $tempArray[$key] = $value . ',';
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (isset($tempArray) && sizeof($tempArray) > 0) {
                foreach ($tempArray as $key => $value) {
                    $trimmedValue = trim($value, ',');
                    $finalArray['commaSeparated'][$key] = $trimmedValue;
                }
            }
        }
        return $finalArray;
    }

    public function getCommaSeparatedUnqiloOrdFields($reqiredFields = array(), $dataArray = array())
    {
        $finalArray = array();
        if (isset($dataArray) && sizeof($dataArray) > 0) {
            $tempArray = array();
            foreach ($dataArray as $eachRow) {
                if (isset($eachRow['id'])) {
                    $index = $eachRow['id'];
                    $finalArray['orders'][$index] = $eachRow;
                    foreach ($eachRow as $key => $value) {
                        if (in_array($key, $reqiredFields)) {
                            if ($value != '') {
                                if (isset($tempArray[$key]) && $tempArray[$key] != '') {
                                    $tempArray[$key] = $tempArray[$key] . $value . ',';
                                } else {
                                    $tempArray[$key] = $value . ',';
                                }
                            }
                        }
                    }
                }
            }
            if (isset($tempArray) && sizeof($tempArray) > 0) {
                foreach ($tempArray as $key => $value) {
                    $trimmedValue = trim($value, ',');
                    $finalArray['commaSeparated'][$key] = $trimmedValue;
                }
            }
        }
        return $finalArray;
    }
}

?>
