<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class DataQueryFormatter_model extends CI_model
{
    public function __construct()
    {
        parent::__construct();
    }

    // the below method will convert the multiple rows of same order in to single row for order reference for a single order.
    public function getOrderReferenceData(string $orderids, array $data, string $codes = ''): array
    {
        if ($codes != '') {
            //do nothing
        } else {
            $codes = "'DQ','PO','BN','CTR','COI','LPC','ORD','XSR','AWB','PQ', 'IV'";
        }
        if ($orderids != '') {
            $sql = "select  order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
                SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                         FROM tb_order_references ar where
                         reference_id IN ($codes) and status='1' and order_id in ($orderids)


                 ) AS final_ref group by order_id ";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && count($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $value = $each['reference_value'];
                        $data['orders'][$index]['reference_value'] = $value;
                    }
                }
            }
        }
        return $data;
    }

    /* get uniqlo order reference data */
    public function getUniqloOrderReferenceData(string $orderids, array $data, string $codes = ''): array
    {
        if ($codes != '') {
            //do nothing
        } else {
            $codes = "'DQ','PO','BN','CTR','COI','LPC','ORD','XSR','AWB'";
        }
        $awbArr = array();
        $awbdata = "";
        if ($orderids != '') {
            $sql = "select  order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
                SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                         FROM tb_order_references ar where
                         reference_id IN ($codes) and status='1' and order_id in ($orderids)
                         group by order_id,reference_id

                 ) AS final_ref group by order_id ";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $value = $each['reference_value'];
                        $data['orders'][$index]['reference_value'] = $value;
                        if ($value != "") {
                            $referenceDataArray = explode('?????', $value);
                            if (!empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
                                foreach ($referenceDataArray as $eachRefData) {
                                    if (!empty($eachRefData) && $eachRefData != '') {
                                        $requiredArray = explode('=====', $eachRefData);
                                        if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                                            $reftype = trim($requiredArray[0]);
                                            if ($reftype == "AWB") {
                                                $awbArr[] = trim($requiredArray[1]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!empty($awbArr)) {
                    $awbdata = implode(",", $awbArr);
                }
            }
        }
        $data['commaSeparated']['awb_num'] = $awbdata;
        return $data;
    }

    // the below method will convert the multiple rows of cargos in to single row for an order
    public function getOrderCargoDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "SELECT order_id,sum(c.weight) as totwg,sum(c.quantity) as totqty,sum(c.volumetric_weight) as volumetric_weight,
            sum(c.volume) as totvolume,sum(c.scanned_quantity) as scanned_quantity
            FROM tb_order_cargodetails c
            where status=1 and order_id>0  and c.order_id in ($orderids) group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['totwg'] = $each['totwg'];
                        $data['orders'][$index]['totwg'] = $each['totwg'];
                        $data['orders'][$index]['totqty'] = $each['totqty'];
                        $data['orders'][$index]['volumetric_weight'] = $each['volumetric_weight'];
                        $data['orders'][$index]['totvolume'] = $each['totvolume'];
                        $data['orders'][$index]['scanned_quantity'] = $each['scanned_quantity'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the multiple order cargo contents to a single line order cargo content
    public function getOrderCargoContent(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select group_concat(cargo_content SEPARATOR '?????') as cargo_content,group_concat(ref_order_num) as ref_order_num,
            order_id from ( SELECT distinct(cargo_content),order_id,ref_order_num FROM `tb_order_cargodetails` c
            left join tb_inner_cargo i on i.cargo_id=c.cargo_id
            WHERE order_id in ($orderids) ) as inner_cargo group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['cargo_content'] = $each['cargo_content'];
                        $data['orders'][$index]['ref_order_num'] = $each['ref_order_num'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will provide the stop delviered status based on the shipment ids
    public function getStopStatusDelviered(string $shiftIds): array
    {
        $data = array();
        if ($shiftIds != '') {
            $sql = "select shipment_id,sm.id,sm.status_name,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name,tps.status_id,tps.status_code,tps.createdon,tps.updatedon
            from  `tb_stop_status` tps
            inner join tb_status_master sm on sm.id=tps.status_id
            where  tps.shipment_id in ($shiftIds) AND  tps.shipment_id !=0 AND tps.status_code='3000'
            group by tps.shipment_id
            order by tps.id desc";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['delivered_status_id'] = $each['id'];
                        $data[$index]['delivered_status_status_name'] = $each['status_name'];
                        $data[$index]['delivered_status_stop_type'] = $each['stop_type'];
                        $data[$index]['delivered_status_latitude'] = $each['latitude'];
                        $data[$index]['delivered_status_longitude'] = $each['longitude'];
                        $data[$index]['delivered_status_loc_name'] = $each['loc_name'];
                        $data[$index]['delivered_status_status_id'] = $each['status_id'];
                        $data[$index]['delivered_status_status_code'] = $each['status_code'];
                        $data[$index]['delivered_status_createdon'] = $each['createdon'];
                        $data[$index]['delivered_status_updatedOn'] = $each['updatedon'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert all the multiple status of a particular order in to a single line order for a particular order
    public function getStopStatusGeneric(string $shiftIds): array
    {
        $data = array();
        if ($shiftIds != '') {
            $sql = "SELECT tps.shipment_id,sm.id,sm.status_name,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name,tps.status_id,
            tps.status_code,tps.createdon
            FROM tb_stop_status tps
            inner join tb_status_master sm on sm.id=tps.status_id
            WHERE tps.id IN ( SELECT max(id) as id FROM tb_stop_status where shipment_id in
            ($shiftIds)
            AND shipment_id !=0 GROUP by shipment_id ORDER by id DESC )";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['generic_status_id'] = $each['id'];
                        $data[$index]['generic_status_status_name'] = $each['status_name'];
                        $data[$index]['generic_status_stop_type'] = $each['stop_type'];
                        $data[$index]['generic_status_latitude'] = $each['latitude'];
                        $data[$index]['generic_status_longitude'] = $each['longitude'];
                        $data[$index]['generic_status_loc_name'] = $each['loc_name'];
                        $data[$index]['generic_status_status_id'] = $each['status_id'];
                        $data[$index]['generic_status_status_code'] = $each['status_code'];
                        $data[$index]['generic_status_createdon'] = $each['createdon'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give the estimated pickup date of orders
    public function getEstimatedPickup(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "SELECT order_id,createdon as estimated_pickup_time FROM tb_stop_status WHERE status_id=1 and order_id!=0  and
            order_id in ($orderids) group by order_id order by order_id desc";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['estimated_pickup_time'] = $each['estimated_pickup_time'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the multiple lines of status dates of an order to a single line
    public function getOrderStatusDates(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select
            order_id,
            GROUP_CONCAT(status_date SEPARATOR '?????') as status_date,
            GROUP_CONCAT(status_code SEPARATOR '?????') as status_code
            from (
            select
            order_id,
            IFNULL(concat('status_date','=====',status_date),'status_date=====') as status_date,
            IFNULL(concat('status_code','=====',status_code),'status_code=====') as status_code
            from tb_order_status where status_code in (2491,2492) and status=1 and order_id in ($orderids)
            ) as tmpOrderStatus group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && count($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['status_date'] = $each['status_date'];
                        $data['orders'][$index]['status_code'] = $each['status_code'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give the order stop status dates in to a single line for a prticular order
    public function getOrderStopStatusStatus(string $orderids, array $data, string $statusCodes = ''): array
    {
        if ($statusCodes != '') {
            // do nothing
        } else {
            $statusCodes = '1550,0191,0500,3000,0212';
        }
        if ($orderids != '') {
            $sql = "select
            order_id,
            GROUP_CONCAT(createdon SEPARATOR '?????') as stop_status_createdon,
            GROUP_CONCAT(status_code SEPARATOR '?????') as stop_status_code
            from (
            select
            order_id,
            IFNULL(concat('createdon','=====',createdon),'createdon=====') as createdon,
            IFNULL(concat('status_code','=====',status_code),'status_code=====') as status_code
            from tb_stop_status where status_code in ($statusCodes) and status=1 and order_id in ($orderids)
            ) as tmpOrderStopStatusStatus group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['stop_status_createdon'] = $each['stop_status_createdon'];
                        $data['orders'][$index]['stop_status_code'] = $each['stop_status_code'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give the driver acceptance date based on the shift id
    public function getDriverAcceptance(string $shiftIds): array
    {
        $data = array();
        if ($shiftIds != '') {
            $sql = "select shipment_id,createdon as driver_acceptance_date from tb_stop_status where status_code='0212' and shipment_id!=0 and status=1 and
            shipment_id in ($shiftIds)";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['driver_acceptance_date'] = $each['driver_acceptance_date'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the multiple revenue details of an order to a single line
    public function getRevenueDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select order_id,sum(revenue_order_count) as  revenue_order_count,group_concat(revenue_details SEPARATOR '?????') as revenue_details FROM (
                select order_id,sum(revenue_order_count) as revenue_order_count, concat(type,'+++++',recipient_role,'+++++',foreign_currency,'+++++',debtor_jfr,'+++++',bu_jfr,'+++++',exchange_rate,'+++++',invoice_number,
        '+++++',invoice_date,'+++++',credit_note_number,'+++++',invoice_creation_date,'+++++',invoice_receivdon_date,'+++++',invoice_status
        )  as revenue_details
                from (
        SELECT order_id, count(order_id) as revenue_order_count,
        IFNULL(concat('recipient_role','=====',recipient_role),'recipient_role=====') as recipient_role,
        IFNULL(concat('type','=====',type),'type=====') as type,
        IFNULL(concat('foreign_currency','=====',foreign_currency),'foreign_currency=====') as foreign_currency,
        IFNULL(concat('debtor_jfr','=====',debtor_jfr),'debtor_jfr=====') as debtor_jfr,
        IFNULL(concat('bu_jfr','=====',bu_jfr),'bu_jfr=====') as bu_jfr,
        IFNULL(concat('exchange_rate','=====',exchange_rate),'exchange_rate=====') as exchange_rate,
        IFNULL(concat('invoice_number','=====',invoice_number),'invoice_number=====') as invoice_number ,
        IFNULL(concat('invoice_date','=====',invoice_date),'invoice_date=====') as invoice_date,
        IFNULL(concat('credit_note_number','=====',credit_note_number),'credit_note_number=====') as credit_note_number,
        IFNULL(concat('invoice_creation_date','=====',invoice_creation_date),'invoice_creation_date=====') as invoice_creation_date,
        IFNULL(concat('invoice_receivdon_date','=====',invoice_receivdon_date),'invoice_receivdon_date=====') as invoice_receivdon_date ,
        IFNULL(concat('invoice_status','=====',invoice_status),'invoice_date=====') as invoice_status
        FROM `tb_reveneus`
        WHERE `status` = 1 and order_id>0 and
        id in (  SELECT max(id) FROM `tb_reveneus` WHERE order_id in ($orderids) and status=1 group by order_id,type,recipient_role)group by order_id,type,recipient_role
                )as r1 group by order_id,type,recipient_role
                ) AS final_rev group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['revenue_order_count'] = $each['revenue_order_count'];
                        $data['orders'][$index]['revenue_details'] = $each['revenue_details'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give the order references in to a single line for a particular order
    public function getOrderReferences(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select order_id,group_concat(ref_details SEPARATOR '?????') as reference_value FROM (
                select order_id, concat(reference_id,'+++++',description,'+++++',ref_value)  as ref_details
                from (
                SELECT order_id,
                    IFNULL(concat('reference_id','=====',o.reference_id),'reference_id=====') as reference_id,
                    IFNULL(concat('description','=====',r.description),'description=====') as description ,
                    IFNULL(concat('ref_value','=====',o.ref_value),'ref_value=====') as ref_value

                FROM `tb_order_references` `o`
                LEFT JOIN `tb_reference_master` `r` ON `o`.`reference_id`=`r`.`name`
                WHERE `o`.`order_id` >0
                AND `o`.`status` = 1 and order_id in ($orderids)
                )as r1
                ) AS final_ref group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $value = $each['reference_value'];
                        $data['orders'][$index]['reference_value'] = $value;
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the multiple party items of an order to a single order line
    public function getPartyDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select order_id,
            GROUP_CONCAT(id SEPARATOR '?????') as partydetails_id,
            GROUP_CONCAT(party_type_id SEPARATOR '?????') as partydetails_party_type_id,
            GROUP_CONCAT(name SEPARATOR '?????') as partydetails_name,
            GROUP_CONCAT(mobile SEPARATOR '?????') as partydetails_mobile,
            GROUP_CONCAT(email SEPARATOR '?????') as partydetails_email,
            GROUP_CONCAT(code SEPARATOR '?????') as partydetails_code,
            GROUP_CONCAT(customeridentifier SEPARATOR '?????') as partydetails_customeridentifier,
            GROUP_CONCAT(house_number SEPARATOR '?????') as partydetails_house_number,
            GROUP_CONCAT(fax SEPARATOR '?????') as partydetails_fax,
            GROUP_CONCAT(acon_debitor_code SEPARATOR '?????') as partydetails_acon_debitor_code,
            GROUP_CONCAT(kn_login_account SEPARATOR '?????') as partydetails_kn_login_account,
            GROUP_CONCAT(vat_reg_no SEPARATOR '?????') as partydetails_vat_reg_no,
            GROUP_CONCAT(tax_payer_no SEPARATOR '?????') as partydetails_tax_payer_no,
            GROUP_CONCAT(contract_no SEPARATOR '?????') as partydetails_contract_no,
            GROUP_CONCAT(contract_date SEPARATOR '?????') as partydetails_contract_date,
            GROUP_CONCAT(party_type SEPARATOR '?????') as partydetails_party_type,
            GROUP_CONCAT(party_type_name SEPARATOR '?????') as partydetails_party_type_name
            from (
            select o.order_id,
            concat('id','=====',p.id) as id,
                 IFNULL(concat('party_type_id','=====',p.party_type_id),'party_type_id=====') as party_type_id,
                 IFNULL(concat('name','=====',p.name),'name=====') as name,
                 IFNULL(concat('mobile','=====',p.mobile),'mobile=====') as mobile,
                 IFNULL(concat('email','=====',p.email),'email=====') as email,
                 IFNULL(concat('code','=====',p.code),'code=====') as code,
                 IFNULL(concat('customeridentifier','=====',p.customeridentifier),'customeridentifier=====') as customeridentifier,
                 IFNULL(concat('house_number','=====',p.house_number),'house_number=====') as house_number,
                 IFNULL(concat('fax','=====',p.fax),'fax=====') as fax,
                 IFNULL(concat('acon_debitor_code','=====',p.acon_debitor_code),'acon_debitor_code=====') as acon_debitor_code,
                 IFNULL(concat('kn_login_account','=====',p.kn_login_account),'kn_login_account=====') as kn_login_account,
                 IFNULL(concat('vat_reg_no','=====',p.vat_reg_no),'vat_reg_no=====') as vat_reg_no,
                 IFNULL(concat('tax_payer_no','=====',p.tax_payer_no),'tax_payer_no=====') as tax_payer_no,
                 IFNULL(concat('contract_no','=====',p.contract_no),'contract_no=====') as contract_no,
                 IFNULL(concat('contract_date','=====',p.contract_date),'contract_date=====') as contract_date,
                 IFNULL(concat('party_type','=====',o.party_type),'party_type=====') as party_type,
                 IFNULL(concat('party_type_name','=====',pt.name),'party_type_name=====') as party_type_name
                 FROM tbl_party_master p
                 INNER JOIN tb_order_parties o ON p.id=o.party_id
                 left join tbl_party_types pt on pt.id=o.party_type
                 WHERE  p.status = 1 AND o.status = 1 and  order_id in ($orderids)  GROUP BY o.party_type,o.order_id
            ) as final_query group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['partydetails_id'] = $each['partydetails_id'];
                        $data['orders'][$index]['partydetails_party_type_id'] = $each['partydetails_party_type_id'];
                        $data['orders'][$index]['partydetails_name'] = $each['partydetails_name'];
                        $data['orders'][$index]['partydetails_mobile'] = $each['partydetails_mobile'];
                        $data['orders'][$index]['partydetails_email'] = $each['partydetails_email'];
                        $data['orders'][$index]['partydetails_code'] = $each['partydetails_code'];
                        $data['orders'][$index]['partydetails_customeridentifier'] = $each['partydetails_customeridentifier'];
                        $data['orders'][$index]['partydetails_house_number'] = $each['partydetails_house_number'];
                        $data['orders'][$index]['partydetails_fax'] = $each['partydetails_fax'];
                        $data['orders'][$index]['partydetails_acon_debitor_code'] = $each['partydetails_acon_debitor_code'];
                        $data['orders'][$index]['partydetails_kn_login_account'] = $each['partydetails_kn_login_account'];
                        $data['orders'][$index]['partydetails_vat_reg_no'] = $each['partydetails_vat_reg_no'];
                        $data['orders'][$index]['partydetails_tax_payer_no'] = $each['partydetails_tax_payer_no'];
                        $data['orders'][$index]['partydetails_contract_no'] = $each['partydetails_contract_no'];
                        $data['orders'][$index]['partydetails_contract_date'] = $each['partydetails_contract_date'];
                        $data['orders'][$index]['partydetails_party_type'] = $each['partydetails_party_type'];
                        $data['orders'][$index]['partydetails_party_type_name'] = $each['partydetails_party_type_name'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give multiple value added services to a single line
    public function getValueAddedServices($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select order_id,group_concat(vas_details SEPARATOR '?????') as vas_details from (
                select order_id, concat(vas_name,'+++++',quantity) as vas_details from (
                select v.order_id,
                    IFNULL(concat('vas_name','=====',vm.vas_name),'vas_name=====') as vas_name,
                    IFNULL(concat('vas_quantity','=====',v.quantity),'name=====') as quantity
                      FROM tb_order_vas v
                      LEFT join tb_vas_master vm on vm.id=v.vas_id
                      WHERE  v.status = 1  and  order_id in ($orderids)
                      GROUP BY vm.vas_name,v.order_id
                    )  as v1
                  ) as final_vas
                  group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['vas_details'] = $each['vas_details'];
                    }
                }
            }
        }
        return $data;
    }

    // th e below method will give the bill details
    public function getBillDetails(string $orderids, array $data): array
    {
        $company_code = $this->session->userdata('company_code');
        if ($company_code != '') {
            $condition = "  and tparty.company_code='$company_code'";
        } else {
            $condition = '';
        }

        if ($orderids != '') {
            $sql = "SELECT tr.order_id,tb.code as bill_code,tparty.id as payer_id,
            tparty.name as payer_name,
            tparty.code as payer_cid,
            tparty.acon_debitor_code as payer_acondebtorcode,
            tparty.kn_login_account as payer_kn_login_account,
            tparty.vat_reg_no as payer_vat_regno,
            tparty.tax_payer_no as payer_tax_payerid,
            tparty.street as payer_steeet_house,
			tparty.house_number as payer_house_number,
            tparty.pincode  as payer_postal,
            tparty.country as payer_country,
            tparty.mobile as payer_phone,
            tparty.email as payer_email,
            tparty.location_id as payer_city
            FROM tb_reveneus tr
            left join tbl_bills tb on tb.id = tr.bill_id
            left join tbl_party_master tparty on tparty.code = tb.code $condition
            WHERE recipient_role = 'Customer' AND tr.status = 1 and tb.status!=0
            and tr.order_id in  ($orderids)
            group by tr.order_id";
            $res = $this->db->query($sql);
            if ($res && $res->num_rows() > 0) {
                $result = $res->result_array();
                foreach($result as $each){
                    $index=$each['order_id'];
                    $data['orders'][$index]['bill_code']=$each['bill_code'];
                    $data['orders'][$index]['payer_id']=$each['payer_id'];
                    $data['orders'][$index]['payer_name']=$each['payer_name'];
                    $data['orders'][$index]['payer_cid']=$each['payer_cid'];
                    $data['orders'][$index]['payer_acondebtorcode']=$each['payer_acondebtorcode'];
                    $data['orders'][$index]['payer_kn_login_account']=$each['payer_kn_login_account'];
                    $data['orders'][$index]['payer_vat_regno']=$each['payer_vat_regno'];
                    $data['orders'][$index]['payer_tax_payerid']=$each['payer_tax_payerid'];
                    $data['orders'][$index]['payer_steeet_house']=$each['payer_steeet_house'];
                    $data['orders'][$index]['payer_house_number']=$each['payer_house_number'];
                    $data['orders'][$index]['payer_postal']=$each['payer_postal'];
                    $data['orders'][$index]['payer_country']=$each['payer_country'];
                    $data['orders'][$index]['payer_phone']=$each['payer_phone'];
                    $data['orders'][$index]['payer_email']=$each['payer_email'];
                    $data['orders'][$index]['payer_city']=$each['payer_city'];
                }
            }
        }
        return $data;
    }

    // the below method will give the complete cargo details and convert the multiple rows to a single row for an order
    public function getCompleteOrderCargoDetails($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select  order_id,
            sum(cd.quantity) as cargo_total_quantity,
            sum(cd.weight) as carg_total_weight,
            sum(cd.volume) as cargo_total_volume,
            sum(cd.ldm) as cargo_total_ldm,
            sum(cd.volumetric_weight) as cargo_total_volumetric_weight,
            sum(cd.second_volume) as cargo_total_second_volume,
            sum(cd.second_weight) as cargo_total_second_weight,
            GROUP_CONCAT(DISTINCT(cd.cargo_type))  as cargo_total_package_type,
            GROUP_CONCAT(DISTINCT(cd.length))  as  cargo_total_length,
            GROUP_CONCAT(DISTINCT(cd.length_unit))  as  cargo_total_length_unit,
            GROUP_CONCAT(DISTINCT(cd.width))  as  cargo_total_width,
            GROUP_CONCAT(DISTINCT(cd.width_unit))  as cargo_total_width_unit,
            GROUP_CONCAT(DISTINCT(cd.height))  as  cargo_total_height,
            GROUP_CONCAT(DISTINCT(cd.height_unit))  as cargo_total_height_unit,
            GROUP_CONCAT(DISTINCT(cd.weight_unit))  as cargo_total_weight_unit,
            GROUP_CONCAT(DISTINCT(cd.volume_unit))  as cargo_total_volume_unit,
            GROUP_CONCAT(DISTINCT(cd.volweight_uom))  as cargo_total_volweight_uom,
            GROUP_CONCAT(DISTINCT(cd.stackable))  as cargo_total_stackable,
            GROUP_CONCAT(DISTINCT(cd.dg_goods))  as cargo_total_dg_goods
            FROM `tb_cargo_details` `cd`
            LEFT JOIN `tb_order_cargodetails` `ocd` ON `cd`.`id`= `ocd`.`cargo_id`
            WHERE
            `ocd`.`status` = 1 and `ocd`.`order_id` in ($orderids)
            group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['cargo_total_quantity'] = $each['cargo_total_quantity'];
                        $data['orders'][$index]['carg_total_weight'] = $each['carg_total_weight'];
                        $data['orders'][$index]['cargo_total_volume'] = $each['cargo_total_volume'];
                        $data['orders'][$index]['cargo_total_ldm'] = $each['cargo_total_ldm'];
                        $data['orders'][$index]['cargo_total_volumetric_weight'] = $each['cargo_total_volumetric_weight'];
                        $data['orders'][$index]['cargo_total_second_volume'] = $each['cargo_total_second_volume'];
                        $data['orders'][$index]['cargo_total_second_weight'] = $each['cargo_total_second_weight'];
                        $data['orders'][$index]['cargo_total_package_type'] = $each['cargo_total_package_type'];
                        $data['orders'][$index]['cargo_total_length'] = $each['cargo_total_length'];
                        $data['orders'][$index]['cargo_total_length_unit'] = $each['cargo_total_length_unit'];
                        $data['orders'][$index]['cargo_total_width'] = $each['cargo_total_width'];
                        $data['orders'][$index]['cargo_total_width_unit'] = $each['cargo_total_width_unit'];
                        $data['orders'][$index]['cargo_total_height'] = $each['cargo_total_height'];
                        $data['orders'][$index]['cargo_total_height_unit'] = $each['cargo_total_height_unit'];
                        $data['orders'][$index]['cargo_total_weight_unit'] = $each['cargo_total_weight_unit'];
                        $data['orders'][$index]['cargo_total_volume_unit'] = $each['cargo_total_volume_unit'];
                        $data['orders'][$index]['cargo_total_volweight_uom'] = $each['cargo_total_volweight_uom'];
                        $data['orders'][$index]['cargo_total_stackable'] = $each['cargo_total_stackable'];
                        $data['orders'][$index]['cargo_total_dg_goods'] = $each['cargo_total_dg_goods'];
                    }
                }
            }
        }
        return $data;
    }

    // the following method will accept the comma separated values and explode it and remove the duplicates and again will return the unique comma separated values
    public function getUniqueValues($values = '', $quotes = '')
    {
        if ($values != '') {
            $array = explode(',', $values);
            $array = array_unique($array);
            if ($quotes == '1') {
                if (!empty($array) && sizeof($array) > 0) {
                    $tempStr = '';
                    foreach ($array as $each) {
                        $tempStr = $tempStr . "'$each'" . ',';
                    }
                    $values = $tempStr;
                }
            } else {
                $values = implode(',', $array);
            }
        }
        $values = trim($values, ',');
        return $values;
    }

    // the below method will give the customer details
    public function getCustomerDetails($custIds)
    {
        $data = array();
        $custIds = $this->getUniqueValues($custIds);
        if ($custIds != '') {
            $sql = "select
            c.id as cust_id,
            p.customeridentifier as cust_customeridentifier,
            p.name as cust_name,
            p.mobile as cust_mobile,
            p.email as cust_email,
            p.fax as cust_fax,
            p.code as cust_code,
            p.street as cust_street,
            p.state as cust_state,
            p.location_id as cust_location_id,
            p.country as cust_country,
            p.pincode as cust_pincode,
            p.acon_debitor_code as cust_acon_debitor_code,
            p.kn_login_account as cust_kn_login_account,
            p.vat_reg_no as cust_vat_reg_no,
            p.tax_payer_no as cust_tax_payer_no,
            p.contract_no as cust_contract_no,
            p.contract_date as cust_contract_date,
            p.house_number as cust_house_number
            FROM tbl_party_master p
            INNER JOIN tb_customers c ON p.code=c.code AND c.company_code =p.company_code
             where p.status=1 and c.status=1 and c.id in ($custIds) group by c.id";

            $res = $this->db->query($sql);
            if ($res && $res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['cust_id'];
                        $data[$index]['cust_id'] = $each['cust_id'];
                        $data[$index]['cust_customeridentifier'] = $each['cust_customeridentifier'];
                        $data[$index]['cust_name'] = $each['cust_name'];
                        $data[$index]['cust_mobile'] = $each['cust_mobile'];
                        $data[$index]['cust_email'] = $each['cust_email'];
                        $data[$index]['cust_fax'] = $each['cust_fax'];
                        $data[$index]['cust_code'] = $each['cust_code'];
                        $data[$index]['cust_street'] = $each['cust_street'];
                        $data[$index]['cust_state'] = $each['cust_state'];
                        $data[$index]['cust_location_id'] = $each['cust_location_id'];
                        $data[$index]['cust_country'] = $each['cust_country'];
                        $data[$index]['cust_pincode'] = $each['cust_pincode'];
                        $data[$index]['cust_acon_debitor_code'] = $each['cust_acon_debitor_code'];
                        $data[$index]['cust_kn_login_account'] = $each['cust_kn_login_account'];
                        $data[$index]['cust_vat_reg_no'] = $each['cust_vat_reg_no'];
                        $data[$index]['cust_tax_payer_no'] = $each['cust_tax_payer_no'];
                        $data[$index]['cust_contract_no'] = $each['cust_contract_no'];
                        $data[$index]['cust_contract_date'] = $each['cust_contract_date'];
                        $data[$index]['cust_house_number'] = $each['cust_house_number'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convertt the multiple status details to a single row for a particular order
    public function getStatusDates($orderNumbers)
    {
        $data = array();
        $orderNumbers = $this->getUniqueValues($orderNumbers, '1');
        if ($orderNumbers != '') {
            $sql = "select order_id,GROUP_CONCAT(final_column SEPARATOR '?????') as status_details from (
                select order_id,
                concat(stop_type,'+++++',createdon
                ) as final_column
               from (
                select te.order_id,
                IFNULL(concat('stop_type','=====',tps.stop_type),'stop_type=====') as stop_type,
           IFNULL(concat('createdon','=====',tps.createdon),'createdon=====') as createdon
               FROM `tb_stop_status` `tps`
          LEFT JOIN `tb_shifts` `ts` ON `tps`.`shipment_id`=`ts`.`id`
          LEFT JOIN `tb_employee` `te` ON `ts`.`id` =`te`.`shift_id`
          WHERE `tps`.`stop_type` IN('P', 'D') and te.order_id in ($orderNumbers)
          AND `tps`.`status_code` IN('0500', '3000')
          AND `tps`.`status` = 1
          AND `te`.`status` = 1
          AND `ts`.`status` = 1
                GROUP BY tps.stop_type,te.order_id
                ) as p1
                    ) as final_query
           group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data[$index]['order_id'] = $each['order_id'];
                        $data[$index]['status_details'] = $each['status_details'];
                    }
                }
            }
        }
        return $data;
    }

    public function getTripInfo(string $shiftIds): array
    {
        $data = [];
        if ($shiftIds != '') {
            $shiftIds = explode(',', $shiftIds);
            $sql = "select
            tsh.id as shift_id,
            tsh.created_on as trip_created_date,
            tven.code as supplier_id,
            tven.name as suppier_name,
            tven.address as suppier_steeet_house,
            tven.pincode as suppier_postalcode,
            tven.country as suppier_country,
            tven.mobile as suppier_phone,
            tven.email as suppier_email,
			tven.location as supplier_city,
            ttt.trucktype as vehicle_type,
            IFNULL(tm.trailer_name,ttd.truck_number) as trailer_no,
            ttd.register_number,
            tdr.name as driver_name,
            tdr.driving_licence_num as driver_licence_number
            from tb_shifts tsh
            left join tb_vendors tven on tven.id=tsh.vendor_id
            left join tb_trips ttr on ttr.shift_id=tsh.id
            left join tb_trucks_data ttd on ttd.id=ttr.vehicle_id
            left join tb_trucktypes ttt on ttt.id=ttd.truck_type
            left join tb_truck_drivers tdr on tdr.id=ttr.driver_id
            left join tb_shft_veh tsv on (tsv.shft_id = tsh.id and tsv.status = 1)
            left join trailer_master tm on (tm.id = tsv.trailer_id and tm.status = 1)
            where tsh.id in ?
            group by tsh.id";
            $res = $this->db->query($sql, [$shiftIds]);
            if ($res && $res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && count($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shift_id'];
                        $data[$index]['shift_id'] = $each['shift_id'];
                        $data[$index]['supplier_id'] = $each['supplier_id'];
                        $data[$index]['suppier_name'] = $each['suppier_name'];
                        $data[$index]['suppier_steeet_house'] = $each['suppier_steeet_house'];
                        $data[$index]['suppier_postalcode'] = $each['suppier_postalcode'];
                        $data[$index]['suppier_country'] = $each['suppier_country'];
                        $data[$index]['suppier_phone'] = $each['suppier_phone'];
                        $data[$index]['suppier_email'] = $each['suppier_email'];
                        $data[$index]['supplier_city'] = $each['supplier_city'];
                        $data[$index]['vehicle_type'] = $each['vehicle_type'];
                        $data[$index]['trailer_no'] = $each['trailer_no'];
                        $data[$index]['register_number'] = $each['register_number'];
                        $data[$index]['driver_name'] = $each['driver_name'];
                        $data[$index]['driver_licence_number'] = $each['driver_licence_number'];
                        $data[$index]['driver_address'] = $each['driver_address'] ?? '';
                        $data[$index]['trip_created_date'] = $each['trip_created_date'] ?? '';
                        $data[$index]['driver_number'] = "";
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the multiple rows of charge details of an order to a single row
    public function getChargeInfo($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select order_id,
            GROUP_CONCAT(type SEPARATOR '?????') as chargedetails_type,
            GROUP_CONCAT(chargecode SEPARATOR '?????') as chargedetails_chargecode,
            GROUP_CONCAT(chargecodename SEPARATOR '?????') as chargedetails_chargecodename,
            GROUP_CONCAT(quantity_unit SEPARATOR '?????') as chargedetails_quantity_unit,
            GROUP_CONCAT(value SEPARATOR '?????') as chargedetails_value,
            GROUP_CONCAT(rate_id SEPARATOR '?????') as chargedetails_rate_id,
            GROUP_CONCAT(amount SEPARATOR '?????') as chargedetails_amount,
            GROUP_CONCAT(currency SEPARATOR '?????') as chargedetails_currency,
            GROUP_CONCAT(vat_percentage SEPARATOR '?????') as chargedetails_vat_percentage,
            GROUP_CONCAT(vat_amount SEPARATOR '?????') as chargedetails_vat_amount
           from (
           select r.order_id,
           IFNULL(concat('type','=====',r.type),'type=====') as type,
           IFNULL(concat('charge_code','=====',cc.charge_code),'charge_code=====') as chargecode,
           IFNULL(concat('name','=====',cc.name),'name=====') as chargecodename,
           IFNULL(concat('quantity_unit','=====',c.quantity_unit),'quantity_unit=====') as quantity_unit,
           IFNULL(concat('value','=====',c.value),'value=====') as value,
           IFNULL(concat('rate_id','=====',c.rate_id),'rate_id=====') as rate_id,
           IFNULL(concat('amount','=====',c.amount),'amount=====') as amount,
           IFNULL(concat('currency','=====',c.currency),'currency=====') as currency,
           IFNULL(concat('vat_percentage','=====',c.vat_percentage),'vat_percentage=====') as vat_percentage,
           IFNULL(concat('vat_amount','=====',c.vat_amount),'vat_amount=====') as vat_amount
           from tb_charges c
           inner join tb_reveneus r on c.revenue_id=r.id
           INNER JOIN tb_charge_codes cc ON c.charge_code=cc.id
           WHERE r.order_id in ($orderids)
           AND r.type in (0,1) AND r.status = 1 AND c.status = 1
                 ) as p1  group by order_id";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['chargedetails_type'] = $each['chargedetails_type'];
                        $data['orders'][$index]['chargedetails_chargecode'] = $each['chargedetails_chargecode'];
                        $data['orders'][$index]['chargedetails_chargecodename'] = $each['chargedetails_chargecodename'];
                        $data['orders'][$index]['chargedetails_quantity_unit'] = $each['chargedetails_quantity_unit'];
                        $data['orders'][$index]['chargedetails_value'] = $each['chargedetails_value'];
                        $data['orders'][$index]['chargedetails_rate_id'] = $each['chargedetails_rate_id'];
                        $data['orders'][$index]['chargedetails_amount'] = $each['chargedetails_amount'];
                        $data['orders'][$index]['chargedetails_currency'] = $each['chargedetails_currency'];
                        $data['orders'][$index]['chargedetails_vat_percentage'] = $each['chargedetails_vat_percentage'];
                        $data['orders'][$index]['chargedetails_vat_amount'] = $each['chargedetails_vat_amount'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will provide the last status data of an order
    public function getStopStatusGenericAllround(string $shiftIds): array
    {
        $data = array();
        if ($shiftIds != '') {
            $sql = "SELECT tps.shipment_id,sm.status_name,tps.status_code,tps.createdon
            FROM tb_stop_status tps
            inner join tb_status_master sm on sm.id=tps.status_id
            WHERE tps.id IN ( SELECT max(id) as id FROM tb_stop_status
            where shipment_id in
            ($shiftIds) AND shipment_id !=0
            GROUP by shipment_id ORDER by id DESC )";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['generic_status_status_code'] = $each['status_code'];
                        $data[$index]['generic_status_status_name'] = $each['status_name'];
                        $data[$index]['generic_status_createdon'] = $each['createdon'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will convert the  multiple pod details of on order to a single row
    public function getPODUploads($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select order_id,group_concat(pod_details SEPARATOR '?????') as pod_details from (
                select order_id, concat(createdon,'+++++',stop_type) as pod_details from (
                select p.order_id,
                    IFNULL(concat('createdon','=====',createdon),'createdon=====') as createdon,
                    IFNULL(concat('stop_type','=====',stop_type),'stop_type=====') as stop_type
                    FROM tb_pod_uploads p
                    where stop_type in ('D','P') and doc_type=3 and status=1 and order_id in ($orderids)
                    )  as v1
                  ) as final_pod
                  group by order_id";
            $res = $this->db->query($sql);

            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['pod_details'] = $each['pod_details'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will provide the vehicle details based on the shift ids
    public function getDriverVehicleDetails($shiftIds)
    {
        $data = $tripShiftIds = $vehicleIds = $driverNames = [];
        if ($shiftIds != '') {
            $tripsSql = $this->db->query(
                "select t.shift_id,td.register_number,td.truck_number as trailer_no,ttt.trucktype,
            dr.name as drivername,
            dr.driving_licence_num as driver_licence_number
            from tb_trips t
            left join tb_trucks_data  td on t.vehicle_id=td.id
            left join tb_trucktypes ttt on ttt.id=td.truck_type
            left join tb_truck_drivers dr on t.driver_id=dr.id
            where t.shift_id IN ($shiftIds)
            group by t.shift_id
            order by t.shift_id desc"
            );
            $tripsResult = $tripsSql->num_rows() > 0 ? $tripsSql->result_array() : [];
            foreach ($tripsResult as $eachLine) {
                $index = $eachLine['shift_id'];
                $tripShiftIds[] = $index;
                $data[$index]['shift_id'] = $eachLine['shift_id'];
                $data[$index]['register_number'] = $eachLine['register_number'];
                $data[$index]['drivername'] = $eachLine['drivername'];
                $data[$index]['trucktype'] = $eachLine['trucktype'];
                $data[$index]['trailer_no'] = $eachLine['trailer_no'];
                $data[$index]['drivername'] = $eachLine['drivername'];
                $data[$index]['driver_licence_number'] = $eachLine['driver_licence_number'];
            }
            $shiftArray = explode(',', $shiftIds);
            $finalShiftIds = array_diff($shiftArray, $tripShiftIds);
            if (!empty($finalShiftIds)) {
                $res = $this->db->query(
                    "select s.id,td.id as vehicle_id,td.register_number,td.truck_number as trailer_no,ttt.trucktype,
            dr.name as drivername,
            dr.driving_licence_num as driver_licence_number
            from tb_shifts s
            left join tb_shft_veh sv on sv.shft_id=s.id
            left join tbl_assigned_drivers ad on ad.vehicle_id=sv.vehicle_id AND ad.status ='1'
            left join tb_trucks_data  td on sv.vehicle_id=td.id
            left join tb_trucktypes ttt on ttt.id=td.truck_type
            left join tb_truck_drivers dr on ad.driver_id=dr.id
            where s.id in ?
            group by sv.shft_id
            order by sv.id desc",
                    [$finalShiftIds]
                );
                if ($res->num_rows() > 0) {
                    $result = $res->result_array();
                    if (isset($result) && sizeof($result) > 0) {
                        foreach ($result as $each) {
                            $index = $each['id'];
                            $data[$index]['shift_id'] = $each['id'];
                            $vehicleIds[$index] = $each['vehicle_id'];
                            $data[$index]['register_number'] = $each['register_number'];
                            $data[$index]['drivername'] = $each['drivername'];
                            $data[$index]['trucktype'] = $each['trucktype'];
                            $data[$index]['trailer_no'] = $each['trailer_no'];
                            $data[$index]['drivername'] = $each['drivername'];
                            $data[$index]['vehicleId'] = $each['vehicle_id'];
                            $data[$index]['driver_licence_number'] = $each['driver_licence_number'];
                        }
                    }
                }
            }
            if (!empty($vehicleIds)) {
                $this->load->model("MassStatusModel");
                $driversData = $this->MassStatusModel->getLatestDriverDataByVehicle(array_unique($vehicleIds));
                if(!empty($driversData)){
                    $query = $this->db->query("SELECT id,name FROM tb_truck_drivers WHERE id IN ? ",[$driversData]);
                    foreach($query->result_array() as $eachLine){
                        $driverNames[$eachLine['id']] = $eachLine['name'];
                    }
                }
                foreach ($vehicleIds as $key => $eachId) {
                    $driverId = $driversData[$eachId] ?? 0;
                    if ($driverId >0 ) {
                        $data[$key]['drivername'] = $driverNames[$driverId] ?? "";
                    }
                }
            }
        }
        return $data;
    }

    public function getPODDelivered($orderids, $data, $podType=false)
    {
        if ($orderids != '') {
            $podStr = "";
            if ($podType) {
                $podStr = " or pod.doc_type ='1' or pod.doc_type ='2' ";
            }
            $sql = "select order_id,doc_type,imgpath,receiver_name,createdon from tb_pod_uploads as pod where (pod.doc_type ='3' " . $podStr . " ) AND pod.stop_type ='D' AND pod.status ='1'
            and order_id in ($orderids)
            ";
            $res = $this->db->query($sql);

            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['doc_type'] = $each['doc_type'];
                        $data['orders'][$index]['imgpath'] = $each['imgpath'];
                        $data['orders'][$index]['receiver_name'] = $each['receiver_name'];
                        $data['orders'][$index]['pod_available'] = $each['createdon'];

                    }
                }
            }
        }
        return $data;
    }

    public function getOrdercargodetailsformanifest(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $ordeIdCondition = " and order_id in ($orderids) ";
            $sql = "select order_id,GROUP_CONCAT(cargo_details order by id desc SEPARATOR '+++++') as cargo_details from
                ( select id, order_id,cargo_details
                    from ( select id, order_id,concat( weight,';',volume,';',quantity,';',quantity_type) as cargo_details
                        from (
                        SELECT id, order_id,
                        IFNULL(concat('weight','=====',weight),'weight=====') as weight,
                        IFNULL(concat('volume','=====',volume),'volume=====') as volume,
                        IFNULL(concat('quantity','=====',quantity),'quantity=====') as quantity,
                        IFNULL(concat('quantity_type','=====',quantity_type),'quantity_type=====') as quantity_type
                            from `tb_order_cargodetails` WHERE  `status` = 1
                            $ordeIdCondition
                            )as cargo1
                        ) as cargo2
                    ) as cargo3
                    group by order_id";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    $i = 0;
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $cargo_details = $each['cargo_details'];
                        $data['orders'][$index]['cargos'][$i]['cargodetails'] = $cargo_details;
                        $i++;
                    }
                }
            }
        }
        return $data;
    }

    public function getOrderReferenceMultipleData($orderids, $data, $codes = '')
    {
        if ($codes != '') {
        } else {
            $codes = "'PO','LPC'";
        }
        if ($orderids != '') {
            $sql = "select  order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
                SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                         FROM tb_order_references ar where
                         reference_id IN ($codes) and status='1' and order_id in ($orderids)
                    GROUP BY ref_value,order_id
                 ) AS final_ref group by order_id ";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $value = $each['reference_value'];
                        $data['orders'][$index]['multiple_reference_value'] = $value;
                    }
                }
            }
        }
        return $data;
    }

    public function getAllRevenueDetailsForOrders($orderids, $data)
    {
        if ($orderids != "") {
            $sql = "select order_id,GROUP_CONCAT(invoice_details order by id desc SEPARATOR '+++++') as invoice_details from
            ( select id, order_id,invoice_details
                from ( select id, order_id,concat( type,';',invoice_status,';',recipient_name,';',debtor_jfr) as invoice_details
                    from (

                    SELECT id, order_id,
                    concat ('type','=====',type) as type ,
                    IFNULL(concat('invoice_status','=====',invoice_status),'invoice_status=====') as invoice_status,
                    IFNULL(concat('recipient_name','=====',recipient_name),'recipient_name=====') as recipient_name,
                    IFNULL(concat('debtor_jfr','=====',debtor_jfr),'debtor_jfr=====') as debtor_jfr
                        from `tb_reveneus` WHERE  `status` = 1
                        and order_id in ($orderids)
                        )as invoice_inner1
                    ) as invoice_inner2
                ) as invoice_inner3
                group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                foreach ($result as $each) {
                    $index = $each['order_id'];
                    $value = $each['invoice_details'];
                    $data['orders'][$index]['revenue_details'] = $value;
                }
            }
        }
        return $data;
    }
    
    public function getOrderInvoiceData($orderids, $data, $codes = '')
    {
        if ($orderids != "") {
            $sql = "select order_id,GROUP_CONCAT(invoice_details order by id desc SEPARATOR '+++++') as invoice_details from
                ( select id, order_id,invoice_details
                    from ( select id, order_id,concat( type,';',invoice_status,';',recipient_role,';',recipient_name,';',debtor_jfr,';',amount,';',status,';',invoice_no,';',acon_invoice_status,';',acon_accrual_status) as invoice_details
                        from (
                            SELECT r.id, r.order_id,
                            concat ('type','=====',r.type) as type ,
                            IFNULL(concat('invoice_status','=====',r.invoice_status),'invoice_status=====') as invoice_status,
                            IFNULL(concat('recipient_role','=====',r.recipient_role),'recipient_role=====') as recipient_role,
                            IFNULL(concat('recipient_name','=====',r.recipient_name),'recipient_name=====') as recipient_name,
                            IFNULL(concat('debtor_jfr','=====',r.debtor_jfr),'debtor_jfr=====') as debtor_jfr,
                            IFNULL(concat('amount','=====',r.amount),'amount=====') as amount,
                            IFNULL(concat('invoice_no','=====',b.invoice_no),'invoice_no=====') as invoice_no,
                            IFNULL(concat('status','=====',b.status),'status=====') as status,
                            IFNULL(concat('acon_invoice_status','=====',b.acon_invoice_status),'acon_invoice_status=====') as acon_invoice_status,
                            IFNULL(concat('acon_accrual_status','=====',b.acon_accrual_status),'acon_accrual_status=====') as acon_accrual_status
                                from tb_reveneus r
                                LEFT JOIN tbl_bills b ON b.id=r.bill_id
                                WHERE  r.status = 1
                                and r.order_id in ($orderids)
                            )as invoice_inner1
                        ) as invoice_inner2
                    ) as invoice_inner3
                    group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                foreach ($result as $each) {
                    $index = $each['order_id'];
                    $value = $each['invoice_details'];
                    $data['orders'][$index]['invoice_details'] = $value;
                }
            }
        }
        return $data;
    }

    // the below method will give the order cargo details and convert the multiple rows to a single row for an order
    public function getOrderCargoDetailsForOrderListing($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select  order_id,
            sum(ocd.quantity) as totqty,
            sum(ocd.weight) as totwg,
            sum(ocd.volume) as totvol,
            sum(ocd.second_volume) as second_volume,
            sum(ocd.second_weight) as second_weight,
            cd.secondweight_uom,cd.secondvolume_uom
            FROM `tb_cargo_details` `cd`
            LEFT JOIN `tb_order_cargodetails` `ocd` ON `cd`.`id`= `ocd`.`cargo_id`
            WHERE
            `ocd`.`status` = 1 and `ocd`.`order_id` in ($orderids)
            group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['totqty'] = $each['totqty'];
                        $data['orders'][$index]['totwg'] = $each['totwg'];
                        $data['orders'][$index]['totvol'] = $each['totvol'];
                        $data['orders'][$index]['second_volume'] = $each['second_volume'];
                        $data['orders'][$index]['second_weight'] = $each['second_weight'];
                        $data['orders'][$index]['secondweight_uom'] = $each['secondweight_uom'];
                        $data['orders'][$index]['secondvolume_uom'] = $each['secondvolume_uom'];
                    }
                }
            }
        }
        return $data;
    }

    // the below method will give the order cargo details and convert the multiple rows to a single row for an order
    public function getTripCountFromEmployee($orderids)
    {
        if ($orderids != '') {
            $quotedOrderIds = $this->getUniqueValues($orderids, 1);
            if ($quotedOrderIds != '') {
                $sql = "select order_id,count(trip_id) as trip_no from tb_employee where order_id!='' and  order_id in ($quotedOrderIds) GROUP BY order_id";
                $res = $this->db->query($sql);
                if ($res->num_rows() > 0) {
                    $result = $res->result_array();
                    if (isset($result) && sizeof($result) > 0) {
                        foreach ($result as $each) {
                            $index = $each['order_id'];
                            $data[$index]['order_id'] = $each['order_id'];
                            $data[$index]['trip_no'] = $each['trip_no'];
                        }
                    }
                }
            }
        }
        return $data ?? [];
    }

    // the below method will give the delivered date of orders
    public function getDeliveredStatusForOrder($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "SELECT order_id,createdon as delivered_time FROM tb_stop_status WHERE order_id!=0  and
            order_id in ($orderids) and status_code='3000' and status=1 group by order_id order by order_id desc";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['delivered_time'] = $each['delivered_time'];
                    }
                }
            }
        }
        return $data;
    }

    public function getReportPartyDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "select order_id,
            GROUP_CONCAT(acon_debitor_code SEPARATOR '?????') as partydetails_acon_debitor_code,
            GROUP_CONCAT(party_type_name SEPARATOR '?????') as partydetails_party_type_name,
            GROUP_CONCAT(party_customer_identifier SEPARATOR '?????') as partydetails_party_customer_identifier
            from (
            select o.order_id,
            concat('id','=====',p.id) as id,
                 IFNULL(concat('acon_debitor_code','=====',p.acon_debitor_code),'acon_debitor_code=====') as acon_debitor_code,
                 IFNULL(concat('party_type_name','=====',pt.name),'party_type_name=====') as party_type_name,
                 IFNULL(concat('party_customer_identifier','=====',p.customeridentifier),'party_customer_identifier=====') as party_customer_identifier
            FROM tbl_party_master p
                 INNER JOIN tb_order_parties o ON p.id=o.party_id
                 left join tbl_party_types pt on pt.id=o.party_type
                 WHERE  p.status = 1 AND o.status = 1 and  order_id in ($orderids)  GROUP BY o.party_type,o.order_id
            ) as final_query group by order_id";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['partydetails_acon_debitor_code'] = $each['partydetails_acon_debitor_code'];
                        $data['orders'][$index]['partydetails_party_type_name'] = $each['partydetails_party_type_name'];
                        $data['orders'][$index]['partydetails_party_customer_identifier'] = $each['partydetails_party_customer_identifier'];
                    }
                }
            }
        }
        return $data;
    }

    public function getOrderTypeDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $quotedOrderIds = $this->getUniqueValues($orderids, 1);
            if ($quotedOrderIds != '') {
                $sql = "select od.order_row_id as order_id,od.department_code, type_name as order_type_name from tb_order_types ot RIGHT JOIN tb_order_details od ON ot.id = od.order_type where od.order_row_id in ($quotedOrderIds)";
                $res = $this->db->query($sql);
                if ($res->num_rows() > 0) {
                    $result = $res->result_array();
                    if (isset($result) && sizeof($result) > 0) {
                        foreach ($result as $each) {
                            $index = $each['order_id'];
                            $data['orders'][$index]['department_code'] = $each['department_code'];
                            $data['orders'][$index]['order_type_name'] = $each['order_type_name'];
                        }
                    }
                }
            }
        }
        return $data;
    }

    public function getOrderCostTypeDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $quotedOrderIds = $this->getUniqueValues($orderids, 1);
            if ($quotedOrderIds != '') {
                $sql = "select od.order_row_id as order_id, type_name as cost_type_name from tb_cost_center cc INNER JOIN tb_order_details od ON cc.id = od.cost_center_id where od.order_row_id in ($quotedOrderIds)";
                $res = $this->db->query($sql);
                if ($res->num_rows() > 0) {
                    $result = $res->result_array();
                    if (isset($result) && sizeof($result) > 0) {
                        foreach ($result as $each) {
                            $index = $each['order_id'];
                            $data['orders'][$index]['cost_type_name'] = $each['cost_type_name'];
                        }
                    }
                }
            }
        }
        return $data;
    }

    public function getReportOrderCargoDetails(string $orderids, array $data): array
    {
        if ($orderids != '') {
            $sql = "SELECT order_id,SUM(c.weight) AS totweight,SUM(c.volume) AS totvolume, SUM(c.quantity) AS cargo_quantity, cd.weight_unit,cd.volume_unit,GROUP_CONCAT(cargo_type) AS cargo_type
            FROM tb_order_cargodetails c INNER JOIN tb_cargo_details cd ON cd.id = c.cargo_id
            where c.status=1 and c.order_id>0  and c.order_id in ($orderids) group by c.order_id";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['cargo_actual_weight'] = $each['totweight'];
                        $data['orders'][$index]['cargo_actual_volume'] = $each['totvolume'];
                        $data['orders'][$index]['cargo_quantity'] = $each['cargo_quantity'];
                        $data['orders'][$index]['cargo_actual_weight_unit'] = $each['weight_unit'];
                        $data['orders'][$index]['cargo_actual_volume_unit'] = $each['volume_unit'];
                        $data['orders'][$index]['cargo_package_type'] = $each['cargo_type'];
                    }
                }
            }
        }
        return $data;
    }

    public function getLastStatusDetails(string $orderId): array
    {
        if (empty($orderId)) {
            return [];
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $this->db->select("ts.latitude,ts.longitude,ts.status_code,ts.loc_name,convertToClientTZ(ts.createdon," . $this->db->escape($curtz) . ") as createdon,sm.status_name");
        $this->db->from("tb_stop_status ts");
        $this->db->join('tb_status_master sm', 'sm.id = ts.status_id', 'inner');
        $this->db->join('tb_employee e', 'ts.shipment_id = e.shift_id', 'inner');
        $this->db->where("e.order_id", $orderId);
        $this->db->order_by("ts.id", "DESC");
        $this->db->limit(1);
        $stopStatus = $this->db->get();

        return $stopStatus->result_array();
    }

    // the below method will get order status from order_status table
    public function getOrderLastStatus($orderId)
    {
        if ($orderId != '') {
            $sql = "SELECT sm.id,sm.status_name,tps.latitude,tps.longitude,tps.status_id, tps.status_code,tps.createdon
            FROM tb_order_status tps
            inner join tb_status_master sm on sm.id=tps.status_id
            WHERE tps.id IN ( SELECT max(id) as id FROM tb_order_status where order_id in
            (?) ORDER by id DESC ) LIMIT 1";
            $res = $this->db->query($sql, $orderId);
            if ($res->num_rows() > 0) {
                return $res->row_array();
            }
        }
        return [];
    }

    public function getCustomerDeliveryNote($orderId): array
    {
        $this->db->select("ref_value");
        $this->db->from("tb_order_references");
        $this->db->where(["order_id" => $orderId, "status" => 1, "reference_id" => "DQ"]);
        $this->db->not_like('ref_value', 'SVK', 'after');
        $getRefNumber = $this->db->get();
        return ($getRefNumber->num_rows() > 0) ? $getRefNumber->row_array() : [];
    }

    public function GetSecureLinkDriverDetails(string $tripIds): array
    {
        if ($tripIds === '') {
            return [];
        }

        $data = [];
        $tripIds = explode(',', $tripIds);
        $res = $this->db->query("select  trip_id,GROUP_CONCAT(driver_details SEPARATOR '?????') as driver_details from (
            SELECT trip_id,concat(driver_name,' ===== ',driver_contact_number,' ===== ',driver_truck_reg_number) as driver_details
                     FROM tb_securelink_drivers sd where
                     trip_id IN ? and status=?
                     group by trip_id,driver_name
             ) AS final_ref group by trip_id ", [$tripIds,1]);

        if (!$res->num_rows()) {
            return [];
        }

        $result = $res->result_array();
        foreach ($result as $each) {
            $index = $each['trip_id'];
            $data[$index]['trip_id'] = $each['trip_id'];
            $data[$index]['driver_details'] = $each['driver_details'];
        }

        return $data;
    }

    public function getTransitTimeDetails(string $orderIds, array $data): array
    {
        if ($orderIds != '') {
            $orderIds = explode(',', $orderIds);
            $sql = "SELECT GROUP_CONCAT(createdon SEPARATOR '#') AS createdon,order_id FROM tb_stop_status WHERE ((`status_code`=? AND `stop_type`=?) OR (`status_code`= ? AND `stop_type`=?)) AND order_id IN ? GROUP BY order_id";
            $query = $this->db->query($sql,['0191','P','0192','D',$orderIds]);
            if ($query->num_rows() > 0) {
                $result = $query->result();
                foreach ($result as $response) {
                    $createdon = explode('#', $response->createdon);
                    $transitTime = '-';

                    if (count($createdon) === 2) {
                        $gateIn  = strtotime($createdon[0]);
                        $gateOut = strtotime($createdon[1]);

                        if ((int)$gateOut > (int) $gateIn) {
                            $duration = $gateOut - $gateIn;
                            $mins     = floor($duration / 60);
                            $hours    = str_pad(floor($mins /60),2,"0",STR_PAD_LEFT);
                            $transitTime = $hours > 1 ? $hours : '-';
                        }
                    }
                    $index = $response->order_id;
                    $data['orders'][$index]['transit_time_in_hours'] = $transitTime;
                }
            }
        }
        return $data;
    }

    public function getPUPUploads($orderids, $data)
    {
        if ($orderids != '') {
            $sql = "select order_id,group_concat(pup_details SEPARATOR '?????') as pup_details from (
                select order_id, concat(createdon,'+++++',stop_type) as pup_details from (
                select p.order_id,
                    IFNULL(concat('createdon','=====',createdon),'createdon=====') as createdon,
                    IFNULL(concat('stop_type','=====',stop_type),'stop_type=====') as stop_type
                    FROM tb_pod_uploads p
                    where stop_type='P' and doc_type=4 and status=1 and order_id in ($orderids)
                    )  as v1
                  ) as final_pod
                  group by order_id";
            $res = $this->db->query($sql);

            if ($res->num_rows() > 0) {
                $result = $res->result_array();

                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data['orders'][$index]['pup_details'] = $each['pup_details'];
                    }
                }
            }
        }
        return $data;
    }
}
