<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Datatables_model extends CI_model{

    function __construct(){
        parent::__construct();
    }

    public function datatablesQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn = '', $resultInArray = false, $groupBy = '', $excludeCountQuery = 'No', $postType = '')
    {
        if ($postType == 'POST') {
            $search = $this->input->post('search');
            $search = $search['value'] ?? '';
            $start = $this->input->post('start');
            $length = $this->input->post('length');
            $draw = $this->input->post('draw');
            $order = $this->input->post('order');
        } else {
            $search = $this->input->get('search');
            $search = $search['value'] ?? '';
            $start = $this->input->get('start');
            $length = $this->input->get('length');
            $draw = $this->input->get('draw');
            $order = $this->input->get('order');
        }
        $whr = '';
        $selectQueryColumns = implode(',', $selectColumns);
        $this->db->select($selectQueryColumns);
        $this->db->from($table_name);
        if (!empty($joinsArray) && sizeof($joinsArray) > 0) {
            foreach ($joinsArray as $each) {
                $this->db->join($each['table_name'], $each['condition'], $each['join_type']);
            }
        }
        if ($wherecondition != '1') {
            $this->db->where($wherecondition);
        }
        if ($search != '') {
            $sortFilters = [];
            foreach ($selectColumns as $eachColumn) {
                $tempVar = explode(' as ', $eachColumn);
                if (!empty($tempVar) && sizeof($tempVar) > 1) {
                    $eachColumn = $tempVar[0];
                }
                $filter = "  $eachColumn like '%$search%' ";
                $sortFilters[] = $filter;
            }
            $searchCond = implode('or ', $sortFilters);
            $searchCond = "( " . $searchCond . " )";
            $this->db->where($searchCond);
        }
        if ($groupBy != '') {
            $this->db->group_by($groupBy);
        }
        if (!empty($order)) {
            $columnIndex = $order[0]['column'];
            $orderByColumn = $dataTableSortOrdering[$columnIndex];
            if ($orderByColumn == '') {
                $orderByColumn = $indexColumn;
            }
            $sortType = $order[0]['dir'];
            $this->db->order_by($orderByColumn, $sortType);
        } else {
            if ($indexColumn != '') {
                $this->db->order_by($indexColumn, 'desc');
            }
        }
        if ($length != 0 && $length > 0) {
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        log_message("error","Inn:".$this->db->last_query());
        $recordsFiltered = $query->num_rows();
        if ($resultInArray) {
            $returnData = $query->result_array();
        } else {
            $returnData = $query->result();
        }
        $selectCountColumn = $indexColumn ?: '*';
        $table_total = '';
        if ($excludeCountQuery == 'Yes') {
        } else {
            $countQuery = "select count($selectCountColumn) as count from $table_name ";
            if ($wherecondition != '') {
                $countQuery .= ' where ' . $wherecondition;
            }
            $totalCountRecords = $this->db->query($countQuery);
            $countTotal = $totalCountRecords->result_array();
            $table_total = $countTotal[0]['count'];
        }
        $getRecordListing['data'] = $returnData;
        $getRecordListing['recordsTotal'] = $table_total;
        $getRecordListing['recordsFiltered'] = $table_total;
        return $getRecordListing;
    }

    /*get mis report notify data*/
    public function datatablesMISQuery($selectColumns,$table_name,$joinsArray,$wherecondition,$indexColumn='') {
        $whr='';
        $selectQueryColumns=implode(',',$selectColumns);
        $this->db->select($selectQueryColumns);
        $this->db->from($table_name);
        if(!empty($joinsArray) && sizeof($joinsArray)>0){
            foreach($joinsArray as $each){
                $this->db->join($each['table_name'],$each['condition'],$each['join_type']);
            }
        }
        $this->db->where($wherecondition);
        $this->db->order_by($indexColumn, 'ASC');
        $query=$this->db->get();
        $returnData = $query->result_array();
        $getRecordListing['data']=$returnData;
        return $getRecordListing;
    }

    public function customerordersdataQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn = '', $resultInArray = false, $groupBy = '', $excludeCountQuery = 'No', $postType = '', $orderbycol = '' , $orderby = '')
    {
        if ($postType == 'POST') {
            $search = $this->input->post('search');
            $search = $search['value'] ?? '';
            $start = $this->input->post('start');
            $length = $this->input->post('length');
            $draw = $this->input->post('draw');
            $order = $this->input->post('order');
        } else {
            $search = $this->input->get('search');
            $search = $search['value'] ?? '';
            $start = $this->input->get('start');
            $length = $this->input->get('length');
            $draw = $this->input->get('draw');
            $order = $this->input->get('order');
        }
        $whr = '';
        $selectQueryColumns = implode(',', $selectColumns);
        $this->db->select($selectQueryColumns);
        $this->db->from($table_name);
        if (!empty($joinsArray) && sizeof($joinsArray) > 0) {
            foreach ($joinsArray as $each) {
                $this->db->join($each['table_name'], $each['condition'], $each['join_type']);
            }
        }
        if ($wherecondition != '1') {
            $this->db->where($wherecondition);
        }
        if ($search != '') {
            $sortFilters = [];
            foreach ($selectColumns as $eachColumn) {
                $tempVar = explode(' as ', $eachColumn);
                if (!empty($tempVar) && sizeof($tempVar) > 1) {
                    $eachColumn = $tempVar[0];
                }
                $filter = "  $eachColumn like '%$search%' ";
                $sortFilters[] = $filter;
            }
            $searchCond = implode('or ', $sortFilters);
            $searchCond = "( " . $searchCond . " )";
            $this->db->where($searchCond);
        }
        if ($groupBy != '') {
            $this->db->group_by($groupBy);
        }
        $sortType = $orderby;
        if (!empty($orderbycol)) {
            $this->db->order_by($orderbycol, $sortType);
        } else {
            if ($indexColumn != '') {
                $this->db->order_by($indexColumn, $sortType);
            }
        }
        if ($length != 0 && $length > 0) {
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        $recordsFiltered = $query->num_rows();
        if ($resultInArray) {
            $returnData = $query->result_array();
        } else {
            $returnData = $query->result();
        }
        $selectCountColumn = $indexColumn ?: '*';
        $table_total = '';
        if ($excludeCountQuery == 'Yes') {
        } else {
            $countQuery = "select count($selectCountColumn) as count from $table_name ";
            if ($wherecondition != '') {
                $countQuery .= ' where ' . $wherecondition;
            }
            $totalCountRecords = $this->db->query($countQuery);
            $countTotal = $totalCountRecords->result_array();
            $table_total = $countTotal[0]['count'];
        }
        $getRecordListing['data'] = $returnData;
        $getRecordListing['recordsTotal'] = $table_total;
        $getRecordListing['recordsFiltered'] = $table_total;
        return $getRecordListing;
    }
}
?>
