<?php
class DelhiveryB2BEDIModel extends CI_Model {
	public function getPartyInfoByOrderId(int $orderId, string $partyType) : array {
		$getResult = $this->db->query("SELECT m.id,m.name,m.email,m.mobile,m.code,m.location_id,m.address,m.country,m.state,m.pincode,m.partyindetifier
			FROM tbl_party_master m, tbl_party_types p, tb_order_parties t
			WHERE t.order_id = ? AND t.status = ? AND m.id = t.party_id AND t.party_type = p.id AND p.name = ?
			",[$orderId, 1, $partyType]);
		return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
	}

	public function getPartyInfo(int $id) : array {

		$getResult = $this->db->query("SELECT id,name,email,mobile,code,location_id,address,country,state,pincode
			FROM tbl_party_master WHERE id = ? ",[$id]);
		return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
	}

	public function updateStatus(string $ordersData): string
    {
        $ordersInfo = json_decode($ordersData, true);
        $message = "0";
        foreach ($ordersInfo as $orders) {
        	$lrNumber = $orders['OrderID'];
			$getBookingID = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT OUTER JOIN tb_order_references tr ON tr.order_id=o.id WHERE tr.`ref_value`= ? AND tr.`status`=1 LIMIT 1", [$orders['OrderID']]);
			$orders['OrderID'] = ($getBookingID->num_rows() > 0) ? $getBookingID->row()->order_id : $orders['OrderID'];
            if ($orders['OrderID'] > 0) {
            	$orderInfo = $this->db->query("SELECT id, user_id, shipmentid, shift_id, trip_id, created_source, vendor_id FROM tb_orders WHERE order_id = ? ", [$orders['OrderID']]);
                if ($orderInfo->num_rows() > 0) {
                	$orderInfo = $orderInfo->row_array();
                    $orderId = $orderInfo['id'];
                    $userId = $orderInfo['user_id'];
                    $shipmentId = $orderInfo['shipmentid'];
                    $createdsource = $orderInfo['created_source'];
                    $countryCode = "";
                    $countryCodeDetails = $this->db->query("SELECT country_code FROM tb_users WHERE id = ?", [$userId]);
                    if ($countryCodeDetails->num_rows() > 0) {
                        $countryCode = $countryCodeDetails->row()->country_code;
                    }

                    if (!empty($countryCode)) {
                        $countryTimeZone = $this->db->query("SELECT cntry_timezone,cntry_hrs FROM tbl_country_master WHERE country_code =? AND status=1 LIMIT 1", [$countryCode]);
                        if ($countryTimeZone->num_rows() > 0) {
                            $timeZone = $countryTimeZone->row()->cntry_timezone;
                        } else {
                            $timeZone = "Asia/Singapore";
                        }
                    } else {
                        $timeZone = "Asia/Singapore";
                    }
                    $date = str_replace("T", " ", $orders['datetime']);
                    $promisedDeliveryDate = str_replace("T", " ", $orders['promiseddeliverydate']);
                    $expectedDeliveryDate = str_replace("T", " ", $orders['expecteddeliverydate']);
                    $dateTime = getdatetimebytimezone(DFLT_TZ, $date, $timeZone);
					$promisedDeliveryDate =	date('Y-m-d H:i:00',strtotime($promisedDeliveryDate));
					$expectedDeliveryDate =	date('Y-m-d H:i:00',strtotime($expectedDeliveryDate));
					$statusDateTime = date('Y-m-d h:i:00',strtotime($dateTime['datetime']));
                    if ($this->db->query("UPDATE tb_order_details SET promise_deliver_date = ? WHERE order_row_id = ? ", [$promisedDeliveryDate, $orderId])) {
                    	$statusInfo = [];
                    	$statusName = '';
                    	if($orders['statuscode']) {
                    		$statusQry = $this->db->query("SELECT status_name FROM tb_status_master WHERE status_code = ? ", [$orders['statuscode']]);
                    		$statusName = $statusQry->num_rows() > 0 ? $statusQry->row()->status_name : "";
                    	}
                    	$statusType = strtolower($statusName) === 'complete' ? 'DL' : 'UD';
						$pushApiData = [
							'order_id'=>$orderId,
							'status_name'=>$statusName,
							'status_datetime'=>$statusDateTime,
							'status_type'=>$statusType,
							'status_location'=>$orders['location'],
							'instructions'=>$orders['shipmentremark'],
							'promise_deliver_date'=>$promisedDeliveryDate,
							'exp_deliver_date'=>$expectedDeliveryDate,
							'awbnum'=>$lrNumber,
							'status'=>1,
							'createdon'=>date('Y-m-d')
						];
						$checkExists = $this->db->query("SELECT id FROM tb_uniqlo_push_api_data WHERE order_id = ? AND status_name = ? AND status_datetime = ? AND status_type = ? ",[$orderId, $statusName, $statusDateTime, $statusType]);
						if ($checkExists->num_rows() == 0) {
							$this->db->insert("tb_uniqlo_push_api_data",$pushApiData);
						} else {
							$this->db->set($pushApiData)->where(['id'=>$checkExists->row()->id])->update("tb_uniqlo_push_api_data");
						}
						$scanData = [
							'order_id'=>$orderId,
							'scan_datetime'=>$statusDateTime,
							'scan_type'=>$statusType,
							'scan_val'=>$statusName,
							'scan_status_time'=>$statusDateTime,
							'scan_location'=>$orders['location'],
							'scan_instruction'=>$orders['shipmentremark'],
							'scan_status_code'=>$statusName,
							'status'=>1,
							'createdon'=>date('Y-m-d')
						];

						$checkExists = $this->db->query("SELECT id FROM tb_uniqlo_order_scans WHERE order_id = ? AND scan_val = ? AND scan_datetime = ? AND scan_type = ? ",[$orderId, $statusName, $statusDateTime, $statusType]);
						if ($checkExists->num_rows() == 0) {
							$this->db->insert('tb_uniqlo_order_scans',$scanData);
						} else {
							$this->db->set($scanData)->where(['id'=>$checkExists->row()->id])->update("tb_uniqlo_order_scans");
						}
                    }
                }
                $message = "1";
            }
        }
        return $message;
    }
}