<?php

use App\ShipmentStopDetails\ShipmentStopDetailsService;
use App\ShipmentStops\GetShipmentStopsService;

defined('BASEPATH') or exit('No direct script access allowed');

class Driverappv3model extends Common
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getShipments($curtz, $shift_id, $stop_id, $type): array
    {
        $result = [];

        $where = ($type == "1") ? " AND accepted = 1 " : "";
        $query = ShipmentStopDetailsService::getStopDetailsDataV3($shift_id, $stop_id, $curtz, $where, $this->db);

        if ($query->num_rows() > 0) {
            $result = $query->result();
        }

        return $result;
    }

    public function getCrossBorderShipments(string $curtz, int $shift_id, int $stop_id, int $type): array
    {
        $result = [];
        $where = ($type == "1") ? " AND accepted = 1 " : "";
        $query = ShipmentStopDetailsService::getCrossBorderStopDetailsDataV3($shift_id, $stop_id, $curtz, $where, $this->db);
        if ($query->num_rows() > 0) {
            $result = $query->result();
        }
        return $result;
    }

    /**
     * @param string $curtz
     * @param int $shift_id
     * @return array
     */
    public function shiporderStops(string $curtz, int $shift_id): array
    {
        $result = [];
        $query = GetShipmentStopsService::getStops($curtz ?? "", $shift_id ?? 0, $this->db);
        if ($query->num_rows() > 0) {
            $result = $query->result();
        }

        return $result;
    }

    public function employeeData($stop_id, $shft_id, $stop_id_col): array
    {
        return self::gettblrowdata([$stop_id_col => $stop_id, 'shift_id' => $shft_id, 'status' => 1], 'id,order_id ', 'tb_employee', 0, 0);
    }

    public function shipmentTripInfo(string $shipment_id): array
    {
        $result = [];
        $sql   = "SELECT tb_shifts.id AS shift_id
                            ,tb_shifts.status as active_status
                            ,tb_shifts.shipmentid
                            ,tb_trips.id AS trip_id
                            ,IFNULL(tb_trips.driver_id,'0') AS driver_id
                            ,tb_shft_veh.id AS shift_veh_id
                            ,IFNULL(tb_trips.transit_status,'-1') AS astatus
                        FROM tb_shifts
                            LEFT JOIN `tb_trips` ON (tb_trips.shift_id = tb_shifts.id)
                            LEFT JOIN `tb_shft_veh` ON (tb_shft_veh.shft_id=tb_shifts.id AND tb_shft_veh.status =1)
                        WHERE tb_shifts.shipmentid ='" . $shipment_id . "' limit 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
        }

        return $result;
    }

    public function driverLoginByToken($mobile): array
    {
        $this->db->select('d.*,u.country_code,u.mobile_no,u.default_currency as currency');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
        $this->db->where(["d.contact_num" => $mobile, "d.status" => "Active"]);
        $this->db->limit(1);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->row_array(): [];
    }

    public function truckDriverData($driverId): object
    {
        $result = new stdClass();
        $query = $this->db->query(
          "SELECT t.id,t.register_number from tbl_assigned_drivers a, tb_trucks_data t, tb_truck_drivers d
where a.driver_id= $driverId AND t.id=a.vehicle_id AND a.status=1 AND d.status='Active' AND d.id=a.driver_id AND t.status='Active' ORDER BY a.id DESC LIMIT 1"
        );
        if ($query->num_rows() > 0) {
            $result = $query->row();
        }

        return $result;
    }

    public function getStopStatus(array $whr, string $curtz): array
    {
        $res = [];
        $this->db->select("s.id,s.stop_type,s.status_id,convertToClientTZ(s.createdon,'" . $curtz . "') as createdon,t.status_name");
        $this->db->from('tb_stop_status s');
        $this->db->join('tb_status_master t', 's.status_id=t.id', 'INNER');
        $this->db->where($whr);
        $this->db->order_by('s.createdon', 'DESC');
        $this->db->limit(1);
        $chkrecent = $this->db->get();
        if ($chkrecent->num_rows() > 0) {
            $res = [
              'name'      => $chkrecent->row()->status_name,
              'id'        => $chkrecent->row()->id,
              'createdon' => $chkrecent->row()->createdon,
              'status_id' => $chkrecent->row()->status_id,
              'stop_type' => $chkrecent->row()->stop_type,
            ];
        }

        return $res;
    }

    public function shipmentUserData(int $stop_id, string $shipment_id): object
    {
        $ord_whr = '';
        if ($stop_id) {
            $ord_whr = " AND (e.stop_id=" . $stop_id . " OR e.drop_stopid=" . $stop_id . ") ";
        }

        $query = $this->db->query("SELECT o.id,o.order_id,o.user_id,o.shipmentid FROM tb_orders o,tb_employee e WHERE o.order_id=e.order_id AND o.shift_id='" . $shipment_id . "' AND e.status=1 $ord_whr LIMIT 1");
        if ($query->num_rows() > 0) {
            $result = $query->row();
        }

        return $result;
    }

    public function checkTripCancellation(string $shipmentId): bool
    {
        $shipmentActiveRow = $this->gettblrowdata(['shipmentid' => $shipmentId], 'status as active_status', 'tb_shifts', 0, 0);
        $result = 1;
        if (! empty($shipmentActiveRow)) {
            $result = $shipmentActiveRow['active_status'];
        }

        return $result;
    }

    public function checkUserRegistration(string $shipmentId): bool
    {
        $where_in = ['col' => 'company_code', 'arr' => SECURE_LINK_DRIVER_REGISTRATION_ALLOWED_COUNTRIES];
        $result = $this->gettbldata_where_in(['shipmentid' => $shipmentId], $where_in, '*', 'tb_orders', 0, 0);
        return !(count($result) > 0);
    }

    public function getTripDriverDetails(string $shipmentId): array
    {
        $tripData = $this->db->query(
            "select `id` as `trip_id`, `shift_id`, `vehicle_id`, `driver_id` from `tb_trips` where `id` = (select distinct `trip_id` from `tb_orders` where `shipmentid` = '{$shipmentId}')"
        );
        if ($tripData->num_rows() > 0) {
            $tripData = $tripData->row();
            $tuckDriverRowData = $this->gettblrowdata(['id' => $tripData->driver_id], '*', 'tb_truck_drivers', 0, 0);
            $trucksRowData = $this->gettblrowdata(['id' => $tripData->vehicle_id], '*', 'tb_trucks_data', 0, 0);
            return [
                'tripData' => $tripData,
                'tuckDriverRowData' => $tuckDriverRowData,
                'trucksRowData' => $trucksRowData,
            ];
        }else{
            $checkCrossBorderTrip = $this->db->query("SELECT t.id as trip_id,t.shift_id,t.vehicle_id,t.driver_id FROM tb_trips t,tb_shifts s  WHERE s.shipmentid = ? AND s.shift_leg_id >0 AND t.shift_id = s.id",[$shipmentId]);
            if($checkCrossBorderTrip->num_rows() >0){
                $tripData = $checkCrossBorderTrip->row();
                $tuckDriverRowData = $this->gettblrowdata(['id' => $tripData->driver_id], '*', 'tb_truck_drivers', 0, 0);
                $trucksRowData = $this->gettblrowdata(['id' => $tripData->vehicle_id], '*', 'tb_trucks_data', 0, 0);
                return [
                    'tripData' => $tripData,
                    'tuckDriverRowData' => $tuckDriverRowData,
                    'trucksRowData' => $trucksRowData,
                ];
            }

        }

        return [];
    }

    public function checkDriverDeviceExisted(string $deviceUUID, string $shipmentId, int $tripId): bool
    {
        $row = $this->db->query(
            "SELECT count(*) as driversCount FROM `tb_securelink_drivers` WHERE `driver_device_uuid` = '{$deviceUUID}' AND `shipment_id` = '{$shipmentId}' AND `trip_id` = $tripId AND `status` = 1 ORDER BY `id` DESC"
        )->row();
        return $row->driversCount > 0;
    }

    public function driverDetailsStore(array $tuckDriverRowData): int
    {
        $driverNewContactNum = $tuckDriverRowData['contact_num'] ?: 0;
        $tuckDriverRowData['status'] = 'Active';

        if (isset($tuckDriverRowData['imei'])) {
            unset($tuckDriverRowData['imei']);
        }

        if ($driverNewContactNum) {
            $driverDataExisted = $this->gettblrowdata(
                ['contact_num' => $driverNewContactNum],
                'id, contact_num',
                'tb_truck_drivers',
                0,
                0
            );
            if (isset($driverDataExisted['id'])) {
                $this->updatetbledata("tb_truck_drivers", $tuckDriverRowData, ["id" => $driverDataExisted['id']]);
                return $driverDataExisted['id'];
            }
        }
        return $this->insertTableData('tb_truck_drivers', $tuckDriverRowData);
    }

    public function truckDetailsStore(array $trucksRowData): int
    {
        $truckNewRegNum = $trucksRowData['truck_number'] ?: 0;
        $trucksRowData['status'] = 'Active';
        $trucksRowData['updatedon'] = date('Y-m-d H:i:s');
        if ($truckNewRegNum) {
            $truckDataExisted = $this->gettblrowdata(
                ['truck_number' => $trucksRowData['truck_number']],
                'id, truck_number',
                'tb_trucks_data',
                0,
                0
            );
            if (isset($truckDataExisted['id'])) {
                $this->updatetbledata("tb_trucks_data", $trucksRowData, ["id" => $truckDataExisted['id']]);
                return $truckDataExisted['id'];
            }
        }
        $trucksRowData['createdon'] = $trucksRowData['updatedon'];
        return $this->insertTableData('tb_trucks_data', $trucksRowData);
    }

    public function getCargoDetailsByShiftId(int $shiftId): array
    {
        $query = $this->db->query(
            "SELECT
          SUM(cd.weight) as weight,
          cd.weight_unit,
          SUM(cd.ldm) as ldm,
          SUM(cd.quantity) as quantity,
          oc.order_id,
          oc.quantity_type
        FROM
          tb_cargo_details cd
          LEFT JOIN tb_order_cargodetails oc ON oc.cargo_id = cd.id
          LEFT JOIN tb_orders o ON o.id = oc.order_id
        WHERE
          o.shift_id = ?
          AND o.status != ?
          AND cd.status = ?
          AND oc.status = ?
          GROUP by cd.weight_unit,oc.quantity_type, oc.order_id", [$shiftId, 0, 1, 1]
        );
        return $query->result_array();
    }

    public function getCrossBorderLegsLocation(int $shiftId): array
    {
        $result = [];
        $dropStopId = $pickupStopId = 0;
        $getLocationIds = $this->db->query("SELECT stoptype,stop_party_id FROM tb_shiporder_stops WHERE shipment_id = ? AND status =? AND stop_party_id > ?", [$shiftId, '1', '0']);
        if ($getLocationIds->num_rows() == 0) {
            return [];
        }
        foreach ($getLocationIds->result_array() as $eachRow) {
            $stopType = $eachRow['stoptype'];
            if (strtoupper($stopType) == "P") {
                $pickupStopId = $eachRow['stop_party_id'];
            } else {
                $dropStopId = $eachRow['stop_party_id'];
            }
        }
        $stopIds = [$dropStopId, $pickupStopId];
        if (in_array('0', $stopIds)) {
            return [];
        }
        $getLocationDetails = $this->db->query("SELECT id,name,location_id,country,state,street,pincode FROM tbl_party_master WHERE id IN ?", [$stopIds]);
        if ($getLocationDetails->num_rows() == 0) {
            return [];
        }
        foreach ($getLocationDetails->result_array() as $eachRow) {
            $rowId = $eachRow['id'];
            $result[$rowId == $pickupStopId ? 'P' : 'D'] = ['name' => $eachRow['name'], 'city' => $eachRow['location_id'], 'street' => $eachRow['street'], 'state' => $eachRow['state'], 'country' => $eachRow['country'], 'pincode' => $eachRow['pincode']];
        }
        return $result;
    }

    public function getOrderRowIdByBookingId(string $bookingId): array
    {
        $query = $this->db->query("SELECT id,pickup_company,pickup_city,pickup_country,pickup_address1,pickup_address2,pickup_pincode,delivery_country,delivery_company,delivery_city,delivery_address1,delivery_address2,delivery_pincode,company_code,shipmentid,created_source FROM tb_orders WHERE order_id = ? ", [$bookingId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
}
