<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ediroutermodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getTripCustomer(int $shiftId): array
    {
        $result = [];
        $result_set = $this->db->select(['tb_customers.id', 'code', 'name'])
            ->from('tb_orders')
            ->join('tb_customers', 'tb_customers.id = tb_orders.customer_id', 'join')
            ->where(['tb_orders.shift_id' => $shiftId, 'tb_customers.status' => 1, 'tb_orders.status>=' => 1])
            ->limit(1)
            ->get();
        if ($result_set && $result_set->num_rows() > 0) {
            $result = $result_set->row_array();
        }
        return $result;
    }

    public function getUsernameAndPasswordOfCarrier(int $vendorId)
    {
        $this->load->model('common');
        $response = $this->common->gettblrowdata(['id' => $vendorId, 'status' => 1], ['mobile', 'password'], 'tb_vendors', 0, 0);
        if (isset($response['mobile']) && isset($response['password']) && strlen($response['mobile']) > 3 && strlen($response['password']) > 3) {
            return ['status' => 1, 'username' => $response['mobile'], 'password' => $response['password']];
        }
        return ['status' => 0, 'username' => '', 'password' => ''];
    }

    public function getShipmentId(int $shiftId): ?string
    {
        $resultSet = $this->db->select(['shipmentid'])->from('tb_orders')->where(['shift_id' => $shiftId])->limit(1)->get();
        return $resultSet && $resultSet->num_rows() > 0 ? ($resultSet->row_array())['shipmentid'] : (string)$shiftId;
    }
}
