<?php 
class Frieghttrack extends CI_Model
{
  
  function getContainerInfo($shipmentid){
    $this->db->select('vehicle_type')->from('tb_shifts')->where('id',$shipmentid);
    $shipment = $this->db->get()->row();
    $shipment->vehicle_type = 25;
    $this->db->select('*')->from('tb_trucks_data')->where('truck_type',$shipment->vehicle_type);
    $query = $this->db->get();
    return $query->row();
  }

  function getCargoDetailsByShiftid($shipmentid){
    
      $this->db->select('ocd.*,o.weight as order_weight,cd.length_unit, cd.width_unit, cd.height_unit, cd.stackable,cd.grounded')->from('tb_order_cargodetails ocd');
      $this->db->join('tb_cargo_details cd','ocd.cargo_id = cd.id','LEFT');
      $this->db->join('tb_orders o','o.id = ocd.order_id','INNER');
      $this->db->where('o.shift_id',$shipmentid);
      $this->db->where('ocd.status',1);
      $query = $this->db->get(); 
      //log_message("error","CargoQuery:".$this->db->last_query()); 
      return $query->result();
  
  }

  function getCargoDetailsByOrderid($order_id){
    $this->db->select('cd.*,o.weight as order_weight')->from('tb_order_cargodetails cd');
    $this->db->join('tb_orders o','o.id = cd.order_id','INNER');
    $this->db->where('o.id',$order_id);
    $this->db->where('cd.status',1);
    $query = $this->db->get(); 
    return $query->result();
  }

  /*function getContainerInfoByType($type){
    $this->db->select("td.register_number,td.length,td.breadth,td.height,td.truck_weight as truck_capacity")->from('tb_trucks_data td');
    $this->db->join('tb_trucktypes t','t.id = td.truck_type','INNER');
    $this->db->where('t.trucktype',$type);
    $this->db->order_by('td.id');
    $query = $this->db->get();
    return (array)$query->row();
  }*/
  
  public function getContainerInfoByType($register_number = '', $truckType = '')
    {
        $this->db->select("td.register_number, td.length, td.breadth, td.height, td.length_unit, td.breadth_unit, td.height_unit, td.truck_weight as truck_capacity")
                 ->from('tb_trucks_data td')
                 ->join('tb_trucktypes t', 't.id = td.truck_type', 'INNER')
                 ->where('td.status', 'Active');
        //log_message('error', "Register number provided: " .$register_number);
        if (!empty($register_number)) {
            $this->db->where('td.register_number', $register_number);
        } else {
            $this->db->where('t.trucktype', $truckType);
            //log_message('error', "Register number empty. Used truck type: " . $truckType);
        }
        $this->db->order_by('td.id');
        $query = $this->db->get();
        //log_message('error', 'Query Run in getContainerInfoFlexible: ' . $this->db->last_query());
        return (array) $query->row();
    }
    
    public function getRegisterNumberByShipment($shipmentid)
    {
        $query = $this->db->query("
            SELECT register_number 
            FROM tb_shft_veh 
            WHERE shft_id = ? AND status = 1
            ORDER BY id DESC
            LIMIT 1
        ", [$shipmentid]);
        if ($query->num_rows() > 0) {
            $register_number = $query->row()->register_number;
            log_message('error', "Register number fetched from tb_shft_veh: " . $register_number);
            return $register_number;
        }return '';
    }
    
    public function convertToInches($value, $unit)
    {
        $unit = strtoupper(trim($unit)); 
    
        if ($unit === 'M') {
            return $value * 39.3701;
        } elseif ($unit === 'CM') {
            return $value * 0.393701; 
        } elseif ($unit === 'FT') {
            return $value * 12; 
        } else {
            return $value;
        }
    }

}