<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Geoprovincemodel extends CI_Model
{
    public function getsearchdata(array $whr, array $where): array
    {
        $this->db->select('tp.*, cm.country_name');
        $this->db->from('tb_geo_provinces as tp');
        $this->db->like($where);
        $this->db->where($whr);
        $this->db->order_by('tp.id', 'DESC');
        $this->db->join('tbl_country_master as cm', 'cm.country_code=tp.country_code', 'LEFT');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function selectlist(string $select, string $table, array $whr, string $group): array
    {
        $this->db->select($select);
        $this->db->group_by($group);
        $this->db->where($whr);
        $this->db->from($table);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
    public function viewdata(int $id): array
    {
        $this->db->select('tp.*,cm.country_name');
        $this->db->from('tb_geo_provinces as tp');
        $this->db->where('tp.id', $id);
        $this->db->join('tbl_country_master as cm', 'cm.country_code=tp.country_code', 'LEFT');
        $edit = $this->db->get()->row_array();
        return $edit;
    }
    public function editdata(int $id): array
    {
        $this->db->select('tp.*,');
        $this->db->from('tb_geo_provinces as tp');
        $this->db->where('tp.id', $id);
        $edit = $this->db->get()->row_array();
        return $edit;
    }

    public function selectBranchCodes(string $cmpCode): array
    {
        $this->db->from('tb_branch_master');
        $this->db->select('id, branch_code');
        $this->db->where('company_code', $cmpCode);
        $this->db->where('status', 1);
        return $this->db->get()->result_array();
    }

    public function generateRandomId(): mixed
    {
        $this->db->from('tb_geo_provinces');
        $this->db->select('id');
        $this->db->limit(1, 0);
        $this->db->order_by('id', 'desc');
        $result = $this->db->get()->row_array();
        if (isset($result) && sizeof($result) > 0) {
            $lastId = $result['id'] + 1;
            if (strlen($lastId) < 4) {
                $lastGenId = str_pad($lastId, 4, '0', STR_PAD_LEFT);
            } else {
                $lastGenId = $lastId;
            }
        } else {
            $lastId = 1;
            $lastGenId = str_pad($lastId, 4, '0', STR_PAD_LEFT);
        }
        return $lastGenId;
    }

}

