<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class KNCarrierExcel extends CI_Model {

    function getsearchdata($whr, $where) {
        $this->db->select('tt.*, c.name as uname');
        $this->db->from('tb_order_types as tt');
        $this->db->join('tb_customers c', 'tt.customer_id=c.id', "LEFT");
        $this->db->like($where);
        $this->db->where($whr);
        $this->db->order_by('tt.id', 'DESC');
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }

    /* Excel Data getting from Database  */

    public function employeeList($company_code, $branch_code, $trip_id) {
//        log_message("error", $company_code . ',' . $branch_code . ',' . $trip_id);
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $this->db->select("so.id as uniq_order_id,so.order_id,convertToClientTZ(so.pickup_datetime,'" . $curtz . "') pickup_datetime,so.pickup_endtime,
                CAST(convertToClientTZ(so.delivery_datetime,'" . $curtz . "') AS DATE) AS delivert_date,
                CAST(convertToClientTZ(so.delivery_datetime,'" . $curtz . "') AS TIME) delivery_time,so.delivery_city AS city,tpm.id ,tpm.name,tpm.mobile,so.weight,so.volume,CONCAT(so.delivery_pincode,',',so.delivery_country,',',so.delivery_address2,',',so.delivery_city,',',so.delivery_address1) AS cons_address,tos.vas_name,tos.vas_id,tod.purchase_order,v.email,v.name as carrier_name");
        $this->db->from('tb_shifts s');
        $this->db->join('tb_shft_veh sv', 'sv.shft_id=s.id', "LEFT");
        $this->db->join('tb_vendors v', 'v.id = sv.carrier_id', "LEFT");
        $this->db->join('tb_orders so', 's.shipmentid=so.shipmentid', "LEFT");
        $this->db->join('tb_order_details tod', 'tod.order_id=so.order_id', "LEFT");
        //$this->db->join('tb_shipment_orders tso','s.shipment_id=tso.shipment_id',"LEFT");
        $this->db->join('tbl_party_types tpt', 'so.user_id=tpt.user_id', "LEFT");
        $this->db->join('tbl_party_master tpm', 'tpm.party_type_id=tpt.id', "LEFT");
        $this->db->join('tb_order_vas tov', 'tov.order_id=so.id AND tov.status=1', "LEFT");
        $this->db->join('tb_vas_master tos', 'tos.id=tov.vas_id AND tos.status=1', "LEFT");
        $this->db->where("s.company_code", $company_code);
        $this->db->where("s.branch_code", $branch_code);
        $this->db->where("s.shipmentid", $trip_id);
        $this->db->group_by('so.order_id');
        $this->db->order_by("so.order_id", "DESC");
        $query = $this->db->get();
        // log_message("error","------3:15------".$this->db->last_query());
        return $query->result_array();
    }

    function getConsigneeDetails($order_id) {
        $select = 'party_id,party_type,tpt.name,tpm.mobile as consignee_mobile,tpm.name as consignee_name,tpm.id
                    ,IFNULL(tpm.vat_reg_no," ") vat_reg_no,IFNULL(tpm.tax_payer_no," ") tax_payer_no,IFNULL(tpm.code," ") code';
        $consignee_info = $this->db->select($select)
                        ->from("tb_order_parties  top")
                        ->join("tbl_party_types tpt", "top.party_type=tpt.id AND tpt.name LIKE '%Consig%'")
                        ->join("tbl_party_master tpm", "top.party_id=tpm.id")
                        ->where(array("order_id" => $order_id))->get()->row_array();
        // log_message("error","------3:56------".$this->db->last_query());
        return $consignee_info;
    }

}

?>