<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Knratemodel extends CI_Model {

    /* Rate Exchange */
    public function getrateexchange($wher, $whr,$con=null){
    	$response = array();
	    $this->db->select('re.*,c.name as cus_name,c.code as cid');
		$this->db->from('tb_rate_exchange re' );
		$this->db->join('tb_customers c', 're.customer_id = c.id', 'left');
        $this->db->where($wher);
        $this->db->like($whr);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get();
        if($query && $query->num_rows()>0){
			if($con==1){
	        	$response = $query->row_array();
			}else{
				$response = $query->result_array();
			}
		}
		return $response;
    }
    /* get currency  */
    public function getcurrency(){
    	$response = array();
		$this->db->select('currency');
		$this->db->distinct('currency');
        $this->db->from('tbl_country_master');
		$this->db->where('status',1);
		$this->db->order_by('currency', 'ASC');
        $query = $this->db->get();
        if($query->num_rows()>0){
			$response = $query->result_array();
		}
		return $response;
	}
	/* get last id  */
     public function getlastid($whr,$select,$table,$or_col){
     	$response = array();
		$this->db->select($select);
        $this->db->from($table);
		$this->db->where($whr);
		$this->db->order_by($or_col, 'DESC');
		$this->db->limit(1);
        $query = $this->db->get();
        if($query->num_rows()>0){
			$response = $query->row_array();
		}
		return $response;
	}
	
	/* Rate Service */
	 public function getservice($wher, $whr)
    {
    	$response = array();
        $this->db->select('rs.*,sm.name')->from('tb_rate_services rs');
        $this->db->join('tb_service_master sm', 'rs.service_type=sm.id', 'LEFT');
        $this->db->where($wher);
        $this->db->like($whr);
        $this->db->order_by('rs.id', 'DESC');
        $query = $this->db->get();
        if($query->num_rows()>0){
        	$response = $query->result_array();
        }
		return $response;
    }
	/* conversion factor list data */
	public function getConversionData($select,$where,$whr,$str=null)
    {
	    $result=array();
	    if($str != ""){
	    	$select .= ",'".$str."' as country_name";
	    }
        $this->db->select($select);
        $this->db->from('tb_knuom_conversion uo');
		$this->db->join('tb_customers cs', 'uo.customer_id=cs.id', 'LEFT');
		$this->db->join(' tb_vendors v', 'uo.carrier_id=v.id', 'LEFT');
		$this->db->where($where);
		$this->db->like($whr);
		$this->db->order_by('uo.id', 'DESC');
        $res= $this->db->get();
        if($res->num_rows()>0){
        	foreach($res->result_array() as $resp){
        		if(!isset($resp['country_name'])){
        			$cntryname = $this->db->select('country_name')->get_where("tbl_country_master",array("country_code"=>$resp['country']),1,0);
        			if($cntryname->num_rows()>0){ 
        				$resp['country_name'] = $cntryname->row()->country_name;
        			}else{
        				$resp['country_name'] = $resp['country'];
        			}
        		}
        		$result[] = $resp;
        	}
        }
		return $result;
    }
	/* get tbl_country_master table */
	 public function getcountry(){
		$result=array();
		$this->db->select('country_name,country_code');
        $this->db->from('tbl_country_master');
		$this->db->where('status',1);
		$this->db->order_by('country_name', 'ASC');
        $res = $this->db->get();
		if($res->num_rows()>0){
	     	$result = $res->result_array();
        }
	    return $result;
	}

	/* get tbl_country_master table */
	 public function getcountrybyname($whr){
		$result=array();
		$this->db->select('country_name,country_code');
        $this->db->from('tbl_country_master');
		$this->db->where($whr);
		$this->db->limit(1);
        $res = $this->db->get();
		if($res->num_rows()>0){
	     	$result = $res->row_array();
        }
	    return $result;
	}
	
}
