<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Nicplacemodel extends Common
{
  public function __construct()
  {
    parent::__construct();
  }

  public function getOrderDetails($order_id_pk): array
  {
    $select = "`o`.`id`, `o`.`order_id`,
    `o`.`pickup_datetime`, `o`.`pickup_endtime`, `o`.`shipment_id`,
    `o`.`delivery_datetime`,`o`.`drop_endtime`,
    `o`.`pickup_company` as `pickup`,`o`.`pickup_address1`,`o`.`pickup_address2`,  `o`.`pickup_city`, `o`.`pickup_country`, `o`.`pickup_pincode`,
    `o`.`delivery_company` as `delivery`, `o`.`delivery_address1`, `o`.`delivery_address2`,`o`.`delivery_city`, `o`.`delivery_country`, `o`.`delivery_pincode`,
    `o`.`company_code`, `o`.`branch_code`,
    `o`.`product`, `o`.`goods_value`, `o`.`currency`, `o`.`transport_mode`, `o`.`vehicle_type`,
    `o`.`quantity`, `o`.`customer_id`, `o`.`vendor_id`, `o`.`pickup_custid`, `o`.`pickup_partyid`,
    `o`.`drop_custid`, `o`.`drop_partyid`, `o`.`trip_sts`, `o`.`shift_id`, `o`.`trip_id`, `o`.`status`,
    `o`.`order_status`, `o`.`createdon`, `o`.`updatedon`, `o`.`shipmentid`,
    `o`.`consignee_id`, `o`.`shipper_id` as `o_shipper_id`,
    `d`.`order_type`, `d`.`shipper_id`, `d`.`service`, `d`.`delivery_term`, `d`.`incoterm`,
    `d`.`delivery_note`, `d`.`purchase_order`, `d`.`notify_party`, `d`.`lane_reference`,
    `d`.`distance`, `d`.`customs_required`, `d`.`high_cargo_value`, `d`.`valorance_insurance`,
    `d`.`temperature_control`, `d`.`department_code`, `d`.`docs_received_datetime`,
    `d`.`docs_sent_datetime`, `d`.`consignment_note`, `d`.`order_remarks`,
    `v`.`code` as `carrier_code`";

    $result = array();
    $this->db->select($select);
    $this->db->from('tb_orders o');
    $this->db->join('tb_order_details d', '`o`.`id`=`d`.`order_row_id`', 'INNER');
    $this->db->join('tb_vendors v', '`o`.`vendor_id` = `v`.`id`', 'INNER');
    $this->db->where(['o.id' => $order_id_pk]);
    $res = $this->db->get();
    if ($res && $res->num_rows() > 0) {
      $result = $res->row_array();
    }
    return $result;
  }

  public function orderNicplaceRef(int $order_id)
  {
    $sql = "select
                group_concat(ref_value) as ref_value,
                ref_belongs_to, group_concat(id) as ref_pk_id
            from `tb_order_references`
            where
                  `order_id` = $order_id
              and `reference_id` = 'ORD_NICPLACE_TOUR_ID'
              and (ref_belongs_to = 'truck' OR `ref_belongs_to` = 'trailer')
            group by ref_belongs_to";

    $query = $this->db->query($sql);
    if ($query->num_rows() > 0) {
      $result = $query->result_array();
    }

    return $result;
  }

  /*
     *  Purpose:    Based on shipment Id we will fetch order ids from tb_orders table.
     *  @param      shipmentid      int
     *  return      array
     */

  public function getOrderIds($shipment_id)
  {
    $orderids = array();
    $where = array("shift_id" => $shipment_id);
    $orderids = $this->gettbldata($where, "id, order_id, user_id", "tb_orders", 0, 0);
    return $orderids;
  }

  public function checkOrderTriggerOrNot($orderGenId, $userId)
  {
    $result = [];
    $sql = "select * from `tb_nic_tour`
            where
                  `trip_id` = $orderGenId
              and `user_id` = $userId
              and `tour_id` is not null
              and `request_unique_id` is not null
              and `http_status` between 200 and 299
              and `status` = 1";

    $query = $this->db->query($sql);
    if ($query->num_rows() > 0) {
      $result = $query->result_array();
    }

    return $result;
  }

  public function getIntermediateCheck($customerCode): array
  {
    $result = [];
    if ($customerCode) {
      $carrierExisted = $this->gettblrowdata(['code' => $customerCode, 'company_code' => 'PLKN', 'branch_code' => 'PLKTW'], '*', 'tb_vendors', 0, 0);
      if ($carrierExisted) {
        $intermediateStopsCarriers = [
          "KK_TRANS"  => [
            "ids"     => [1002053292, 1001413219, 1000512905],
            "address" => [
              "poi_name"                => $carrierExisted['name'],
              "poi_street"              => "Świętojańska 18/13",
              "poi_city"                => "Chełm",
              "poi_country"             => "PL",
              "poi_postal_code"         => "32-340",
            ] //"ul. Świętojańska 18 13, 32-340 Chełm"
          ],
          "KUS_TRANS" => [
            "ids"     => [1002053400, 1001747484],
            "address" => [
              "poi_name"                => $carrierExisted['name'],
              "poi_street"              => "Chełmska 137",
              "poi_city"                => "Gołaczewy",
              "poi_country"             => "PL",
              "poi_postal_code"         => "32-340",
            ] //"ul. Chełmska 137, 32-340 Gołaczewy"
          ],
          "NIKO" => [
            "ids"     => [1002083226, 1000525908],
            "address" => [
              "poi_name"        => $carrierExisted['name'],
              "poi_street"      => "Rzemieślnicza 23",
              "poi_city"        => "Będzin",
              "poi_country"     => "PL",
              "poi_postal_code" => "42-504",
            ] //"ul. Rzemieślnicza 23, 42-504 Będzin"
          ]
        ];
        $foundCarrier = [];
        foreach ($intermediateStopsCarriers as $carrierData) {
          if (in_array($customerCode, $carrierData['ids'])) {
            $carrierData['address']["poi_customer_identifier"] = $customerCode;
            $foundCarrier[$customerCode] = $carrierData['address'];
          }
        }
        if (!empty($foundCarrier)) {
          $result = $foundCarrier;
        }
      }
    }
    return $result;
  }

    public function checkAtromAlarm(int $carrierCode, string $companyCode, array $alarmExceptionCarrierRule): array
    {
        $sql = "SELECT * FROM `tb_vendors`WHERE `code` = ? AND `company_code` = ? AND (`name` LIKE ? OR `name` LIKE ? )";
        $query = $this->db->query($sql, [
            $carrierCode,
            $companyCode,
            sprintf('%s%%', $alarmExceptionCarrierRule[0]),
            sprintf('%s%%',$alarmExceptionCarrierRule[1]),
        ]);

        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
}

