<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class OptimizeTripOrdersModel extends CI_Model
{
    private const KG_CHARGEBASIS = ['KG','PER KG'];
    private const CBM_CHARGEBASIS = ['CBM','PER CBM'];
    private const PEICE_CHARGEBASIS = ['PIECE','PER PIECE'];
    private const TRIP_CHARGEBASIS = ['TRIP','PER TRIP'];
    private const KM_CHARGEBASIS = ['KM','PER KM'];
    private const MILES_CHARGEBASIS = ['MILE','PER MILE','MI','PER MI'];
    private const HOURS_CHARGEBASIS = ['HOURS','PER HOUR','HOUR','WAITING TIME(HRS)'];
    private const DAYS_CHARGEBASIS = ['DAYS','PER DAY','DAY'];
    private const MINUTES_CHARGEBASIS = ['MINUTES','PER MINUTE','MINUTE','MIN','MINS'];

    function __construct() {
        parent::__construct();
    }
    public function getOrdersLocation(array $orderIds): array
    {
        $query = $this->db->query("SELECT o.id, o.order_id, o.pickup_datetime, o.delivery_datetime, o.pickup_country, o.delivery_country, o.pickup_city, o.delivery_city, o.pickup_pincode, o.delivery_pincode, o.pickup_address2, o.delivery_address2, o.transport_mode, o.plat, o.plng, o.dlat, o.dlng, d.service FROM tb_orders o INNER JOIN tb_order_details d ON d.order_row_id = o.id WHERE o.id IN ? AND d.status = ? AND o.shift_id = ? AND o.status > ?",[$orderIds, 1, 0, 0]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if(empty($queryResult)){
            return [];
        }
        $getOrderAddons = $this->db->query("SELECT order_id,vas_id,quantity FROM tb_order_vas WHERE order_id IN ? AND status = ?",[$orderIds, 1]);
        foreach(($getOrderAddons->num_rows() > 0 ? $getOrderAddons->result_array() : []) as $eachLine){
            $allOrderAddons[$eachLine['order_id']][] = ['vasId'=>$eachLine['vas_id'],'quantity'=>$eachLine['quantity']]; 
        }
        foreach($queryResult as $eachRow){
            $orderAddons = $allOrderAddons[$eachRow['id']] ?? [];
            $fromDate = $eachRow['pickup_datetime'];
            $toDate = $eachRow['delivery_datetime'];
            $timeDiff = $this->calculateDaysBetweenTwoDates(['fromDate'=>$fromDate, 'toDate'=>$toDate]);
            $ordersLocation[$eachRow['id']] = ['fromPincode'=>$eachRow['pickup_pincode'],'fromCity'=>$eachRow['pickup_city'],'fromProvince'=>$eachRow['pickup_address2'],'fromCountry'=>$eachRow['pickup_country'],'transportMode'=>$eachRow['transport_mode'],'fromLat'=>$eachRow['plat'],'fromLng'=>$eachRow['plng'],'toPincode'=>$eachRow['delivery_pincode'],'toCity'=>$eachRow['delivery_city'],'toProvince'=>$eachRow['delivery_address2'],'toCountry'=>$eachRow['delivery_country'],'toLat'=>$eachRow['dlat'],'toLng'=>$eachRow['dlng'],'serviceRowId'=>$eachRow['service'], 'orderAddons'=>$orderAddons, 'fromDate'=>$fromDate,'toDate'=>$toDate,'timeDiff'=>$timeDiff];
        }
        return $ordersLocation;
    }

    private function calculateDaysBetweenTwoDates(array $data): float
    {
        $fromDate = new DateTime($data['fromDate']);
        $toDate = new DateTime($data['toDate']);
        $secondsDiff = $toDate->getTimestamp() - $fromDate->getTimestamp();
        return $secondsDiff / 86400; 
    }

    public function getOrderTotalDimensions(array $orderIds): array
    {
        if(empty($orderIds)){
            return [];
        }
        $query = $this->db->query("SELECT order_id, SUM(weight) as totalWeight, SUM(second_weight) as totalSecondWeight, SUM(volume) as totalVolume, SUM(second_volume) as totalSecondVolume, SUM(quantity) as totalQuantity FROM tb_order_cargodetails WHERE order_id IN ? AND status = ?",[$orderIds,1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachOrder){
            $cargos[$eachOrder['order_id']] = ['totalWeight'=>$eachOrder['totalWeight'],'totalVolume'=>$eachOrder['totalVolume'],'totalQuantity'=>$eachOrder['totalQuantity'],'totalSecondWeight'=>$eachOrder['totalSecondWeight'],'totalSecondVolume'=>$eachLine['totalSecondVolume']];
        }
        return $cargos;
    }

    public function getVendorIdsFromVendorProfile(int $profileId, int $vendorId): array
    {
        $vendorIds = [];
        if($profileId == 0){
            return [];
        }
        $this->db->select('v.id,v.name,v.code');
        $this->db->from( 'tb_vendors v' );
        $this->db->join( 'tb_vendor_profile_list vpl', 'vpl.profile_id = v.code', 'inner' );
        $this->db->where( 'vpl.vp_id', $profileId );
        if($vendorId > 0){
            $this->db->where('vpl.party_id',$vendorId);
        }
        $this->db->where("vpl.status ='1'");
        $this->db->group_by("vpl.id");
        $query = $this->db->get();
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachRow){
            $vendorIds[] = ['rowId'=>$eachRow['id'],'name'=>$eachRow['name'],'code'=>$eachRow['code']];
        }
        return $vendorIds;
    }
    
    public function getCustomerIdsFromCustomerProfile(int $profileId): array
    {
        $vendorIds = [];
        if($profileId == 0){
            return [];
        }
        $this->db->select('c.id,c.name,c.code');
        $this->db->from( 'tb_customers c' );
        $this->db->join( 'tb_customer_profile_list cpl', 'cpl.profile_id = c.code', 'inner' );
        $this->db->where( 'cpl.cp_id', $profileId );
        $this->db->where("cpl.status ='1'");
        $this->db->group_by("cpl.id");
        $query = $this->db->get();
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachRow){
            $vendorIds[] = ['rowId'=>$eachRow['id'],'name'=>$eachRow['name'],'code'=>$eachRow['code']];
        }
        return $vendorIds;
    }

    public function getVehicleIdsFromVehicleProfile(int $profileId): array
      {
        $vehicleTypes = [];
        if($profileId == 0){
            return [];
        }
        $this->db->select('tt.id,tt.trucktype');
        $this->db->from( 'tb_trucktypes tt' );
        $this->db->join( 'tb_vehicle_profile_list vpl', 'vpl.profile_id=tt.id', 'inner' );
        $this->db->where( 'vpl.veh_p_id', $profileId );
        $this->db->where("vpl.status ='1'");
        $this->db->group_by("vpl.id");
        $query = $this->db->get();
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if(empty($queryResult)){
            return [];
        } 
        foreach($queryResult as $eachRow){
            $vehicleTypes[] = ['rowId'=>$eachRow['id'],'truckType'=>$eachRow['trucktype']];
        }
        
        return $vehicleTypes;
    }
    public function getConversionFactorRateForOptimizeResult(array $offeringAndRecordsData, array $existingOfferingIdsWithConversion, array $oldRateOfferingData, array $data): array
    {
        if(empty($offeringAndRecordsData)){
            log_message("error","no conversion factor");
            return [];
        }
        $cargos = $data['cargos'];
        $geoTierPairs = $data['geoTierPairs'];
        $uomConversionId = $offeringAndRecordsData['uomConversionId'];
        $rateRecordRowId = $offeringAndRecordsData['rateRecordRowId'];
        $rateOfferingRowId = $offeringAndRecordsData['offeringRowId'];
        $query = $this->db->select("id, uom_type1, uom_type2, uom_type3, uom_type4, uom1, uom2, uom3, uom4,
        uom1_conversion, uom2_conversion, uom3_conversion, uom4_conversion, base_uom");
        $this->db->from("tb_knuom_conversion");
        $this->db->where("id = '".$uomConversionId."' AND status  = '1'");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $queryResult = $query->row_array();
            $cargoWeight = $cargos['cargoWeight'];
            $cargoSecondWeight = $cargos['cargoSecondWeight'];
            $cargoVolume = $cargos['cargoVolume'];
            $cargoSecondVolume = $cargos['cargoSecondVolume'];
            $cargoQuantity = $cargos['cargoQuantity']; 
            $conversionFactorWeight = $this->getConversionFactorForWeight($queryResult) ?? 0;
            $conversionFactorSecondWeight = $this->getConversionFactorForSecondWeight($queryResult) ?? 0;
            $conversionFactorVolume = $this->getConversionFactorForVolume($queryResult) ?? 0;
            $conversionFactorSecondVolume = $this->getConversionFactorForSecondVolume($queryResult) ?? 0;
            $weight = $cargoWeight * $conversionFactorWeight;
            $volume = $cargoVolume * $conversionFactorVolume;
            $cargoSecondWeight = $cargoSecondWeight * $conversionFactorSecondWeight;
            $cargoSecondVolume = $cargoSecondVolume * $conversionFactorSecondVolume;
            $data['unitToBeConsidered'] = max($weight, $volume, $cargoSecondWeight, $cargoSecondVolume);
            $data['conversionBaseUom'] = $queryResult['base_uom'];
            $data['cargoWeight'] = $weight;
            $data['cargoVolume'] = $volume;
            $data['cargoSecondWeight'] = $cargoSecondWeight;
            $data['cargoSecondVolume'] = $cargoSecondVolume;
            $data['cargoQuantity'] = $cargoQuantity;
            $data['GEOPROVINCE'] = $geoTierPairs['PROVINCE'];
            $data['GEOPOSTAL CODE'] = $geoTierPairs['POSTAL CODE'];
            $data['GEOCITY'] = $geoTierPairs['CITY'];
            $data['GEOCOUNTRY'] = $geoTierPairs['COUNTRY'];
            $data['rateOfferingId'] = $rateOfferingRowId;
            $data['rateRecordId'] = $rateRecordRowId;
            $allTablesConditions = $this->generateUnitsAndValuesToDynamicMultiArrayForAllTables($data);
            $data['allTablesConditions'] = $allTablesConditions;
            if(!in_array($rateOfferingRowId,$existingOfferingIdsWithConversion)){
                $rateOfferingData = $this->getRateOfferingPriceByConversionFactor($data);
                if(!empty($rateOfferingData)){
                   $rateOfferingPrice[$rateOfferingData['rateOfferingId']] = $rateOfferingData['totalOfferingAmount'];
                }
            }
            $rateRecordChargesData = $this->getRateRecordChargesPriceByConversionFactor($data);
            $rateRecordServicesData = $this->getRateRecordServicesPriceByConversionFactor($data);
            $fuelSurchargeData = $this->getRateRecordFuelSurchargePriceByConversionFactor($data);
            if(!empty($rateRecordChargesData)){
                $rateRecordServicePrice = $rateRecordServicesData['totalRecordServiceAmount'] ?? 0;
                $rateRecordChargesPrice = $rateRecordChargesData['totalChargeAmount'] ?? 0;
                $rateRecordPrice[$rateRecordChargesData['rateRecordId']] = $rateRecordChargesPrice + $rateRecordServicePrice;
                if(!empty($fuelSurchargeData)){
                    $fuelSurchargePrice[$rateRecordChargesData['rateRecordId']] = ['rateRecordId'=>$fuelSurchargeData['rateRecordId'],'totalFRTCharge'=>$fuelSurchargeData['totalFRTCharge'],'percentage'=>$fuelSurchargeData['percentage'],'fuelSurchargeFlatAmount'=>$fuelSurchargeData['fuelSurchargeFlatAmount'],'fuelSurchargePercentageAmount'=>$fuelSurchargeData['fuelSurchargePercentageAmount']];
                }
            }
        }
        return ['rateOfferingPriceWithConversion'=> $rateOfferingPrice ?? [],'rateRecordPriceWithConversion'=> $rateRecordPrice ?? [],'fuelSurchargePriceWithConversion'=> $fuelSurchargePrice ?? [], 'oldRateOfferingData'=>$oldRateOfferingData ?? []];
    }

    public function getConversionFactorForWeight(array $data)
    {
        if (in_array($data['uom_type1'], ['ACTUAL WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], ['ACTUAL WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], ['ACTUAL WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], ['ACTUAL WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_weight'] ?? 1;
    }

    public function getConversionFactorForSecondWeight(array $data)
    {
        if (in_array($data['uom_type1'], ['WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], ['WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], ['WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], ['WEIGHT'], true)) {
            $data['conversion_factor_weight'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_weight'] ?? 1;
    }

    public function getConversionFactorForVolume(array $data)
    {
        if (in_array($data['uom_type1'], ['ACTUAL VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], ['ACTUAL VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], ['ACTUAL VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], ['ACTUAL VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_volume'] ?? 1;
    }

    public function getConversionFactorForSecondVolume(array $data)
    {
        if (in_array($data['uom_type1'], ['VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], ['VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], ['VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], ['VOLUME'], true)) {
            $data['conversion_factor_volume'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_volume'] ?? 1;
    }

    public function getChargesFromRates(array $data): array
    {
        $offeringType = $this->db->escape($data['offeringType']);
        $tariffType = $this->db->escape($data['tariffType']);
        $serviceType = $this->db->escape($data['serviceType']);
        $companyCode = $this->db->escape($data['companyCode']);
        $branchCode = $this->db->escape($data['branchCode']);
        $carrierId = $data['carrierId'];
        $geoPairs = $data['geoPairs'];
        $geoTierPairs = $data['geoTierPairs'];
        $ratePreferencesData = $data['ratePreferencesData'];     
        $geoPairsGsheet = $geoPairs['geoCondition'];
        $geoPairsLaneMaster = $geoPairs['lanesCondition'];
        $orderTimeDiff = $data['orderTimeDiff'];
        if($carrierId > 0 ){
            $sql = "SELECT rs.id as rateServiceRowId, rs.service_id as serviceId, rs.service_name as serviceName, lm.id as laneMasterId,rsl.rs_lane_days as serviceDays, ro.id as offeringRowId, ro.offering_id as offeringId, ro.offering_name as offeringName, ro.uom_conversion_id as uomConversionId, ro.veh_profile_id as vehicleProfileId, ro.cust_profile_id as customerProfileId, ro.vendor_profile_id as vendorProfileId, rr.id as rateRecordRowId, rr.rate_id as rateRecordId,rr.record_name as rateRecordName
                    FROM tb_lanes_master lm
                    INNER JOIN  tb_rateservice_lanes rsl  ON lm.id = rsl.lane_id
                    INNER JOIN  tb_rate_services rs  ON rsl.rate_id = rs.id
                    INNER JOIN  tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id
                    INNER JOIN tb_vendor_profile_list vpl ON vpl.vp_id = ro.vendor_profile_id
                    INNER JOIN  tb_rate_records rr ON rr.offering_id = ro.id 
                    WHERE ( ".$geoPairsLaneMaster.") AND ro.tarrif_type =".$tariffType." AND ro.offering_active=1 AND ro.offering_type=".$offeringType." AND rs.service_type = ".$serviceType." AND vpl.party_id = ".$carrierId." AND vpl.status = '1' AND rr.company_code = ".$companyCode." AND rr.branch_code=".$branchCode." AND rs.status = 1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1 GROUP BY rateRecordRowId";
        }else{
            $sql = "SELECT rs.id as rateServiceRowId, rs.service_id as serviceId, rs.service_name as serviceName, lm.id as laneMasterId,rsl.rs_lane_days as serviceDays, ro.id as offeringRowId, ro.offering_id as offeringId, ro.offering_name as offeringName, ro.uom_conversion_id as uomConversionId, ro.veh_profile_id as vehicleProfileId, ro.cust_profile_id as customerProfileId, ro.vendor_profile_id as vendorProfileId, rr.id as rateRecordRowId, rr.rate_id as rateRecordId,rr.record_name as rateRecordName
                    FROM tb_lanes_master lm
                    INNER JOIN  tb_rateservice_lanes rsl  ON lm.id = rsl.lane_id
                    INNER JOIN  tb_rate_services rs  ON rsl.rate_id = rs.id
                    INNER JOIN  tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id
                    INNER JOIN  tb_rate_records rr ON rr.offering_id = ro.id 
                    WHERE ( ".$geoPairsLaneMaster.") AND ro.tarrif_type =".$tariffType." AND ro.offering_active=1 AND ro.offering_type=".$offeringType." AND rs.service_type = ".$serviceType." AND rr.company_code = ".$companyCode." AND rr.branch_code=".$branchCode." AND rs.status = 1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1 GROUP BY rateRecordRowId";
        }
        $query = $this->db->query($sql);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        $existingOfferingIdsWithConversion = $oldRateOfferingData = [];
        foreach($queryResult as $eachRow){
            $ratesData[] = $eachRow;
            if($eachRow['uomConversionId'] > 0 ){
                $ChargesWithConversion[$eachRow['offeringRowId']."_".$eachRow['rateRecordRowId']] = $this->getConversionFactorRateForOptimizeResult(['offeringRowId'=>$eachRow['offeringRowId'],'rateRecordRowId'=>$eachRow['rateRecordRowId'],'uomConversionId'=>$eachRow['uomConversionId']],$existingOfferingIdsWithConversion ?? [], $oldRateOfferingData, $data);
                if(!in_array($eachRow['offeringRowId'],$existingOfferingIdsWithConversion)){
                    $existingOfferingIdsWithConversion[] = $eachRow['offeringRowId'];
                    $conversionAmount = $ChargesWithConversion[$eachRow['offeringRowId']."_".$eachRow['rateRecordRowId']] ?? [];
                    $totalOfferingAmountWithConversion = $conversionAmount['rateOfferingPriceWithConversion'] ?? 0;
                    $oldRateOfferingData[$eachRow['offeringRowId']] = $totalOfferingAmountWithConversion[$eachRow['offeringRowId']];
                }
            }else{
                $allTablesConditions = $this->generateUnitsAndValuesToDynamicMultiArrayForAllTables($data);
                $data['allTablesConditions'] = $allTablesConditions;
                $rateRecordIdsWithoutConversion[] = $eachRow['rateRecordRowId'];
                $rateOfferingIdsWithoutConversion[] = $eachRow['offeringRowId'];
            }
        }
        if(empty($ratesData ?? [])){
            return [];
        }
        if(!empty($rateRecordIdsWithoutConversion ?? [])){
            $recordCharges = $this->calculateRateRecordCharges(array_unique($rateRecordIdsWithoutConversion),$data);
            $recordServices = $this->calculateRateRecordServices(array_unique($rateRecordIdsWithoutConversion),$data);
            $fuelSurcharges = $this->calculateFuelSurchargeAmount(array_unique($rateRecordIdsWithoutConversion),$data);
        }
        if(!empty($rateOfferingIdsWithoutConversion ?? [])){
            $offeringCharges = $this->calculateRateOfferingServices(array_unique($rateOfferingIdsWithoutConversion),$data);
            
        }
        foreach($ratesData as $eachLine){
            $recordRowId = $eachLine['rateRecordRowId'];
            $offeringRowId = $eachLine['offeringRowId']; 
            $rateServiceRowId = $eachLine['rateServiceRowId']; 
            $conversionAmount = $ChargesWithConversion[$offeringRowId."_".$recordRowId] ?? [];
            $serviceDays = $eachLine['serviceDays'];
            $clockIconFlag = 0;
            if($orderTimeDiff <= $serviceDays){
                $clockIconFlag = 1;
            }
           $fuelSurchargeFlatAmount = $fuelSurchargePercentageAmount = 0;
            if(!empty($conversionAmount)){
                $totalOfferingAmountWithConversion = $conversionAmount['rateOfferingPriceWithConversion'] ?? 0;                
                if((empty($totalOfferingAmountWithConversion) && !empty($oldRateOfferingData ?? []))){
                    $totalOfferingAmountWithConversion[$offeringRowId] = $oldRateOfferingData[$offeringRowId] ?? 0;
                }
                $totalRecordAmountWithConversion = $conversionAmount['rateRecordPriceWithConversion'] ?? 0;
                $totalFuelSurchageWithConversion = $conversionAmount['fuelSurchargePriceWithConversion'] ?? [];
                $totalAmountWithoutFuelSurcharge = ($totalOfferingAmountWithConversion[$offeringRowId] ?? 0) + ($totalRecordAmountWithConversion[$recordRowId] ?? 0);
                $fuelSurchargeData = $totalFuelSurchageWithConversion[$recordRowId] ?? [];
                $fuelSurchargeFlatAmount = $fuelSurchargeData['fuelSurchargeFlatAmount'] ?? 0;
                $fuelSurchargepercentage = $fuelSurchargeData['percentage'] ?? 0;
                $fuelSurchargePercentageAmount = $fuelSurchargeData['fuelSurchargePercentageAmount'] ?? 0;
            }else{
                $totalOfferingAmountWithoutConversion = $offeringCharges[$offeringRowId] ?? 0;
                $totalRecordChargesAmountWithoutConversion = $recordCharges[$recordRowId] ?? 0;
                $totalRecordServicesAmountWithoutConversion = $recordServices[$recordRowId] ?? 0;
                $totalRecordAmountWithoutConversion = $totalRecordChargesAmountWithoutConversion + $totalRecordServicesAmountWithoutConversion;
                $totalAmountWithoutFuelSurcharge = $totalOfferingAmountWithoutConversion + $totalRecordAmountWithoutConversion;
                $fuelSurchargeData = $fuelSurcharges[$recordRowId] ?? [];
                $fuelSurchargeFlatAmount = $fuelSurchargeData['fuelSurchargeFlatAmount'] ?? 0;
                $fuelSurchargepercentage = $fuelSurchargeData['percentage'] ?? 0;
                $fuelSurchargePercentageAmount = $fuelSurchargeData['fuelSurchargePercentageAmount'] ?? 0;
            }
            $totalAmount = $totalAmountWithoutFuelSurcharge 
             + ($fuelSurchargePercentageAmount > 0 ? $fuelSurchargePercentageAmount 
             : ($fuelSurchargeFlatAmount > 0 ? $fuelSurchargeFlatAmount : 0));
            $finalResult[] = ['totalPrice'=>$totalAmount,'vehicleProfileId'=>$eachLine['vehicleProfileId'],'vendorProfileId'=>$eachLine['vendorProfileId'],'rateServiceId'=>$eachLine['serviceId'],'rateOfferingId'=>$eachLine['offeringId'],'rateRecordId'=>$eachLine['rateRecordId'], 'customerProfileId'=>$eachLine['customerProfileId'], 'recordRowId'=>$recordRowId, 'offeringRowId'=>$offeringRowId, 'clockIconFlag'=>$clockIconFlag, 'fuelSurchargepercentage'=>$fuelSurchargepercentage, 'fuelSurchargePercentageAmount'=>$fuelSurchargePercentageAmount, 'fuelSurchargeFlatAmount'=>$fuelSurchargeFlatAmount, 'uomConversionId'=>$eachLine['uomConversionId'], 'rateServiceRowId'=>$rateServiceRowId];
        }
    
        return $finalResult ?? [];
    }

    private function calculateRateOfferingServices(array $rateOfferingIds, array $data): array
    {
        
        $allTablesConditions = $data['allTablesConditions'];
        $offeringServiceConditions= $allTablesConditions['offeringServiceConditions'];
        $query = $this->db->query("SELECT ros.rateoffering_id as rateOfferingId,
                      SUM( 
                        CASE
                            {$offeringServiceConditions}
                        END
                    ) AS totalOfferingAmount 
            FROM tb_rateoffering_services ros where ros.rateoffering_id IN (" . implode(',', $rateOfferingIds) . " ) AND ros.status = 1 GROUP BY rateOfferingId");
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : []; 
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachLine){
            $offeringCharges[$eachLine['rateOfferingId']] = $eachLine['totalOfferingAmount'];
        }
        return $offeringCharges;
    }

    private function calculateRateRecordServices(array $rateRecordIds, array $data)
    {
        $orderVasData = $data['orderAddons'] ?? [];
        if(empty($orderVasData)){
            return [];
        }
        foreach($orderVasData as $eachLine){
            $orderVasIds[] = $eachLine['vasId'];
        }
        $orderVasDataJson = json_encode($orderVasData);
        $allTablesConditions = $data['allTablesConditions'];
        $rateServiceConditions = $allTablesConditions['rateServiceConditions'];
        $query = $this->db->query("
                WITH orderVasData AS (
                    SELECT vasTable.vasId, vasTable.quantity
                    FROM JSON_TABLE(
                        '$orderVasDataJson',
                        '$[*]' COLUMNS (
                            vasId INT PATH '$.vasId',
                            quantity DECIMAL(10,2) PATH '$.quantity'
                        )
                    ) vasTable
                )
                SELECT 
                    rrs.raterecord_id AS rateRecordId, 
                    SUM( 
                        CASE
                            {$rateServiceConditions}
                            WHEN rrs.charge_basis IN ('" . implode("','", self::TRIP_CHARGEBASIS) . "')
                                THEN GREATEST(v.quantity * rrs.amount, rrs.min_amount) 
                        END
                    ) AS totalRecordServiceAmount
                FROM tb_raterecord_services rrs
                JOIN orderVasData v 
                    ON v.vasId = rrs.raterecord_vas_id
                WHERE rrs.raterecord_id IN (" . implode(',', $rateRecordIds) . " ) 
                AND rrs.raterecord_vas_id IN (" . implode(',', $orderVasIds) . " ) 
                AND rrs.status = 1
                GROUP BY rrs.raterecord_id");
        if($query->num_rows() == 0){
            return [];
        }
        foreach(($query->result_array()) as $eachLine){
            $rateRecordServices[$eachLine['rateRecordId']] = $eachLine['totalRecordServiceAmount'];
        }
        return $rateRecordServices;
    }

    private function calculateRateRecordCharges(array $rateRecordIds, array $data): array
    {
        
        $geoPairs = $data['geoPairs'];
        $geoTierPairs = $data['geoTierPairs'];
        $geoPairsGsheet = $geoPairs['geoCondition']; 
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $query = $this->db->query("SELECT rc.raterecord_id as rateRecordId,
                    SUM(
                        CASE 
                            WHEN rc.rr_charge_type = 'FIXED' THEN
                                CASE
                                    {$rateChargeConditions}
                                END
                            WHEN rc.rr_charge_type = 'TIER' 
                                AND tsheet.id IS NOT NULL THEN
                                CASE 
                                    {$rateTierConditionsOne}
                                END
                            WHEN rc.rr_charge_type = 'Geo Tier' 
                            AND gtier.id IS NOT NULL 
                            AND gsheet.id IS NOT NULL
                            THEN
                                CASE
                                    {$geoTierConditions}
                                END
                            END
                    ) AS totalChargeAmount 
                    FROM tb_raterecord_charges rc 
                    LEFT JOIN tb_tier_master tier 
                        ON tier.id = rc.rr_tier_id AND tier.status = 1
                    LEFT JOIN tb_tier_rate_sheet tsheet 
                        ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                    LEFT JOIN tb_geo_tier gtier 
                        ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                    LEFT JOIN tb_geo_tier_sheet gsheet 
                        ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                        (
                            ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$geoTierPairs['PROVINCE']." )
                            OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$geoTierPairs['POSTAL CODE']." )
                            OR ( gtier.geo_hierarchy ='CITY' AND ".$geoTierPairs['CITY']." )
                            OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$geoTierPairs['COUNTRY']." ) )  OR
                            ( ".$geoPairsGsheet." ) 
                        )
                    where rc.raterecord_id IN (" . implode(',', $rateRecordIds) . " ) AND rc.status = 1 GROUP BY raterecord_id");
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : []; 
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachLine){
            $recordCharges[$eachLine['rateRecordId']] = $eachLine['totalChargeAmount'];
        }
        return $recordCharges;
    }

    private function calculateFuelSurchargeAmount(array $rateRecordIds, array $data): array
    {
        $orderVasData = $data['orderAddons'] ?? [];
        if(empty($orderVasData)){
            return $this->calculateFuelSurchargeAmountForRRChargesOnly($rateRecordIds, $data);
        }
        foreach($orderVasData as $eachLine){
            $orderVasIds[] = $eachLine['vasId'];
        }
        $currentDate = date('Y-m-d');
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateServiceConditions= $allTablesConditions['rateServiceConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $geoPairs = $data['geoPairs'];
        $geoTierPairs = $data['geoTierPairs'];
        $geoPairsGsheet = $geoPairs['geoCondition'];
        
        $orderVasDataJson = json_encode($orderVasData);
        $query = $this->db->query("
                            WITH orderVasData AS (
                            SELECT vasTable.vasId, vasTable.quantity
                            FROM JSON_TABLE(
                                '$orderVasDataJson',
                                '$[*]' COLUMNS (
                                    vasId INT PATH '$.vasId',
                                    quantity DECIMAL(10,2) PATH '$.quantity'
                                )
                            ) vasTable
                        ),
                        vasCharges AS (
                            SELECT 
                                rrs.raterecord_id AS rateRecordId, 
                                SUM(
                                    CASE
                                        {$rateServiceConditions}
                                        WHEN rrs.charge_basis IN ('" . implode("','", self::TRIP_CHARGEBASIS) . "')
                                            THEN GREATEST(v.quantity * rrs.amount, rrs.min_amount) 
                                    END
                                ) AS totalVASCharge
                            FROM tb_raterecord_services rrs
                            JOIN orderVasData v 
                                ON v.vasId = rrs.raterecord_vas_id
                            WHERE rrs.raterecord_id IN (" . implode(',', $rateRecordIds) . " )  
                            AND rrs.raterecord_charge_id = 39
                            AND rrs.status = 1
                            GROUP BY rrs.raterecord_id
                        ),
                        totalFRTCharges AS (
                            SELECT 
                                rc.raterecord_id as rateRecordId,
                                SUM(
                                    CASE 
                                        WHEN rc.rr_charge_type = 'FIXED' THEN
                                            CASE
                                                {$rateChargeConditions}
                                            END
                                        WHEN rc.rr_charge_type = 'TIER'
                                            AND tsheet.id IS NOT NULL THEN
                                            CASE 
                                                {$rateTierConditionsOne}
                                            END
                                    WHEN rc.rr_charge_type = 'Geo Tier' 
                                    AND gtier.id IS NOT NULL 
                                    AND gsheet.id IS NOT NULL
                                    THEN
                                        CASE
                                            {$geoTierConditions}
                                        END
                                    END
                                ) AS totalFRTCharge
                            FROM tb_raterecord_charges rc
                            LEFT JOIN tb_tier_master tier 
                                ON tier.id = rc.rr_tier_id AND tier.status = 1
                            LEFT JOIN tb_tier_rate_sheet tsheet 
                                ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                            LEFT JOIN tb_geo_tier gtier 
                                ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                            LEFT JOIN tb_geo_tier_sheet gsheet 
                                ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                                (
                                    ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$geoTierPairs['PROVINCE']." )
                                    OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$geoTierPairs['POSTAL CODE']." )
                                    OR ( gtier.geo_hierarchy ='CITY' AND ".$geoTierPairs['CITY']." )
                                    OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$geoTierPairs['COUNTRY']." ) )  OR
                                    ( ".$geoPairsGsheet." ) 
                                )
                            WHERE rc.rr_charge_id = 39 
                            AND rc.status = 1
                            AND rc.raterecord_id IN (" . implode(',', $rateRecordIds) . " ) 
                            GROUP BY rc.raterecord_id
                        ),
                        combinedCharges AS (
                            SELECT 
                                f.rateRecordId,
                                f.totalFRTCharge,
                                COALESCE(v.totalVASCharge,0) AS totalVASCharge,
                                (f.totalFRTCharge + COALESCE(v.totalVASCharge,0)) AS totalCombinedCharge
                            FROM totalFRTCharges f
                            LEFT JOIN vasCharges v 
                                ON v.rateRecordId = f.rateRecordId
                            UNION
                            SELECT 
                                v.rateRecordId,
                                COALESCE(f.totalFRTCharge,0),
                                v.totalVASCharge,
                                (COALESCE(f.totalFRTCharge,0) + v.totalVASCharge)
                            FROM vasCharges v
                            LEFT JOIN totalFRTCharges f 
                                ON v.rateRecordId = f.rateRecordId
                        )
                        SELECT 
                            c.rateRecordId,
                            c.totalFRTCharge,
                            c.totalVASCharge,
                            c.totalCombinedCharge,
                            fsheet.percentage,
                            fsheet.amount AS fuelSurchargeFlatAmount,
                            CASE 
                                WHEN fsheet.percentage IS NOT NULL 
                                    THEN (c.totalCombinedCharge * fsheet.percentage / 100.0)
                                WHEN fsheet.amount IS NOT NULL 
                                    THEN fsheet.amount
                                ELSE 0
                            END AS fuelSurchargePercentageAmount,
                            (c.totalCombinedCharge +
                                CASE 
                                    WHEN fsheet.percentage IS NOT NULL 
                                        THEN (c.totalCombinedCharge * fsheet.percentage / 100.0)
                                    WHEN fsheet.amount IS NOT NULL 
                                        THEN fsheet.amount
                                    ELSE 0
                                END
                            ) AS finalTotalAmount
                        FROM combinedCharges c
                        INNER JOIN tb_raterecord_charges rc 
                            ON rc.raterecord_id = c.rateRecordId 
                        AND rc.fuel_surcharge_id > 0
                        AND rc.status = 1
                        AND rc.raterecord_id IN (" . implode(',', $rateRecordIds) . " )
                        INNER JOIN tb_fuel_surcharge_sheet fsheet 
                            ON fsheet.fuel_surcharge_id = rc.fuel_surcharge_id
                        AND fsheet.status = 1
                        AND fsheet.from_date <= CURDATE()
                        AND fsheet.to_date   >= CURDATE()
                        GROUP BY c.rateRecordId, c.totalFRTCharge, c.totalVASCharge, c.totalCombinedCharge,
                                fsheet.percentage, fsheet.amount");
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : []; 
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachLine){
            $fuelSurcharges[$eachLine['rateRecordId']] = ['totalFRTCharge'=>$eachLine['totalCombinedCharge'],'percentage'=>$eachLine['percentage'],'fuelSurchargeFlatAmount'=>$eachLine['fuelSurchargeFlatAmount'],'fuelSurchargePercentageAmount'=>$eachLine['fuelSurchargePercentageAmount']];
        }
        return $fuelSurcharges ?? [];
    }

    private function calculateFuelSurchargeAmountForRRChargesOnly(array $rateRecordIds, array $data): array
    {
        $currentDate = date('Y-m-d');
        $geoPairs = $data['geoPairs'];
        $geoTierPairs = $data['geoTierPairs'];
        $geoPairsGsheet = $geoPairs['geoCondition']; 
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $query = $this->db->query("WITH totalFRTCharges AS (
                SELECT 
                    rc.raterecord_id as rateRecordId,
                    SUM(
                        CASE 
                            WHEN rc.rr_charge_type = 'FIXED' THEN
                                CASE
                                    {$rateChargeConditions}
                                END
                            WHEN rc.rr_charge_type = 'TIER'
                                AND tsheet.id IS NOT NULL THEN
                                CASE 
                                    {$rateTierConditionsOne}
                                END
                            WHEN rc.rr_charge_type = 'Geo Tier' 
                            AND gtier.id IS NOT NULL 
                            AND gsheet.id IS NOT NULL
                            THEN
                                CASE
                                    {$geoTierConditions}
                                END
                        END
                    ) AS totalFRTCharge
                FROM tb_raterecord_charges rc
                LEFT JOIN tb_tier_master tier 
                    ON tier.id = rc.rr_tier_id AND tier.status = 1
                LEFT JOIN tb_tier_rate_sheet tsheet 
                    ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                LEFT JOIN tb_geo_tier gtier 
                    ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                LEFT JOIN tb_geo_tier_sheet gsheet 
                    ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                        (
                            ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$geoTierPairs['PROVINCE']." )
                            OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$geoTierPairs['POSTAL CODE']." )
                            OR ( gtier.geo_hierarchy ='CITY' AND ".$geoTierPairs['CITY']." )
                            OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$geoTierPairs['COUNTRY']." ) )  OR
                            ( ".$geoPairsGsheet." ) 
                        )
                WHERE rc.rr_charge_id = 39 
                AND rc.status = 1
                GROUP BY rateRecordId
            )
            SELECT 
                table1.rateRecordId,
                table1.totalFRTCharge,
                fsheet.percentage,
                fsheet.amount AS fuelSurchargeFlatAmount,
                CASE 
                    WHEN fsheet.percentage IS NOT NULL 
                        THEN (table1.totalFRTCharge * fsheet.percentage / 100.0)
                    WHEN fsheet.amount IS NOT NULL 
                        THEN fsheet.amount
                    ELSE 0
                END AS fuelSurchargePercentageAmount
            FROM totalFRTCharges table1
            INNER JOIN tb_raterecord_charges rc 
                ON rc.raterecord_id = table1.rateRecordId 
                AND rc.charge_basis = 'FRT'
            INNER JOIN tb_fuel_surcharge_sheet fsheet 
                ON fsheet.fuel_surcharge_id = rc.fuel_surcharge_id
                WHERE rc.raterecord_id IN (" . implode(',', $rateRecordIds) . " ) AND fsheet.status = 1
                AND fsheet.from_date <= '".$currentDate."'
                AND fsheet.to_date   >= '".$currentDate."' AND rc.status  = 1;
        ");
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : []; 
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachLine){
            $fuelSurcharges[$eachLine['rateRecordId']] = ['totalFRTCharge'=>$eachLine['totalFRTCharge'],'percentage'=>$eachLine['percentage'],'fuelSurchargeFlatAmount'=>$eachLine['fuelSurchargeFlatAmount'],'fuelSurchargePercentageAmount'=>$eachLine['fuelSurchargePercentageAmount']];
        }
        return $fuelSurcharges ?? [];
    }

    private function getRateOfferingPriceByConversionFactor(array $data): array
    {
        
        $rateOfferingId = $data['rateOfferingId'];
        $allTablesConditions = $data['allTablesConditions'];
        $offeringServiceConditions= $allTablesConditions['offeringServiceConditions'];
        $query = $this->db->query("SELECT ros.rateoffering_id as rateOfferingId,
                      SUM( 
                        CASE
                            {$offeringServiceConditions}
                        END
                    ) AS totalOfferingAmount 
            FROM tb_rateoffering_services ros where ros.rateoffering_id ='".$rateOfferingId."' AND ros.status = 1 GROUP BY rateOfferingId");
        return $query->num_rows() > 0 ? $query->row_array() : []; 
    }

    private function getRateRecordServicesPriceByConversionFactor(array $data): array
    {
        $orderVasData = $data['orderAddons'] ?? [];
        if(empty($orderVasData)){
            return [];
        }
        foreach($orderVasData as $eachLine){
            $orderVasIds[] = $eachLine['vasId'];
        }
        $rateRecordId = $data['rateRecordId'];
        $orderVasDataJson = json_encode($orderVasData);
        $allTablesConditions = $data['allTablesConditions'];
        $rateServiceConditions = $allTablesConditions['rateServiceConditions'];
        $query = $this->db->query("WITH orderVasData AS (
                    SELECT vasTable.vasId, vasTable.quantity
                    FROM JSON_TABLE(
                        '$orderVasDataJson',
                        '$[*]' COLUMNS (
                            vasId INT PATH '$.vasId',
                            quantity DECIMAL(10,2) PATH '$.quantity'
                        )
                    ) vasTable
                )
                SELECT 
                    rrs.raterecord_id AS rateRecordId, 
                    SUM( 
                        CASE
                            {$rateServiceConditions}
                            WHEN rrs.charge_basis IN ('" . implode("','", self::TRIP_CHARGEBASIS) . "')
                                THEN GREATEST(v.quantity * rrs.amount, rrs.min_amount) 
                        END
                    ) AS totalRecordServiceAmount
                FROM tb_raterecord_services rrs
                JOIN orderVasData v 
                    ON v.vasId = rrs.raterecord_vas_id
                WHERE rrs.raterecord_id = '".$rateRecordId."'
                AND rrs.raterecord_vas_id IN (" . implode(',', $orderVasIds) . " ) 
                AND rrs.status = 1
                GROUP BY rrs.raterecord_id");
        return $query->num_rows() > 0 ? $query->row_array() : []; 
    }

    private function getRateRecordChargesPriceByConversionFactor(array $data): array
    {
        $rateRecordId = $data['rateRecordId'];
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $query = $this->db->query("SELECT rc.raterecord_id as rateRecordId,
                    SUM(
                        CASE 
                            WHEN rc.rr_charge_type = 'FIXED' THEN
                                CASE
                                    {$rateChargeConditions}
                                END
                            WHEN rc.rr_charge_type = 'TIER' 
                               AND tsheet.id IS NOT NULL THEN
                            CASE 
                                {$rateTierConditionsOne}
                            END
                            WHEN rc.rr_charge_type = 'Geo Tier' 
                            AND gtier.id IS NOT NULL 
                            AND gsheet.id IS NOT NULL
                            THEN
                            CASE
                                {$geoTierConditions}
                            END
                        END
                    ) AS totalChargeAmount 
                    FROM tb_raterecord_charges rc 
                    LEFT JOIN tb_tier_master tier 
                        ON tier.id = rc.rr_tier_id AND tier.status = 1
                    LEFT JOIN tb_tier_rate_sheet tsheet 
                        ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                    LEFT JOIN tb_geo_tier gtier 
                        ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                    LEFT JOIN tb_geo_tier_sheet gsheet 
                        ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                        (
                            ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$data['GEOPROVINCE']." )
                            OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$data['GEOPOSTAL CODE']." )
                            OR ( gtier.geo_hierarchy ='CITY' AND ".$data['GEOCITY']." )
                            OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$data['GEOCOUNTRY']." ) )
                        )
                    where rc.raterecord_id = ".$rateRecordId." AND rc.status = 1 GROUP BY raterecord_id");
        return $query->num_rows() > 0 ? $query->row_array() : []; 
    }

    private function calculateFuelSurchargeAmountForRRChargesOnlyByConversion(array $data): array
    {
        $currentDate = date('Y-m-d');
        $rateRecordId = $data['rateRecordId'];
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateServiceConditions= $allTablesConditions['rateServiceConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $query = $this->db->query("WITH totalFRTCharges AS (
                SELECT 
                    rc.raterecord_id as rateRecordId,
                    SUM(
                        CASE 
                            WHEN rc.rr_charge_type = 'FIXED' THEN
                                CASE
                                    {$rateChargeConditions}
                                END
                            WHEN rc.rr_charge_type = 'TIER'
                                AND tsheet.id IS NOT NULL THEN
                            CASE 
                                {$rateTierConditionsOne}
                            END
                            WHEN rc.rr_charge_type = 'Geo Tier' 
                                AND gtier.id IS NOT NULL 
                                AND gsheet.id IS NOT NULL
                                THEN
                                CASE
                                    {$geoTierConditions}
                                END
                        END
                    ) AS totalFRTCharge
                FROM tb_raterecord_charges rc
                LEFT JOIN tb_tier_master tier 
                    ON tier.id = rc.rr_tier_id AND tier.status = 1
                LEFT JOIN tb_tier_rate_sheet tsheet 
                    ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                LEFT JOIN tb_geo_tier gtier 
                    ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                LEFT JOIN tb_geo_tier_sheet gsheet 
                    ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                        (
                            ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$data['GEOPROVINCE']." )
                            OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$data['GEOPOSTAL CODE']." )
                            OR ( gtier.geo_hierarchy ='CITY' AND ".$data['GEOCITY']." )
                            OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$data['GEOCOUNTRY']." ) )
                        )
                WHERE rc.rr_charge_id = 39 
                AND rc.status = 1
                GROUP BY rateRecordId
            )
            SELECT 
                table1.rateRecordId,
                table1.totalFRTCharge,
                fsheet.percentage,
                fsheet.amount AS fuelSurchargeFlatAmount,
                CASE 
                    WHEN fsheet.percentage IS NOT NULL 
                        THEN (table1.totalFRTCharge * fsheet.percentage / 100.0)
                    WHEN fsheet.amount IS NOT NULL 
                        THEN fsheet.amount
                    ELSE 0
                END AS fuelSurchargePercentageAmount
            FROM totalFRTCharges table1
            INNER JOIN tb_raterecord_charges rc 
                ON rc.raterecord_id = table1.rateRecordId 
                AND rc.charge_basis = 'FRT'
            INNER JOIN tb_fuel_surcharge_sheet fsheet 
                ON fsheet.fuel_surcharge_id = rc.fuel_surcharge_id
                WHERE rc.raterecord_id = '" .$rateRecordId. "' AND fsheet.status = 1
                AND fsheet.from_date <= '".$currentDate."'
                AND fsheet.to_date   >= '".$currentDate."' AND rc.status  = 1;
        ");
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    private function getRateRecordFuelSurchargePriceByConversionFactor(array $data): array
    {
        $orderVasData = $data['orderAddons'] ?? [];
        if(empty($orderVasData)){
            return $this->calculateFuelSurchargeAmountForRRChargesOnlyByConversion($data);
        }
        $currentDate = date('Y-m-d');
        $rateRecordId = $data['rateRecordId'];
        $rateOfferingId = $data['rateOfferingId'];
        $geoPairs = $data['geoPairs'];
        $geoTierPairs = $data['geoTierPairs'];
        $geoPairsGsheet = $geoPairs['geoCondition'];
        $allTablesConditions = $data['allTablesConditions'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateServiceConditions= $allTablesConditions['rateServiceConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $orderVasDataJson = json_encode($orderVasData);
        $query = $this->db->query("
                            WITH orderVasData AS (
                            SELECT vasTable.vasId, vasTable.quantity
                            FROM JSON_TABLE(
                                '$orderVasDataJson',
                                '$[*]' COLUMNS (
                                    vasId INT PATH '$.vasId',
                                    quantity DECIMAL(10,2) PATH '$.quantity'
                                )
                            ) vasTable
                        ),
                        vasCharges AS (
                            SELECT 
                                rrs.raterecord_id AS rateRecordId, 
                                SUM(
                                    CASE
                                        {$rateServiceConditions}
                                        WHEN rrs.charge_basis IN ('" . implode("','", self::TRIP_CHARGEBASIS) . "')
                                            THEN GREATEST(v.quantity * rrs.amount, rrs.min_amount) 
                                    END
                                ) AS totalVASCharge
                            FROM tb_raterecord_services rrs
                            JOIN orderVasData v 
                                ON v.vasId = rrs.raterecord_vas_id
                            WHERE rrs.raterecord_id = ".$rateRecordId."
                            AND rrs.raterecord_charge_id = 39
                            AND rrs.status = 1
                            GROUP BY rrs.raterecord_id
                        ),
                        totalFRTCharges AS (
                            SELECT 
                                rc.raterecord_id as rateRecordId,
                                SUM(
                                    CASE 
                                        WHEN rc.rr_charge_type = 'FIXED' THEN
                                            CASE
                                                {$rateChargeConditions}
                                            END
                                        WHEN rc.rr_charge_type = 'TIER'
                                        AND tsheet.id IS NOT NULL THEN
                                        CASE 
                                            {$rateTierConditionsOne}
                                        END
                                    WHEN rc.rr_charge_type = 'Geo Tier' 
                                    AND gtier.id IS NOT NULL 
                                    AND gsheet.id IS NOT NULL
                                    THEN
                                    CASE
                                        {$geoTierConditions}
                                        END
                                    END
                                ) AS totalFRTCharge
                            FROM tb_raterecord_charges rc
                            LEFT JOIN tb_tier_master tier 
                                ON tier.id = rc.rr_tier_id AND tier.status = 1
                            LEFT JOIN tb_tier_rate_sheet tsheet 
                                ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                            LEFT JOIN tb_geo_tier gtier 
                                ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                            LEFT JOIN tb_geo_tier_sheet gsheet 
                                ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                                (
                                    ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$geoTierPairs['PROVINCE']." )
                                    OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$geoTierPairs['POSTAL CODE']." )
                                    OR ( gtier.geo_hierarchy ='CITY' AND ".$geoTierPairs['CITY']." )
                                    OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$geoTierPairs['COUNTRY']." ) )  OR
                                    ( ".$geoPairsGsheet." ) 
                                )
                            WHERE rc.rr_charge_id = 39 
                            AND rc.status = 1
                            AND rc.raterecord_id = ".$rateRecordId." 
                            GROUP BY rc.raterecord_id
                        ),
                        combinedCharges AS (
                            SELECT 
                                f.rateRecordId,
                                f.totalFRTCharge,
                                COALESCE(v.totalVASCharge,0) AS totalVASCharge,
                                (f.totalFRTCharge + COALESCE(v.totalVASCharge,0)) AS totalCombinedCharge
                            FROM totalFRTCharges f
                            LEFT JOIN vasCharges v 
                                ON v.rateRecordId = f.rateRecordId
                            UNION
                            SELECT 
                                v.rateRecordId,
                                COALESCE(f.totalFRTCharge,0),
                                v.totalVASCharge,
                                (COALESCE(f.totalFRTCharge,0) + v.totalVASCharge)
                            FROM vasCharges v
                            LEFT JOIN totalFRTCharges f 
                                ON v.rateRecordId = f.rateRecordId
                        )
                        SELECT 
                            c.rateRecordId,
                            c.totalFRTCharge,
                            c.totalVASCharge,
                            c.totalCombinedCharge,
                            fsheet.percentage,
                            fsheet.amount AS fuelSurchargeFlatAmount,
                            CASE 
                                WHEN fsheet.percentage IS NOT NULL 
                                    THEN (c.totalCombinedCharge * fsheet.percentage / 100.0)
                                WHEN fsheet.amount IS NOT NULL 
                                    THEN fsheet.amount
                                ELSE 0
                            END AS fuelSurchargePercentageAmount,
                            (c.totalCombinedCharge +
                                CASE 
                                    WHEN fsheet.percentage IS NOT NULL 
                                        THEN (c.totalCombinedCharge * fsheet.percentage / 100.0)
                                    WHEN fsheet.amount IS NOT NULL 
                                        THEN fsheet.amount
                                    ELSE 0
                                END
                            ) AS finalTotalAmount
                        FROM combinedCharges c
                        INNER JOIN tb_raterecord_charges rc 
                            ON rc.raterecord_id = c.rateRecordId 
                        AND rc.fuel_surcharge_id > 0
                        AND rc.status = 1
                        AND rc.raterecord_id  = ".$rateRecordId."
                        INNER JOIN tb_fuel_surcharge_sheet fsheet 
                            ON fsheet.fuel_surcharge_id = rc.fuel_surcharge_id
                        AND fsheet.status = 1
                        AND fsheet.from_date <= CURDATE()
                        AND fsheet.to_date   >= CURDATE()
                        GROUP BY c.rateRecordId, c.totalFRTCharge, c.totalVASCharge, c.totalCombinedCharge,
                                fsheet.percentage, fsheet.amount");
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : []; 
        if(empty($queryResult)){
            return [];
        }
        foreach($queryResult as $eachLine){
            $fuelSurcharges = ['totalFRTCharge'=>$eachLine['totalCombinedCharge'],'percentage'=>$eachLine['percentage'],'fuelSurchargeFlatAmount'=>$eachLine['fuelSurchargeFlatAmount'],'fuelSurchargePercentageAmount'=>$eachLine['fuelSurchargePercentageAmount'],'rateRecordId'=>$rateRecordId];
        }
        return $fuelSurcharges ?? [];
    }

    private function generateUnitsAndValuesToDynamicMultiArrayForAllTables(array $data): array
    {
        $cargos = $data['cargos'] ?? [];
        if(empty($cargos)){
            $cargoWeight = $data['cargoWeight'];
            $cargoVolume = $data['cargoVolume'];
            $cargoQuantity = $data['cargoQuantity'];
            $cargoSecondWeight = $data['cargoSecondWeight'];
            $cargoSecondVolume = $data['cargoSecondVolume'];
        }else{
            $cargoWeight = $cargos['cargoWeight'];
            $cargoVolume = $cargos['cargoVolume'];
            $cargoQuantity = $cargos['cargoQuantity'];
            $cargoSecondWeight = $cargos['cargoSecondWeight'];
            $cargoSecondVolume = $cargos['cargoSecondVolume'];
        }
        $distanceAndDuration = $data['distanceAndDuration'] ?? [];
        if(empty($distanceAndDuration)){
            $distanceKm = $data['distanceKm'];
            $distanceMiles = $data['distanceMiles'];
            $durationMin = $data['durationMin'];
            $durationHours = $data['durationHours'];
            $durationDays = $data['durationDays'];
        }else{
            $distanceKm = $distanceAndDuration['distanceKm'];
            $distanceMiles = $distanceAndDuration['distanceMiles'];
            $durationMin = $distanceAndDuration['durationMin'];
            $durationHours = $distanceAndDuration['durationHours'];
            $durationDays = $distanceAndDuration['durationDays'];
        }
        
        $conversionBaseUom = $data['conversionBaseUom'] ?? "";
        $unitToBeConsidered = $data['unitToBeConsidered'] ?? 0;
        if($unitToBeConsidered > 0){
            $cargoVolume = ($conversionBaseUom == 'CBM') ? $unitToBeConsidered : $cargoVolume;
            $cargoWeight = (in_array($conversionBaseUom, ['KG','TON','LB','MTON'])) ? $unitToBeConsidered : $cargoWeight;
            $distanceKm = ($conversionBaseUom == 'KM') ? $unitToBeConsidered : $distanceKm;
            $distanceMiles = ($conversionBaseUom == 'MI') ? $unitToBeConsidered : $distanceMiles;
            $durationMin = ($conversionBaseUom == 'MIN') ? $unitToBeConsidered : $durationMin;
            $durationHours = ($conversionBaseUom == 'HOURS') ? $unitToBeConsidered : $durationHours;
            $durationDays = ($conversionBaseUom == 'DAYS') ? $unitToBeConsidered : $durationDays;
        }
        $basicConditions = [
            [
                'key' => self::KG_CHARGEBASIS,
                'value' => $cargoWeight,
            ],
            [
                'key' => self::CBM_CHARGEBASIS,
                'value' => $cargoVolume,
            ],
            [
                'key' => self::PEICE_CHARGEBASIS,
                'value' => $cargoQuantity,
            ],
            [
                'key' => self::TRIP_CHARGEBASIS,
                'value' => 1,
                'tripChargeBasis' => 1,
            ],
            [
                'key' => self::KM_CHARGEBASIS,
                'value' => $distanceKm,
            ],
            [
                'key' => self::MILES_CHARGEBASIS,
                'value' => $distanceMiles,
            ],
            [
                'key' => self::HOURS_CHARGEBASIS,
                'value' => $durationHours,
            ],
        ];
       
        $rateChargeConditionsString = $geoTierConditionsString = $rateServiceonditionsString = $offeringServiceonditionsString = $rateTierConditionsStringOne = $rateTierConditionsStringTwo = "";
        foreach($basicConditions as $eachLine){
            $keys = implode("','", $eachLine['key']);
            $value = $eachLine['value'];
            $rateChargeConditionsString .= "WHEN rc.charge_basis IN ('{$keys}') 
                                            THEN GREATEST({$value} * rc.amount, rc.min_amount) ";
            $offeringServiceonditionsString .= "WHEN ros.charge_basis IN ('{$keys}') 
                                            THEN GREATEST({$value} * ros.amount, ros.min_amount) ";
            if(($eachLine['tripChargeBasis'] ?? 0) ==  0){
                $rateServiceonditionsString .= "WHEN rrs.charge_basis IN ('{$keys}') 
                                            THEN GREATEST({$value} * rrs.amount, rrs.min_amount) ";
            }
        }
        $dimensionsData = [
            [
                'uom'=>'ACTUAL WEIGHT',
                'unitMeasure' => ['KG','LB','TON'],
                'dynamicValue'=>[$cargoWeight, $cargoWeight, $cargoWeight],
            ],
            [
                'uom'=>'WEIGHT',
                'unitMeasure' => ['KG','LB','TON'],
                'dynamicValue'=>[$cargoSecondWeight, $cargoSecondWeight, $cargoSecondWeight],
            ],
            [
                'uom'=>'ACTUAL VOLUME',
                'unitMeasure' => ['CBM'],
                'dynamicValue'=>[$cargoVolume],
            ],
            [
                'uom'=>'VOLUME',
                'unitMeasure' => ['CBM'],
                'dynamicValue'=>[$cargoSecondVolume],
            ],
            [
                'uom'=>'DISTANCE',
                'unitMeasure' => ['KM','MI'],
                'dynamicValue'=>[$distanceKm, $distanceMiles],
            ],
            [
                'uom'=>'DURATION',
                'unitMeasure' => ['DAYS','HOURS','MIN'],
                'dynamicValue'=>[$durationDays, $durationHours, $durationMin],
            ],
        ];
        foreach($dimensionsData as $eachRowData){
            $uom = $eachRowData['uom'];
            $unitMeasure = $eachRowData['unitMeasure'];
            $dynamicValues = $eachRowData['dynamicValue'];
            $geoTierConditionsString .= " WHEN UPPER(gtier.uom1) = '".$uom."' THEN CASE ";
            for($i = 0;$i<count($unitMeasure); $i++){
                $measure = $unitMeasure[$i];
                $value = $dynamicValues[$i];
                $geoTierConditionsString .= " WHEN UPPER(gtier.unit_measure1) = '".$measure."' AND $value >0 AND $value  BETWEEN gsheet.uom1_min AND gsheet.uom1_max THEN GREATEST($value * gsheet.cost, gsheet.uom1_minimum) ";
            }
            $geoTierConditionsString .= "END ";
            
        }
        $rateTierConditionsStringOne .= " WHEN UPPER(tier.billing_uom) = UPPER(tier.uom1) THEN CASE ";
        foreach($dimensionsData as $eachRowData){
            $uom = $eachRowData['uom'];
            $unitMeasure = $eachRowData['unitMeasure'];
            $dynamicValues = $eachRowData['dynamicValue'];
            $rateTierConditionsStringOne .= " WHEN UPPER(tier.uom1) = '".$uom."' THEN CASE ";
            for($i = 0;$i<count($unitMeasure); $i++){
                $measure = $unitMeasure[$i];
                $value = $dynamicValues[$i];
                $rateTierConditionsStringOne .= " WHEN UPPER(tier.unit_measure1) = '".$measure."' THEN tsheet.cost * $value";
            }
            $rateTierConditionsStringOne .= " END ";
        }
        $rateTierConditionsStringOne .= "END WHEN UPPER(tier.billing_uom) = UPPER(tier.uom2) THEN CASE ";
        foreach($dimensionsData as $eachRowData){
            $uom = $eachRowData['uom'];
            $unitMeasure = $eachRowData['unitMeasure'];
            $dynamicValues = $eachRowData['dynamicValue'];
            $rateTierConditionsStringOne .= " WHEN UPPER(tier.uom2) = '".$uom."' THEN CASE ";
            for($i = 0;$i<count($unitMeasure); $i++){
                $measure = $unitMeasure[$i];
                $value = $dynamicValues[$i];
                $rateTierConditionsStringOne .= " WHEN UPPER(tier.unit_measure2) = '".$measure."' THEN tsheet.cost * $value";
            }
            $rateTierConditionsStringOne .= " END ";
        }
        $rateTierConditionsStringOne .= " END ";
        $dimensionsDataCount = count($dimensionsData);
        $j = $k = 0;
        foreach($dimensionsData as $eachRowData){
            $uom = $eachRowData['uom'];
            $unitMeasure = $eachRowData['unitMeasure'];
            $dynamicValues = $eachRowData['dynamicValue'];
            $rateTierConditionsStringTwo .= " ( UPPER(tier.uom1) = '".$uom."' AND ";
            $unitMeasureCount = count($unitMeasure);
            if($unitMeasureCount == 1){
                $measure = $unitMeasure[0];
                $value = $dynamicValues[0];
                $rateTierConditionsStringTwo .= " UPPER(tier.unit_measure1) = '".$measure."' AND $value BETWEEN tsheet.uom1_min AND tsheet.uom1_max) OR ";
            }else{
                $rateTierConditionsStringTwo .= " ( ";
                for($i = 0;$i<$unitMeasureCount; $i++){
                    $measure = $unitMeasure[$i];
                    $value = $dynamicValues[$i];
                    $rateTierConditionsStringTwo .= "( UPPER(tier.unit_measure1) = '".$measure."' AND $value BETWEEN tsheet.uom1_min AND tsheet.uom1_max) ";
                    if($i != ($unitMeasureCount - 1)){
                        $rateTierConditionsStringTwo .= " OR ";
                    }else{
                        $rateTierConditionsStringTwo .= " ) ";
                    }
                }
                if($j != ($dimensionsDataCount - 1)){
                    $rateTierConditionsStringTwo .= " ) OR ";
                }else{
                    $rateTierConditionsStringTwo .= " ) ";
                }
            }
            $j++;
        }
        $rateTierConditionsStringTwo .= " ) AND ( "; 
        foreach($dimensionsData as $eachRowData){
            $uom = $eachRowData['uom'];
            $unitMeasure = $eachRowData['unitMeasure'];
            $dynamicValues = $eachRowData['dynamicValue'];
            $rateTierConditionsStringTwo .= " ( UPPER(tier.uom2) = '".$uom."' AND ";
            $unitMeasureCount = count($unitMeasure);
            if($unitMeasureCount == 1){
                $measure = $unitMeasure[0];
                $value = $dynamicValues[0];
                $rateTierConditionsStringTwo .= " UPPER(tier.unit_measure2) = '".$measure."' AND $value BETWEEN tsheet.uom2_min AND tsheet.uom2_max) OR ";
            }else{
                $rateTierConditionsStringTwo .= " ( ";
                for($i = 0;$i<$unitMeasureCount; $i++){
                    $measure = $unitMeasure[$i];
                    $value = $dynamicValues[$i];
                    $rateTierConditionsStringTwo .= "( UPPER(tier.unit_measure2) = '".$measure."' AND $value BETWEEN tsheet.uom2_min AND tsheet.uom2_max) ";
                    if($i != ($unitMeasureCount - 1)){
                        $rateTierConditionsStringTwo .= " OR ";
                    }else{
                        $rateTierConditionsStringTwo .= " ) ";
                    }
                }
                if($k != ($dimensionsDataCount - 1)){
                    $rateTierConditionsStringTwo .= " ) OR ";
                }else{
                    $rateTierConditionsStringTwo .= " ) ";
                }
            }
            $k++;
        }
        return ['rateChargeConditions'=> $rateChargeConditionsString, 'geoTierConditions'=> $geoTierConditionsString ,'rateServiceConditions'=>$rateServiceonditionsString, 'offeringServiceConditions'=>$offeringServiceonditionsString,'rateTierConditionsOne'=>$rateTierConditionsStringOne, 'rateTierConditionsTwo'=> $rateTierConditionsStringTwo];
    }

    public function getAllRateChargesList(array $data): array
    {
        if($data['uomConversionId'] > 0){
            $query = $this->db->select("id, uom_type1, uom_type2, uom_type3, uom_type4, uom1, uom2, uom3, uom4,
            uom1_conversion, uom2_conversion, uom3_conversion, uom4_conversion, base_uom");
            $this->db->from("tb_knuom_conversion");
            $this->db->where("id = '".$data['uomConversionId']."' AND status  = '1'");
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                $queryResult = $query->row_array();
                $cargoWeight = $data['cargoWeight'];
                $cargoSecondWeight = $data['cargoSecondWeight'];
                $cargoVolume = $data['cargoVolume'];
                $cargoSecondVolume = $data['cargoSecondVolume'];
                $cargoQuantity = $data['cargoQuantity']; 
                $conversionFactorWeight = $this->getConversionFactorForWeight($queryResult) ?? 0;
                $conversionFactorSecondWeight = $this->getConversionFactorForSecondWeight($queryResult) ?? 0;
                $conversionFactorVolume = $this->getConversionFactorForVolume($queryResult) ?? 0;
                $conversionFactorSecondVolume = $this->getConversionFactorForSecondVolume($queryResult) ?? 0;
                $weight = $cargoWeight * $conversionFactorWeight;
                $volume = $cargoVolume * $conversionFactorVolume;
                $cargoSecondWeight = $cargoSecondWeight * $conversionFactorSecondWeight;
                $cargoSecondVolume = $cargoSecondVolume * $conversionFactorSecondVolume;
                $data['unitToBeConsidered'] = max($weight, $volume, $cargoSecondWeight, $cargoSecondVolume);
                $data['conversionBaseUom'] = $queryResult['base_uom'];
                $data['cargoWeight'] = $weight;
                $data['cargoVolume'] = $volume;
                $data['cargoSecondWeight'] = $cargoSecondWeight;
                $data['cargoSecondVolume'] = $cargoSecondVolume;
                $data['cargoQuantity'] = $cargoQuantity;
            }
        }
        $allTablesConditions = $this->generateUnitsAndValuesToDynamicMultiArrayForAllTables($data);
        $offeringServiceConditions = $allTablesConditions['offeringServiceConditions'];
        $geoTierPairs = $data['geoTierPairs'];
        $rateChargeConditions = $allTablesConditions['rateChargeConditions'];
        $rateTierConditionsOne = $allTablesConditions['rateTierConditionsOne'];
        $rateTierConditionsTwo = $allTablesConditions['rateTierConditionsTwo'];
        $geoTierConditions = $allTablesConditions['geoTierConditions'];
        $rateServiceConditions = $allTablesConditions['rateServiceConditions'];
        $recordRowId = $data['recordRowId'];
        $offeringRowId = $data['offeringRowId'];
        $chargeIds = $geoTierIds = $rateTierIds = $individualCharges = [];
        $rateOfferingQuery = $this->db->query("SELECT ros.rateoffering_id as rateOfferingId, ros.ro_charge_id as chargeId, ros.charge_basis as chargeBasis, 
                        CASE
                            {$offeringServiceConditions}
                        END AS amount,ros.currency
            FROM tb_rateoffering_services ros where ros.rateoffering_id = $offeringRowId AND ros.status = 1 GROUP BY ros.id HAVING amount > 0");
        $rateOfferingQueryResult = $rateOfferingQuery->num_rows() > 0 ? $rateOfferingQuery->result_array() : []; 
        foreach($rateOfferingQueryResult as $eachLine){
            $individualCharges[] = ['rateOfferingId'=>$eachLine['rateOfferingId'], 'chargeId'=>$eachLine['chargeId'], 'chargeBasis'=>$eachLine['chargeBasis'], 'amount'=>$eachLine['amount'], 'currency'=>$eachLine['currency'], 'rateId'=>$data['rateOfferingId']];
            $chargeIds[] = $eachLine['chargeId'];
        }
        $orderVasData = $data['orderAddons'] ?? [];
        if(!empty($orderVasData)){
            foreach($orderVasData as $eachLine){
            $orderVasIds[] = $eachLine['vasId'];
            }
            $orderVasDataJson = json_encode($orderVasData);
            $rrServicesQuery = $this->db->query("
                    WITH orderVasData AS (
                        SELECT vasTable.vasId, vasTable.quantity
                        FROM JSON_TABLE(
                            '$orderVasDataJson',
                            '$[*]' COLUMNS (
                                vasId INT PATH '$.vasId',
                                quantity DECIMAL(10,2) PATH '$.quantity'
                            )
                        ) vasTable
                    )
                    SELECT 
                        rrs.raterecord_id AS rateRecordId, rrs.raterecord_charge_id as chargeId, rrs.charge_basis as chargeBasis, 
                        CASE
                            {$rateServiceConditions}
                            WHEN rrs.charge_basis IN ('" . implode("','", self::TRIP_CHARGEBASIS) . "')
                                THEN GREATEST(v.quantity * rrs.amount, rrs.min_amount) 
                        END
                    AS amount, rrs.currency
                    FROM tb_raterecord_services rrs
                    JOIN orderVasData v 
                        ON v.vasId = rrs.raterecord_vas_id
                    WHERE rrs.raterecord_id = $recordRowId 
                    AND rrs.raterecord_vas_id IN (" . implode(',', $orderVasIds) . " ) 
                    AND rrs.status = 1
                    GROUP BY rrs.id");
            $rrServicesQueryResult = $rrServicesQuery->num_rows() > 0 ? $rrServicesQuery->result_array() : []; 
            foreach($rrServicesQueryResult as $eachLine){
                $individualCharges[] = ['rateRecordId'=>$eachLine['rateRecordId'], 'chargeId'=>$eachLine['chargeId'],'chargeBasis'=>$eachLine['chargeBasis'],'amount'=>$eachLine['amount'],'currency'=>$eachLine['currency'], 'rateId'=>$data['rateRecordId']];
                $chargeIds[] = $eachLine['chargeId'];
            }
        }
        $rrChargesQuery = $this->db->query("SELECT rc.id,rc.raterecord_id as rateRecordId,rc.rr_charge_type as rrChargeType,rc.rr_tier_id as rateTierId,rc.geo_tier_id as geoTierId,rc.rr_charge_id as chargeId,rc.charge_basis as chargeBasis,
                    CASE 
                        WHEN rc.rr_charge_type = 'FIXED' THEN
                            CASE
                                {$rateChargeConditions}
                            END
                        WHEN rc.rr_charge_type = 'TIER' 
                        AND tsheet.id IS NOT NULL THEN
                        CASE 
                            {$rateTierConditionsOne}
                        END
                        WHEN rc.rr_charge_type = 'Geo Tier' 
                        AND gtier.id IS NOT NULL 
                        AND gsheet.id IS NOT NULL
                        THEN
                        CASE
                        {$geoTierConditions}
                        END
                    END
                    AS amount,rc.currency 
                    FROM tb_raterecord_charges rc 
                    LEFT JOIN tb_tier_master tier 
                        ON tier.id = rc.rr_tier_id AND tier.status = 1
                    LEFT JOIN tb_tier_rate_sheet tsheet 
                        ON tsheet.tier_master_id = tier.id AND tsheet.status = 1 AND ( ( $rateTierConditionsTwo ) )
                    LEFT JOIN tb_geo_tier gtier 
                        ON gtier.id = rc.geo_tier_id AND gtier.status = 1 
                    LEFT JOIN tb_geo_tier_sheet gsheet 
                        ON gsheet.geo_tier_id = gtier.id AND gsheet.status = 1 AND 
                        (
                            ( ( gtier.geo_hierarchy ='PROVINCE' AND ".$geoTierPairs['PROVINCE']." )
                            OR ( gtier.geo_hierarchy ='POSTAL CODE' AND ".$geoTierPairs['POSTAL CODE']." )
                            OR ( gtier.geo_hierarchy ='CITY' AND ".$geoTierPairs['CITY']." )
                            OR (  gtier.geo_hierarchy ='COUNTRY' AND ".$geoTierPairs['COUNTRY']." ) )  
                        )
                    where rc.raterecord_id = $recordRowId AND rc.status = 1 GROUP BY rc.id,gsheet.id,tsheet.id HAVING amount > 0");
        $rrChargesQueryResult = $rrChargesQuery->num_rows() > 0 ? $rrChargesQuery->result_array() : []; 
        foreach($rrChargesQueryResult as $eachLine){
            $geoTierId = $eachLine['geoTierId'];
            if($geoTierId > 0){
                $geoTierIds[] = $geoTierId;
            }
            $rateTierId = $eachLine['rateTierId'];
            if($rateTierId > 0){
                $rateTierIds[] = $rateTierId;
            }
            $individualCharges[] = ['rateRecordId'=>$eachLine['rateRecordId'],'rrChargeType'=>$eachLine['rrChargeType'],'rateTierId'=>$rateTierId,'geoTierId'=>$geoTierId,'chargeId'=>$eachLine['chargeId'],'chargeBasis'=>$eachLine['chargeBasis'],'amount'=>$eachLine['amount'],'currency'=>$eachLine['currency'], 'rateId'=>$data['rateRecordId']];
            $chargeIds[] = $eachLine['chargeId'];
        }
        $getCharges = $this->db->query("SELECT id,charge_code,name FROM tb_charge_codes WHERE id IN ? ",[array_unique($chargeIds)]);
        foreach($getCharges->result_array() as $eachLine){
            $chargeCodes[$eachLine['id']] = ['code'=>$eachLine['charge_code'], 'name'=>$eachLine['name']];
        }
        if(!empty($rateTierIds)){
            $getRateTier = $this->db->query("SELECT id,tier_id FROM tb_tier_master WHERE id IN ? AND status = ?",[array_unique($rateTierIds),'1']);
            $rateTierResult = $getRateTier->num_rows() > 0 ? $getRateTier->result_array() : [];
            foreach($rateTierResult as $eachLine){
                $ratTiers[$eachLine['id']] = $eachLine['tier_id'];
            }
        }
        if(!empty($geoTierIds)){
            $getGeoTier = $this->db->query("SELECT id,geo_tier_id FROM tb_geo_tier WHERE id IN ? AND status = ?",[array_unique($geoTierIds),'1']);
            $gateTierResult = $getGeoTier->num_rows() > 0 ? $getGeoTier->result_array() : [];
            foreach($gateTierResult as $eachLine){
                $geoTiers[$eachLine['id']] = $eachLine['geo_tier_id'];
            }
        }
        return ['individualCharges'=>$individualCharges ?? [], 'chargeCodes'=>$chargeCodes ?? [], 'ratTiers'=>$ratTiers ?? [], 'geoTiers'=>$geoTiers ?? []];
    }

    public function getOrderConstraints(array $data):array
    {
        $orderId = $data['orderId'];
        $fromDate = $data['fromDate'];
        $toDate = $data['toDate'];
        $getOrderParties = $this->db->query("SELECT o.id, o.order_id, o.party_id, p.name FROM tb_order_parties AS o INNER JOIN tbl_party_types AS p ON o.party_type = p.id WHERE o.order_id = ? AND o.status = ?",[$orderId,1]);
        $orderPartiesResult = $getOrderParties->num_rows() > 0 ? $getOrderParties->result_array() : [];
        if(empty($orderPartiesResult)){
            return ['truckTypeConstraints'=> [],'timeConstraints'=> 0];
        }
        foreach($orderPartiesResult as $eachLine){
            $partyType = strtoupper($eachLine['name']);
            if($partyType == "SHIPPER"){
                $shipperId = $eachLine['party_id'];
            }
            if($partyType == "CONSIGNEE"){
                $consigneeId = $eachLine['party_id'];
            }
        }
        if((($shipperId ?? 0) == 0 ) && (($consigneeId ?? 0) == 0)){
            return ['truckTypeConstraints'=> [],'timeConstraints'=> 0];
        }
        $getPartyVehicleTypes = $this->db->query("SELECT partner_id,trucktype_id FROM partner_vehicletypes WHERE partner_id IN ? AND status = ?",[[$shipperId, $consigneeId],1]);
        $partyVehicleTypesResult = $getPartyVehicleTypes->num_rows() > 0 ? $getPartyVehicleTypes->result_array() : [];
        $checkPartnerTimeConstraints = $this->db->query("SELECT id,partner_id FROM partner_timeconstraints WHERE partner_id IN ? AND status = ? GROUP BY partner_id",[[$shipperId, $consigneeId], 1]);
        $allTimeConstraints = $checkPartnerTimeConstraints->num_rows() > 0 ? $checkPartnerTimeConstraints->result_array() : [];
        if((empty($checkPartnerTimeConstraints)) && (empty($partyVehicleTypesResult))){
            return ['truckTypeConstraints'=> [],'timeConstraints'=> 1];
        }
        foreach($partyVehicleTypesResult as $eachLine){
            $truckTypeConstraints[] = $eachLine['trucktype_id'];
        }
        $fromDateConversion = getdatetimebytimezone($data['sessionTimeZone'], $fromDate, DFLT_TZ );
        $userFromDate =  $fromDateConversion['datetime'];
        $fromDay  = date('l', strtotime($userFromDate));
        $fromTime = date('H:i:s', strtotime($userFromDate));
        $toDateConversion = getdatetimebytimezone($data['sessionTimeZone'], $toDate, DFLT_TZ );
        $userToDate =  $toDateConversion['datetime'];
        $toDay  = date('l', strtotime($userToDate));
        $toTime = date('H:i:s', strtotime($userToDate));
        foreach($allTimeConstraints as $eachConstraint){
            $partnerId = $eachConstraint['partner_id'];
            $constraintType = $eachConstraint['type'];
            if($partnerId == $shipperId){
                $checkDay = $fromDay;
                $checkTime = $fromTime;
                $checkPartnerConstraints = $this->db->query("SELECT id FROM partner_timeconstraints WHERE partner_id = ? AND day = ? AND ((pickup_start_time < pickup_end_time AND ? BETWEEN pickup_start_time AND pickup_end_time) OR (pickup_start_time > pickup_end_time AND (? >= pickup_start_time OR ? <= pickup_end_time))) AND status = ?",[$partnerId, $checkDay, $checkTime, $checkTime, $checkTime, 1]);
            }else{
                $checkDay = $toDay;
                $checkTime = $toTime;
                $checkPartnerConstraints = $this->db->query("SELECT id FROM partner_timeconstraints WHERE partner_id = ? AND day = ? AND ((drop_start_time < drop_end_time AND ? BETWEEN drop_start_time AND drop_end_time) OR (drop_start_time > drop_end_time AND (? >= drop_start_time OR ? <= drop_end_time))) AND status = ?",[$partnerId, $checkDay, $checkTime, $checkTime, $checkTime, 1]);
            }
            if($checkPartnerConstraints->num_rows() == 0){
                return ['truckTypeConstraints'=> $truckTypeConstraints ?? [],'timeConstraints'=> 0];
            }
        }
        
        return ['truckTypeConstraints'=> $truckTypeConstraints ?? [],'timeConstraints'=> 1];
    }

    public function checkRegionData(array $pickupData, array $destinationData): array
    {
        $checkPickupRegion = $this->db->query("SELECT region FROM tb_kn_geocodes WHERE (postal_code = ? OR city = ? OR province = ? ) AND country = ? AND status = ?",[$pickupData[0], $pickupData[1], $pickupData[2], $pickupData[3], 1]);
        $checkDeliveryRegion = $this->db->query("SELECT region FROM tb_kn_geocodes WHERE (postal_code = ? OR city = ? OR province = ? ) AND country = ? AND status = ?",[$destinationData[0], $destinationData[1], $destinationData[2], $destinationData[3], 1]);
        $dbPickupRegions = $checkPickupRegion->num_rows() > 0 ? $checkPickupRegion->result_array() : [];
        $dbDeliveryRegions = $checkDeliveryRegion->num_rows() > 0 ? $checkDeliveryRegion->result_array(): [];
        foreach($dbPickupRegions as $eachRegion){
            $pickupRegions[] = $eachRegion['region'];
        }
        foreach($dbDeliveryRegions as $eachRegion){
            $deliveryRegions[] = $eachRegion['region'];
        }
        return ['pickupRegions'=>array_unique($pickupRegions ?? []), 'deliveryRegions'=>array_unique($deliveryRegions ?? [])];
    }
}

?>