<?php


namespace App\Models;


use App\Helpers\ParsedOrderIdHelperInterface;
use CI_DB_query_builder;
use Exception;

class OrderIdModel implements OrderIdModelInterface
{
    /** @var CI_DB_query_builder $db */
    private $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function getMaxOrderId(ParsedOrderIdHelperInterface $orderId): int
    {
        return (int) $this->db->query("
        SELECT MAX(order_id) AS 'order_id'
        FROM tb_orders
        WHERE order_id
                  LIKE '{$orderId->getPrefix()}%'")
            ->row(1)->order_id;
    }

    public function getNumberOfOrderIDs($orderId): int
    {
        return $this->db->query("
                SELECT order_id
                FROM tb_orders
                WHERE order_id = {$orderId->getFullId()}
                UNION
                SELECT order_id
                FROM tb_unique_order_ids
                WHERE order_id = {$orderId->getFullId()}"
        )->num_rows();
    }

    /**
     * @param $orderId
     * @throws Exception
     */
    public function saveOrderId($orderId): void
   {
       $this->db->insert('tb_unique_order_ids', ['order_id' => $orderId]);
       if(mysqli_errno($this->db->conn_id) === 1062) {
            throw new Exception;
       }
   }

}
