<?php

namespace App\Models;

use App\Helpers\ParsedOrderIdHelperInterface;

interface OrderIdModelInterface {
    public function getMaxOrderId(ParsedOrderIdHelperInterface $orderId): int;
    public function getNumberOfOrderIDs($orderId): int;

    /**
     * @param $orderId
     * @throws Exception
     */
    public function saveOrderId($orderId): void;
}
