<?php

namespace App\Models\OrderList;

use \Exception;

/**
 * Class ExcelUpload
 * @package App\Models\OrderList
 */
class ExcelUpload
{
    const IDS_FOR_UPLOAD = [
        '01',
        '02',
        '03',
        '04',
        '05'
    ];

    protected $id;

    /**
     * ExcelUpload constructor.
     * @param string $id
     */
    public function __construct($id)
    {
        $this->id = $id;
    }

    /**
     * @param string $companyCode
     * @return array|array[]|string
     * @throws Exception
     */
    public function upload($companyCode)
    {
        switch ($this->id) {
            case '01':
                //After excel upload, we are displaying popup with given order details
                // with success or failure status
                if ($companyCode == "KNAU") {
                    $filename = "assets/ordertemplate/excelauuploaddata.txt";
                } else {
                    $filename = "assets/ordertemplate/exceluploaddata.txt";
                }

                $result['excel_uploaddata'] = $this->getExcelArray($filename);
                $result['booking_ids'] = $this->create($filename, true);

                $result['list_types'] = [
                    'list_type' => 1,
                    'cllist_type' => 0,
                    'charge_list_type' => 0,
                    'knlogin_list_type' => 0
                ];
                break;
            case '02':
                //For CL excel upload(THKN), we are displaying popup with given order details
                //with success or failure status
                $result['booking_ids'] = $this->create("assets/ordertemplate/clexceluploaddata.txt", true);

                $result['list_types'] = [
                    'list_type' => 0,
                    'cllist_type' => 1,
                    'charge_list_type' => 0,
                    'knlogin_list_type' => 0
                ];
                break;
            case '03':
                $result['booking_ids'] = $this->create("assets/ordertemplate/charges_exceluploaddata.txt");
                $result['excel_uploaddata'] = $this->getExcelArray("assets/ordertemplate/charges_exceluploaddata.txt");
                $result['list_types'] = [
                    'list_type' => 0,
                    'cllist_type' => 0,
                    'charge_list_type' => 1,
                    'knlogin_list_type' => 0
                ];

                break;
            case '04':
                $result['booking_ids'] = [];
                $result['excel_uploaddata'] = $this->getExcelArray("assets/ordertemplate/exceluploaddata.txt");
                $result['list_types'] = [
                    'list_type' => 0,
                    'cllist_type' => 0,
                    'charge_list_type' => 0,
                    'knlogin_list_type' => 1
                ];

                break;
            case '05':
                $result['excel_uploaddata'] = $this->getExcelArray("assets/ordertemplate/quickRatesExcelData.txt");
                $result['list_types'] = [
                    'list_type' => 1
                ];

                break;
            default:
                $result['booking_ids'] = [];

                $result['list_types'] = [
                    'list_type' => 0,
                    'cllist_type' => 0,
                    'charge_list_type' => 0,
                    'knlogin_list_type' => 0
                ];
                break;
        }

        return $result;
    }

    /**
     * @param string $filename
     * @param bool $addIds
     * @return array[]|string
     * @throws Exception
     */
    protected function create($filename, $addIds = false)
    {
        if (!file_exists($filename)) {
            throw new Exception('File template does not exists');
        }

        $exc_booking_id = [];

        try {
            $filedata = file_get_contents($filename);
            $excel_uploaddata = json_decode($filedata);

            if (!empty($excel_uploaddata)) {
                addordertologs($filedata);

                //For ATS,need to send shipper, consigne,customer,carrier details
                if ($addIds) {
                    foreach ($excel_uploaddata as $exc_data) {
                        $exc_booking_id[] = $exc_data->booking_id;
                    }
                }
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $exc_booking_id;
    }

    /**
     * @param string $filename
     * @return array
     * @throws Exception
     */
    protected function getExcelArray($filename)
    {
        if (!file_exists($filename)) {
            throw new Exception('File template does not exists');
        }

        $excel_uploaddata = [];

        try {
            $filedata = file_get_contents($filename);
            $excel_uploaddata = json_decode($filedata);
        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $excel_uploaddata;
    }
}
