<?php

namespace App\Models\OrderList\Search;

/**
 * Class AdvancedSearch
 * @package App\Models\OrderList\Search
 */
class AdvancedSearch implements SearchInterface
{
    private $db;
    private $post;

    /**
     * Properties constructor.
     * @param object $db
     */
    public function __construct($db, $post)
    {
        $this->db = $db;
        $this->post = $post;
    }

    public function toDate($field, &$whr)
    {
        if (isset($this->post['advto_date']) && $this->post['advto_date'] != "") {
            $post_advto_date = $this->db->escape_str($this->post['advto_date']);
            $whr["date(" . $field . ") <="] = date('Y-m-d', strtotime($post_advto_date));

            return true;
        }

        return false;
    }

    public function fromDate($field, &$whr)
    {
        if (isset($this->post['advfrom_date']) && $this->post['advfrom_date'] != "") {
            $post_advfrom_date = $this->db->escape_str($this->post['advfrom_date']);
            $whr["date(" . $field . ") >="] = date('Y-m-d', strtotime($post_advfrom_date));

            return true;
        }

        return false;
    }

    /**
     * @param object $input
     * @param int $user_role_id
     * @param int $session_user_id
     * @return array
     */
    public function buildWhereClause($input, $user_role_id, $session_user_id,$company_code=null)
    {
        $where = [];
        $properties = new Properties($this->db);

        $orderMappings = $this->getOrderFieldsMapping();
        $orderDetailsMappings = $this->getOrderDetailFieldsMapping();

        foreach ($orderMappings as $field => $value) {
            if (isset($this->post[$value]) && $this->post[$value] != "") {
                $where[self::ORDER_TABLE_ALIAS . '.' . $field] = $this->db->escape_str($input->post($value, true) ?? $input->get($value, true));
            }
        }

        foreach ($orderDetailsMappings as $field => $value) {
            if (isset($this->post[$value]) && $this->post[$value] != "") {
                $where[self::ORDER_DETAILS_TABLE_ALIAS . '.' . $field] = $this->db->escape_str($input->post($value, true) ?? $input->get($value, true));
            }
        }

        $properties->getCustomerById($this->post,$where,$company_code);
        $properties->getCustomerByName($this->post,$where);
        $properties->getCarrierByName($this->post,$where);

        $orderIds[] = $properties->getPurchaseOrder($this->post, $user_role_id, $session_user_id,$company_code);
        $orderIds[] = $properties->getDeliveryNote($this->post);
        $orderIds[] = $properties->getLoadPlanConote($this->post);

        foreach ($orderIds as $orderId) {
            if ($orderId !== false) {
                $where['o.id'] = $orderId;
                break;
            }
        }

        return $where;
    }

    /**
     * @return string[]
     */
    private function getOrderFieldsMapping()
    {
        return [
            'order_id' => 'order_id',
            'pickup_company' => 'searchshipper_name',
            'delivery_company' => 'searchconsignee_name',
            'product' => 'product',
            'transport_mode' => 'modeof_trasnport',
            'pickup_custid' => 'searchshipper_id',
            'drop_custid' => 'searchconsignee_id',
            'shipmentid' => 'trip_id',
            'company_code' => 'company_code',
            'branch_code' => 'branch_code'
        ];
    }

    /**
     * @return string[]
     */
    private function getOrderDetailFieldsMapping()
    {
        return [
            'service' => 'service',
            'order_type' => 'order_type'
        ];
    }
}
