<?php

namespace App\Models\OrderList\Search;

use \Exception;

/**
 * Class Properties
 * @package App\Models\OrderList\Search
 */
class Properties implements SearchInterface
{
    private $db;

    /**
     * Properties constructor.
     * @param object $db
     */
    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * @param array $result
     * @return string
     */
    public function getInvoices($result)
    {
        $html = "";
        $finalJfr = "";
        $invoices = $debtorJfrArray = [];
        if (isset($result['invoice_details']) && !empty($result['invoice_details'])) {
            $invoices = json_decode('[' . $result['invoice_details'] . ']', true);
        }
        foreach ($invoices as $invoice) {
            $invoice_status = $invoice['invoice_status'] ?? "";
            $recipient_name = $invoice['recipient_name'] ?? "";
            $amount = $invoice['amount'] ?? "0";
            $debtorJfr = $invoice['debtor_jfr'] ?? "";
            $status = isset(self::INVOICE_STATUSES[$invoice_status]) ? self::INVOICE_STATUSES[$invoice_status] : 0;
            $type = (isset($invoice['type']) && $invoice['type'] !== 0) ? 1 : 0;
            $text = $type ? "<b>(Cost)</b> " : "<b>(Rev)</b> ";
            $statusName = is_array($status) ? self::INVOICE_STATUSES[$invoice_status][$type] : self::INVOICE_STATUSES[$invoice_status];
            $html .= $text . $recipient_name . " : " . $statusName . " - [" . $amount . ']<br>';
            if($debtorJfr != "") {
                $debtorJfrArray[] = $debtorJfr;
            }
        }
        if(!empty($debtorJfrArray)){
            $debtorJfrArray = array_unique($debtorJfrArray);
            $finalJfr = implode("",$debtorJfrArray);
        }
        return ['html'=>$html,'finaljfr'=>$finalJfr];
    }

    /**
     * @param array $result
     * @return array
     */
    public function getReferences($result)
    {
        $references = [];

        $placeholder['container_no'] = [];
        $placeholder['delivery_notp'] = [];
        $placeholder['manifestno'] = [];
        $placeholder['loadplanconnote'] = [];
        $placeholder['salog_ref'] = [];
        $placeholder['pq_ref'] = [];
        $placeholder['pos_ref'] = [];
        $placeholder['purchase_order'] = [];

        $data['container_no'] = "";
        $data['delivery_note'] = "";
        $data['manifestno'] = "";
        $data['loadplanconnote'] = "";
        $data['salog_ref'] = "";
        $data['pq_ref'] = "";
        $data['pos_ref'] = "";
        $data['purchase_order'] = "";

        if (isset($result['reference_value']) && !empty($result['reference_value'])) {
            $references = json_decode('[' . $result['reference_value'] . ']', true);
        }

        foreach ($references as $item) {
            foreach ($item as $type => $value) {
                if ($type == "CTR" || $type == "AWB") {
                    $placeholder['container_no'][] = $value;
                    $data['container_no'] = implode(", ", $placeholder['container_no']);
                } elseif ($type == "DQ") {
                    $placeholder['delivery_note'][] = $value;
                    $data['delivery_note'] = implode(", ", $placeholder['delivery_note']);
                } elseif ($type == "MN") {
                    $placeholder['manifestno'][] = $value;
                    $data['manifestno'] = implode(", ", $placeholder['manifestno']);
                } elseif ($type == "LPC") {
                    $placeholder['loadplanconnote'][] = $value;
                    $data['loadplanconnote'] = implode(", ", $placeholder['loadplanconnote']);
                } elseif ($type == "XSR") {
                    $placeholder['salog_ref'][] = $value;
                    $data['salog_ref'] = implode(", ", $placeholder['salog_ref']);
                } elseif ($type == "POS") {
                    $placeholder['pos_ref'][] = $value;
                    $data['pos_ref'] = implode(", ", $placeholder['pos_ref']);
                } elseif ($type == "PO") {
                    $placeholder['purchase_order'][] = $value;
                    $data['purchase_order'] = implode(", ", $placeholder['purchase_order']);
                }  elseif ($type == "PQ") {
                    $placeholder['pq_ref'][] = $value;
                    $data['pq_ref'] = implode(", ", $placeholder['pq_ref']);
                }
            }
        }

        return $data;
    }

    /**
     * @param array $result
     * @return string
     */
    public function getStatusName($result)
    {
        $order_status = 'PENDING';
        if ( $result['trip_id'] != 0 && $result['trip_sts'] == 0 ) {
            $order_status = 'ACTIVE';
        } elseif ( $result['trip_id'] != 0 && $result['trip_sts'] == 1 ) {
            $order_status = 'CLOSED';
        }

        //Manifest and scanned status added in KNAU (company-code)
        if ( ($order_status == 'PENDING') && ($result['company_code'] == 'AUKN' || $result['company_code'] == 'KNAU')) {
            $statuslist = $this->db->select( "status_code" )->order_by( "id", "DESC" )->get_where( "tb_order_status", array( 'order_id' => $result['id'], 'status' => '1' ) );

            if ( $statuslist->num_rows() > 0 ) {
                $status_code = $statuslist->row()->status_code;

                if ( $status_code == '2491' ) {
                    $order_status = "SCANNED";
                }
                if ( $status_code == '2492' ) {
                    $order_status = 'MANIFESTED';
                }
            }
        }

        if($order_status == 'PENDING') {
            $status_name = $this->db->select("COUNT(trip_id) AS tripno")->get_where("tb_employee", ['order_id' => $result['order_id']]);

            if ($status_name->num_rows() > 0) {
                $tripno = $status_name->row()->tripno;

                if ($tripno) {
                    $order_status = $result['trip_sts'] ? 'CLOSED' : 'ACTIVE';
                }
            }
        }
        if ($result['status'] == 3) {
            $order_status = 'CANCELLED';
        }
        //log_message("error","Status:".$order_status);
        return $order_status;
    }

    /**
     * @param array $post
     * @return string
     */
    public function getDateFieldName($post)
    {
        if ((isset($post['status'])) && ($post['status'] == "SCANNED")) {
            $field = "os.createdon";
        } elseif ((isset($post['status'])) && ($post['status'] == "MANIFESTED")) {
            $field = "o.pickup_datetime";
        } else {
            $field = "o.createdon";
        }

        return $field;
    }

    public function getLoadPlanConote($post)
    {
        if (isset($post['load_plan_connote']) && $post['load_plan_connote'] != "") {
            $query = "SELECT o.id FROM tb_orders o JOIN tb_order_references r ON o.id = r.order_id";
            $query .= " WHERE o.status != ? AND r.reference_id = ? AND r.ref_value = ?";

            $getpo = $this->db->query($query, [0, 'LPC', $post['load_plan_connote']]);

            return $getpo->num_rows() > 0 ? $getpo->row()->id : 0;
        }

        return false;
    }

    public function getPurchaseOrder($post, $user_role_id, $session_user_id,$company_code=NULL)
    {
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $query = "SELECT o.id FROM tb_orders o JOIN tb_order_references r ON o.id = r.order_id";
            $query .= ($user_role_id != '1') ? " WHERE o.user_id = ? AND " : " WHERE". (!empty($company_code)? ' o.company_code=? AND ':'');
            $query .= "o.status != ? AND r.reference_id = ? AND r.ref_value = ? AND r.status = ?";
            if($user_role_id != '1'){
                $getpo = $this->db->query($query, [$session_user_id,0, 'PO', $post['purchase_order'], 1]);
            }else{
                if(!empty($company_code)){
                    $getpo = $this->db->query($query, [$company_code,0, 'PO', $post['purchase_order'], 1]);
                }else{
                $getpo = $this->db->query($query, [0, 'PO', $post['purchase_order'], 1]);
                }
            }
            return $getpo->num_rows() > 0 ? $getpo->row()->id : 0;
        }

        return false;
    }

    public function getDeliveryNote($post)
    {
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $getdelivery_noteid = $this->db->select("order_id")
                ->get_where(
                    "tb_order_references",
                    [
                        'ref_value' => $post['delivery_note'],
                        'status' => '1', 'reference_id' => 'DQ'
                    ]
                );

            return $getdelivery_noteid->num_rows() > 0 ? $getdelivery_noteid->row()->order_id : 0;
        }

        return false;
    }

	public function getSalogref(array $post): int
	{
		$orderId = 0;
		if (isset($post['salog_ref']) && $post['salog_ref'] != "") {
			$getSalogReferenceId = $this->db->select("order_id")
				->get_where(
					"tb_order_references",
					[
						'ref_value' => $post['salog_ref'],
						'status' => '1', 'reference_id' => 'XSR'
					]
				);

			$orderId = $getSalogReferenceId->num_rows() > 0 ? $getSalogReferenceId->row()->order_id : 0;
		}
		return $orderId;
	}

    /**
     * @param array $exc_booking_id
     * @param \Order $order
     * @param array $ats_parties
     * @return bool
     */
    public function getOrderBookings($exc_booking_id, $order, &$ats_parties)
    {
        $booking_ids = $order->getOrderdetailsByOrderId($exc_booking_id, 'order_id');

        foreach ($booking_ids as $bookids) {
            $ats_parties[] = array('name' => $bookids['pickup_company'], 'street' => $bookids['pickup_address1'], 'city' => $bookids['pickup_city'], 'zipcode' => $bookids['pickup_pincode'], 'country' => $bookids['pickup_country'], 'type' => "shipper", 'booking_id' => $bookids['order_id']);
            $ats_parties[] = array('name' => $bookids['delivery_company'], 'street' => $bookids['delivery_address1'], 'city' => $bookids['delivery_city'], 'zipcode' => $bookids['delivery_pincode'], 'country' => $bookids['delivery_country'], 'type' => "consignee", 'booking_id' => $bookids['order_id']);
            $ats_parties[] = array('name' => $bookids['name'], 'street' => $bookids['street'], 'city' => $bookids['location'], 'zipcode' => $bookids['pincode'], 'country' => $bookids['country'], 'type' => "customer", 'booking_id' => $bookids['order_id']);

            $bookingvendor_id = isset($bookids['vendor_id']) ? $bookids['vendor_id'] : "";

            if($bookingvendor_id != "" && $bookingvendor_id >0) {
                $ats_parties[] = array('name' => $bookids['vendor_name'], 'street' => $bookids['street'], 'city' => $bookids['vendor_address'], 'zipcode' => $bookids['vendor_pincode'], 'country' => $bookids['vendor_country'], 'type' => "carrier", 'booking_id' => $bookids['order_id']);
            }
        }

        return true;
    }

    /**
     * For ATS,need to send shipper, consigne,customer,carrier details
     * @param string $id
     * @param \Order $order
     * @param array $ats_parties
     * @return array
     */
    public function getBooking($id, $order, &$ats_parties)
    {
        $booking = [];

        $getbooking_id = $order->getOrderdetailsByOrderId($id, 'id');

        if (!empty($getbooking_id)) {
            $booking = [$getbooking_id['order_id']];

            $ats_parties[] = array('name' => $getbooking_id['pickup_company'], 'street' => $getbooking_id['pickup_address1'], 'city' => $getbooking_id['pickup_city'], 'zipcode' => $getbooking_id['pickup_pincode'], 'country' => $getbooking_id['pickup_country'], 'type' => "shipper", 'booking_id' => $getbooking_id['order_id']);
            $ats_parties[] = array('name' => $getbooking_id['delivery_company'], 'street' => $getbooking_id['delivery_address1'], 'city' => $getbooking_id['delivery_city'], 'zipcode' => $getbooking_id['delivery_pincode'], 'country' => $getbooking_id['delivery_country'], 'type' => "consignee", 'booking_id' => $getbooking_id['order_id']);
            $ats_parties[] = array('name' => $getbooking_id['name'], 'street' => $getbooking_id['street'], 'city' => $getbooking_id['location'], 'zipcode' => $getbooking_id['pincode'], 'country' => $getbooking_id['country'], 'type' => "customer", 'booking_id' => $getbooking_id['order_id']);

            $bookingvendor_id = isset($getbooking_id['vendor_id']) ? $getbooking_id['vendor_id'] : "";

            if($bookingvendor_id != "" && $bookingvendor_id >0){
                $ats_parties[] = array('name' => $getbooking_id['vendor_name'], 'street' => $getbooking_id['street'], 'city' => $getbooking_id['vendor_address'], 'zipcode' => $getbooking_id['vendor_pincode'], 'country' => $getbooking_id['vendor_country'], 'type' => "carrier", 'booking_id' => $getbooking_id['order_id']);
            }
        }

        return $booking;
    }

    /**
     * @param array $result
     * @return string
     */
    public function getOtherStatus($result)
    {
        $otherstatus = '';

        if (!isset($result['order_status'])) {
            return $otherstatus;
        }

        if ($result['order_status'] == ''){
            try {
                $query = "SELECT order_status FROM tb_order_details WHERE order_row_id = ?";
                $result = $this->db->query($query, [$result['id']]);
                $row = $result->row();

                $otherstatus = isset($row->order_status) ? $row->order_status : '';
            } catch (Exception $e) {
                return $otherstatus;
            }
        }else{
                $otherstatus = $result['order_status'];
        }

        if ($otherstatus == '') {
            $otherstatus = isset($result['order_detail_status']) ? $result['order_detail_status'] : '';
        }

        $otherstatus = strtoupper($otherstatus);

        return ($otherstatus != 'READY' && $otherstatus != 'INVOICE') ? '' : $otherstatus;
    }

    /**
     * @param array $post
     * @param array $whr
     * @return bool
     */
    public function getCustomerById($post, &$whr,$company_code=null)
    {
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            try {
                $query = "SELECT id from tb_customers WHERE code = ? AND company_code = ? AND status = ?  LIMIT 1";
                $result = $this->db->query($query, [$post['searchcustomer_id'], $company_code, 1])->row();

                if ($result && isset($result->id)) {
                    $whr['o.customer_id'] = $result->id;
                } else {
                    $whr['o.id'] = '0';
                }
            } catch (\Exception $e) {
                return false;
            }

            return true;
        }

        return false;
    }

    /**
     * @param array $post
     * @param array $whr
     * @return bool
     */
    public function getCustomerByName($post, &$whr)
    {
        if (isset($post['searchcustomer_name']) && $post['searchcustomer_name'] != "") {
            try {
                $query = "SELECT id from tb_customers WHERE name LIKE ?";
                $result = $this->db->query($query, [$post['searchcustomer_name'] . '%'])->result_array();

                if ($result && count($result) > 0) {
                    $ids = array_map('current', $result);
                    if (isset($whr['o.customer_id']) && $whr['o.customer_id'] != '')
                    {
                        array_push($ids, $whr['o.customer_id']);
                    }
                    $whr['o.customer_id'] = implode(',', $ids);
                }
            } catch (\Exception $e) {
                return false;
            }

            return true;
        }

        return false;
    }

    /**
     * Get booking ids
     *
     * @param string $wildcardSearchValue
     * @param array $searchIds
     * @param string $company_code
     * @param int $user_id
     * @param array $countryids
     * @return array|array[]
     */
    public function getOrderIdsMapping($wildcardSearchValue, $searchIds, $company_code, $user_id, $countryids)
    {
        try {
            $binds = [];

            //remove any special characters (security fix)
            $wildcard = preg_replace('/[^A-Za-z0-9]/', '', $wildcardSearchValue);

            if($wildcardSearchValue != "" || !empty($searchIds)) {
                $query = "SELECT order_id FROM tb_orders WHERE status != ?";
                $binds[] = 0;

                if($wildcardSearchValue != "" && !empty($searchIds)) {
                    $query .= ' AND (order_id LIKE ? OR order_id IN ?)';
                    $binds[] = $wildcard . '%';
                    $binds[] = $searchIds;
                } elseif (!empty($searchIds)) {
                    $query .= ' AND order_id IN ?';
                    $binds[] = $searchIds;
                } elseif ($wildcardSearchValue != "") {
                    $query .= ' AND order_id LIKE ?';
                    $binds[] = $wildcard . '%';
                }

                if (in_array('orders', checkuserpermissions())) {
                    $query .= " AND company_code = ?";
                    $binds[] = $company_code;
                } elseif ($user_id) {
                    $query .= " AND user_id = ?";
                    $binds[] = $user_id;
                } elseif (!empty($countryuids) && $user_id) {
                    $query .= " AND user_id IN ?";
                    $binds[] = $countryids;
                }

                $query .= " GROUP BY order_id ORDER BY createdon DESC";
                $result = $this->db->query($query, $binds)->result_array();

                //return tb_orders::order_id
                if ($result && !empty($result)) {
                    return array_unique(array_map('current', $result));
                }
            }

            return [];
        } catch (Exception $e) {
            return [];
        }
    }

    public function getCarrierByName($post, &$whr)
    {
        if (isset($post['carrier']) && $post['carrier'] != "") {
            try {
                $query = "SELECT id from tb_vendors WHERE name LIKE ?";
                $result = $this->db->query($query, [$post['carrier'] . '%'])->result_array();

                if ($result && count($result) > 0) {
                    $ids = array_map('current', $result);
                    if (isset($whr['o.vendor_id']) && $whr['o.vendor_id'] != '')
                    {
                        array_push($ids, $whr['o.vendor_id']);
                    }
                    $whr['o.vendor_id'] = implode(',', $ids);
                }
            } catch (\Exception $e) {
                return false;
            }

            return true;
        }

        return false;
    }
}
