<?php

namespace App\Models\OrderList\Search;

/**
 * Class Search
 * @package App\Models\OrderList
 */
class Search
{
    private $db;
    private $post;

    /**
     * Properties constructor.
     * @param object $db
     */
    public function __construct($db, $post)
    {
        $this->db = $db;
        $this->post = $post;
    }

    public function toDate($field, &$whr)
    {
        if (isset($this->post['todate']) && $this->post['todate'] != "") {
            $post_todate = $this->db->escape_str($this->post['todate']);
            $whr["date(" . $field . ") <="] = date('Y-m-d', strtotime($post_todate));

            return  true;
        }

        return false;
    }

    public function fromDate($field, &$whr)
    {
        $todate = date('Y-m-d');

        if (isset($this->post['fromdate']) && $this->post['fromdate'] != "") {
            $post_fromdate = $this->db->escape_str($this->post['fromdate']);
            $fromdate = date('Y-m-d', strtotime($post_fromdate));

            $whr["date(" . $field . ") >="] = $fromdate;
            $whr["date(" . $field . ") <="] = $todate;

            return true;
        }

        return false;
    }
}