<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;
/**
 * Auxillary table of extra information about an order. Has 1:1 linkage to
 * `tb_orders`.
 */
class Order_details extends Table
{
	const TABLE = "tb_order_details";

    const CHARACTER_ID_COL = "character_id";
    const CHARACTER_NAME_COL = "character_name";
    const CLIENT_COL = "client";
    const CONSIGNMENT_NOTE_COL = "consignment_note";
    const COST_CENTER_ID_COL = "cost_center_id";
    const CREATEDON_COL = "createdon";
    const CUSTOMS_REQUIRED_COL = "customs_required";
    const CUST_PAYMENT_COL = "cust_payment";
    const DELIVERY_NOTE_COL = "delivery_note";
    const DELIVERY_REQUEST_COL = "delivery_request";
    const DELIVERY_TERM_COL = "delivery_term";
    const DEPARTMENT_CODE_COL = "department_code";
    const DISTANCE_COL = "distance";
    const DOCS_RECEIVED_DATETIME_COL = "docs_received_datetime";
    const DOCS_SENT_DATETIME_COL = "docs_sent_datetime";
    const GOODS_DESCRIPTION_COL = "goods_description";
    const HIGH_CARGO_VALUE_COL = "high_cargo_value";
    const ID_COL = "id";
    const INCOTERM_COL = "incoterm";
    const LANE_REFERENCE_COL = "lane_reference";
    const MAIL_NOTIFY_COL = "mail_notify";
    const MAIL_NOTIFY_DATETIME_COL = "mail_notify_datetime";
    const NOTIFY_PARTY_COL = "notify_party";
    const NUM_OF_PALLETS_COL = "num_of_pallets";
    const ORDER_ID_COL = "order_id";
    const ORDER_REMARKS_COL = "order_remarks";
    const ORDER_ROW_ID_COL = "order_row_id";
    const ORDER_STATUS_COL = "order_status";
    const ORDER_TYPE_COL = "order_type";
    const ORD_NUM_COL = "ord_num";
    const PO_DATE_COL = "po_date";
    const PO_TYPE_COL = "po_type";
    const PURCHASE_ORDER_COL = "purchase_order";
    const REVENUE_CURRENCY_COL = "revenue_currency";
    const REVENUE_PRICE_COL = "revenue_price";
    const RUSH_FLAG_COL = "rush_flag";
    const SERVICE_COL = "service";
    const SHIPMENTBY_COL = "shipmentby";
    const SHIPMENT_ID_COL = "shipment_id";
    const SHIPPER_ID_COL = "shipper_id";
    const STATUS_COL = "status";
    const TEMPERATURE_CONTROL_COL = "temperature_control";
    const UPDATEDON_COL = "updatedon";
    const VALORANCE_INSURANCE_COL = "valorance_insurance";
    const WAREHOUSE_COL = "warehouse";

    public $character_id; // varchar(30)	NULL=YES
    public $character_name; // varchar(60)	NULL=YES
    public $client; // varchar(30)	NULL=YES
    public $consignment_note; // varchar(50)	NULL=YES
    public $cost_center_id; // int(11)	NULL=YES
    public $createdon; // datetime	NULL=NO
    public $cust_payment; // varchar(30)	NULL=YES
    public $customs_required; // tinyint(1)	NULL=NO
    public $delivery_note; // varchar(500)	NULL=YES
    public $delivery_request; // varchar(30)	NULL=YES
    public $delivery_term; // varchar(60)	NULL=YES
    public $department_code; // varchar(30)	NULL=YES
    public $distance; // varchar(60)	NULL=YES
    public $docs_received_datetime; // varchar(50)	NULL=YES
    public $docs_sent_datetime; // varchar(50)	NULL=YES
    public $goods_description; // mediumtext	NULL=YES
    public $high_cargo_value; // tinyint(1)	NULL=NO
    public $id; // int(11)	NULL=NO
    public $incoterm; // varchar(60)	NULL=YES
    public $lane_reference; // varchar(60)	NULL=YES
    public $mail_notify; // int(2)	NULL=YES
    public $mail_notify_datetime; // varchar(22)	NULL=YES
    public $notify_party; // varchar(60)	NULL=YES
    public $num_of_pallets; // int(11)	NULL=YES
    public $ord_num; // varchar(30)	NULL=YES
    public $order_id; // varchar(60)	NULL=YES
    public $order_remarks; // varchar(255)	NULL=YES
    public $order_row_id; // int(11)	NULL=YES
    public $order_status; // varchar(60)	NULL=YES
    public $order_type; // varchar(60)	NULL=YES
    public $po_date; // varchar(30)	NULL=YES
    public $po_type; // varchar(30)	NULL=YES
    public $purchase_order; // varchar(500)	NULL=YES
    public $revenue_currency; // varchar(20)	NULL=YES
    public $revenue_price; // varchar(30)	NULL=YES
    public $rush_flag; // varchar(10)	NULL=YES
    public $service; // varchar(60)	NULL=YES
    public $shipment_id; // varchar(30)	NULL=YES
    public $shipmentby; // varchar(30)	NULL=YES
    public $shipper_id; // int(11)	NULL=YES
    public $status; // tinyint(4)	NULL=NO
    public $temperature_control; // tinyint(1)	NULL=NO
    public $updatedon; // timestamp	NULL=NO
    public $valorance_insurance; // tinyint(1)	NULL=NO
    public $warehouse; // varchar(30)	NULL=YES

    public function getOrderRouteDetails(string $bookingId): array
    {
        $this->db->select("o.id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,v.name,o.company_code");
        $this->db->from("tb_orders o");
        $this->db->join("tb_vendors v", "v.id=o.vendor_id", "LEFT");
        $this->db->where("o.order_id", $bookingId);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getOrderStatuses(string $timeZone, string $bookingId, int $shiftId, int $orderRowId = 0, string $companyCode = ''): array
    {
        if($orderRowId >0){
            if($companyCode == ""){
                $companyCode = $this->session->userdata("company_code");
            }
            $this->load->model("smtcorder");
            $result = $this->smtcorder->getStopStatusForOrder(['orderId' => $orderRowId, 'timeZone' => $timeZone, 'orderCompanyCode' => $companyCode]);
        }else{
            $sql = "SELECT
          ts.id,
          ts.latitude,
          ts.longitude,
          ts.loc_name,
          ts.stop_id,
          ts.stop_type,
          ts.status_code,
          convertToClientTZ(ts.createdon, ?) as createdon,
          sm.id as status_master_id,
          sm.status_name,
          ts.comment
        from
          tb_stop_status ts,
          tb_status_master sm,
          tb_employee e
        WHERE
          sm.id = ts.status_id
          AND ts.shipment_id = e.shift_id
          AND e.order_id = ?
          AND ts.shipment_id = ?
          AND (
            ts.stop_detail_id = 0
            OR ts.stop_detail_id = e.id
          )
        GROUP BY
          ts.id
        ORDER BY
          ts.id ASC";
            $getResult = $this->db->query($sql, [$timeZone, $bookingId, $shiftId]);
            $result = $getResult->num_rows() > 0 ? $getResult->result_array() : [];
        }
        return $result;
    }

    public function getHandlingUnitId(string $unitName, array $info): int
    {
        $unitId = 0;
        $this->db->select("id");
        $this->db->from("tbl_shipunit_types");
        $this->db->where("status", 1);
        $this->db->like("unit_name", $unitName);
        $this->db->limit(1);
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            $unitId = $getResult->row()->id;
        } else {
            $handlingUnitData = [
                'unit_name' => $unitName,
                'description' => $unitName,
                'user_id' => $info['userId'],
                'created_at' => $info['dateTime'],
                'status' => '1'
            ];
            $this->db->insert("tbl_shipunit_types", $handlingUnitData);
            $unitId = $this->db->insert_id();
        }
        return $unitId;
    }
    public function getPickupAndDeliveryDates($orderId)
    {
        $result = [];
        $this->db->select("o.order_id,s.status_code,s.createdon");
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status s", "o.id=s.order_id");
        $this->db->where("o.id", $orderId);
        $this->db->where_in("s.status_code", ['0500','3000']);
        $result = $this->db->get()->result();
        $deliveryDate = $pickUpDate = '';
        foreach ($result as $values) {
            if ($values->status_code == "3000") {
                $deliveryDate = $values->createdon;
            }
            if ($values->status_code == "0500") {
                $pickUpDate = $values->createdon;
            }
        }
        return ['delivery_date' => $deliveryDate, 'pickup_date' => $pickUpDate];
    }

    public function checkShipmentCreation(int $ord_id): array
    {
        $this->db->select("shift_id,vendor_id");
        $this->db->from("tb_orders");
        $this->db->where("id", $ord_id);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getCustomerReferencesBySearchTerm(string $type, array $customerIds, string $searchTerm): array
    {
        $sql = "SELECT
                  r.ref_value
                FROM
                  tb_order_references r,
                  tb_orders o
                WHERE
                  r.order_id = o.id
                  AND o.customer_id IN ?
                  AND r.reference_id IN ?
                  AND r.ref_value LIKE concat(?, '%')
                  AND r.status = 1
                  AND o.status != 0 ";
        if ($type == 'active') {
            $sql .= " AND o.trip_id >= 0 AND o.trip_sts=0";
        } elseif ($type == 'ready') {
            $sql .= " AND  o.order_status = 'READY' AND o.trip_id=0 AND o.trip_sts=0";
        } elseif ($type == 'pending') {
            $sql .= " AND o.trip_id=0 AND o.trip_sts=0";
        } elseif ($type == 'done') {
            $sql .= " AND o.trip_sts=1";
        }
        $sql .= " GROUP BY
                  r.id
                ORDER BY
                    r.createdon ASC
                LIMIT
                  15
                ";
        if (empty($customerIds) || $searchTerm == '') {
            return [];
        }
        $getResult = $this->db->query($sql, [$customerIds, ['DQ', 'XSR', 'AWB', 'MAWB', 'TKN', 'INV'], $searchTerm]);
         log_message("error","Qry:".$this->db->last_query());
        foreach ($getResult->result_array() as $eachRow) {
            $data[] = ["id" => $eachRow['ref_value'], "text" => $eachRow['ref_value']];
        }
        return $data ?? [];
    }

    public function getUserReferencesBySearchTerm(array $userIds, string $searchTerm): array
    {
        $vendorId = $this->session->userdata("id");
        $sql = "SELECT
                  r.ref_value
                FROM
                  tb_order_references r,
                  tb_orders o
                WHERE
                  r.order_id = o.id
                  AND o.user_id IN ?
                  AND r.reference_id IN ?
                  AND r.ref_value LIKE concat(?, '%')
                  AND r.status = 1
                  AND o.status != 0
                 " . ($this->session->userdata("user_role_id") == 3 ? "AND o.vendor_id = ?" : "") . "
                GROUP BY
                  r.id
                ORDER BY
                    r.createdon ASC
                LIMIT
                  15
                ";
        if ((empty($userIds) || $searchTerm == '') && ($this->session->userdata("user_role_id") != 3)) {
            return [];
        }
        $bindings = [
            $userIds,
            ['DQ', 'XSR', 'AWB', 'MAWB', 'TKN', 'INV'],
            $searchTerm,
        ];

        // Bind vendor_id parameter if user_role_id is 3
        if ($this->session->userdata("user_role_id") == 3) {
            $bindings[] = $this->session->userdata("id");
        }
        $getResult = $this->db->query($sql, $bindings);

        foreach ($getResult->result_array() as $eachRow) {
            $data[] = ["id" => $eachRow['ref_value'], "text" => $eachRow['ref_value']];
        }
        return $data ?? [];
    }

    public function getShipmentStops(array $shiftsIdsData): array
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'] ?? DFLT_TZ;
        $query = $this->db->query(
            "SELECT
                id, shipment_id,order_id,
                stopname,address,plat,plng,stoptype,stopstatus,ordernumber,
                convertToClientTZ(startdate,'" . $curtz . "') as startdate,
                convertToClientTZ(enddate,'" . $curtz . "') as enddate,
                weight,volume,ship_units
             FROM tb_shiporder_stops
             WHERE status = 1 AND shipment_id IN ?
             ORDER BY ordernumber ASC", [$shiftsIdsData]
        );
        if (!$query) {
            return [];
        }
        foreach ($query->result_array() as $row) {
            $row["act_ship_units"] = $row['ship_units'];
            $empDetails = $this->getemployeeDetails($row['stoptype'], $row['id']);
            $row["shipment_volume"] = $empDetails->shipment_volume ?? "0";
            $row["order_id"] = $empDetails->order_id ?? 0;
            $row["no_of_pkgs"] = $empDetails->no_of_pkgs ?? 0;
            $row["accepted"] = $empDetails->accepted ?? 0;
            $ShiporderStops[$row['shipment_id']] [] = $row;
        }
        return $ShiporderStops ?? [];
    }

    public function getemployeeDetails(string $stoptype, int $stopid): array
    {
        $where = "";
        if ($stoptype == "P") {
            $where = "stop_id = ? AND status= ?";
        }
        if ($stoptype == "D") {
            $where = "drop_stopid = ? AND status= ?";
        }
        $query = $this->db->query(
            "SELECT
            id, order_id,
            stop_id, drop_stopid,
            shipment_volume, no_of_pkgs, accepted
        FROM tb_employee
        WHERE '.$where.'",
            [$stopid, 1]
        );
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getPendingOrderIdsByCarrier(array $data): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.order_id FROM tb_orders o WHERE o.vendor_id IN ? AND o.status!=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0)  AND o.trip_sts=0 " . $data['whereCondition'] . " GROUP BY o.order_id ORDER BY o.pickup_datetime DESC", [$data['carrierCondition']]
        );
        foreach ($query->result_array() as $eachOrderId) {
            $orderIds[] = $eachOrderId['id'];
            $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
        }
        if (checkAccessConditions('CHECK_CUSTOM_BROKERAGE_EXITS', $data['companyCode']) && checkAccessConditions('CHECK_CUSTOM_BROKERAGE_CIDS', $data['carrierCode'])) {
            $partyDetails = $this->getCustomBarrierData($data);
            $partyMasterId = $partyDetails['partyMasterId'];
            $partyTypeIds = $partyDetails['partyTypeIds'];
            if ($partyMasterId === 0) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            if (empty($partyTypeIds)) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            $this->db->select('o.id,o.order_id');
            $this->db->from("tb_orders o");
            $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "RIGHT");
            $this->db->where("o.status!=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0)  AND o.trip_sts=0 " . $data['whereCondition']);
            $getCustomBarrierData = $this->db->get();
            foreach ($getCustomBarrierData->result_array() as $eachOrderId) {
                $orderIds[] = $eachOrderId['id'];
                $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
            }
        }
        return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
    }

    public function getActiveOrderIdsByCarrier(array $data): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.order_id FROM tb_orders o  WHERE o.vendor_id IN ?  AND o.status NOT IN (0,3) AND o.trip_id!=0 AND (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.trip_sts=0 " . $data['whereCondition'] . "  GROUP BY o.order_id ORDER BY o.pickup_datetime DESC", [$data['carrierCondition']]
        );
        foreach ($query->result_array() as $eachOrderId) {
            $orderIds[] = $eachOrderId['id'];
            $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
        }
        if (checkAccessConditions('CHECK_CUSTOM_BROKERAGE_EXITS', $data['companyCode']) && checkAccessConditions('CHECK_CUSTOM_BROKERAGE_CIDS', $data['carrierCode'])) {
            $partyDetails = $this->getCustomBarrierData($data);
            $partyMasterId = $partyDetails['partyMasterId'];
            $partyTypeIds = $partyDetails['partyTypeIds'];
            if ($partyMasterId === 0) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            if (empty($partyTypeIds)) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            $this->db->select('o.id,o.order_id');
            $this->db->from("tb_orders o");
            $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "RIGHT");
            $this->db->where("o.status !=0 AND o.trip_id!=0 AND (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.trip_sts=0 " . $data['whereCondition']);
            $getCustomBarrierData = $this->db->get();
            foreach ($getCustomBarrierData->result_array() as $eachOrderId) {
                $orderIds[] = $eachOrderId['id'];
                $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
            }
        }
        return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
    }

    public function getCustomBarrierData(array $data): array
    {
        $getPartyMasterId = $this->db->query("SELECT id FROM tbl_party_master WHERE code = ? AND company_code = ? AND status = ?", [$data['carrierCode'], $data['companyCode'], '1']);
        $partyMasterId = $getPartyMasterId->num_rows() > 0 ? $getPartyMasterId->row()->id : 0;
        $getCustomBarrierPartyTypeId = $this->db->query("SELECT id FROM tbl_party_types WHERE name = ? AND company_code = ? AND status = ?", ['Customs Brokerage', $data['companyCode'], '1']);
        $partyIds = $getCustomBarrierPartyTypeId->num_rows() > 0 ? $getCustomBarrierPartyTypeId->result_array() : [];
        foreach ($partyIds as $eachId) {
            $partyTypeIds[] = $eachId['id'];
        }
        return ['partyMasterId' => $partyMasterId ?? 0, 'partyTypeIds' => $partyTypeIds ?? []];
    }

    public function getCustomBarrierPendingOrders(array $data)
    {
        $partyDetails = $this->getCustomBarrierData($data);
        $partyMasterId = $partyDetails['partyMasterId'];
        $partyTypeIds = $partyDetails['partyTypeIds'];
        if ($partyMasterId === 0) {
            return [];
        }
        if (empty($partyTypeIds)) {
            return [];
        }
        $this->db->select('r.id,r.reference_id,r.ref_value');
        $this->db->from('tb_order_references r');
        $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
        $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "INNER");
        $this->db->where("o.status!=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0)  AND o.trip_sts=0");
        if ($data['searchTerm'] != "") {
            $this->db->where_in('r.ref_value', $data['searchTerm']);
        }
        $this->db->where_in('r.reference_id', ['DQ', 'XSR']);
        $this->db->group_by('r.id');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomBarrierActiveOrders(array $data)
    {
        $partyDetails = $this->getCustomBarrierData($data);
        $partyMasterId = $partyDetails['partyMasterId'];
        $partyTypeIds = $partyDetails['partyTypeIds'];
        if ($partyMasterId === 0) {
            return [];
        }
        if (empty($partyTypeIds)) {
            return [];
        }
        $this->db->select('r.id,r.reference_id,r.ref_value');
        $this->db->from('tb_order_references r');
        $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
        $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "INNER");
        $this->db->where("o.status !=0 AND o.trip_id!=0 AND (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.trip_sts=0");
        if ($data['searchTerm'] != "") {
            $this->db->where_in('r.ref_value', $data['searchTerm']);
        }
        $this->db->where_in('r.reference_id', ['DQ', 'XSR']);
        $this->db->group_by('r.id');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomBarrierClosedOrders(array $data)
    {
        $partyDetails = $this->getCustomBarrierData($data);
        $partyMasterId = $partyDetails['partyMasterId'];
        $partyTypeIds = $partyDetails['partyTypeIds'];
        if ($partyMasterId === 0) {
            return [];
        }
        if (empty($partyTypeIds)) {
            return [];
        }
        $this->db->select('r.id,r.reference_id,r.ref_value');
        $this->db->from('tb_order_references r');
        $this->db->join('tb_orders o', 'r.order_id=o.id', 'INNER');
        $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "INNER");
        $this->db->where("o.status !=0 AND o.trip_sts = 1");
        if ($data['searchTerm'] != "") {
            $this->db->where_in('r.ref_value', $data['searchTerm']);
        }
        $this->db->where_in('r.reference_id', ['DQ', 'XSR']);
        $this->db->group_by('r.id');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsByCarrier(array $data): array
    {
        if(empty($data['orderIds'])) {
            return [];
        }
        $query = $this->db->query("SELECT o.id,o.order_id,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,o.pickup_city,o.pickup_country,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.delivery_city,o.delivery_country,o.shift_id,o.trip_id,o.created_source FROM tb_orders o WHERE o.id IN ? ORDER BY o.pickup_datetime DESC LIMIT ?, ?", [$data['timeZone'], $data['timeZone'], $data['orderIds'], (int) $data['start'], (int)$data['limit']]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getClosedOrderIdsByCarrier(array $data): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.order_id FROM tb_orders o  WHERE o.vendor_id IN ?  AND o.status != ? AND (o.trip_sts = ? OR ((o.trip_sts = ? AND o.status = ?))) " . $data['whereCondition'] . "  GROUP BY o.order_id ORDER BY o.pickup_datetime DESC", [$data['carrierCondition'], '0', '1', 0, 3]
        );
        foreach ($query->result_array() as $eachOrderId) {
            $orderIds[] = $eachOrderId['id'];
            $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
        }
        if (checkAccessConditions('CHECK_CUSTOM_BROKERAGE_EXITS', $data['companyCode']) && checkAccessConditions('CHECK_CUSTOM_BROKERAGE_CIDS', $data['carrierCode'])) {
            $partyDetails = $this->getCustomBarrierData($data);
            $partyMasterId = $partyDetails['partyMasterId'];
            $partyTypeIds = $partyDetails['partyTypeIds'];
            if ($partyMasterId === 0) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            if (empty($partyTypeIds)) {
                return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
            }
            $this->db->select('o.id,o.order_id');
            $this->db->from("tb_orders o");
            $this->db->join("tb_order_parties op", "o.id= op.order_id AND op.party_id ='" . $partyMasterId . "' AND op.party_type IN (" . implode(',', $partyTypeIds) . ") AND op.status ='1'", "RIGHT");
            $this->db->where("o.status !=0 AND o.trip_sts = 1 " . $data['whereCondition']);
            $getCustomBarrierData = $this->db->get();
            foreach ($getCustomBarrierData->result_array() as $eachOrderId) {
                $orderIds[] = $eachOrderId['id'];
                $orderData[] = ['id' => $eachOrderId['order_id'], 'text' => $eachOrderId['order_id']];
            }
        }
        return ['orderIds' => $orderIds ?? [], 'orderData' => $orderData ?? []];
    }

    public function getPartyTypeNames(array $partyTypeIds): array
    {
        $partyTypeIds = (is_array($partyTypeIds) && !empty($partyTypeIds)) ? array_filter($partyTypeIds) : $partyTypeIds;
        $query = $this->db->query("SELECT id,name FROM tbl_party_types WHERE id IN (" . implode(',', $partyTypeIds) . ") GROUP BY name");
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

}
