<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Otmbookingmodel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'otmshipmentmodel']);
    }

    public function getOrderCount(string $table, array $values): int
    {
        $this->db->from($table);
        foreach ($values as $key => $value) {
            $this->db->where($key, $value);
        }

        $db_results = $this->db->get();
        return $db_results->num_rows();
    }

    public function checkOrderType(string $orderType,
        int $organizationId,
        int $businessEntityID,
        int $businessEntityValue
    ): int {
        $orderTypeData = [
            'order_type' => $orderType,
            /*'organization' => $organizationId,
            'business_entity' => $businessEntityID,
            'business_enity_value' => $businessEntityValue,*/
            'status' => 1,
        ];

        $getOrderType = $this->common->gettblrowdata($orderTypeData, 'id', 'tb_order_type', 0, 0);
        $orderTypeId = 0;
        if (!empty($getOrderType)) {
            $orderTypeId = $getOrderType['id'];
        }
        return $orderTypeId ?? 0;
    }

    public function checkModeOfTransport(
        string $modeOfTransport,
        int $organizationId,
        int $businessEntityID,
        int $businessEntityValue
    ): int {
        $modeOfTransportData = [
            'name' => $modeOfTransport,
            /*'organization' => $organizationId,
            'business_entity' => $businessEntityID,
            'business_enity_value' => $businessEntityValue,*/
            'status' => 1,
        ];
        $getmodeOfTransport = $this->common->gettblrowdata($modeOfTransportData, 'id', 'tb_mode_of_transport', 0, 0);
        $modeOfTransportId = 0;
        if (!empty($getmodeOfTransport)) {
            $modeOfTransportId = $getmodeOfTransport['id'];
        }

        return $modeOfTransportId ?? 0;
    }

    public function checkProduct(string $product, int $organizationId, int $businessEntityValue): int
    {
        $productData = [
            'name' => $product,
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'status' => 1,
        ];
        $getproduct = $this->common->gettblrowdata($productData, 'id', 'tb_product_master', 0, 0);
        if (!empty($getproduct)) {
            $productId = $getproduct['id'];
        } else {
            $productData['description'] = $product;
            $productData['createdby'] = $productData['modifiedby'] = 1;
            $productId = $this->common->insertTableData('tb_product_master', $productData);
        }
        return $productId ?? 0;
    }

    public function checkServiceType(string $serviceType, int $organizationId, int $businessEntityValue): int
    {
        $serviceTypeData = [
            'name' => $serviceType,
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'status' => 1,
        ];
        $getserviceType = $this->common->gettblrowdata($serviceTypeData, 'id', 'tb_service_master', 0, 0);
        if (!empty($getserviceType)) {
            $serviceTypeId = $getserviceType['id'];
        } else {
            $serviceTypeData['service_id'] = $serviceType;
            $serviceTypeData['createdby'] = $serviceTypeData['modifiedby'] = 1;
            $serviceTypeId = $this->common->insertTableData('tb_service_master', $serviceTypeData);
        }
        return $serviceTypeId ?? 0;
    }

    public function checkIncoTerm(string $incoterm,
        int $organizationId,
        int $businessEntityID,
        int $businessEntityValue): int {
        $incotermData = [
            'name' => $incoterm,
            'incoterm_code' => $incoterm,
            'organization' => $organizationId,
            'business_entity_value' => $businessEntityValue,
            'business_entity' => $businessEntityID,
            'status' => 1,
        ];
        $getincoterm = $this->common->gettblrowdata($incotermData, 'id', 'tb_incoterm_codes', 0, 0);
        if (!empty($getincoterm)) {
            $incotermID = $getincoterm['id'];
        } else {
            $incotermData['createdby'] = $incotermData['modifiedby'] = 1;
            $incotermID = $this->common->insertTableData('tb_incoterm_codes', $incotermData);
        }
        return $incotermID ?? 0;
    }

    public function getPartyTypeId(string $partyDataType): int
    {
        $partyTypeInfo = [
            "UPPER(party_role)" => strtoupper($partyDataType),
            "status" => 1,
        ];
        $checkPartyType = $this->db->select("id")->get_where("tb_party_roles", $partyTypeInfo, 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $party_type_id = $checkPartyType->row()->id;
        } else {
            $party_type_id = $this->common->insertTableData('tb_party_roles', $partyTypeInfo);
        }
        return $party_type_id ?? 0;
    }

    public function checkUser(string $company_code, string $branch_code, string $firstTwoChars): int
    {
        $userId = 0;
        $currentDate = date('Y-m-d H:i:s');
        $checkUser = $this->db->query(
            "SELECT id FROM tb_users WHERE company_code=? AND branch_code=? AND status='Active' LIMIT 1",
            [$company_code, $branch_code]
        );
        if ($checkUser->num_rows() > 0) {
            $userId = $checkUser->row()->id;
        } else {
            $checkUserCompany = $this->db->query(
                "SELECT user_id FROM tb_user_companies WHERE company_code=? AND branch_code=? AND status=1 LIMIT 1",
                [$company_code, $branch_code]
            );
            if ($checkUserCompany->num_rows() > 0) {
                $userId = $checkUserCompany->row()->user_id;
            } else {
                $adminPhone = time();
                $adminPassword = password_hash($adminPhone, PASSWORD_DEFAULT);
                $userData = [
                    'country_code' => $firstTwoChars,
                    'name' => $firstTwoChars . "_Admin",
                    'company_indv_name' => $company_code,
                    'business_type' => 'Truck_Owner',
                    'mobile_no' => $adminPhone,
                    'password' => $adminPassword,
                    'emailid' => 'etrucknow@kuehne-nagel.com',
                    'domain_name' => $branch_code,
                    'location_id' => 1646,
                    'createdby' => 1,
                    'status' => 'Active',
                    'createdon' => $currentDate,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                ];
                $userId = $this->common->insertTableData('tb_users', $userData);
            }
        }
        return $userId;
    }

    public function getUserTimeZone(int $user_id): string
    {
        $checkUser = $this->db->query("SELECT country_code FROM tb_users WHERE id=? AND status='Active' LIMIT 1",
            [$user_id]);
        if ($checkUser->num_rows() > 0) {
            $country_code = $checkUser->row()->country_code;
            $getqry = $this->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE (country_code=? OR country_name=?) AND status=1 LIMIT 1",
                [$country_code, $country_code]);
            if ($getqry && $getqry->num_rows() > 0) {
                $timeZone = $getqry->row()->cntry_timezone;
            } else {
                throw new RuntimeException("login user's timezone is undefined.");
            }
        }
        return $timeZone;
    }

    public function getUserId(string $username): int
    {
        $getUserId = $this->db->select('id')->get_where("tb_users", ['user_id' => $username]);
        return $getUserId->num_rows() > 0 ? $getUserId->row()->id : 0;
    }

    public function generateOrderBookingId(int $order_id, int $user_id): string
    {
        $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
        $country_code = $get_country->row()->country_code;
        $company_code = $get_country->row()->company_code;
        $genord = [
            "user_id" => $user_id,
            "order_id" => $order_id,
            "country_code" => $country_code,
            "company_code" => $company_code,
        ];
        return generatebookingid($genord);
    }

    public function insertOrder(
        array $orderData,
        array $customerInfo,
        array $sourceInfo,
        array $destinationInfo,
        int $ship_row_id,
        string $timeZone,
        string $company_code,
        string $branch_code,
        int $user_id
    ): int {
        $earlyPickupDatetime = (empty($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']);
        $e_pickup = str_replace("T", " ", $earlyPickupDatetime);
        $latePickupDatetime = (empty($orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']);
        $l_pickup = str_replace("T", " ", $latePickupDatetime);
        $earlyDeliveryDatetime = (empty($orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']);
        $e_delivery = str_replace("T", " ", $earlyDeliveryDatetime);
        $lateDeliveryDatetime = (empty($orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']) ? date('Y-m-d H:i:s') : $orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']);
        $l_delivery = str_replace("T", " ", $lateDeliveryDatetime);
        $getactual = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $timeZone);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $timeZone);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $timeZone);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $timeZone);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $timeZone);
        $l_delivery = $getldelivery['datetime'];
        $created_source = '4';
        $customer_id = $customerInfo['customer_id'];
        $customer_code = $customerInfo['party_code'];
        $pickup_custid = $sourceInfo['party_id'];
        $pickup_code = $sourceInfo['party_code'];
        $destination_custid = $destinationInfo['party_id'];
        $destination_code = $destinationInfo['party_code'];

        $plat = (empty($orderData['sourceInfo']['Address']['Latitude']) ? "" : $orderData['sourceInfo']['Address']['Latitude']);
        $plng = (empty($orderData['sourceInfo']['Address']['Longitude']) ? "" : $orderData['sourceInfo']['Address']['Longitude']);
        $sourceStreet = (empty($orderData['sourceInfo']['Address']['Street']) ? "" : $orderData['sourceInfo']['Address']['Street']);
        $sourceCity = (empty($orderData['sourceInfo']['Address']['City']) ? "" : $orderData['sourceInfo']['Address']['City']);
        $sourceCountry = (empty($orderData['sourceInfo']['Address']['Country']) ? "" : $orderData['sourceInfo']['Address']['Country']);
        $sourcePostal = (empty($orderData['sourceInfo']['Address']['Postal']) ? "" : $orderData['sourceInfo']['Address']['Postal']);
        if ($plat == "" && $plng == "") {
            $pickupaddress = implode(",", [$sourceStreet, $sourceCity, $sourceCountry, $sourcePostal]);
            $data = getlatlngsbyplace($pickupaddress);
            $plat = @$data[0];
            $plng = @$data[1];
        }

        $dlat = (empty($orderData['destinationInfo']['Address']['Latitude']) ? "" : $orderData['destinationInfo']['Address']['Latitude']);
        $dlng = (empty($orderData['destinationInfo']['Address']['Longitude']) ? "" : $orderData['destinationInfo']['Address']['Longitude']);
        $destinationStreet = (empty($orderData['destinationInfo']['Address']['Street']) ? "" : $orderData['destinationInfo']['Address']['Street']);
        $destinationCity = (empty($orderData['destinationInfo']['Address']['City']) ? "" : $orderData['destinationInfo']['Address']['City']);
        $destinationCountry = (empty($orderData['destinationInfo']['Address']['Country']) ? "" : $orderData['destinationInfo']['Address']['Country']);
        $destinationPostal = (empty($orderData['destinationInfo']['Address']['Postal']) ? "" : $orderData['destinationInfo']['Address']['Postal']);
        if ($dlat == "" && $dlng == "") {
            $dropaddress = implode(",",
                [$destinationStreet, $destinationCity, $destinationCountry, $destinationPostal]);
            $data = getlatlngsbyplace($dropaddress);
            $dlat = @$data[0];
            $dlng = @$data[1];
        }
        $orderQuantity = empty($orderData['cargoSummary']['TotalQuantity']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalQuantity']['Value'];
        $orderWeight = empty($orderData['cargoSummary']['TotalWeight']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalWeight']['Value'];
        $orderVolume = empty($orderData['cargoSummary']['TotalVolume']['Value']) ? "0.00" : $orderData['cargoSummary']['TotalVolume']['Value'];

        $orderinfo = [
            'customer_id' => $customer_id,
            'product' => $orderData['Product'],
            'pickup_datetime' => $e_pickup,
            'delivery_datetime' => $e_delivery,
            'pickup_endtime' => $l_pickup,
            'drop_endtime' => $l_delivery,
            'goods_value' => "0.00",
            'currency' => "",
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'drop_custid' => $destination_custid,
            'drop_partyid' => $destination_custid,
            'user_id' => $user_id,
            'sub_uid' => 0,
            'pickup_custid' => $pickup_custid,
            'pickup_partyid' => $pickup_custid,
            'pickup_country' => $sourceCountry ?? "",
            'pickup_city' => $sourceCity ?? "",
            'pickup_pincode' => $sourcePostal ?? "",
            'pickup_company' => (empty($orderData['sourceInfo']['Address']['CompanyName']) ? "" : $orderData['sourceInfo']['Address']['CompanyName']),
            'pickup_address1' => (empty($orderData['sourceInfo']['Address']['Address1']) ? "" : $orderData['sourceInfo']['Address']['Address1']),
            'pickup_address2' => (empty($orderData['sourceInfo']['Address']['Address2']) ? "" : $orderData['sourceInfo']['Address']['Address2']),
            'delivery_country' => $destinationCountry,
            'delivery_city' => $destinationCity,
            'delivery_pincode' => $destinationPostal,
            'delivery_company' => (empty($orderData['destinationInfo']['Address']['CompanyName']) ? "" : $orderData['destinationInfo']['Address']['CompanyName']),
            'delivery_address1' => (empty($orderData['destinationInfo']['Address']['Address1']) ? "" : $orderData['destinationInfo']['Address']['Address1']),
            'delivery_address2' => (empty($orderData['destinationInfo']['Address']['Address2']) ? "" : $orderData['destinationInfo']['Address']['Address2']),
            'is_created' => '1',
            'plat' => $plat,
            'plng' => $plng,
            'dlat' => $dlat,
            'dlng' => $dlng,
            'quantity' => $orderQuantity,
            'weight' => $orderWeight,
            'volume' => $orderVolume,
            'transport_mode' => $orderData['ModeOfTransport'],
            'created_source' => $created_source,
            'createdon' => date('Y-m-d H:i:s'),
            'external_order_id' => $orderData['EXTOrderID'],
        ];
        $order_id = $this->common->insertTableData('tb_orders', $orderinfo);
        return $order_id;
    }

    public function insertCargoInfo(array $orderCargo, int $order_id, int $organizationId, int $businessEntityValue): int
    {
        $ItemId = is_array($orderCargo['ItemId']) ? "0" : $orderCargo['ItemId'];
        $checkOrderCargoData = $this->db->select("id,package_type, goods_description, marks_and_numbers, handling_unit, length, length_uom,
			width, width_uom, height, height_uom, ldm, item_id, weight, weight_uom, volume, volume_uom, second_weight,
			second_weight_uom, actual_volume_metric, actual_volume_metric_uom, quantity, scanned_quantity,
			grounded, stackable, splittable, dangerous")->get_where("tb_order_cargo_details",
            [
                'order_id' => $order_id,
                'external_cargo_id' => $ItemId,
            ]);

        $lengthUomCode = $widthUomCode = $heightUomCode = $actualWeightUomCode = $actualVolumeUomCode = $weightUomCode = $volumeUomCode = 0;

        if (!empty($orderCargo['Length']['UOM'])) {
            $lengthUOM = $this->otmshipmentmodel->checkUOM($orderCargo['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($lengthUOM)) {
                $lengthUomCode = $this->otmshipmentmodel->getUOMId($lengthUOM);
            }*/
            $lengthUomCode = $lengthUOM;
        }
        if (!empty($orderCargo['Width']['UOM'])) {
            $widthUOM = $this->otmshipmentmodel->checkUOM($orderCargo['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($widthUOM)) {
                
                $widthUomCode =  = $this->otmshipmentmodel->getUOMId($widthUOM);
            }*/
            $widthUomCode = $widthUOM;
        }
        if (!empty($orderCargo['Height']['UOM'])) {
            $heightUOM = $this->otmshipmentmodel->checkUOM($orderCargo['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($heightUOM)) {
                $heightUomCode = $this->otmshipmentmodel->getUOMId($heightUOM);
            }*/
            $heightUomCode = $heightUOM;
        }
        if (!empty($orderCargo['ActualWeight']['UOM'])) {
            $actualWeightUOM = $this->otmshipmentmodel->checkUOM($orderCargo['ActualWeight']['UOM'], 'WT', $organizationId, $businessEntityValue);
            /*if (!empty($actualWeightUOM)) {
                
                $actualWeightUomCode  = $this->otmshipmentmodel->getUOMId($actualWeightUOM);
            }*/
            $actualWeightUomCode = $actualWeightUOM;
        }
        if (!empty($orderCargo['ActualVolume']['UOM'])) {
            $actualVolumeUOM = $this->otmshipmentmodel->checkUOM($orderCargo['ActualVolume']['UOM'], 'VO', $organizationId, $businessEntityValue);
            /*if (!empty($actualVolumeUOM)) {
                $actualVolumeUomCode = $this->otmshipmentmodel->getUOMId($actualVolumeUOM);
            }*/
            $actualVolumeUomCode = $actualVolumeUOM;
        }
        if (!empty($orderCargo['Weight']['UOM'])) {
            $weightUOM = $this->otmshipmentmodel->checkUOM($orderCargo['Weight']['UOM'], 'WT', $organizationId, $businessEntityValue);
            /*if (!empty($weightUOM)) {
                $weightUomCode = $this->otmshipmentmodel->getUOMId($weightUOM);
            }*/
            $weightUomCode = $weightUOM;
        }
        if (!empty($orderCargo['Volume']['UOM'])) {
            $volumeUOM = $this->otmshipmentmodel->checkUOM($orderCargo['Volume']['UOM'], 'VO', $organizationId, $businessEntityValue);
            /*if (!empty($volumeUOM)) {
                $volumeUomCode = $this->otmshipmentmodel->getUOMId($volumeUOM);
            }*/
            $volumeUomCode = $volumeUOM;
        }

        if ($checkOrderCargoData->num_rows() > 0) {
            $cargoType = is_array($orderCargo['PackageType']) ? $checkOrderCargoData->row()->package_type : $orderCargo['PackageType'];
            $GoodsDescription = is_array($orderCargo['GoodsDescription']) ? $checkOrderCargoData->row()->goods_description : $orderCargo['GoodsDescription'];
            $MarksandNumbers = is_array($orderCargo['MarksandNumbers']) ? $checkOrderCargoData->row()->marks_and_numbers : $orderCargo['MarksandNumbers'];
            $ValueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "" : $orderCargo['ValueOfGoods'];
            $HandlingUnit = is_array($orderCargo['HandlingUnit']) ? $checkOrderCargoData->row()->handling_unit : $orderCargo['HandlingUnit'];
            $LengthValue = is_array($orderCargo['Length']['Value']) ? $checkOrderCargoData->row()->length : $orderCargo['Length']['Value'];
            $LengthUom = is_array($lengthUomCode) ? $checkOrderCargoData->row()->length_uom : $lengthUomCode;
            $WidthValue = is_array($orderCargo['Width']['Value']) ? $checkOrderCargoData->row()->width : $orderCargo['Width']['Value'];
            $WidthUom = is_array($widthUomCode) ? $checkOrderCargoData->row()->width_uom : $widthUomCode;
            $HeightValue = is_array($orderCargo['Height']['Value']) ? $checkOrderCargoData->row()->height : $orderCargo['Height']['Value'];
            $HeightUom = is_array($heightUomCode) ? $checkOrderCargoData->row()->height_uom : $heightUomCode;
            $ActualWeightValue = is_array($orderCargo['ActualWeight']['Value']) ? $checkOrderCargoData->row()->weight : $orderCargo['ActualWeight']['Value'];
            $ActualWeightUom = is_array($actualWeightUomCode) ? $checkOrderCargoData->row()->weight_uom : $actualWeightUomCode;
            $WeightValue = is_array($orderCargo['Weight']['Value']) ? $checkOrderCargoData->row()->second_weight : $orderCargo['Weight']['Value'];
            $WeightUom = is_array($weightUomCode) ? $checkOrderCargoData->row()->second_weight_uom : $weightUomCode;
            $VolumetricWeightValue = is_array($orderCargo['VolumetricWeight']['Value']) ? "" : $orderCargo['VolumetricWeight']['Value'];
            $VolumetricWeightUom = is_array($orderCargo['VolumetricWeight']['UOM']) ? "" : $orderCargo['VolumetricWeight']['UOM'];
            $VolumeValue = is_array($orderCargo['Volume']['Value']) ? $checkOrderCargoData->row()->volume : $orderCargo['Volume']['Value'];
            $VolumeUom = is_array($volumeUomCode) ? $checkOrderCargoData->row()->volume_uom : $volumeUomCode;
            $ActualVolumeValue = is_array($orderCargo['ActualVolume']['Value']) ? $checkOrderCargoData->row()->actual_volume_metric : $orderCargo['ActualVolume']['Value'];
            $ActualVolumeUom = is_array($actualVolumeUomCode) ? $checkOrderCargoData->row()->actual_volume_metric_uom : $actualVolumeUomCode;
            $cargoQuantity = is_array($orderCargo['Quantity']) ? $checkOrderCargoData->row()->quantity : $orderCargo['Quantity'];
            $ScannedQuantity = is_array($orderCargo['ScannedQuantity']) ? $checkOrderCargoData->row()->scanned_quantity : $orderCargo['ScannedQuantity'];
            $ldm = 0;
            $itemId = is_array($orderCargo['ldm']) ? $checkOrderCargoData->row()->ldm : $orderCargo['ldm'];
            $GroundedFlag = is_array($orderCargo['GroundedFlag']) ? $checkOrderCargoData->row()->grounded : $orderCargo['GroundedFlag'];
            $StackableFlag = is_array($orderCargo['StackableFlag']) ? $checkOrderCargoData->row()->stackable : $orderCargo['StackableFlag'];
            $SplittableFlag = is_array($orderCargo['SplittableFlag']) ? $checkOrderCargoData->row()->splittable : $orderCargo['SplittableFlag'];
            $DangerousGoodsFlag = is_array($orderCargo['DangerousGoodsFlag']) ? $checkOrderCargoData->row()->dangerous : $orderCargo['DangerousGoodsFlag'];
            $DangerousGoods = is_array($orderCargo['TotalPackagesOfDangerousGoods']) ? 0 : $orderCargo['TotalPackagesOfDangerousGoods'];
            $currentDate = date('Y-m-d H:i:s');
            $orderCargoData = [
                'order_id' => $order_id,
                'package_type' => $cargoType,
                'goods_description' => $GoodsDescription,
                'marks_and_numbers' => $MarksandNumbers,
                'handling_unit' => ($HandlingUnit != "" && $HandlingUnit != 0) ?? $cargoType,
                'length' => $LengthValue,
                'length_uom' => $LengthUom,
                'width' => $WidthValue,
                'width_uom' => $WidthUom,
                'height' => $HeightValue,
                'height_uom' => $HeightUom,
                'item_id' => $itemId,
                'ldm' => $ldm,
                'weight' => $ActualWeightValue,
                'weight_uom' => $ActualWeightUom,
                'volume' => $VolumeValue,
                'volume_uom' => $VolumeUom,
                'second_weight' => $WeightValue,
                'second_weight_uom' => $WeightUom,
                'actual_volume_metric' => $ActualVolumeValue,
                'actual_volume_metric_uom' => $ActualVolumeUom,
                'quantity' => $cargoQuantity,
                'scanned_quantity' => $cargoQuantity,
                'external_cargo_id' => $ItemId,
                'grounded' => $GroundedFlag,
                'stackable' => $StackableFlag,
                'splittable' => $SplittableFlag,
                'dangerous' => $DangerousGoodsFlag,
                'organization_id' => $organizationId,
                'entity_value_id' => $businessEntityValue,
            ];

            $orderCargoId = $checkOrderCargoData->row()->id;
            $orderCargoData['modifiedon'] = $currentDate;
            $this->db->where(["id" => $orderCargoId])->update("tb_order_cargo_details", $orderCargoData);
        } else {
            $cargoType = is_array($orderCargo['PackageType']) ? "" : $orderCargo['PackageType'];
            $GoodsDescription = is_array($orderCargo['GoodsDescription']) ? "" : $orderCargo['GoodsDescription'];
            $MarksandNumbers = is_array($orderCargo['MarksandNumbers']) ? "" : $orderCargo['MarksandNumbers'];
            $ValueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "" : $orderCargo['ValueOfGoods'];
            $HandlingUnit = is_array($orderCargo['HandlingUnit']) ? "" : $orderCargo['HandlingUnit'];
            $ItemId = is_array($orderCargo['ItemId']) ? "0" : $orderCargo['ItemId'];
            $LengthValue = is_array($orderCargo['Length']['Value']) ? 0 : $orderCargo['Length']['Value'];
            $LengthUom = is_array($lengthUomCode) ? "" : $lengthUomCode;
            $WidthValue = is_array($orderCargo['Width']['Value']) ? 0 : $orderCargo['Width']['Value'];
            $WidthUom = is_array($widthUomCode) ? "" : $widthUomCode;
            $HeightValue = is_array($orderCargo['Height']['Value']) ? 0 : $orderCargo['Height']['Value'];
            $HeightUom = is_array($heightUomCode) ? "" : $heightUomCode;
            $ActualWeightValue = is_array($orderCargo['ActualWeight']['Value']) ? "" : $orderCargo['ActualWeight']['Value'];
            $ActualWeightUom = is_array($actualWeightUomCode) ? "" : $actualWeightUomCode;
            $WeightValue = is_array($orderCargo['Weight']['Value']) ? 0 : $orderCargo['Weight']['Value'];
            $WeightUom = is_array($weightUomCode) ? "" : $weightUomCode;
            $VolumetricWeightValue = is_array($orderCargo['VolumetricWeight']['Value']) ? "" : $orderCargo['VolumetricWeight']['Value'];
            $VolumetricWeightUom = is_array($orderCargo['VolumetricWeight']['UOM']) ? "" : $orderCargo['VolumetricWeight']['UOM'];
            $VolumeValue = is_array($orderCargo['Volume']['Value']) ? 0 : $orderCargo['Volume']['Value'];
            $VolumeUom = is_array($volumeUomCode) ? "" : $volumeUomCode;
            $ActualVolumeValue = is_array($orderCargo['ActualVolume']['Value']) ? "" : $orderCargo['ActualVolume']['Value'];
            $ActualVolumeUom = is_array($actualVolumeUomCode) ? "" : $actualVolumeUomCode;
            $cargoQuantity = is_array($orderCargo['Quantity']) ? 0 : $orderCargo['Quantity'];
            $ScannedQuantity = is_array($orderCargo['ScannedQuantity']) ? 0 : $orderCargo['ScannedQuantity'];
            $ldm = 0;
            $itemId = is_array($orderCargo['ldm']) ? 0 : $orderCargo['ldm'];
            $GroundedFlag = is_array($orderCargo['GroundedFlag']) ? 0 : $orderCargo['GroundedFlag'];
            $StackableFlag = is_array($orderCargo['StackableFlag']) ? 0 : $orderCargo['StackableFlag'];
            $SplittableFlag = is_array($orderCargo['SplittableFlag']) ? 0 : $orderCargo['SplittableFlag'];
            $DangerousGoodsFlag = is_array($orderCargo['DangerousGoodsFlag']) ? 0 : $orderCargo['DangerousGoodsFlag'];
            $DangerousGoods = is_array($orderCargo['TotalPackagesOfDangerousGoods']) ? 0 : $orderCargo['TotalPackagesOfDangerousGoods'];
            $currentDate = date('Y-m-d H:i:s');
            $orderCargoData = [
                'order_id' => $order_id,
                'package_type' => $cargoType,
                'goods_description' => $GoodsDescription,
                'marks_and_numbers' => $MarksandNumbers,
                'handling_unit' => ($HandlingUnit != "" && $HandlingUnit != 0) ?? $cargoType,
                'length' => $LengthValue,
                'length_uom' => $LengthUom,
                'width' => $WidthValue,
                'width_uom' => $WidthUom,
                'height' => $HeightValue,
                'height_uom' => $HeightUom,
                'ldm' => $ldm,
                'item_id' => $itemId,
                'weight' => $ActualWeightValue,
                'weight_uom' => $ActualWeightUom,
                'volume' => $VolumeValue,
                'volume_uom' => $VolumeUom,
                'second_weight' => $WeightValue,
                'second_weight_uom' => $WeightUom,
                'actual_volume_metric' => $ActualVolumeValue,
                'actual_volume_metric_uom' => $ActualVolumeUom,
                'quantity' => $cargoQuantity,
                'scanned_quantity' => $cargoQuantity,
                'external_cargo_id' => $ItemId,
                'grounded' => $GroundedFlag,
                'stackable' => $StackableFlag,
                'splittable' => $SplittableFlag,
                'dangerous' => $DangerousGoodsFlag,
                'organization_id' => $organizationId,
                'entity_value_id' => $businessEntityValue,
            ];
            $orderCargoId = $this->common->insertTableData('tb_order_cargo_details', $orderCargoData);
        }

        if (isset($orderCargo['CargoPuDetails']) && !empty($orderCargo['CargoPuDetails'])) {
            if (array_key_exists("0", $orderCargo['CargoPuDetails']) == 1) {
                foreach ($orderCargo['CargoPuDetails'] as $orderInnerCargo) {
                    $packageType = empty($orderInnerCargo['PackageType']) ? "" : $orderInnerCargo['PackageType'];
                    $toPackage = $this->otmshipmentmodel->checkPackageType($packageType, $organizationId, $businessEntityValue);
                    if (!empty($toPackage)) {
                        $packageId = $this->otmshipmentmodel->getPackageId($toPackage);
                        $orderInnerCargo['PackageType'] = $packageId;
                        $this->insertInnerCargoInfo($orderInnerCargo, $orderCargoId, $order_id, $organizationId, $businessEntityValue);
                    }
                }
            } else {
                if (!empty($orderCargo['CargoPuDetails'])) {
                    $packageType = empty($orderCargo['CargoPuDetails']['PackageType']) ? "" : $orderCargo['CargoPuDetails']['PackageType'];
                    $toPackage = $this->otmshipmentmodel->checkPackageType($packageType, $organizationId, $businessEntityValue);
                    if (!empty($toPackage)) {
                        $packageId = $this->otmshipmentmodel->getPackageId($toPackage);
                        $orderCargo['CargoPuDetails']['PackageType'] = $packageId;
                        $this->insertInnerCargoInfo($orderCargo['CargoPuDetails'], $orderCargoId, $order_id, $organizationId, $businessEntityValue);
                    }
                }
            }
        }
        return $orderCargoId;
    }

    private function insertInnerCargoInfo(array $packagingunit, int $orderCargoId, int $order_id, int $organizationId, int $businessEntityValue): void
    {
        $currentDate = date('Y-m-d H:i:s');
        $checkOrderinnerCargoData = $this->db->select("package_type, package_description, quantity, scanned_quantity, length, length_uom,
			width, width_uom, height, height_uom, weight, weight_uom, volume, volume_uom, external_cargo_id")->get_where("tb_order_inner_cargo", [
            'order_id' => $order_id,
            'order_cargo_id' => $orderCargoId,
            'external_cargo_id' => is_array($packagingunit['ItemId']) ? "" : $packagingunit['ItemId'],
        ]);
        $lengthUomCode = $widthUomCode = $heightUomCode = $weightUomCode = $volumeUomCode = 0;
        if (!empty($packagingunit['Length']['UOM'])) {
            $lengthUOM = $this->otmshipmentmodel->checkUOM($packagingunit['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($lengthUOM)) {
                $lengthUomCode = $this->otmshipmentmodel->getUOMId($lengthUOM);
            }*/
            $lengthUomCode = $lengthUOM;
        }
        if (!empty($packagingunit['Width']['UOM'])) {
            $widthUOM = $this->otmshipmentmodel->checkUOM($packagingunit['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($widthUOM)) {
                $widthUomCode = $this->otmshipmentmodel->getUOMId($widthUOM);
            }*/
            $widthUomCode = $widthUOM;
        }
        if (!empty($packagingunit['Height']['UOM'])) {
            $heightUOM = $this->otmshipmentmodel->checkUOM($packagingunit['Length']['UOM'], 'D', $organizationId, $businessEntityValue);
            /*if (!empty($heightUOM)) {
                $heightUomCode = $this->otmshipmentmodel->getUOMId($heightUOM);
            }*/
            $heightUomCode = $heightUOM;
        }
        if (!empty($packagingunit['Weight']['UOM'])) {
            $weightUOM = $this->otmshipmentmodel->checkUOM($packagingunit['Weight']['UOM'], 'WT', $organizationId, $businessEntityValue);
            /*if (!empty($weightUOM)) {
                $weightUomCode = $this->otmshipmentmodel->getUOMId($weightUOM);
            }*/
            $weightUomCode = $weightUOM;
        }
        if (!empty($packagingunit['Volume']['UOM'])) {
            $volumeUOM = $this->otmshipmentmodel->checkUOM($packagingunit['Volume']['UOM'], 'VO', $organizationId, $businessEntityValue);
            /*if (!empty($volumeUOM)) {
                $volumeUomCode = $this->otmshipmentmodel->getUOMId($volumeUOM);
            }*/
            $volumeUomCode = $volumeUOM;
        }
        if ($checkOrderinnerCargoData->num_rows() > 0) {
            $orderInnerCargoId = $checkOrderinnerCargoData->row()->external_cargo_id;
            $innerCargo['modifiedon'] = $currentDate;
            $innerCargo = [
                'package_type' => is_array($packagingunit['PackageType']) ? $checkOrderinnerCargoData->row()->package_type : $packagingunit['PackageType'],
                'order_cargo_id' => $orderCargoId,
                'order_id' => $order_id,
                'package_description' => is_array($packagingunit['GoodsDescription']) ? $checkOrderinnerCargoData->row()->package_description : $packagingunit['GoodsDescription'],
                'quantity' => is_array($packagingunit['Quantity']) ? $checkOrderinnerCargoData->row()->quantity : $packagingunit['Quantity'],
                'scanned_quantity' => is_array($packagingunit['Quantity']) ? $checkOrderinnerCargoData->row()->scanned_quantity : $packagingunit['Quantity'],
                'length' => is_array($packagingunit['Length']['Value']) ? $checkOrderinnerCargoData->row()->length : $packagingunit['Length']['Value'],
                'length_uom' => is_array($lengthUomCode) ? $checkOrderinnerCargoData->row()->length_uom : $lengthUomCode,
                'width' => is_array($packagingunit['Width']['Value']) ? $checkOrderinnerCargoData->row()->width : $packagingunit['Width']['Value'],
                'width_uom' => is_array($widthUomCode) ? $checkOrderinnerCargoData->row()->width_uom : $widthUomCode,
                'height' => is_array($packagingunit['Height']['Value']) ? $checkOrderinnerCargoData->row()->height : $packagingunit['Height']['Value'],
                'height_uom' => is_array($heightUomCode) ? $checkOrderinnerCargoData->row()->height_uom : $heightUomCode,
                'weight' => is_array($packagingunit['Weight']['Value']) ? $checkOrderinnerCargoData->row()->weight : $packagingunit['Weight']['Value'],
                'weight_uom' => is_array($weightUomCode) ? $checkOrderinnerCargoData->row()->weight_uom : $weightUomCode,
                'volume' => is_array($packagingunit['Volume']['Value']) ? $checkOrderinnerCargoData->row()->volume : $packagingunit['Volume']['Value'],
                'volume_uom' => is_array($volumeUomCode) ? $checkOrderinnerCargoData->row()->volume_uom : $volumeUomCode,
                'external_cargo_id' => is_array($packagingunit['ItemId']) ? $checkOrderinnerCargoData->row()->external_cargo_id : $packagingunit['ItemId'],
            ];
            $this->db->where([
                'order_id' => $order_id,
                'order_cargo_id' => $orderCargoId,
                'external_cargo_id' => $orderInnerCargoId,
            ])->update("tb_order_inner_cargo", $innerCargo);
        } else {
            $innerCargo = [
                'package_type' => is_array($packagingunit['PackageType']) ? "" : $packagingunit['PackageType'],
                'order_cargo_id' => $orderCargoId,
                'order_id' => $order_id,
                'package_description' => is_array($packagingunit['GoodsDescription']) ? "" : $packagingunit['GoodsDescription'],
                'quantity' => is_array($packagingunit['Quantity']) ? "" : $packagingunit['Quantity'],
                'scanned_quantity' => is_array($packagingunit['Quantity']) ? "" : $packagingunit['Quantity'],
                'length' => is_array($packagingunit['Length']['Value']) ? "" : $packagingunit['Length']['Value'],
                'length_uom' => is_array($lengthUomCode) ? "" : $lengthUomCode,
                'width' => is_array($packagingunit['Width']['Value']) ? "" : $packagingunit['Width']['Value'],
                'width_uom' => is_array($widthUomCode) ? "" : $widthUomCode,
                'height' => is_array($packagingunit['Height']['Value']) ? "" : $packagingunit['Height']['Value'],
                'height_uom' => is_array($heightUomCode) ? "" : $heightUomCode,
                'weight' => is_array($packagingunit['Weight']['Value']) ? "" : $packagingunit['Weight']['Value'],
                'weight_uom' => is_array($weightUomCode) ? "" : $weightUomCode,
                'volume' => is_array($packagingunit['Volume']['Value']) ? "" : $packagingunit['Volume']['Value'],
                'volume_uom' => is_array($volumeUomCode) ? "" : $volumeUomCode,
                'external_cargo_id' => is_array($packagingunit['ItemId']) ? "" : $packagingunit['ItemId'],
            ];
            $orderInnerCargoId = $this->common->insertTableData('tb_order_inner_cargo', $innerCargo);
        }
    }

    public function insertValueAddedServices(array $ordervas,
        int $order_id,
        int $organizationId,
        int $businessEntityValue): void {
        $addonName = is_array($ordervas['AddonName']) ? "" : $ordervas['AddonName'];
        $addonCode = is_array($ordervas['AddonCode']) ? "" : $ordervas['AddonCode'];
        $addonCurrency = is_array($ordervas['Currency']) ? "" : $ordervas['Currency'];
        $addonRateUnit = is_array($ordervas['RateUnit']) ? "" : $ordervas['RateUnit'];
        $addonAmount = is_array($ordervas['AddonAmount']) ? "" : $ordervas['AddonAmount'];
        $addonQuantity = is_array($ordervas['AddonQuantity']) ? "" : $ordervas['AddonQuantity'];

        if ($addonName == "" && $addonCode == "") {
            return;
        }

        $checkVasMasterData = $this->db->select("id")->get_where("tb_vas_master",
            [
                'vas_id' => $addonCode,
                'vas_name' => $addonName,
                'organization_id' => $organizationId,
                'business_entity_value_id' => $businessEntityValue,
                'status' => 1,
            ],
            1,
            0);
        if ($checkVasMasterData->num_rows() > 0) {
            $vasMasterId = $checkVasMasterData->row()->id;
        } else {
            $vasMasterData = [
                'vas_id' => $addonCode,
                'vas_name' => $addonName,
                'organization_id' => $organizationId,
                'business_entity_value_id' => $businessEntityValue,
                'status' => 1,
            ];
            $vasMasterId = $this->common->insertTableData('tb_vas_master', $vasMasterData);
        }

        $vasData = [
            'order_id' => $order_id,
            'vas_id' => $vasMasterId,
            'vas_quantity' => $addonQuantity,
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'status' => 1,
        ];
        $checkVasData = $this->db->select("id")->get_where("tb_order_vas", $vasData, 1, 0);
        if ($checkVasData->num_rows() > 0) {
            $vasId = $checkVasData->row()->id;
        } else {
            $vasId = $this->common->insertTableData('tb_order_vas', $vasData);
        }
    }

    /*public function checkCrossReferences(string $orderRef): string
    {
    $toRefCode = $this->db->select("to_ref_code")->get_where("tb_references_xref", ["from_ref_code" => $orderRef]);
    return $toRefCode->num_rows() > 0 ? $toRefCode->row()->to_ref_code : "";
    }*/

    public function checkRefMaster(string $toRefCode): int
    {
        $refId = $this->db->select("reference_type_id")->get_where("tb_reference_type_master", ["reference_type" => $toRefCode]);
        return $refId->num_rows() > 0 ? $refId->row()->reference_type_id : 0;
    }

    public function checkRemMaster(string $toRemarkCode): int
    {
        $remId = $this->db->select("remark_type_id")->get_where("tb_remark_type_master", ["remark_type" => $toRemarkCode]);
        return $remId->num_rows() > 0 ? $remId->row()->remark_type_id : 0;
    }

    public function insertOrderReferences(int $ord_id, array $orderRef, int $organizationId,
        int $businessEntityValue): void {
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'order_id' => $ord_id,
            'reference_id' => $orderRef['RefType']['Code'],
            //'ref_value' => $orderRef['RefType']['Value'],
        ];
        $chkref = $this->db->select("id")->get_where("tb_order_references", $chkdt);
        $srefqry = [
            'order_id' => $ord_id,
            'reference_id' => $orderRef['RefType']['Code'],
            'ref_value' => $orderRef['RefType']['Value'],
            'status' => 1,
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'createdon' => $curdt,
        ];
        if ($chkref->num_rows() == 0) {
            $this->common->insertTableData('tb_order_references', $srefqry);
        } else {
            $this->db->where(["order_id" => $ord_id, "reference_id" => $orderRef['RefType']['Code']])->update("tb_order_references", $srefqry);
        }
    }

    public function insertOrderRemarks(int $ord_id, array $orderRem, int $organizationId,
        int $businessEntityValue): void {
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'order_id' => $ord_id,
            'remarks_id' => $orderRem['Code'],
        ];
        $chkrem = $this->db->select("id")->get_where("tb_order_remarks", $chkdt);
        $sremqry = [
            'order_id' => $ord_id,
            'remarks_id' => $orderRem['Code'],
            'remarks' => $orderRem['Value'],
            'status' => 1,
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'createdon' => $curdt,
        ];
        if ($chkrem->num_rows() == 0) {
            $this->common->insertTableData('tb_order_remarks', $sremqry);
        } else {
            $this->db->where(["order_id" => $ord_id, "remarks_id" => $orderRem['Code']])->update("tb_order_remarks", $sremqry);
        }
    }

    public function insertOrderStatus(string $trip_id, string $bookingId, int $organizationId, int $businessEntityValue): void
    {
        $order_qry = $this->db->select("id")->get_where('tb_orders', ["order_id" => $bookingId]);
        $curdt = date("Y-m-d H:i:s");
        $status_qry = $this->db->query("SELECT id, status_description FROM tb_status_type WHERE status_description in ('Booking', 'Trip Created')");
        $statusResult = $status_qry->num_rows() > 0 ? $status_qry->result_array() : [];
        if (sizeof($statusResult) > 0) {
            foreach ($statusResult as $status) {
                $check_array = [
                    'order_id' => $order_qry->row()->id,
                    'order_status_id' => $status['id'],
                    'status' => 1,
                ];
                $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                if ($chk_qry->num_rows() == 0 && (($status['status_description'] == 'Booking') || ($status['status_description'] == 'Trip Created' && $trip_id != "0"))) {
                    $innr_array = array(
                        'order_id' => $order_qry->row()->id,
                        'trip_id' => $trip_id,
                        'order_status_id' => $status['id'],
                        'order_status_date_and_time' => $curdt,
                        'status_type' => $status['status_description'],
                        'organization_id' => $organizationId,
                        'entity_value_id' => $businessEntityValue,
                        'order_status_remarks' => '',
                        'order_status_location' => '',
                        'status_latitude' => '',
                        'status_longitude' => '',
                        'createdby' => 0,
                        'modifiedby' => 0,
                        'status' => 1,
                        'createdon' => $curdt,
                        'modifiedon' => $curdt,
                    );
                    $this->db->insert('tb_order_status', $innr_array);
                    $innrTrip_array = array(
                        'order_id' => $order_qry->row()->id,
                        'trip_id' => $trip_id,
                        'status_id' => $status['id'],
                        'status_date' => $curdt,
                        'status_type' => $status['status_description'],
                        'status_location' => '',
                        'latitude' => '',
                        'longitude' => '',
                        'status' => 1,
                        'createdon' => $curdt,
                    );
                    $this->db->insert('tb_trip_status', $innrTrip_array);
                }
            }
        }
    }

    public function checkOrderCount(string $orderID, int $organizationId, int $businessEntityValue): array
    {
        $checkEtnOrder = $this->db->query(
            "select id,order_id,order_type,pickup_start_date,pickup_end_date,delivery_start_date,delivery_end_date,ship_unit_id,order_type,mode_of_transport,quantity,order_weight,order_volume,order_volume,order_volume_uom from tb_orders where external_order_id = ? AND organization_id = ? AND entity_value_id = ? AND status <> 0 ",
            [$orderID, $organizationId, $businessEntityValue]
        );
        return $checkEtnOrder->num_rows() > 0 ? $checkEtnOrder->row_array() : [];
    }

    public function checkOrderDetails(int $orderId, int $bookingId): int
    {
        $checkOrderDetails = $this->db->select("id")->get_where("tb_order_details",
            ["order_row_id" => $orderId, "order_id" => $bookingId, "status" => 1],
            1,
            0);
        return $checkOrderDetails->num_rows() ?? 0;
    }

    public function getBookingId(int $orderId): int
    {
        $getBookingId = $this->db->select("order_id")->get_where("tb_orders", ["id" => $orderId], 1, 0);
        return $getBookingId->num_rows() > 0 ? $getBookingId->row()->order_id : 0;
    }

    public function insertOrderParties(array $orderParty): void
    {
        $updateOrderParty = [
            'order_id' => $orderParty['order_id'],
            //'party_id' => $orderParty['party_id'],
            'party_type' => $orderParty['party_type'],
            'organization_id' => $orderParty['organization_id'],
            'entity_value_id' => $orderParty['entity_value_id'],
            'status' => 1,
        ];

        if (!empty($orderParty)) {
            $checkOrderParty = $this->db->select("id")->get_where("tb_order_involved_parties", $updateOrderParty, 1, 0);
            if ($checkOrderParty->num_rows() == 0) {
                $this->common->insertTableData('tb_order_involved_parties', $orderParty);
            } else {
                $this->db->where($updateOrderParty)->update("tb_order_involved_parties", $orderParty);
            }
        }
    }

    public function getTransportModeName(string $modeOfTransport): array
    {
        $modeOfTransportName = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE  ?",
            [$modeOfTransport]);
        return $modeOfTransportName->num_rows() > 0 ? $modeOfTransportName->row_array() : [];
    }

    public function getBranchCompanyCodes(string $logicalReceiver): array
    {
        $checkBranchCompanyCodes = $this->db->select("branch_code,company_code")->get_where(
            "tb_branch_master",
            [
                "logical_sender" => $logicalReceiver,
                "status" => 1,
            ],
            1,
            0
        );
        return $checkBranchCompanyCodes->num_rows() > 0 ? $checkBranchCompanyCodes->row_array() : [];
    }

    public function insertUser(array $userInfo): int
    {
        $userId = 0;
        $userData = $this->db->select("id")->get_where("tb_users", ["user_id" => $userInfo['user_id']], 1, 0);
        if ($userData->num_rows() == 0) {
            $password = decryptCryptoLibPassword($userInfo['user_id']);
            $currentDateTime = date('Y-m-d H:i:s');
            $userInsertionData = [
                'user_id' => $userInfo['user_id'],
                'parent_id' => $userInfo['parent_id'],
                'privilege' => $userInfo['privilege'],
                'party_type' => $userInfo['party_type'],
                'password' => encryptCryptoLibPassword($userInfo['user_id']),
                'effective_from' => $currentDateTime,
                'effective_to' => date('Y-m-d H:i:s', strtotime('+1 year', strtotime($currentDateTime))),
                'status' => 1,
            ];
            $userId = $this->common->insertTableData('tb_users', $userInsertionData);
            if (strlen($userId) < 4) {
                $lastGenId = str_pad($userId, 4, '0', STR_PAD_LEFT);
            } else {
                $lastGenId = $userId;
            }
            $employeeId = "EMP" . date('d') . date('m') . date('y') . $lastGenId;
            $this->common->updatetbledata("tb_users", ['employee_id' => $employeeId], ['id' => $userId]);
            $userAssociationInsertionData = [
                'user_id' => $userId,
                'organization_id' => $userInfo['organization_id'],
                'structure_id' => $userInfo['structure_id'],
                'business_unit' => $userInfo['entity_id'],
                'role' => $userInfo['privilege'],
                'business_unit_value' => $userInfo['entity_value_id'],
                'defaultorg' => 1,
            ];

            $userAssociationsIdValue = $this->common->insertTableData('tb_user_associations', $userAssociationInsertionData);
        } else {
            $userId = $userData['id'];
        }
        return $userId ?? 0;
    }
}
