<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;
use App\Models\Traits\CacheTrait;

/**
 * Table for generic parties or business entities in svkonekt.
 * This table houses customers, carriers, and other entities.
 *
 * NOTE that svkonekt does not have the concept of a generic address
 * for pickup or delivery. A pickup or delivery location MUST be saved
 * as a party in this table, then linked to from other tables.
 */
class Party_masters extends Table {

    use CacheTrait;

    const TABLE = "tbl_party_master";

    const ID_COL = "id";
    const PARTY_TYPE_ID_COL = "party_type_id";
    const NAME_COL = "name";
    const EMAIL_COL = "email";
    const MOBILE_COL = "mobile";
    const USER_ID_COL = "user_id";
    const CODE_COL = "code";
    const IMG_COL = "img";
    const PARTYINDETIFIER_COL = "partyindetifier";
    const CUSTOMERIDENTIFIER_COL = "customeridentifier";
    const COMPANY_CODE_COL = "company_code";
    const BRANCH_CODE_COL = "branch_code";
    const DEPARTMENT_CODE_COL = "department_code";
    const CUSTOMER_CODE_COL = "customer_code";
    const PARENT_ID_COL = "parent_id";
    const LOCATION_ID_COL = "location_id";
    const ADDRESS_COL = "address";
    const COUNTRY_COL = "country";
    const STATE_COL = "state";
    const DIVISION_NAME_COL = "division_name";
    const SUB_DISTRICT_COL = "sub_district";
    const STREET_COL = "street";
    const PINCODE_COL = "pincode";
    const STREET_2_COL = "street_2";
    const STREET_3_COL = "street_3";
    const HOUSE_NUMBER_COL = "house_number";
    const PARTY_TYPES_COL = "party_types";
    const BUILDING_COL = "building";
    const EXTENSION_COL = "extension";
    const LATITUDE_COL = "latitude";
    const LONGITUDE_COL = "longitude";
    const HOMEPAGE_COL = "homepage";
    const CATEGORY_TYPE_COL = "category_type";
    const CATEGORY_ID_COL = "category_id";
    const TIME_ZONE_CITY_COL = "time_zone_city";
    const TIME_ZONE_CODE_COL = "time_zone_code";
    const TIME_ZONE_NAME_COL = "time_zone_name";
    const ACON_DEBITOR_CODE_COL = "acon_debitor_code";
    const KN_LOGIN_ACCOUNT_COL = "kn_login_account";
    const PASSWORD_COL = "password";
    const OFFERING_TYPE_COL = "offering_type";
    const CARRIER_GRADE_COL = "carrier_grade";
    const AUTOACCEPT_COL = "autoaccept";
    const INVOICE_TYPE_COL = "invoice_type";
    const CUST_PROFILE_ID_COL = "cust_profile_id";
    const VENDOR_PROFILE_ID_COL = "vendor_profile_id";
    const CARGO_LIMIT_COL = "cargo_limit";
    const LIMIT_AMOUNT_COL = "limit_amount";
    const CURRENCY_COL = "currency";
    const CREDIT_LIMIT_COL = "credit_limit";
    const CREDIT_LIMIT_AMOUNT_COL = "credit_limit_amount";
    const CREDIT_CURRENCY_COL = "credit_currency";
    const UTILIZED_AMOUNT_COL = "utilized_amount";
    const CREDIT_UTILIZED_AMOUNT_COL = "credit_utilized_amount";
    const VAT_REG_NO_COL = "vat_reg_no";
    const TAX_PAYER_NO_COL = "tax_payer_no";
    const CONTRACT_NO_COL = "contract_no";
    const CONTRACT_DATE_COL = "contract_date";
    const FAX_COL = "fax";
    const STATUS_COL = "status";
    const ATS_STATUS_COL = "ats_status";
    const CREATED_ON_COL = "created_on";
    const UPDATED_ON_COL = "updated_on";

    /**
     * @param $data
     * @param $type
     * @return array
     */
    public function get_party_by_type($data, $type) : array
    {
        $this->load->model(['Party_types']);

        $conditions = [
            'name' => $type,
            'user_id' => $data['user_id'],
            'company_code' => $data['company_code'],
            'branch_code' => $data['branch_code'],
            'status' => 1
        ];
        $type = $this->_getCache($conditions);
        if (empty($type)) {
            $type = $this->party_types->find($conditions);
            $type = reset($type);
            $this->_setCache($conditions, $type);
        }


        $conditions = [
            'party_type_id' => $type->id,
            'name' => $data['name'],
            'code' => $data['code'],
            'user_id' => $data['user_id'],
            'company_code' => $data['company_code'],
            'branch_code' => $data['branch_code']
        ];
        $cache = $this->_getCache($conditions);
        if (!empty($cache)) {
            return $cache;
        }

        $entity = $this->find($conditions, [], [
            'limit' => 1
        ]);
        $entity = reset($entity);
        if (empty($entity)) {
            $result = $this->insert([
                'party_type_id' => $type->id,
                'name' => $data['name'],
                'code' => $data['code'],
                'user_id' => $data['user_id'],
                'company_code' => $data['company_code'],
                'branch_code' => $data['branch_code'],
                'partyindetifier' => $data['code'], // duplicated for code
                'customeridentifier' => $data['code'], // duplicated for code
                'location_id' => $data['city'],
                'address' => $data['address'],
                'country' => $data['country'],
                'state' => $data['state'],
                'street' => $data['address'], //duplicated
                'pincode' => $data['postal'],
            ]);
            if (empty($result)) {
                throw new LogicException('Unable to save Order Parties');
            }
            $entity = $this->find($conditions, [], [
                'limit' => 1
            ]);
            $entity = reset($entity);
        }

        $result = [
            'id' => $entity->id,
            'party_type_id' => $type->id,
            'name' => $data['name'],
            'address' => $data['address'],
            'city' => $data['city'],
            'country' => $data['country'],
            'state' => $data['state'],
            'street' => $data['address'], //duplicated
            'postal' => $data['postal']
        ];
        $this->_setCache($conditions, $result);

        return $result;

    }


}
