<?php
 
class Ratecategory_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get rate_category by id
     */
    function get_rate_category($id)
    {
        return $this->db->get_where('tb_shipment_rate_categories',array('id'=>$id))->row_array();
    }
    
    /*
     * Get all rate_categories count
     */
    function get_all_rate_categories_count()
    {
        $this->db->from('tb_shipment_rate_categories');
        return $this->db->count_all_results();
    }
        
    /*
     * Get all rate_categories
     */
    function get_all_rate_categories($params = array())
    {
        $this->db->order_by('id', 'desc');
        if(isset($params) && !empty($params))
        {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('tb_shipment_rate_categories')->result_array();
    }
        
    /*
     * function to add new rate_category
     */
    function add_rate_category($params)
    {
        $this->db->insert('tb_shipment_rate_categories',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update rate_category
     */
    function update_rate_category($id,$params)
    {
        $this->db->where('id',$id);
        return $this->db->update('tb_shipment_rate_categories',$params);
    }
    
    /*
     * function to delete rate_category
     */
    function delete_rate_category($id)
    {
        return $this->db->delete('tb_shipment_rate_categories',array('id'=>$id));
    }
}