<?php

class Rateenquirymodel extends CI_Model
{
    private const FRT_CHARGE_ID = '39';
    private const FAF_CHARGE_ID = '38';
    private const WEIGHT_CHARGE_BASIS = ['PER KG', 'KG'];
    private const VOLUME_CHARGE_BASIS = ['PER CBM', 'CBM'];
    private const QUANTITY_CHARGE_BASIS = ['PER PIECE', 'PIECE'];
    private const TRIP_CHARGE_BASIS = ['PER TRIP', 'TRIP'];
    private const KM_CHARGE_BASIS = ['PER KM', 'KM'];
    private const MILES_CHARGE_BASIS = ['PER MILE', 'MILE'];
    private const LDM_CHARGE_BASIS = ['PER LDM', 'LDM'];
    private const WEIGHT_TYPES = ['ACTUAL WEIGHT', 'WEIGHT'];
    private const VOLUME_TYPES = ['ACTUAL VOLUME', 'VOLUME'];

    public function getPartyMasterData(array $partyType, array $companyCodes, int $limit = 0): array
    {
        $partyIds = $rowIds = [];
        $getPartyTypeIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND company_code IN ?", [$partyType, $companyCodes]);
        $typesData = $getPartyTypeIds->num_rows() > 0 ? $getPartyTypeIds->result_array() : [];
        if (empty($typesData)) {
            return [];
        }
        foreach ($typesData as $eachType) {
            $partyIds[] = $eachType['id'];
            $partyTypeData[$eachType['id']] = $eachType['name'];
        }
        $partyIds = array_unique($partyIds);
        $limitQuery = " ";
        if ($limit > 0) {
            $limitQuery .= "LIMIT " . $limit;
        }
        $getPartyMasterData = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,company_code,branch_code,location_id,country,state,division_name,sub_district,street,pincode FROM tbl_party_master WHERE party_type_id IN ? AND company_code IN ? AND status = ? ORDER BY id DESC" . $limitQuery, [$partyIds, $companyCodes, 1]);
        if ($getPartyMasterData->num_rows() > 0) {
            $masterData = $getPartyMasterData->result_array();
            foreach ($masterData as $eachLine) {
                $rowIds[] = $eachLine['id'];
            }
        }
        foreach ($partyIds as $eachPartyId) {
            if (!empty($rowIds)) {
                $getAdditionalMasterData = $this->db->query("SELECT id FROM tbl_party_master WHERE id NOT IN ? AND company_code IN ? AND (party_types = ? OR party_types LIKE ? OR party_types LIKE ? OR party_types LIKE ?) AND status = ? ORDER BY id DESC " . $limitQuery, [$rowIds, $companyCodes, $eachPartyId, $eachPartyId . ",%", "%," . $eachPartyId . ",%", "%," . $eachPartyId, '1']);
            } else {
                $getAdditionalMasterData = $this->db->query("SELECT id FROM tbl_party_master WHERE company_code IN ? AND (party_types = ? OR party_types LIKE ? OR party_types LIKE ? OR party_types LIKE ?) AND status = ? ORDER BY id DESC " . $limitQuery, [$companyCodes, $eachPartyId, $eachPartyId . ",%", "%," . $eachPartyId . ",%", "%," . $eachPartyId, '1']);
            }
            foreach ($getAdditionalMasterData->result_array() as $eachId) {
                $additionalMasterDataIds[] = $eachId['id'];
            }
        }
        if (empty($additionalMasterDataIds)) {
            return ['masterData' => $masterData ?? [], 'partyTypeData' => $partyTypeData ?? []];
        }
        $getAdditionalData = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,company_code,branch_code,location_id,country,state,division_name,sub_district,street,pincode FROM tbl_party_master WHERE id IN ? ORDER BY id DESC", [$additionalMasterDataIds]);
        $additionalData = $getAdditionalData->num_rows() > 0 ? $getAdditionalData->result_array() : [];
        foreach ($additionalData as $eachArray) {
            $masterData[] = $eachArray;
        }
        return ['masterData' => $masterData ?? [], 'partyTypeData' => $partyTypeData ?? []];
    }

    public function checkCrossBorderCountries(string $companyCode): array
    {
        return ['enabled' => 0, 'companyCodes' => [$companyCode]];
        $query = $this->db->query("SELECT xborder_code FROM tb_xborder_country WHERE company_code = ? AND company_code IS NOT NULL AND company_code != ?", [$companyCode, '']);
        $crossBorderCompaniesInString = $query->num_rows() > 0 ? $query->row()->xborder_code : $companyCode;
        $crossBorderCompanies = explode(',', $crossBorderCompaniesInString);
        $enabledCrossBorder = 1;
        if ((count($crossBorderCompanies) === 1) && $companyCode === $crossBorderCompanies[0]) {
            $enabledCrossBorder = 0;
        }
        return ['enabled' => $enabledCrossBorder, 'companyCodes' => $crossBorderCompanies];
    }

    public function getRateCharges(array $data)
    {
        $crossBorder = $data['crossBorder']['enabled'] ?? 0;
        $companyCodes = $data['crossBorder']['companyCodes'] ?? [$data['companyCode']];
        $queryString = "SELECT
        rs.id as serviceRowId,
        rs.product as product,
        rs.service_id,
        rs.service_name,
        rs.service_type,
        rsl.rs_lane_days as transitDays,
        lm.id as lane_id,
        lm.source_geo,
        lm.source,
        lm.destination_geo,
        lm.destination,
        ro.id as offeringRowId,
        ro.offering_id,
        ro.offering_name,
        ro.offering_type,
        ro.tarrif_type as offeringTariffType,
       (SELECT (CASE
                        WHEN ro.uom_conversion_id = 0 THEN ro.uom_conversion_id
                        WHEN ro.uom_conversion_id > 0 THEN ro.uom_conversion_id IN (SELECT id FROM tb_knuom_conversion WHERE Type = ? AND (customer_id = ? OR customer_id = ? OR customer_id IS NULL) AND status = ? AND company_code = ?)
                    ELSE
                        0
                    END)) AS uom_conversion_id,
        ro.cust_profile_id,
        ro.vendor_profile_id,
        ro.effective_date as effectiveDate,
        ro.expiry_date as expiryDate,
        rr.id as recordRowId,
        rr.rate_id as recordId,
        rr.record_name as recordName
    FROM tb_rate_services rs
    RIGHT JOIN tb_rateservice_lanes rsl ON rsl.rate_id = rs.id AND rsl.status = ?
    RIGHT JOIN tb_lanes_master lm ON lm.id=rsl.lane_id AND lm.status = ?
    RIGHT JOIN tb_rate_offerings ro ON ro.rate_service_id=rs.id ";
        $conditions = $data['conditions'] ?? [];
        $queryParams = [$conditions['tarrifType'] ?? 'SELL', 0, $data['customerRowId'], 1, $data['companyCode'], 1, 1];
        if (isset($conditions['offeringType'])) {
            $queryString .= " AND ro.offering_type = ? ";
            $queryParams[] = $conditions['offeringType'];
        }
        if (isset($conditions['tarrifType'])) {
            $queryString .= " AND ro.tarrif_type = ? ";
            $queryParams[] = $conditions['tarrifType'];
        }
        $vehicleProfileIds = $conditions['vehicleProfileIds'] ?? [];
        if (!empty($vehicleProfileIds)) {
            $queryString .= " AND ro.veh_profile_id IN ? ";
            $queryParams[] = $conditions['vehicleProfileIds'];
        }
        $customerProfileIds = $conditions['customerProfileIds'] ?? [];
        if (!empty($customerProfileIds)) {
            $queryString .= " AND ro.cust_profile_id IN ? ";
            $queryParams[] = $customerProfileIds;
        }
        if (isset($conditions['product'])) {
            $queryString .= " AND rs.product = ? ";
            $queryParams[] = $conditions['product'];
        }
        if (isset($conditions['daysCount'])) {
            $queryString .= " AND rsl.rs_lane_days = ? ";
            $queryParams[] = $conditions['daysCount'];
        }
        if (isset($conditions['vendorProfileId'])) {
            $queryString .= " AND ro.vendor_profile_id = ? ";
            $queryParams[] = $conditions['vendorProfileId'];
        }
        if (isset($conditions['ratesValidFrom'])) {
            $queryString .= " AND ro.effective_date = ? ";
            $queryParams[] = $conditions['ratesValidFrom'];
        }
        if (isset($conditions['ratesValidTo'])) {
            $queryString .= " AND ro.expiry_date = ? ";
            $queryParams[] = $conditions['ratesValidTo'];
        }
        $queryString .= " RIGHT JOIN tb_rate_records rr ON rr.offering_id=ro.id AND rr.status = ?";
        $queryParams[] = 1;
        if (isset($conditions['vehicleCapacity'])) {
            $queryString .= " RIGHT JOIN tb_rateoffering_constraints rc ON ro.id=rc.rateoffering_id AND (rc.min_weight <= ? AND rc.max_weight >= ? OR rc.min_weight = ? AND rc.max_weight = ?) AND rc.status =? ";
            $queryParams[] = $conditions['vehicleCapacity'];
            $queryParams[] = $conditions['vehicleCapacity'];
            $queryParams[] = 0;
            $queryParams[] = 0;
            $queryParams[] = 1;
        }
        $queryString .= " WHERE (" . $data['addressPairs'] . ") AND rs.status =? ";
        $queryParams[] = 1;
        if ($crossBorder > 0) {
            $queryString .= " AND rs.company_code IN ? ";
            $queryParams[] = $companyCodes;
        } else {
            $queryString .= " AND rs.user_id = ? ";
            $queryParams[] = $data['userId'];
        }
        if (isset($conditions['service'])) {
            $queryString .= " AND rs.service_type = ? ";
            $queryParams[] = $conditions['service'];
        }
        $queryString .= "GROUP BY rr.id ORDER BY rr.id DESC ";
        return $this->db->query($queryString, $queryParams);
    }

    public function getVasMasterData(array $ids): array
    {
        $query = $this->db->query("SELECT id,vas_id,vas_name FROM tb_vas_master WHERE id IN ?", [$ids]);
        $result = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($result as $eachRow) {
            $response[$eachRow['id']] = ['vasId' => $eachRow['vas_id'], 'name' => $eachRow['vas_name']];
        }
        return $response ?? [];
    }

    public function getChargeMasterData(array $ids): array
    {
        $query = $this->db->query("SELECT id,charge_code,name FROM tb_charge_codes WHERE id IN ?", [$ids]);
        $result = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($result as $eachRow) {
            $response[$eachRow['id']] = ['chargeCode' => $eachRow['charge_code'], 'name' => $eachRow['name']];
        }
        return $response ?? [];
    }

    public function getAllServicesAndCharges(array $offeringIds, array $recordIds, string $userCurrency, int $userId, array $vasData = [], int $ajaxCall = 0): array
    {
        $otherRecordCurrencyCharges = $recordUserCurrencyCharges = [];
        if (!empty($offeringIds)) {
            $offeringQuery = $this->db->query("SELECT id,rateoffering_id,ro_vas_id,ro_charge_id,charge_basis,min_amount,amount,currency FROM tb_rateoffering_services WHERE rateoffering_id IN ? AND status = ?", [$offeringIds, 1]);
            $offeringServices = $offeringQuery->num_rows() > 0 ? $offeringQuery->result_array() : [];
        }
        if (!empty($recordIds)) {
            if ($ajaxCall > 0) {
                if (!empty($vasData)) {
                    $recordServiceQuery = $this->db->query("SELECT id,raterecord_id,raterecord_vas_id,raterecord_charge_id,charge_basis,min_amount,amount,currency FROM tb_raterecord_services WHERE raterecord_id IN ? AND raterecord_vas_id IN ? AND status = ?", [$recordIds, $vasData, 1]);
                    $recordServices = $recordServiceQuery->num_rows() > 0 ? $recordServiceQuery->result_array() : [];
                }
            } else {
                $recordServiceQuery = $this->db->query("SELECT id,raterecord_id,raterecord_vas_id,raterecord_charge_id,charge_basis,min_amount,amount,currency FROM tb_raterecord_services WHERE raterecord_id IN ? AND status = ?", [$recordIds, 1]);
                $recordServices = $recordServiceQuery->num_rows() > 0 ? $recordServiceQuery->result_array() : [];
            }
            $recordChargeQuery = $this->db->query("SELECT id,raterecord_id,rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,min_amount,amount,fuel_surcharge_id,currency FROM tb_raterecord_charges WHERE raterecord_id IN ? AND status = ?", [$recordIds, 1]);
            $recordChargesResult = $recordChargeQuery->num_rows() > 0 ? $recordChargeQuery->result_array() : [];
            foreach ($recordChargesResult as $eachRow) {
                $recordCurrency = $eachRow['currency'];
                if (($userCurrency === $recordCurrency) || ($eachRow['charge_basis'] === "FRT" && $eachRow['rr_charge_id'] === self::FAF_CHARGE_ID)) {
                    $recordUserCurrencyCharges[] = $eachRow;
                } else {
                    $otherRecordCurrencyCharges[] = $eachRow;
                }
            }
        }
        $otherCurrencyCharges = $this->getOtherCurrencyCharges($recordIds, $userCurrency, $userId);
        return ['offeringServices' => $offeringServices ?? [], 'recordServices' => $recordServices ?? [], 'recordCharges' => array_merge($recordUserCurrencyCharges, $otherCurrencyCharges) ?? []];
    }

    public function getAdditionalRatesData(array $data, array $response): array
    {
        $serviceId = $data['rateServiceRowId'] ?? 0;
        $offeringId = $data['rateOfferingRowId'] ?? 0;
        if ($serviceId > 0) {
            $getServiceData = $this->db->query("SELECT s.service_id,s.name,r.product FROM tb_service_master s,tb_rate_services r WHERE r.id = ? AND r.service_type = s.id LIMIT 1", [$serviceId]);
            $serviceData = $getServiceData->num_rows() > 0 ? $getServiceData->row_array() : [];
            $response['serviceType'] = !empty($serviceData) ? $serviceData['service_id'] . " - " . $serviceData['name'] : "";
            $response['product'] = $serviceData['product'] ?? "";
        }
        if ($offeringId > 0) {
            $getOfferingData = $this->db->query(
                "SELECT t.name as transportMode,o.effective_date,o.expiry_date,o.tarrif_type,
       (CASE WHEN tarrif_type =? THEN (select cust_profile_id FROM tb_customer_profile WHERE id = o.cust_profile_id)
           WHEN tarrif_type =? THEN (select vend_profile_id FROM tb_vendor_profile WHERE id = o.vendor_profile_id)
    ELSE ''
    END) as profile_id
    FROM tb_rate_offerings o,tb_transportmode t WHERE o.id = ? AND o.offering_type = t.code LIMIT 1",
                ['SELL', 'BUY', $offeringId]
            );
            $offeringData = $getOfferingData->num_rows() > 0 ? $getOfferingData->row_array() : [];
            $response['transportMode'] = $offeringData['transportMode'] ?? "";
            $response['effectiveDate'] = $offeringData['effective_date'] ?? "";
            $response['expiryDate'] = $offeringData['expiry_date'] ?? "";
            $response['tariffType'] = $offeringData['tarrif_type'] ?? "";
            $response['profileId'] = $offeringData['profile_id'] ?? "";
        }
        return $response;
    }

    public function getTotalChargesAmount(array $offeringIds, array $recordIds, string $userCurrency, int $userId): array
    {
        if (!empty($offeringIds)) {
            $offeringQuery = $this->db->query("SELECT rateoffering_id,sum(amount) as totalOfferingAmount FROM tb_rateoffering_services WHERE rateoffering_id IN ? AND status = ? GROUP BY rateoffering_id", [$offeringIds, 1]);
            $offeringResult = $offeringQuery->num_rows() > 0 ? $offeringQuery->result_array() : [];
        }
        if (!empty($recordIds)) {
            $recordsServicesQuery = $this->db->query("SELECT raterecord_id,sum(amount) as totalRecordServices FROM tb_raterecord_services WHERE raterecord_id IN ? AND status = ? GROUP BY raterecord_id", [$recordIds, 1]);
            $recordChargesQuery = $this->db->query("SELECT raterecord_id,sum(amount) as totalRecordCharges FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type = ? AND currency = ? AND status = ? GROUP BY raterecord_id", [$recordIds, 'FIXED', $userCurrency, 1]);
            $recordServicesResult = $recordsServicesQuery->num_rows() > 0 ? $recordsServicesQuery->result_array() : [];
            $recordChargesResult = $recordChargesQuery->num_rows() > 0 ? $recordChargesQuery->result_array() : [];
            $getTiersData = $this->db->query("SELECT raterecord_id,rr_tier_id,geo_tier_id,rr_charge_id  FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type != ? AND status = ?", [$recordIds, 'FIXED', 1]);
            $tiersDataResult = $getTiersData->num_rows() > 0 ? $getTiersData->result_array() : [];
            foreach ($tiersDataResult as $eachLine) {
                $tiersData[] = ['recordId' => $eachLine['raterecord_id'], 'tierId' => $eachLine['rr_tier_id'], 'geoTierId' => $eachLine['geo_tier_id'], 'chargeId' => $eachLine['rr_charge_id']];
            }
            $otherCurrencyRecords = $this->getOtherCurrencyCharges($recordIds, $userCurrency, $userId);
            foreach ($otherCurrencyRecords as $eachRow) {
                $otherCurrencyCharges[$eachRow['raterecord_id']] = $eachRow['totalAmount'];
                $dummyCurrencyCharges[$eachRow['id']] = $eachRow['amount'];
            }
            $fafWithRateId = $recordsWithFaf = [];
            $checkIfFafexistsInRecord = $this->db->query("SELECT raterecord_id,fuel_surcharge_id FROM tb_raterecord_charges WHERE raterecord_id IN ? AND fuel_surcharge_id > ? AND status = ?", [$recordIds, 0, 1]);
            $fafResult = $checkIfFafexistsInRecord->num_rows() > 0 ? $checkIfFafexistsInRecord->result_array() : [];
            if (!empty($fafResult)) {
                foreach ($fafResult as $eachLine) {
                    $fafWithRateId[$eachLine['raterecord_id']][] = $eachLine['fuel_surcharge_id'];
                    $recordsWithFaf[] = $eachLine['raterecord_id'];
                }
                if (!empty($recordsWithFaf)) {
                    $getTotalFrtAmount = $this->db->query("SELECT raterecord_id,sum(amount) as amount FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_id = ? AND status = ? GROUP BY raterecord_id", [$recordsWithFaf, self::FRT_CHARGE_ID, 1]);
                    $queryResult = $getTotalFrtAmount->num_rows() > 0 ? $getTotalFrtAmount->result_array() : [];
                    foreach ($queryResult as $eachRecord) {
                        $frtRecordChargesAmount[$eachRecord['raterecord_id']] = $eachRecord['amount'];
                    }
                }
            }
        }
        return ['offering' => $offeringResult ?? [], 'recordServices' => $recordServicesResult ?? [], 'recordCharges' => $recordChargesResult ?? [], 'tiersData' => $tiersData ?? [], 'fafWithRateId' => $fafWithRateId ?? [], 'otherCurrencyCharges' => $otherCurrencyCharges ?? [], 'frtRecordChargesAmount' => $frtRecordChargesAmount ?? []];
    }

    public function getServiceModeMasterData(array $offeringTypes, array $serviceTypes): array
    {
        if (!empty($offeringTypes)) {
            $getOfferingTypes = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ? AND status = ?", [$offeringTypes, 1]);
            $offeringResult = $getOfferingTypes->num_rows() > 0 ? $getOfferingTypes->result_array() : [];
            foreach ($offeringResult as $eachLine) {
                $transportModes[$eachLine['code']] = $eachLine['name'];
            }
        }
        if (!empty($offeringTypes)) {
            $getServiceTypes = $this->db->query("SELECT id,service_id,name FROM tb_service_master WHERE id IN ? AND status = ?", [$serviceTypes, 1]);
            $serviceTypeResult = $getServiceTypes->num_rows() > 0 ? $getServiceTypes->result_array() : [];
            foreach ($serviceTypeResult as $eachLine) {
                $services[$eachLine['id']] = $eachLine['service_id'] . " - " . $eachLine['name'];
            }
        }
        return ['transportModes' => $transportModes ?? [], "services" => $services ?? []];
    }

    public function getVendorProfileData(int $profileId): string
    {
        $query = $this->db->query("SELECT id,vend_profile_id,name FROM tb_vendor_profile WHERE id = ?", [$profileId]);
        $result = $query->num_rows() > 0 ? $query->row_array() : [];
        return !empty($result) ? $result['vend_profile_id'] . " - " . $result['name'] : "";
    }

    public function getCustomerProfileData(int $profileId): string
    {
        $query = $this->db->query("SELECT id,cust_profile_id,name FROM tb_customer_profile WHERE id = ?", [$profileId]);
        $result = $query->num_rows() > 0 ? $query->row_array() : [];
        return !empty($result) ? $result['cust_profile_id'] . " - " . $result['name'] : "";
    }

    public function getGeoTierDataFromSheet(array $addressPairs, array $info): array
    {
        $otherCurrencyData = $geoWithWeight = $ids = $recordIds = $otherCurrencyIds = $userCurrencyResult = $otherCurrencyResult = $result = [];
        $data = $info['data'];
        foreach ($data as $eachLine) {
            $ids[] = $eachLine['geoTierId'];
            $recordIds[$eachLine['geoTierId']] = $eachLine['recordId'];
            $geoChargeIds[$eachLine['geoTierId']] = $eachLine['chargeId'];
        }
        if (empty($ids)) {
            return [];
        }
        $geoTierPairs = $addressPairs['pair1'];
        $geoPairsGsheet = implode(' OR ', $addressPairs['pair2']);
        $queryString = 'CASE
        WHEN g.geo_hierarchy ="PROVINCE" THEN ' . $geoTierPairs["PROVINCE"] . '
                                        WHEN g.geo_hierarchy ="POSTAL CODE" THEN ' . $geoTierPairs["POSTAL CODE"] . '
                                        WHEN g.geo_hierarchy ="CITY" THEN ' . $geoTierPairs["CITY"] . '
                                        WHEN g.geo_hierarchy ="COUNTRY" THEN ' . $geoTierPairs["COUNTRY"] . ' ELSE
                                       ( ' . $geoPairsGsheet . ' ) END';
        $weight = $info['weight'];
        $postVehicleType = $info['vehicleType'] ?? 0;
        if ($postVehicleType > 0) {
            $vehicleTypeQuery = $this->db->query("SELECT trucktype FROM tb_trucktypes WHERE id = ?", [$postVehicleType,]);
            $postVehicleTypeName = $vehicleTypeQuery->num_rows() > 0 ? $vehicleTypeQuery->row()->trucktype : "";
        }
        if ($weight > 0) {
            $checkQuery = $this->db->query("SELECT id FROM tb_geo_tier WHERE id IN ? AND uom1 IN ? AND status = ?", [$ids, self::WEIGHT_TYPES, 1]);
            $getGeoWithWeightIds = $checkQuery->num_rows() > 0 ? $checkQuery->result_array() : [];
            foreach ($getGeoWithWeightIds as $eachLine) {
                $geoWithWeight[] = $eachLine['id'];
            }
            $geoTierIds = array_diff($ids, $geoWithWeight);
            if (!empty($geoWithWeight)) {
                $geoWithWeightQuery = $this->db->query("SELECT g.id as geoTierRowId,g.geo_tier_id as geoTierId,g.uom1 as billing_uom,g.currency,g.vehicle_type,s.geo_tier_id,s.cost FROM tb_geo_tier g, tb_geo_tier_sheet s WHERE s.geo_tier_id = g.id AND  s.geo_tier_id IN ? AND " . $queryString . " AND s.uom1_min < ? AND uom1_max > ? AND s.status = ? GROUP BY g.id", [$geoWithWeight, $weight, $weight, 1]);
                $queryResult1 = $geoWithWeightQuery->num_rows() > 0 ? $geoWithWeightQuery->result_array() : [];
            }
        } else {
            $geoTierIds = $ids;
        }
        if (!empty($geoTierIds)) {
            $query = $this->db->query("SELECT g.id as geoTierRowId,g.geo_tier_id as geoTierId,g.uom1 as billing_uom,g.currency,g.vehicle_type,s.geo_tier_id,s.cost FROM tb_geo_tier g, tb_geo_tier_sheet s WHERE s.geo_tier_id = g.id AND  s.geo_tier_id IN ? AND " . $queryString . " AND s.uom1_min = ? AND s.uom1_max = ? AND s.status = ? GROUP BY g.id", [$geoTierIds, 0, 0, 1]);
            $queryResult2 = $query->num_rows() > 0 ? $query->result_array() : [];
        }
        $queryResult = array_merge($queryResult1 ?? [], $queryResult2 ?? []);
        foreach ($queryResult as $eachLine) {
            $geoTierRowId = $eachLine['geoTierRowId'] ?? 0;
            $vehicleCheck = 1;
            $displayVehicleName = 0;
            $geoTierVehicleType = $eachLine['vehicle_type'];
            if ($postVehicleType > 0) {
                if ($geoTierVehicleType > 0) {
                    if ($postVehicleType != $geoTierVehicleType) {
                        $vehicleCheck = 0;
                    }
                } else {
                    $displayVehicleName = 1;
                }
            }
            $message = "Cost Based On ";
            if ($weight > 0) {
                if (!in_array($geoTierRowId, $geoWithWeight)) {
                    $message = "Minimum Cost Based On ";
                }
            }
            if (!in_array(0, [$geoTierRowId, $vehicleCheck])) {
                $geoCurrency = $eachLine['currency'];
                if ($info['userCurrency'] === $geoCurrency) {
                    $userCurrencyResult[] = ['geoTierId' => $eachLine['geoTierId'], 'currency' => $eachLine['currency'], 'geoTierRowId' => $eachLine['geoTierRowId'], 'cost' => $eachLine['cost'], 'billingUom' => $eachLine['billing_uom'], 'message' => $message, 'displayVehicleName' => $displayVehicleName, 'vehicleTypeName' => $postVehicleTypeName ?? "", 'chargeId' => $geoChargeIds[$eachLine['geoTierRowId']] ?? ""];
                } else {
                    $otherCurrencyIds[] = $eachLine['geoTierRowId'];
                    $otherCurrencyData[$eachLine['geoTierRowId']] = ['rowId' => $eachLine['geoTierRowId'], 'geoTierId' => $eachLine['geoTierId'], 'currency' => $geoCurrency, 'geoTierRowId' => $eachLine['geoTierRowId'], 'cost' => $eachLine['cost'], 'billingUom' => $eachLine['billing_uom'], 'message' => $message, 'displayVehicleName' => $displayVehicleName, 'vehicleTypeName' => $postVehicleTypeName ?? "", 'chargeId' => $geoChargeIds[$eachLine['geoTierRowId']] ?? ""];
                }
            }
        }
        if (!empty($otherCurrencyData)) {
            $otherCurrencyResult = $this->getExchangeRateCurrencyForGeoTiers($otherCurrencyData, $recordIds, $otherCurrencyIds, $info['userCurrency'], $info['userId']);
        }
        foreach ($userCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        foreach ($otherCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        return $result;
    }

    public function getRateTierDataFromSheet(array $info): array
    {
        $ids = $uom2Tiers = $uom1Tiers = $tiersWithWeight = $otherCurrencyIds = $otherCurrencyData = $recordIds = $otherCurrencyResult = $userCurrencyResult = $result = [];
        $data = $info['data'];
        foreach ($data as $eachLine) {
            $ids[] = $eachLine['tierId'];
            $recordIds[$eachLine['tierId']] = $eachLine['recordId'];
            $rateChargeIds[$eachLine['tierId']] = $eachLine['chargeId'];
        }
        if (empty($ids)) {
            return [];
        }
        $weight = $info['weight'];
        if ($weight > 0) {
            $checkQuery = $this->db->query("SELECT id,uom1,uom2 from tb_tier_master WHERE id IN ? AND ( uom1 IN ? OR uom2 IN ? ) AND status = ? ", [$ids, self::WEIGHT_TYPES, self::WEIGHT_TYPES, 1]);
            $tiersWithWeightData = $checkQuery->num_rows() > 0 ? $checkQuery->result_array() : [];
            foreach ($tiersWithWeightData as $eachLine) {
                if (in_array($eachLine['uom1'], self::WEIGHT_TYPES, true)) {
                    $uom1Tiers[] = $eachLine['id'];
                }
                if (in_array($eachLine['uom2'], self::WEIGHT_TYPES, true)) {
                    $uom2Tiers[] = $eachLine['id'];
                }
                $tiersWithWeight[] = $eachLine['id'];
            }
            if (!empty($uom1Tiers)) {
                $query = $this->db->query("SELECT r.id,r.tier_id as rateTierId,r.currency,r.billing_uom,s.cost FROM tb_tier_master r,tb_tier_rate_sheet s WHERE r.id IN ? AND r.status = ? AND r.id = s.tier_master_id AND s.uom1_min < ? AND s.uom1_max > ? AND s.status =? GROUP BY r.id", [$uom1Tiers, 1, $info['weight'], $info['weight'], 1]);
                $queryResult1 = $query->num_rows() > 0 ? $query->result_array() : [];
            }
            if (!empty($uom2Tiers)) {
                $query = $this->db->query("SELECT r.id,r.tier_id as rateTierId,r.currency,r.billing_uom,s.cost FROM tb_tier_master r,tb_tier_rate_sheet s WHERE r.id IN ? AND r.status = ? AND r.id = s.tier_master_id AND s.uom2_min < ? AND s.uom2_max > ? AND s.status =? GROUP BY r.id", [$uom2Tiers, 1, $info['weight'], $info['weight'], 1]);
                $queryResult2 = $query->num_rows() > 0 ? $query->result_array() : [];
            }
            $tierIds = array_diff($ids, $tiersWithWeight);
        } else {
            $tierIds = $ids;
        }
        $tiersResult = array_merge($queryResult1 ?? [], $queryResult2 ?? []);
        if (!empty($tierIds)) {
            $query = $this->db->query("SELECT r.id,r.tier_id as rateTierId,r.currency,r.billing_uom,s.cost FROM tb_tier_master r,tb_tier_rate_sheet s WHERE r.id IN ? AND r.status = ? AND r.id = s.tier_master_id AND s.status =? GROUP BY r.id", [$tierIds, 1, 1]);
            $queryResult3 = $query->num_rows() > 0 ? $query->result_array() : [];
        }
        $queryResult = array_merge($tiersResult, $queryResult3 ?? []);
        foreach ($queryResult as $eachLine) {
            $tierRowId = $eachLine['id'] ?? 0;
            if ($tierRowId > 0) {
                $tierCurrency = $eachLine['currency'];
                $message = "Cost Based On ";
                if ($weight > 0) {
                    if (!in_array($eachLine['billing_uom'], self::WEIGHT_TYPES)) {
                        $message = "Minimum Cost Based On ";
                    }
                }
                if ($tierCurrency === $info['userCurrency']) {
                    $userCurrencyResult[] = ['tierId' => $eachLine['rateTierId'], 'currency' => $tierCurrency, 'tierRowId' => $tierRowId, 'cost' => $eachLine['cost'], 'billingUom' => $eachLine['billing_uom'], 'message' => $message, 'chargeId' => $rateChargeIds[$tierRowId] ?? ""];
                } else {
                    $otherCurrencyIds[] = $eachLine['id'];
                    $otherCurrencyData[$tierRowId] = ['tierId' => $eachLine['rateTierId'], 'currency' => $tierCurrency, 'tierRowId' => $tierRowId, 'cost' => $eachLine['cost'], 'billingUom' => $eachLine['billing_uom'], 'message' => $message, 'chargeId' => $rateChargeIds[$tierRowId] ?? ""];
                }
            }
        }
        if (!empty($otherCurrencyData)) {
            $otherCurrencyResult = $this->getExchangeRateCurrencyForRateTiers($otherCurrencyData, $recordIds, $otherCurrencyIds, $info['userCurrency'], $info['userId']);
        }
        foreach ($userCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        foreach ($otherCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        return $result;
    }

    public function calculateFuelSurchargeData(array $info): array
    {
        $currentDate = date('Y-m-d');
        $query = $this->db->query("SELECT f.id,f.faf_id,s.amount,s.currency,s.percentage FROM tb_fuel_surcharge f,tb_fuel_surcharge_sheet s WHERE f.id IN ? AND f.status = ? AND f.id = s.fuel_surcharge_id AND s.from_date <= ? AND s.to_date >= ? AND s.Status = ?", [$info['ids'], 1, $currentDate, $currentDate, 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachLine) {
            $amount = $eachLine['amount'];
            if ($amount > 0) {
                $finalAmount = $amount;
                $currency = $eachLine['currency'];
            } else {
                $finalAmount = $info['amount'] * ($eachLine['percentage'] / 100);
                $currency = $info['currency'];
            }
            $response[$eachLine['id']][] = ['fafId' => $eachLine['faf_id'], 'fafRowId' => $eachLine['id'], 'currency' => $currency, 'amount' => $finalAmount];
        }
        return $response ?? [];
    }

    public function getVehicleTypeMasterData(array $data): array
    {
        $query = $this->db->query("SELECT id,trucktype FROM tb_trucktypes WHERE company_code IN ? AND status = ?", [$data['companyCodes'], 'Active']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getVehicleTypeProfileIds(array $data): array
    {
        $query = $this->db->query("SELECT p.id FROM tb_vehicle_profile p,tb_vehicle_profile_list pl WHERE p.company_code IN ? AND p.status = ? AND p.id = pl.veh_p_id AND pl.profile_id = ? AND pl.status = ?", [$data['companyCodes'], 1, $data['profileId'], 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachRow) {
            $ids[] = $eachRow['id'];
        }
        $ids[] = 0;
        return $ids ?? [];
    }

    public function getCustomerDataFromProfileId(int $profileId): array
    {
        if ($profileId > 0) {
            $query = $this->db->query("SELECT p.profile_id,c.id,c.name,c.location,c.pincode,c.country,c.state,c.street FROM tb_customer_profile_list p,tb_customers c WHERE c.id = p.party_id AND p.status = ? AND c.status = ? AND p.cp_id = ?", [1, 1, $profileId]);
            $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
            foreach ($queryResult as $eachRow) {
                $result[$eachRow['id']] = ['profileId' => $eachRow['profile_id'], 'rowId' => $eachRow['id'], 'name' => $eachRow['name'], 'location' => $eachRow['location'], 'pincode' => $eachRow['pincode'], 'country' => $eachRow['country'], 'state' => $eachRow['state'], 'street' => $eachRow['street']];
            }
            $getProfileIdAndName = $this->db->query("SELECT cust_profile_id,name FROM tb_customer_profile WHERE id = ?", [$profileId]);
            $profileId = $getProfileIdAndName->num_rows() > 0 ? $getProfileIdAndName->row()->cust_profile_id . " - " . $getProfileIdAndName->row()->name : "";
        }
        return ['result' => $result ?? [], 'profileId' => $profileId ?? ""];
    }

    public function getVendorDataFromProfileId(int $profileId): array
    {
        if ($profileId > 0) {
            $query = $this->db->query("SELECT p.profile_id,v.id,v.name FROM tb_vendor_profile_list p,tb_vendors v WHERE v.id = p.party_id AND p.status = ? AND v.status = ? AND p.vp_id = ?", [1, 1, $profileId]);
            $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
            foreach ($queryResult as $eachRow) {
                $result[$eachRow['id']] = ['profileId' => $eachRow['profile_id'], 'rowId' => $eachRow['id'], 'name' => $eachRow['name']];
            }
            $getProfileIdAndName = $this->db->query("SELECT vend_profile_id,name FROM tb_vendor_profile WHERE id = ?", [$profileId]);
            $profileId = $getProfileIdAndName->num_rows() > 0 ? $getProfileIdAndName->row()->vend_profile_id . " - " . $getProfileIdAndName->row()->name : "";
        }
        return ['result' => $result ?? [], 'profileId' => $profileId ?? ""];
    }

    public function getOtherCurrencyCharges(array $recordIds, string $userCurrency, int $userId): array
    {
        $charges = $exchangeAmountArray = [];
        $currentDate = date('Y-m-d');
        $exchangeRate = 1;
        $query = $this->db->query("SELECT id,raterecord_id,rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,min_amount,amount,fuel_surcharge_id,currency,exchange_rate_id FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type = ? AND currency != ? AND currency != '' AND status = ? ORDER BY raterecord_id DESC", [$recordIds, 'FIXED', $userCurrency, 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachRow) {
            $charges[$eachRow['id']] = [
                'rowId' => $eachRow['id'],
                'recordId' => $eachRow['raterecord_id'],
                'tierId' => $eachRow['rr_tier_id'],
                'geoTierId' => $eachRow['geo_tier_id'],
                'chargeId' => $eachRow['rr_charge_id'],
                'chargeBasis' => $eachRow['charge_basis'],
                'totalAmount' => $otherCharges[$eachRow['raterecord_id']] ?? $eachRow['amount'],
                'exchangeRateId' => $eachRow['exchange_rate_id'],
                'fuelSurchargeId' => $eachRow['fuel_surcharge_id'],
                'minimumAmount' => $eachRow['min_amount'],
                'currency' => $eachRow['currency'],
                'amount' => $eachRow['amount'],
            ];
        }
        $i = $oldRecordId = 0;
        foreach ($charges as $eachRow) {
            $check = 1;
            $enableUserCurrency = 0;
            if ($eachRow['recordId'] !== $oldRecordId) {
                $i = 0;
            }
            if ($i === 0) {
                $otherCharges[$eachRow['recordId']] = 0;
                $oldRecordId = $eachRow['recordId'];
            }
            if ($eachRow['exchangeRateId'] > 0) {
                $checkExchangeRate = $exchangeAmountArray[$eachRow['exchangeRateId'] . "_" . $eachRow['currency'] . "_" . $userCurrency] ?? 0;
                if ($checkExchangeRate > 0) {
                    $exchangeRate = $checkExchangeRate;
                    $check = 0;
                    $enableUserCurrency = 1;
                } else {
                    $query = $this->getFinalAmountFromExchangeRate(['exchangeRateId' => [$eachRow['exchangeRateId']], 'currency' => $eachRow['currency'], 'userCurrency' => $userCurrency, 'currentDate' => $currentDate]);
                    $check = $query->num_rows() > 0 ? 0 : 1;
                    $enableUserCurrency = $check === 0 ? 1 : 0;
                    $exchangeRate = $check === 0 ? $query->row()->exchange_rate : 1;
                    if ($check > 0) {
                        $exchangeAmountArray[$eachRow['exchangeRateId'] . "_" . $eachRow['currency'] . "_" . $userCurrency] = $check > 0 ? $exchangeRate : 0;
                    }
                }
            }
            if ($check > 0) {
                $checkExchangeRate = $dummyExchangeAmount[$eachRow['currency'] . "_" . $userCurrency] ?? 0;
                if ($checkExchangeRate > 0) {
                    $exchangeRate = $checkExchangeRate;
                    $enableUserCurrency = 1;
                } else {
                    $query = $this->getExchangeRateAmountFromUser(['userId' => $userId, 'currency' => $eachRow['currency'], 'userCurrency' => $userCurrency, 'currentDate' => $currentDate]);
                    $exchangeRate = $query->num_rows() > 0 ? $query->row()->exchange_rate : 1;
                    $enableUserCurrency = $query->num_rows() > 0 ? 1 : 0;
                    $dummyExchangeAmount[$eachRow['currency'] . "_" . $userCurrency] = $query->num_rows() > 0 ? $exchangeRate : 0;
                }
            }
            $otherCharges[$eachRow['recordId']] += ($eachRow['amount'] * $exchangeRate);
            $result[] = [
                'id' => $eachRow['rowId'],
                'raterecord_id' => $eachRow['recordId'],
                'rr_tier_id' => $eachRow['tierId'],
                'geo_tier_id' => $eachRow['geoTierId'],
                'rr_charge_id' => $eachRow['chargeId'],
                'charge_basis' => $eachRow['chargeBasis'],
                'min_amount' => $eachRow['minimumAmount'],
                'totalAmount' => $otherCharges[$eachRow['recordId']] ?? $eachRow['amount'],
                'exchangeRateId' => $eachRow['exchangeRateId'],
                'fuel_surcharge_id' => $eachRow['fuelSurchargeId'],
                'currency' => $enableUserCurrency > 0 ? $userCurrency : $eachRow['currency'],
                'amount' => ($eachRow['amount'] * $exchangeRate),
                'exchangeAmount' => $enableUserCurrency > 0 ? $exchangeRate : 0
            ];
            $i++;
        }
        return $result ?? [];
    }

    public function getFinalAmountFromExchangeRate(array $data): object
    {
        return $this->db->query("SELECT exchange_rate FROM tb_rate_exchange_sheet WHERE rate_exchange_id IN ? AND exchange_from = ? AND   exchange_to =  ? AND effective_date <= ? AND expiry_date >= ? AND status =? ORDER BY id DESC LIMIT 1", [$data['exchangeRateId'], $data['currency'], $data['userCurrency'], $data['currentDate'], $data['currentDate'], 1]);
    }

    public function getExchangeRateAmountFromUser(array $data): object
    {
        return $this->db->query("SELECT r.id,s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.user_id = ? AND r.id=s.rate_exchange_id AND s.exchange_from = ? AND s.exchange_to = ? AND s.effective_date <= ? AND s.expiry_date >= ? AND s.status = ? ORDER BY r.id DESC LIMIT 1", [$data['userId'], $data['currency'], $data['userCurrency'], $data['currentDate'], $data['currentDate'], 1]);
    }

    public function getExchangeRateCurrencyForGeoTiers(array $data, array $recordIds, array $geoTierIds, string $userCurrency, int $userId): array
    {
        $recordIdsWithExchangeRate = $finalExchangeRates = $response = $exchangeRateIds = $geoTierData = $responseWithoutExchange = [];
        foreach ($geoTierIds as $eachId) {
            $recordId = $recordIds[$eachId] ?? 0;
            $exchangeRate = 0;
            $responseWithoutExchange[] = $data[$eachId] ?? [];
            if (empty($geoTierData)) {
                continue;
            }
            if ($recordId > 0) {
                if (in_array($recordId, $recordIdsWithExchangeRate)) {
                    $exchangeRate = $finalExchangeRates[$recordId];
                }
                if ($exchangeRate > 0) {
                    $finalAmount = ($geoTierData['cost'] * $exchangeRate);
                    $response[] = ['geoTierId' => $geoTierData['geoTierId'] ?? "", 'currency' => $userCurrency ?? "", 'geoTierRowId' => $geoTierData['geoTierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $geoTierData['billingUom'] ?? "", 'message' => $geoTierData['message'] ?? "", 'displayVehicleName' => $geoTierData['displayVehicleName'] ?? "", 'vehicleTypeName' => $geoTierData['vehicleTypeName'] ?? "", 'minimumAmount' => $geoTierData['minimumAmount'] ?? ""];
                    continue;
                }
                $checkExchangeRate = $this->db->query("SELECT exchange_rate_id FROM tb_raterecord_charges WHERE raterecord_id = ? AND status =  ? AND exchange_rate_id > ? GROUP BY exchange_rate_id", [$recordId, 1, 0]);
                $getExchangeRateIds = $checkExchangeRate->num_rows() > 0 ? $checkExchangeRate->result_array() : [];
                foreach ($getExchangeRateIds as $eachExchangeId) {
                    $exchangeRateIds[] = $eachExchangeId['exchange_rate_id'];
                }
                if (!empty($exchangeRateIds)) {
                    $query = $this->getFinalAmountFromExchangeRate(['exchangeRateId' => $exchangeRateIds, 'currency' => $geoTierData['currency'], 'userCurrency' => $userCurrency, 'currentDate' => date('y-m-d')]);
                    $exchangeRate = $query->num_rows() > 0 ? $query->row()->exchange_rate : 0;
                    $recordIdsWithExchangeRate[] = $recordId;
                    $finalExchangeRates[$recordId] = $exchangeRate;
                    if ($exchangeRate > 0) {
                        $finalAmount = ($geoTierData['cost'] * $exchangeRate);
                        if ($geoTierData['cost'] > 0) {
                            $response[] = ['geoTierId' => $geoTierData['geoTierId'] ?? "", 'currency' => $userCurrency, 'geoTierRowId' => $geoTierData['geoTierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $geoTierData['billingUom'] ?? "", 'message' => $geoTierData['message'] ?? "", 'displayVehicleName' => $geoTierData['displayVehicleName'], 'vehicleTypeName' => $geoTierData['vehicleTypeName'], 'minimumAmount' => $geoTierData['minimumAmount'] ?? ""];
                        }
                    }
                }
                if ($exchangeRate === 0) {
                    $query = $this->getExchangeRateAmountFromUser(['userId' => $userId, 'currency' => $geoTierData['currency'], 'userCurrency' => $userCurrency, 'currentDate' => date('y-m-d')]);
                    $exchangeRate = $query->num_rows() > 0 ? $query->row()->exchange_rate : 1;
                    if ($exchangeRate > 1) {
                        $finalAmount = ($geoTierData['cost'] * $exchangeRate);
                        $response[] = ['geoTierId' => $geoTierData['geoTierId'] ?? "", 'currency' => $userCurrency, 'geoTierRowId' => $geoTierData['geoTierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $geoTierData['billingUom'] ?? "", 'message' => $geoTierData['message'] ?? "", 'displayVehicleName' => $geoTierData['displayVehicleName'] ?? "", 'vehicleTypeName' => $geoTierData['vehicleTypeName'] ?? "", 'minimumAmount' => $geoTierData['minimumAmount'] ?? ""];
                    }
                }
            }
        }
        return count($response) > 0 ? $response : $responseWithoutExchange;
    }

    public function getExchangeRateCurrencyForRateTiers(array $data, array $recordIds, array $tierIds, string $userCurrency, int $userId): array
    {
        $recordIdsWithExchangeRate = $finalExchangeRates = $response = $exchangeRateIds = $tierData = $responseWithoutExchange = [];
        foreach ($tierIds as $eachId) {
            $recordId = $recordIds[$eachId] ?? 0;
            $exchangeRate = 0;
            $responseWithoutExchange[] = $tierData = $data[$eachId] ?? [];
            if (empty($tierData)) {
                continue;
            }
            if ($recordId > 0) {
                if (in_array($recordId, $recordIdsWithExchangeRate)) {
                    $exchangeRate = $finalExchangeRates[$recordId];
                }
                if ($exchangeRate > 0) {
                    $finalAmount = ($tierData['cost'] * $exchangeRate);
                    $response[] = ['tierId' => $tierData['tierId'] ?? "", 'currency' => $userCurrency, 'tierRowId' => $tierData['tierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $tierData['billingUom'] ?? "", 'message' => $tierData['message'] ?? ""];
                    continue;
                }
                $checkExchangeRate = $this->db->query("SELECT exchange_rate_id FROM tb_raterecord_charges WHERE raterecord_id = ? AND status =  ? AND exchange_rate_id > ? GROUP BY exchange_rate_id", [$recordId, 1, 0]);
                $getExchangeRateIds = $checkExchangeRate->num_rows() > 0 ? $checkExchangeRate->result_array() : [];
                foreach ($getExchangeRateIds as $eachExchangeId) {
                    $exchangeRateIds[] = $eachExchangeId['exchange_rate_id'];
                }
                if (!empty($exchangeRateIds)) {
                    $query = $this->getFinalAmountFromExchangeRate(['exchangeRateId' => $exchangeRateIds, 'currency' => $tierData['currency'] ?? "", 'userCurrency' => $userCurrency, 'currentDate' => date('y-m-d')]);
                    $exchangeRate = $query->num_rows() > 0 ? $query->row()->exchange_rate : 0;
                    $recordIdsWithExchangeRate[] = $recordId;
                    $finalExchangeRates[$recordId] = $exchangeRate;
                    if ($exchangeRate > 0) {
                        $finalAmount = ($tierData['cost'] * $exchangeRate);
                        if ($tierData['cost'] > 0) {
                            $response[] = ['tierId' => $tierData['tierId'] ?? "", 'currency' => $userCurrency, 'tierRowId' => $tierData['tierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $tierData['billingUom'] ?? "", 'message' => $tierData['message'] ?? ""];
                        }
                    }
                }
                if ($exchangeRate === 0) {
                    $query = $this->getExchangeRateAmountFromUser(['userId' => $userId, 'currency' => $tierData['currency'] ?? "", 'userCurrency' => $userCurrency, 'currentDate' => date('y-m-d')]);
                    $exchangeRate = $query->num_rows() > 0 ? $query->row()->exchange_rate : 1;
                    if ($exchangeRate > 1) {
                        $finalAmount = ($tierData['cost'] * $exchangeRate);
                        $response[] = ['tierId' => $tierData['tierId'] ?? "", 'currency' => $userCurrency, 'tierRowId' => $tierData['tierRowId'] ?? 0, 'cost' => $finalAmount, 'billingUom' => $tierData['billingUom'] ?? "", 'message' => $tierData['message'] ?? ""];
                    }
                }
            }
        }
        return count($response) > 0 ? $response : $responseWithoutExchange;
    }

    public function getCustomerProfilesByCustomerId(array $data): array
    {
        $query = $this->db->query("SELECT pl.cp_id FROM tb_customer_profile_list pl,tb_customers c WHERE c.company_code IN ? AND pl.status = ? AND pl.profile_id = c.code AND c.status = ? AND c.id = ?", [$data['companyCodes'], 1, 1, $data['profileId']]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachRow) {
            $ids[] = $eachRow['cp_id'];
        }
        $ids[] = 0;
        return $ids ?? [];
    }

    public function getGeoTierSheetsDataForCargo(array $geoPairs, array $info): array
    {
        $otherCurrencyData = $ids = $recordIds = $otherCurrencyIds = $userCurrencyResult = $otherCurrencyResult = [];
        $data = $info['data'];
        $orderTotalWeight = $info['orderTotalWeight'];
        $orderTotalVolume = $info['orderTotalVolume'];
        $totalMiles = $info['totalMiles'];
        $totalKiloMeters = $info['totalKiloMeters'];
        $orderTonWeight = ($orderTotalWeight * 0.001);
        $orderLBWeight = ($orderTotalWeight * 2.2046);
        foreach ($data as $eachLine) {
            $ids[] = $eachLine['geoTierId'];
            $recordIds[$eachLine['geoTierId']] = $eachLine['recordId'];
            $geoChargeIds[$eachLine['geoTierId']] = $eachLine['chargeId'];
        }
        if (empty($ids)) {
            return [];
        }
        $geoTierPairs = $geoPairs['pair1'];
        $geoPairsGsheet = implode(' OR ', $geoPairs['pair2']);
        $queryString = 'CASE
        WHEN g.geo_hierarchy ="PROVINCE" THEN ' . $geoTierPairs["PROVINCE"] . '
        WHEN g.geo_hierarchy ="POSTAL CODE" THEN ' . $geoTierPairs["POSTAL CODE"] . '
        WHEN g.geo_hierarchy ="CITY" THEN ' . $geoTierPairs["CITY"] . '
        WHEN g.geo_hierarchy ="COUNTRY" THEN ' . $geoTierPairs["COUNTRY"] . ' ELSE
       ( ' . $geoPairsGsheet . ' ) END AND
       CASE
        WHEN g.unit_measure1 ="KG" THEN s.uom1_min <= "' . $orderTotalWeight . '" AND s.uom1_max >= "' . $orderTotalWeight . '"
        WHEN g.unit_measure1 ="TON" THEN s.uom1_min <= "' . $orderTonWeight . '" AND s.uom1_max >= "' . $orderTonWeight . '"
        WHEN g.unit_measure1 ="LB" THEN s.uom1_min <= "' . $orderLBWeight . '" AND s.uom1_max >= "' . $orderLBWeight . '"
        WHEN g.unit_measure1 ="KM" THEN s.uom1_min <= "' . $totalKiloMeters . '" AND s.uom1_max >= "' . $totalKiloMeters . '"
        WHEN g.unit_measure1 ="MI" THEN s.uom1_min <= "' . $totalMiles . '" AND s.uom1_max >= "' . $totalMiles . '"
        WHEN g.unit_measure1 ="CBM" THEN s.uom1_min <= "' . $orderTotalVolume . '" AND s.uom1_max >= "' . $orderTotalVolume . '" END AND ';
        $query = $this->db->query("SELECT g.id as geoTierRowId,g.geo_tier_id as geoTierId,g.uom1 as billing_uom,g.unit_measure1,g.currency,g.flat,s.geo_tier_id,s.uom1_minimum,s.cost FROM tb_geo_tier g, tb_geo_tier_sheet s WHERE s.geo_tier_id = g.id AND  s.geo_tier_id IN ? AND " . $queryString . "   s.status = ? GROUP BY g.id", [$ids, 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachLine) {
            $geoTierRowId = $eachLine['geoTierRowId'] ?? 0;
            if ($geoTierRowId > 0) {
                $flat = $eachLine['flat'];
                $unitMeasure = $eachLine['unit_measure1'];
                $geoCurrency = $eachLine['currency'];
                $cost = $eachLine['cost'];
                if ($info['userCurrency'] === $geoCurrency) {
                    if ($flat == 0) {
                        if ($unitMeasure == "CBM") {
                            $cost *= $orderTotalVolume;
                        } elseif ($unitMeasure == "KG") {
                            $cost *= $orderTotalWeight;
                        } elseif ($unitMeasure == "TON") {
                            $cost *= $orderTonWeight;
                        } elseif ($unitMeasure == "LBM") {
                            $cost *= $orderLBWeight;
                        } elseif ($unitMeasure == "MI") {
                            $cost *= $totalMiles;
                        } elseif ($unitMeasure == "KM") {
                            $cost *= $totalKiloMeters;
                        }
                    }
                    $cost = $this->getGeoTierMinimumAmountWithCargo(['rowId' => $eachLine['geoTierRowId'], 'geoTierPairs' => $geoTierPairs, 'geoPairsGsheet' => $geoPairsGsheet, 'cost' => $cost])['cost'];
                    $userCurrencyResult[] = ['geoTierId' => $eachLine['geoTierId'], 'currency' => $eachLine['currency'], 'geoTierRowId' => $eachLine['geoTierRowId'], 'cost' => $cost, 'billingUom' => $eachLine['billing_uom'], 'minimumAmount' => $eachLine['uom1_minimum'], 'chargeId' => $geoChargeIds[$eachLine['geoTierRowId']] ?? ""];
                } else {
                    $otherCurrencyIds[] = $eachLine['geoTierRowId'];
                    $otherCurrencyData[$eachLine['geoTierRowId']] = ['rowId' => $eachLine['geoTierRowId'], 'geoTierId' => $eachLine['geoTierId'], 'currency' => $geoCurrency, 'geoTierRowId' => $eachLine['geoTierRowId'], 'cost' => $cost, 'billingUom' => $eachLine['billing_uom'], 'minimumAmount' => $eachLine['uom1_minimum'], 'chargeId' => $geoChargeIds[$eachLine['geoTierRowId']] ?? ""];
                }
            }
        }
        if (!empty($otherCurrencyData)) {
            $otherCurrencyResult = $this->getExchangeRateCurrencyForGeoTiers($otherCurrencyData, $recordIds, $otherCurrencyIds, $info['userCurrency'], $info['userId']);
        }
        foreach ($otherCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        foreach ($userCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        return $result ?? [];
    }

    public function getGeoTierMinimumAmountWithCargo(array $info): array
    {
        $cost = $info['cost'];
        $geoTierRowId = $info['rowId'];
        $geoTierPairs = $info['geoTierPairs'];
        $geoPairsGsheet = $info['geoPairsGsheet'];
        $queryString = 'CASE
        WHEN g.geo_hierarchy ="PROVINCE" THEN ' . $geoTierPairs["PROVINCE"] . '
        WHEN g.geo_hierarchy ="POSTAL CODE" THEN ' . $geoTierPairs["POSTAL CODE"] . '
        WHEN g.geo_hierarchy ="CITY" THEN ' . $geoTierPairs["CITY"] . '
        WHEN g.geo_hierarchy ="COUNTRY" THEN ' . $geoTierPairs["COUNTRY"] . ' ELSE
       ( ' . $geoPairsGsheet . ' ) END
        AND ';
        $getMinimumGeoAmount = $this->db->query("SELECT s.cost FROM tb_geo_tier_sheet s,tb_geo_tier g WHERE s.geo_tier_id = g.id AND  s.geo_tier_id = ? AND  " . $queryString . " s.uom1_min = ? AND s.uom1_max = ? AND s.status = ? ", [$geoTierRowId, 0, 0, 1]);
        $queryResult = $getMinimumGeoAmount->num_rows() > 0 ? $getMinimumGeoAmount->row_array() : [];
        if (empty($queryResult)) {
            return ['cost' => $cost];
        }
        $minimumAmount = $queryResult['cost'];
        if ($minimumAmount > $cost) {
            $cost = $minimumAmount;
        }
        return ['cost' => $cost];
    }

    public function getRateTierDataFromSheetForCargo(array $info): array
    {
        $ids = $otherCurrencyIds = $otherCurrencyData = $recordIds = $otherCurrencyResult = $userCurrencyResult = $result = [];
        $data = $info['data'];
        foreach ($data as $eachLine) {
            $ids[] = $eachLine['tierId'];
            $recordIds[$eachLine['tierId']] = $eachLine['recordId'];
        }
        if (empty($ids)) {
            return [];
        }
        $orderTotalWeight = $info['orderTotalWeight'];
        $orderTotalVolume = $info['orderTotalVolume'];
        $totalKiloMeters = $info['totalKiloMeters'];
        $totalMiles = $info['totalMiles'];
        $orderTonWeight = ($orderTotalWeight * 0.001);
        $orderLBWeight = ($orderTotalWeight * 2.2046);
        $queryString = ' AND CASE
        WHEN r.unit_measure1 ="KG" THEN s.uom1_min <= "' . $orderTotalWeight . '" AND s.uom1_max >= "' . $orderTotalWeight . '"
        WHEN r.unit_measure1 ="TON" THEN s.uom1_min <= "' . $orderTonWeight . '" AND s.uom1_max >= "' . $orderTonWeight . '"
        WHEN r.unit_measure1 ="LB" THEN s.uom1_min <= "' . $orderLBWeight . '" AND s.uom1_max >= "' . $orderLBWeight . '"
        WHEN r.unit_measure1 ="KM" THEN s.uom1_min <= "' . $totalKiloMeters . '" AND s.uom1_max >= "' . $totalKiloMeters . '"
        WHEN r.unit_measure1 ="MI" THEN s.uom1_min <= "' . $totalMiles . '" AND s.uom1_max >= "' . $totalMiles . '"
        WHEN r.unit_measure1 ="CBM" THEN s.uom1_min <= "' . $orderTotalVolume . '" AND s.uom1_max >= "' . $orderTotalVolume . '" END AND
        CASE
        WHEN r.unit_measure2 ="KG" THEN s.uom2_min <= "' . $orderTotalWeight . '" AND s.uom2_max >= "' . $orderTotalWeight . '"
        WHEN r.unit_measure2 ="TON" THEN s.uom2_min <= "' . $orderTonWeight . '" AND s.uom2_max >= "' . $orderTonWeight . '"
        WHEN r.unit_measure2 ="LB" THEN s.uom2_min <= "' . $orderLBWeight . '" AND s.uom2_max >= "' . $orderLBWeight . '"
        WHEN r.unit_measure2 ="KM" THEN s.uom2_min <= "' . $totalKiloMeters . '" AND s.uom2_max >= "' . $totalKiloMeters . '"
        WHEN r.unit_measure2 ="CBM" THEN s.uom2_min <= "' . $orderTotalVolume . '" AND s.uom2_max >= "' . $orderTotalVolume . '"
        WHEN r.unit_measure2 ="MI" THEN s.uom2_min <= "' . $totalMiles . '" AND s.uom2_max >= "' . $totalMiles . '" END';
        $query = $this->db->query("SELECT r.id,r.tier_id as rateTierId,r.unit_measure1,r.unit_measure2,r.currency,r.billing_uom,s.cost FROM tb_tier_master r,tb_tier_rate_sheet s WHERE r.id IN ? AND r.status = ? AND r.id = s.tier_master_id " . $queryString . " AND s.status =? GROUP BY r.id", [$ids, 1, 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachLine) {
            $tierRowId = $eachLine['id'] ?? 0;
            if ($tierRowId > 0) {
                $tierCurrency = $eachLine['currency'];
                if ($tierCurrency === $info['userCurrency']) {
                    $amount = 0;
                    if (in_array($eachLine['billing_uom'], self::WEIGHT_TYPES)) {
                        if (in_array('KG', [$eachLine['unit_measure1'], $eachLine['unit_measure2']])) {
                            $amount = $eachLine['cost'] * $orderTotalWeight;
                        }
                        if (in_array('LB', [$eachLine['unit_measure1'], $eachLine['unit_measure2']])) {
                            $amount = $eachLine['cost'] * $orderTotalWeight;
                        }
                        if (in_array('TON', [$eachLine['unit_measure1'], $eachLine['unit_measure2']])) {
                            $amount = $eachLine['cost'] * $orderTonWeight;
                        }
                    }
                    if ($eachLine['billing_uom'] == 'DISTANCE') {
                        if (in_array('KM', [$eachLine['unit_measure1'], $eachLine['unit_measure2']])) {
                            $amount = $eachLine['cost'] * $totalKiloMeters;
                        }
                        if (in_array('MI', [$eachLine['unit_measure1'], $eachLine['unit_measure2']])) {
                            $amount = $eachLine['cost'] * $totalMiles;
                        }
                    }
                    if (in_array($eachLine['billing_uom'], self::VOLUME_TYPES)) {
                        $amount = $eachLine['cost'] * $orderTotalVolume;
                    }
                    $userCurrencyResult[] = ['tierId' => $eachLine['rateTierId'], 'currency' => $tierCurrency, 'tierRowId' => $tierRowId, 'cost' => $amount, 'billingUom' => $eachLine['billing_uom'], 'minimumAmount' => 0];
                } else {
                    $otherCurrencyIds[] = $eachLine['id'];
                    $otherCurrencyData[$tierRowId] = ['tierId' => $eachLine['rateTierId'], 'currency' => $tierCurrency, 'tierRowId' => $tierRowId, 'cost' => $eachLine['cost'], 'billingUom' => $eachLine['billing_uom'], 'minimumAmount' => 0];
                }
            }
        }
        if (!empty($otherCurrencyData)) {
            $otherCurrencyResult = $this->getExchangeRateCurrencyForRateTiers($otherCurrencyData, $recordIds, $otherCurrencyIds, $info['userCurrency'], $info['userId']);
        }
        foreach ($otherCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        foreach ($userCurrencyResult as $eachLine) {
            $result[] = $eachLine;
        }
        return $result;
    }

    public function getTotalChargesAmountWithCargos(array $offeringIds, array $recordIds, array $postData, string $userCurrency, int $userId): array
    {
        $orderTotalWeight = $postData['totalWeight'] ?? 0;
        $orderTotalVolume = $postData['totalVolume'] ?? 0;
        $orderTotalQuantity = $postData['totalQuantity'] ?? 0;
        $totalKiloMeters = $postData['totalKiloMeters'] ?? 0;
        $vasData = $postData['vasData'] ?? [];
        $totalMiles = $postData['totalMiles'] ?? 0;
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        if (!empty($offeringIds)) {
            $offeringQuery = $this->db->query(
                "SELECT rateoffering_id,
                    sum(CASE
                    WHEN charge_basis IN ? THEN
                    CASE WHEN min_amount > amount THEN min_amount ELSE amount END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    END) as totalOfferingAmount
                    FROM tb_rateoffering_services WHERE rateoffering_id IN ? AND status = ? group by rateoffering_id",
                [self::TRIP_CHARGE_BASIS, self::WEIGHT_CHARGE_BASIS, $orderTotalWeight, $orderTotalWeight, self::VOLUME_CHARGE_BASIS, $orderTotalVolume, $orderTotalVolume, self::QUANTITY_CHARGE_BASIS, $orderTotalQuantity, $orderTotalQuantity, self::KM_CHARGE_BASIS, $totalKiloMeters, $totalKiloMeters, self::MILES_CHARGE_BASIS, $totalMiles, $totalMiles, self::LDM_CHARGE_BASIS, '0', '0', $offeringIds, 1]
            );
            $offeringResult = $offeringQuery->num_rows() > 0 ? $offeringQuery->result_array() : [];
        }
        if (!empty($recordIds)) {
            if ($ajaxCall > 0) {
                if (!empty($vasData)) {
                    $recordsServicesQuery = $this->db->query(
                        "SELECT raterecord_id,
                    sum(CASE
                    WHEN charge_basis IN ? THEN
                    CASE WHEN min_amount > amount THEN min_amount ELSE amount END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    END) as totalRecordServices
                    FROM tb_raterecord_services WHERE raterecord_id IN ? AND raterecord_vas_id IN ? AND status = ? group by raterecord_id",
                        [self::TRIP_CHARGE_BASIS, self::WEIGHT_CHARGE_BASIS, $orderTotalWeight, $orderTotalWeight, self::VOLUME_CHARGE_BASIS, $orderTotalVolume, $orderTotalVolume, self::QUANTITY_CHARGE_BASIS, $orderTotalQuantity, $orderTotalQuantity, self::KM_CHARGE_BASIS, $totalKiloMeters, $totalKiloMeters, self::MILES_CHARGE_BASIS, $totalMiles, $totalMiles, self::LDM_CHARGE_BASIS, '0', '0', $recordIds, $vasData, 1]
                    );
                    $recordServicesResult = $recordsServicesQuery->num_rows() > 0 ? $recordsServicesQuery->result_array() : [];
                }
            } else {
                $recordsServicesQuery = $this->db->query(
                    "SELECT raterecord_id,
                    sum(CASE
                    WHEN charge_basis IN ? THEN
                    CASE WHEN min_amount > amount THEN min_amount ELSE amount END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    END) as totalRecordServices
                    FROM tb_raterecord_services WHERE raterecord_id IN ? AND status = ? group by raterecord_id",
                    [self::TRIP_CHARGE_BASIS, self::WEIGHT_CHARGE_BASIS, $orderTotalWeight, $orderTotalWeight, self::VOLUME_CHARGE_BASIS, $orderTotalVolume, $orderTotalVolume, self::QUANTITY_CHARGE_BASIS, $orderTotalQuantity, $orderTotalQuantity, self::KM_CHARGE_BASIS, $totalKiloMeters, $totalKiloMeters, self::LDM_CHARGE_BASIS, '0', '0', self::MILES_CHARGE_BASIS, $totalMiles, $totalMiles, $recordIds, 1]
                );
                $recordServicesResult = $recordsServicesQuery->num_rows() > 0 ? $recordsServicesQuery->result_array() : [];
            }
            $recordChargesQuery = $this->db->query(
                "SELECT raterecord_id,
                sum(CASE
                    WHEN charge_basis IN ? THEN
                    CASE WHEN min_amount > amount THEN min_amount ELSE amount END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    END) as totalRecordCharges FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type = ? AND currency = ? AND status = ? GROUP BY raterecord_id",
                [self::TRIP_CHARGE_BASIS, self::WEIGHT_CHARGE_BASIS, $orderTotalWeight, $orderTotalWeight, self::VOLUME_CHARGE_BASIS, $orderTotalVolume, $orderTotalVolume, self::QUANTITY_CHARGE_BASIS, $orderTotalQuantity, $orderTotalQuantity, self::KM_CHARGE_BASIS, $totalKiloMeters, $totalKiloMeters, self::MILES_CHARGE_BASIS, $totalMiles, $totalMiles, self::LDM_CHARGE_BASIS, '0', '0', $recordIds, 'FIXED', $userCurrency, 1]
            );
            $recordChargesResult = $recordChargesQuery->num_rows() > 0 ? $recordChargesQuery->result_array() : [];
            $getTiersData = $this->db->query("SELECT raterecord_id,rr_tier_id,geo_tier_id,rr_charge_id FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type != ? AND status = ?", [$recordIds, 'FIXED', 1]);
            $tiersDataResult = $getTiersData->num_rows() > 0 ? $getTiersData->result_array() : [];
            foreach ($tiersDataResult as $eachLine) {
                $tiersData[] = ['recordId' => $eachLine['raterecord_id'], 'tierId' => $eachLine['rr_tier_id'], 'geoTierId' => $eachLine['geo_tier_id'], 'chargeId' => $eachLine['rr_charge_id']];
            }
            $otherCurrencyRecords = $this->getOtherCurrencyCharges($recordIds, $userCurrency, $userId);
            foreach ($otherCurrencyRecords as $eachRow) {
                $chargeBasis = $eachRow['charge_basis'];
                $finalAmount = $eachRow['totalAmount'];
                $minimumAmount = $eachRow['minimumAmount'] ?? 0;
                if ($eachRow['currency'] == $userCurrency) {
                    if (in_array($chargeBasis, self::TRIP_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount;
                    } elseif (in_array($chargeBasis, self::WEIGHT_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * $orderTotalWeight;
                    } elseif (in_array($chargeBasis, self::VOLUME_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * $orderTotalVolume;
                    } elseif (in_array($chargeBasis, self::QUANTITY_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * $orderTotalQuantity;
                    } elseif (in_array($chargeBasis, self::MILES_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * $totalMiles;
                    } elseif (in_array($chargeBasis, self::KM_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * $totalKiloMeters;
                    } elseif (in_array($chargeBasis, self::LDM_CHARGE_BASIS)) {
                        $totalAmount = $finalAmount * 0;
                    }
                } else {
                    $totalAmount = $finalAmount;
                }
                $totalAmount = $totalAmount ?? 0;
                if ($minimumAmount > $totalAmount) {
                    $totalAmount = $minimumAmount;
                }
                $otherCurrencyCharges[$eachRow['raterecord_id']] = $totalAmount;
                $dummyCurrencyCharges[$eachRow['id']] = $eachRow['amount'];
            }
            $fafWithRateId = [];
            $checkIfFafexistsInRecord = $this->db->query("SELECT raterecord_id,fuel_surcharge_id FROM tb_raterecord_charges WHERE raterecord_id IN ? AND fuel_surcharge_id > ? AND status = ?", [$recordIds, 0, 1]);
            $fafResult = $checkIfFafexistsInRecord->num_rows() > 0 ? $checkIfFafexistsInRecord->result_array() : [];
            foreach ($fafResult as $eachLine) {
                $fafWithRateId[$eachLine['raterecord_id']][] = $eachLine['fuel_surcharge_id'];
                $fafIds[] = $eachLine['raterecord_id'];
            }
            if (!empty($fafWithRateId)) {
                $frtRecordChargesAmount = $this->getFRTTotalAmountFromRateRecordCharges(['recordIds' => $recordIds, 'orderTotalWeight' => $orderTotalWeight, 'orderTotalVolume' => $orderTotalVolume, 'orderTotalQuantity' => $orderTotalQuantity, 'totalKiloMeters' => $totalKiloMeters, 'totalMiles' => $totalMiles, 'userCurrency' => $userCurrency]);
            }
        }
        return ['offering' => $offeringResult ?? [], 'recordServices' => $recordServicesResult ?? [], 'recordCharges' => $recordChargesResult ?? [], 'tiersData' => $tiersData ?? [], 'fafWithRateId' => $fafWithRateId ?? [], 'otherCurrencyCharges' => $otherCurrencyCharges ?? [], 'frtRecordChargesAmount' => $frtRecordChargesAmount ?? []];
    }

    private function getFRTTotalAmountFromRateRecordCharges(array $data)
    {
        $queryResult = $this->db->query(
            "SELECT raterecord_id,
                sum(CASE
                    WHEN charge_basis IN ? THEN
                    CASE WHEN min_amount > amount THEN min_amount ELSE amount END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    WHEN charge_basis IN ? THEN
                    CASE WHEN ( ? * amount ) < min_amount THEN min_amount ELSE ( ? * amount ) END
                    END) as totalRecordCharges FROM tb_raterecord_charges WHERE raterecord_id IN ? AND rr_charge_type = ? AND rr_charge_id = ? AND currency = ? AND status = ? GROUP BY raterecord_id",
            [
                self::TRIP_CHARGE_BASIS,
                self::WEIGHT_CHARGE_BASIS,
                $data['orderTotalWeight'],
                $data['orderTotalWeight'],
                self::VOLUME_CHARGE_BASIS,
                $data['orderTotalVolume'],
                $data['orderTotalVolume'],
                self::QUANTITY_CHARGE_BASIS,
                $data['orderTotalQuantity'],
                $data['orderTotalQuantity'],
                self::KM_CHARGE_BASIS,
                $data['totalKiloMeters'],
                $data['totalKiloMeters'],
                self::MILES_CHARGE_BASIS,
                $data['totalMiles'],
                $data['totalMiles'],
                self::LDM_CHARGE_BASIS,
                '0',
                '0',
                $data['recordIds'],
                'FIXED',
                self::FRT_CHARGE_ID,
                $data['userCurrency'],
                1
            ]
        );
        $result = $queryResult->num_rows() > 0 ? $queryResult->result_array() : [];
        foreach ($result as $eachLine) {
            $response[$eachLine['raterecord_id']] = $eachLine['totalRecordCharges'];
        }
        return $response ?? [];
    }

    public function getAllRatesAmountWithConversion(array $data): array
    {
        $conversionIds = [];
        $offeringIds = $data['offeringRowIdsWithConversion'];
        $postData = $data['postData'];
        $vasData = $postData['vasData'] ?? [];
        $getConversionFactor = $this->db->query("SELECT ro.id,ro.uom_conversion_id,uom.uom_type1,uom.uom1,uom.uom1_conversion,uom.uom_type2,uom.uom2,uom.uom2_conversion,uom.uom_type3,uom.uom3,uom.uom3_conversion,uom.uom_type4,uom.uom4,uom.uom4_conversion,base_uom FROM tb_rate_offerings ro,tb_knuom_conversion uom WHERE ro.id IN ? AND ro.uom_conversion_id = uom.id", [$offeringIds]);
        foreach ($getConversionFactor->num_rows() > 0 ? $getConversionFactor->result_array() : [] as $eachLine) {
            $conversionIds[$eachLine['id']] = [
                'conversionId' => $eachLine['uom_conversion_id'],
                'uomType1' => $eachLine['uom_type1'],
                'uomValue1' => $eachLine['uom1'],
                'uomConversion1' => $eachLine['uom1_conversion'],
                'uomType2' => $eachLine['uom_type2'],
                'uomValue2' => $eachLine['uom2'],
                'uomConversion2' => $eachLine['uom2_conversion'],
                'uomType3' => $eachLine['uom_type3'],
                'uomValue3' => $eachLine['uom3'],
                'uomConversion3' => $eachLine['uom3_conversion'],
                'uomType4' => $eachLine['uom_type4'],
                'uomValue4' => $eachLine['uom4'],
                'uomConversion4' => $eachLine['uom4_conversion'],
                'baseUom' => $eachLine['base_uom']
            ];
        }
        $offeringQuery = $this->db->query("SELECT rateoffering_id,ro_vas_id,ro_charge_id,charge_basis,min_amount,amount,currency FROM tb_rateoffering_services WHERE rateoffering_id IN ? AND status = ?", [$offeringIds, 1]);
        foreach ($offeringQuery->num_rows() > 0 ? $offeringQuery->result_array() : [] as $eachLine) {
            $offeringFinalIds[] = $eachLine['rateoffering_id'];
            $offeringServices[$eachLine['rateoffering_id']][] = ['rowId' => $eachLine['rateoffering_id'], 'offeringId' => $eachLine['rateoffering_id'], 'chargeId' => $eachLine['ro_charge_id'], 'vasId' => $eachLine['ro_vas_id'], 'chargeBasis' => $eachLine['charge_basis'], 'minimumAmount' => $eachLine['min_amount'], 'amount' => $eachLine['amount'], 'currency' => $eachLine['currency']];
        }
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        if ($ajaxCall > 0 && !empty($vasData)) {
            $recordServicesQuery = $this->db->query("SELECT rr.id,rr.offering_id,rrs.raterecord_vas_id,rrs.raterecord_charge_id,rrs.charge_basis,rrs.min_amount.rrs.amount,rrs.currency FROM tb_rate_records rr,tb_raterecord_services rrs WHERE rr.id = rrs.raterecord_id AND rr.offering_id IN ? AND rr.status = ? AND rrs.raterecord_vas_id IN ?  AND rrs.status = ? GROUP BY rrs.id", [$offeringIds, $vasData, 1, 1]);
            foreach ($recordServicesQuery->num_rows() > 0 ? $recordServicesQuery->result_array() : [] as $eachLine) {
                $recordServiceIds[] = $recordRowIds[] = $eachLine['id'];
                $recordServices[$eachLine['id']][] = ['rowId' => $eachLine['id'], 'offeringId' => $eachLine['offering_id'], 'chargeId' => $eachLine['raterecord_charge_id'], 'vasId' => $eachLine['raterecord_vas_id'], 'chargeBasis' => $eachLine['charge_basis'], 'minimumAmount' => $eachLine['min_amount'], 'amount' => $eachLine['amount'], 'currency' => $eachLine['currency']];
            }
        }
        $recordChargesQuery = $this->db->query("SELECT rr.id,rr.offering_id,rrc.rr_charge_type,rrc.rr_tier_id,rrc.geo_tier_id,rrc.rr_charge_id,rrc.charge_basis,rrc.min_amount,rrc.amount,rrc.currency FROM tb_rate_records rr,tb_raterecord_charges rrc WHERE rr.id = rrc.raterecord_id AND rr.offering_id IN ? AND rr.status = ? AND rrc.status = ? GROUP BY rrc.id", [$offeringIds, 1, 1]);
        foreach ($recordChargesQuery->num_rows() > 0 ? $recordChargesQuery->result_array() : [] as $eachLine) {
            $recordChargesIds[] = $recordRowIds[] = $eachLine['id'];
            if (strtoupper($eachLine['rr_charge_type']) == "FIXED") {
                $recordCharges[$eachLine['id']][] = ['rowId' => $eachLine['id'], 'offeringId' => $eachLine['offering_id'], 'chargeBasis' => $eachLine['charge_basis'], 'minimumAmount' => $eachLine['min_amount'], 'amount' => $eachLine['amount'], 'chargeId' => $eachLine['rr_charge_id'], 'currency' => $eachLine['currency']];
            } else {
                $tiersData[] = ['recordId' => $eachLine['id'], 'tierId' => $eachLine['rr_tier_id'], 'geoTierId' => $eachLine['geo_tier_id'], 'chargeId' => $eachLine['rr_charge_id'], 'offeringId' => $eachLine['offering_id']];
            }
        }
        if (!empty($recordRowIds ?? [])) {
            $checkIfFafexistsInRecord = $this->db->query("SELECT rr.id,rr.offering_id,rrc.raterecord_id,rrc.fuel_surcharge_id FROM tb_rate_records rr,tb_raterecord_charges rrc WHERE rrc.raterecord_id IN ? AND rrc.raterecord_id = rr.id AND rrc.fuel_surcharge_id > ? AND rrc.status = ? GROUP BY rrc.id", [$recordRowIds, 0, 1]);
            $fafResult = $checkIfFafexistsInRecord->num_rows() > 0 ? $checkIfFafexistsInRecord->result_array() : [];
            foreach ($fafResult as $eachLine) {
                $fafWithRateRecordId[$eachLine['raterecord_id']][] = $eachLine['fuel_surcharge_id'];
                $fafWithRateOfferingId[$eachLine['offering_id']][] = $eachLine['fuel_surcharge_id'];
                $fafIds[] = $eachLine['fuel_surcharge_id'];
            }
        }
        $offeringData = $this->getFinalRatesAmountWithConversion($offeringFinalIds ?? [], $offeringServices ?? [], $postData, $conversionIds);
        $recordServicesData = $this->getFinalRatesAmountWithConversion($recordServiceIds ?? [], $recordServices ?? [], $postData, $conversionIds);
        $recordChargesData = $this->getFinalRatesAmountWithConversion($recordChargesIds ?? [], $recordCharges ?? [], $postData, $conversionIds);
        return ['offeringData' => $offeringData, 'recordServicesData' => $recordServicesData, 'recordChargesData' => $recordChargesData, 'tiersData' => $tiersData ?? [], 'fafDetails' => ['fafIds' => $fafIds ?? [], 'fafWithRateId' => $fafWithRateRecordId ?? []]];
    }

    private function getFinalRatesAmountWithConversion(array $offeringFinalIds, array $offeringServices, array $postData, array $conversionIds): array
    {
        if (empty($offeringServices)) {
            return [];
        }
        $orderTotalWeight = $postData['totalWeight'] ?? 0;
        $orderTotalVolume = $postData['totalVolume'] ?? 0;
        foreach ($offeringFinalIds as $eachOfferingId) {
            $offeringData = $offeringServices[$eachOfferingId];
            $finalAmount = $unitToBeConsidered = 0;
            $conversionBaseUom = "";
            $charges = [];
            $iMax = count($offeringData);
            for ($i = 0; $i < $iMax; $i++) {
                $offeringId = $offeringData[$i]['offeringId'];
                if ($i > 0) {
                    if ($unitToBeConsidered > 0 && $conversionBaseUom != "") {
                        $offeringData[$i]['unitToBeConsidered'] = $unitToBeConsidered;
                        $offeringData[$i]['conversionBaseUom'] = $conversionBaseUom;
                        $amount = $this->getFinalAmountBasedOnChargeAndConversion($postData, $offeringData[$i])['amount'];
                        if ($offeringData[$i]['minimumAmount'] > $amount) {
                            $finalAmount += $offeringData[$i]['minimumAmount'];
                        } else {
                            $finalAmount += $amount;
                        }
                    }
                } else {
                    $conversionId = $conversionIds[$offeringId]['conversionId'] ?? 0;
                    if ($conversionId > 0) {
                        $conversionData = $conversionIds[$offeringId] ?? [];
                        if (empty($conversionData)) {
                            continue;
                        }
                        $conversionFactorWeight = $this->getConversionFactorWeight($conversionData);
                        $conversionFactorVolume = $this->getConversionFactorVolume($conversionData);
                        $weight = $orderTotalWeight * $conversionFactorWeight;
                        $volume = $orderTotalVolume * $conversionFactorVolume;
                        $unitToBeConsidered = $offeringData[$i]['unitToBeConsidered'] = max($weight, $volume);
                        $conversionBaseUom = $offeringData[$i]['conversionBaseUom'] = $conversionData['baseUom'];
                        $amount = $this->getFinalAmountBasedOnChargeAndConversion($postData, $offeringData[$i])['amount'];
                        if ($offeringData[$i]['minimumAmount'] > $amount) {
                            $finalAmount = $offeringData[$i]['minimumAmount'];
                        } else {
                            $finalAmount = $amount;
                        }
                    }
                }
                $result[$eachOfferingId]['amount'] = $finalAmount;
                $result[$eachOfferingId]['unitToBeConsidered'] = $offeringData[$i]['unitToBeConsidered'];
                $result[$eachOfferingId]['conversionBaseUom'] = $offeringData[$i]['conversionBaseUom'];
                $result[$eachOfferingId]['conversionBaseUom'] = $offeringData[$i]['conversionBaseUom'];
                $result[$eachOfferingId]['rowId'] = $offeringData[$i]['rowId'];
                $amount = $amount ?? 0;
                $charges[] = ['minimumAmount' => $offeringData[$i]['minimumAmount'], 'amount' => $amount > $offeringData[$i]['minimumAmount'] ? $amount : $offeringData[$i]['minimumAmount'], 'currency' => $offeringData[$i]['currency'], 'vasId' => $offeringData[$i]['vasId'] ?? 0, 'chargeId' => $offeringData[$i]['chargeId'], 'rowId' => $offeringData[$i]['rowId']];
                $result[$eachOfferingId]['chargesWithoutFaf'] = $charges;
            }
        }
        return $result ?? [];
    }

    private function getFinalAmountBasedOnChargeAndConversion(array $postData, array $offeringData): array
    {
        $orderTotalWeight = $postData['totalWeight'] ?? 0;
        $orderTotalVolume = $postData['totalVolume'] ?? 0;
        $orderTotalQuantity = $postData['totalQuantity'] ?? 0;
        $totalKiloMeters = $postData['totalKiloMeters'] ?? 0;
        $totalMiles = $postData['totalMiles'] ?? 0;
        if (in_array(strtoupper($offeringData['chargeBasis']), ["PER " . strtoupper($offeringData['conversionBaseUom']), strtoupper($offeringData['conversionBaseUom'])])) {
            $amount = ($offeringData['unitToBeConsidered'] * $offeringData['amount']);
        } else {
            if (in_array(strtoupper($offeringData['chargeBasis']), self::WEIGHT_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * $orderTotalWeight;
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::TRIP_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'];
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::VOLUME_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * $orderTotalVolume;
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::QUANTITY_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * $orderTotalQuantity;
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::MILES_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * $totalMiles;
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::KM_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * $totalKiloMeters;
            } elseif (in_array(strtoupper($offeringData['chargeBasis']), self::LDM_CHARGE_BASIS, true)) {
                $amount = $offeringData['amount'] * 0;
            }
        }
        return ['amount' => $amount ?? 0];
    }

    private function getConversionFactorWeight(array $data): string
    {
        if (in_array($data['uomType1'], self::WEIGHT_TYPES, true)) {
            $data['conversionFactorWeight'] = $data['uomConversion1'];
        } elseif (in_array($data['uomType2'], self::WEIGHT_TYPES, true)) {
            $data['conversionFactorWeight'] = $data['uomConversion2'];
        } elseif (in_array($data['uomType3'], self::WEIGHT_TYPES, true)) {
            $data['conversionFactorWeight'] = $data['uomConversion3'];
        } elseif (in_array($data['uomType4'], self::WEIGHT_TYPES, true)) {
            $data['conversionFactorWeight'] = $data['uomConversion4'];
        }
        return $data['conversionFactorWeight'] ?? 0;
    }

    private function getConversionFactorVolume(array $data): string
    {
        if (in_array($data['uomType1'], self::VOLUME_TYPES, true)) {
            $data['conversionFactorVolume'] = $data['uomConversion1'];
        } elseif (in_array($data['uomType2'], self::VOLUME_TYPES, true)) {
            $data['conversionFactorVolume'] = $data['uomConversion2'];
        } elseif (in_array($data['uomType3'], self::VOLUME_TYPES, true)) {
            $data['conversionFactorVolume'] = $data['uomConversion3'];
        } elseif (in_array($data['uomType4'], self::VOLUME_TYPES, true)) {
            $data['conversionFactorVolume'] = $data['uomConversion4'];
        }
        return $data['conversionFactorVolume'] ?? 0;
    }

    public function getGeoTiersAmountWithConversion(array $data): array
    {
        $geoTierPairs = $data['geoPairs'];
        $geoPairs = $geoTierPairs['pair1'];
        $geoTiers = $data['geoTiers'];
        $totalVolume = $data['totalVolume'];
        $totalWeight = $data['totalWeight'];
        $amountDetails = $data['amountDetails'];
        $recordChargesData = $amountDetails['recordChargesData'];
        foreach ($geoTiers as $eachTier) {
            $geoTierId = $eachTier['geoTierId'];
            $recordId = $eachTier['recordId'];
            $chargeId = $eachTier['chargeId'];
            $unitToBeConsidered = $recordChargesData[$recordId]['unitToBeConsidered'];
            $conversionBaseUom = $recordChargesData[$recordId]['conversionBaseUom'];
            $query = $this->db->query(
                "SELECT gt.geo_tier_id,gt.currency,gt.flat,s.cost FROM tb_geo_tier gt, tb_geo_tier_sheet s WHERE gt.id = s.geo_tier_id
                                       AND gt.id = '" . $geoTierId . "'AND s.uom1_min <= '" . $unitToBeConsidered . "' AND s.uom1_max >='" . $unitToBeConsidered . "' AND gt.unit_measure1= '" . $conversionBaseUom . "' AND s.status = 1 AND gt.status = 1 AND
                                        CASE
                                        WHEN gt.geo_hierarchy ='PROVINCE' THEN " . $geoPairs['PROVINCE'] . "
                                        WHEN gt.geo_hierarchy ='POSTAL CODE' THEN " . $geoPairs['POSTAL CODE'] . "
                                        WHEN gt.geo_hierarchy ='CITY' THEN " . $geoPairs['CITY'] . "
                                        WHEN gt.geo_hierarchy ='COUNTRY' THEN " . $geoPairs['COUNTRY'] . " END "
            );
            if ($query->num_rows() > 0) {
                $queryData = $query->row_array();
                if (!empty($queryData)) {
                    if ($queryData['flat'] > 0) {
                        $amount = $queryData['cost'];
                    } else {
                        $amount = ($queryData['cost'] * $unitToBeConsidered);
                    }
                    $recordChargesData[$recordId]['amount'] += $amount;
                }
            } else {
                $query = $this->db->query(
                    "SELECT gt.geo_tier_id,gt.unit_measure1,gt.currency,gt.flat,s.cost FROM tb_geo_tier gt, tb_geo_tier_sheet s WHERE gt.id = s.geo_tier_id
                                       AND gt.id = '" . $geoTierId . "' AND s.status = 1 AND gt.status = 1 AND
                                        CASE
        WHEN gt.unit_measure1 ='KG' THEN s.uom1_min <= '" . $totalWeight . "' AND s.uom1_max >= '" . $totalWeight . "'
        WHEN gt.unit_measure1 ='CBM' THEN s.uom1_min <= '" . $totalVolume . "' AND s.uom1_max >= '" . $totalVolume . "' END AND
                                        CASE
                                        WHEN gt.geo_hierarchy ='PROVINCE' THEN " . $geoPairs['PROVINCE'] . "
                                        WHEN gt.geo_hierarchy ='POSTAL CODE' THEN " . $geoPairs['POSTAL CODE'] . "
                                        WHEN gt.geo_hierarchy ='CITY' THEN " . $geoPairs['CITY'] . "
                                        WHEN gt.geo_hierarchy ='COUNTRY' THEN " . $geoPairs['COUNTRY'] . " END "
                );
                $queryData = $query->num_rows() > 0 ? $query->row_array() : [];
                if (!empty($queryData)) {
                    if ($queryData['flat'] > 0) {
                        $amount = $queryData['cost'];
                    } else {
                        if ($queryData['unit_measure1'] == "KG") {
                            $unitToBeConsidered = $totalWeight;
                        } else {
                            $unitToBeConsidered = $totalVolume;
                        }
                        $amount = ($queryData['cost'] * $unitToBeConsidered);
                    }
                    $recordChargesData[$recordId]['amount'] += $amount;
                }
            }
            $amountDetails['recordChargesData'] = $recordChargesData;
            $geoTiersData[$recordId][] = ['rowId' => $geoTierId, 'amount' => $amount ?? 0, 'geoTierId' => $queryData['geo_tier_id'], 'chargeId' => $chargeId, 'currency' => $queryData['currency']];
        }
        return ['amountDetails' => $amountDetails, 'geoTiers' => $geoTiersData ?? []];
    }

}

?>
