<?php

defined('BASEPATH') or exit('No direct script access allowed');

class ReportCWGModel extends CI_Model
{

    public function getTripIds(string $tripId, string $getUserIds): array
    {
        $this->db->select("s.shipmentid as tripId");
        $this->db->from("tb_shifts s");
        $this->db->join("tb_orders o", "s.id=o.shift_id AND o.status !='0'", "INNER");
        $this->db->like('s.shipmentid', $tripId, 'both');
        $this->db->where($getUserIds);
        $this->db->limit(50);
        $getShiftData = $this->db->get();
        $getShiftArray = (!empty($getShiftData)) ? $getShiftData->result_array() : [];
        foreach ($getShiftArray as $getTripIds) {
            $getShipmentIds[] = ["id" => $getTripIds['tripId'], "text" => $getTripIds['tripId']];
        }
        return $getShipmentIds ?? ["id" => "", "text" => ""];
    }

    public function getOrderIds(string $bookingId, string $getUserIds): array
    {
        $this->db->select("o.order_id");
        $this->db->from("tb_orders as o");
        $this->db->join("tb_shifts s", "s.id=o.shift_id AND o.status !='0'", "INNER");
        $this->db->like('o.order_id', $bookingId, 'both');
        $this->db->where($getUserIds);
        $this->db->limit(50);
        $getOrderData = $this->db->get();
        $getOrderArray = (!empty($getOrderData)) ? $getOrderData->result_array() : [];
        foreach ($getOrderArray as $getOrderIds) {
            $getBookingIds[] = ["id" => $getOrderIds['order_id'], "text" => $getOrderIds['order_id']];
        }
        return $getBookingIds ?? ["id" => "", "text" => ""];
    }

    public function getPartyCodes(string $orderId): array
    {
        $partyCodes = [];
        $this->db->select(",p.code,pt.name");
        $this->db->from("tbl_party_master as p");
        $this->db->join("tb_order_parties as op", "p.id=op.party_id AND op.status ='1'", "INNER");
        $this->db->join("tbl_party_types as pt", "pt.id=op.party_type AND pt.status ='1'", "INNER");
        $this->db->where(['p.status' => 1, 'op.order_id' => $orderId]);
        $this->db->where_in('pt.name', ['Consignee', 'Shipper']);
        $getPartyData = $this->db->get();
        $getPartyArray = (!empty($getPartyData)) ? $getPartyData->result_array() : [];
        foreach ($getPartyArray as $getParty) {
            if (strtoupper($getParty['name']) === "CONSIGNEE") {
                $partyCodes['consigneeId'] = $getParty['code'];
            }
            if (strtoupper($getParty['name']) === "SHIPPER") {
                $partyCodes['shipperId'] = $getParty['code'];
            }
        }
        return $partyCodes;
    }

    public function getOrderCount(string $whereCondition): array
    {
        $this->db->select("count(s.id) as count");
        $this->db->from("tb_shifts s");
        $this->db->join("tb_orders o", "s.id=o.shift_id", "INNER");
        $this->db->join("tb_shft_veh sv", "s.id=sv.shft_id and sv.status='1'", "LEFT");
        $this->db->join("tb_trucks_data td", "td.id=sv.vehicle_id and td.status='Active'", "LEFT");
        $this->db->where($whereCondition);
        $res = $this->db->get();
        return ($res->num_rows() > 0) ? $res->row_array() : [];
    }

}
