<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class Reportmodel extends CI_Model
{
    public function __construct() {
        parent::__construct();
	}

	public function ordercount($year_stdate,$year_enddate){
		$res=$this->db->query("select count(id) as cnt FROM tb_orders WHERE status!=0 AND parent_id=0 AND DATE(createdon) BETWEEN '".$year_stdate."' AND '".$year_enddate."'");
		$count = 0;
		if($res->num_rows()>0){
			$count = $res->row()->cnt;
		}
		return $count;
	}

    public function countryalldata(array $countryCodes = []): array
    {
        if (empty($countryCodes)) {
            $query = $this->db->query("select distinct(u.country_code),m.country_name,m.annual_shipment_target FROM `tbl_country_master` m, tb_users u WHERE m.status=1 AND u.country_code=m.country_code ORDER BY u.country_code ASC");
        } else {
            $query = $this->db->query("select distinct(u.country_code),m.country_name,m.annual_shipment_target FROM `tbl_country_master` m, tb_users u WHERE m.status=1 AND u.country_code=m.country_code AND m.country_code IN ? ORDER BY u.country_code ASC", [$countryCodes]);
        }
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function monthdata($start_date, $end_date, $country): int
    {
        if ($country == 'AU') {
            $query = "select count(t.id) as cnt FROM tb_orders t,tb_users tu
                      WHERE t.user_id=tu.id AND t.status!=0 AND t.parent_id=0
                      AND tu.country_code=? AND DATE(t.pickup_datetime) BETWEEN ? AND ? ";
        } else {
            $query = "select count(t.id) as cnt FROM tb_orders t,tb_users tu
                      WHERE t.user_id=tu.id AND t.status!=0 AND t.parent_id=0
                      AND tu.country_code=? AND DATE(t.createdon) BETWEEN ? AND ? ";
        }
        $query_fetch = $this->db->query($query, [$country, $start_date, $end_date]);
        return !empty($query_fetch->num_rows()) ? $query_fetch->row()->cnt : 0;
    }

	public function getcategorylist(){
        $organic=array('5','6','7','8');
        $saas=array('4');
        $cross_bu=array('1','2','3');
        $category_array=array();
        /*Cross BU Query*/
        $this->db->where('status <>',0);
        $this->db->where('parent_id',0);
        $this->db->where_in('category_id',$cross_bu);
        $crossbu_res=$this->db->count_all_results('tb_orders');
        /*SAAS Query*/
        $this->db->where('status <>',0);
        $this->db->where('parent_id',0);
        $this->db->where_in('category_id',$saas);
        $saas_res=$this->db->count_all_results('tb_orders');
        /*Organic Query*/
        $this->db->where('status <>',0);
        $this->db->where('parent_id',0);
        $this->db->where_in('category_id',$organic);
        $organic_res=$this->db->count_all_results('tb_orders');
        $category_array['crossbu']= $crossbu_res;
        $category_array['organic']= $organic_res;
        $category_array['saas_res']= $saas_res;
		$category_array['eu_res']= 0;
        return $category_array;
    }

    public function add($data_field, $tablename)
	{
		$this->db->insert($tablename,$data_field ?: []);
		return $this->db->insert_id();
	}

	public function edit_cond($data_field,$where,$tablename)
	{
		return $this->db->update($tablename, $data_field ?: [], $where ?: []);
	}

	public function delete_cond($cond, $tablename)
	{
		$this->db->where($cond ?: [], NULL, false);
		$this->db->delete($tablename);
		return $this->db->affected_rows();
	}
    public function special_fetch($con=null) {
        $query =null;
        if ($con) {
            $query = $this->db->query($con);
        }
        return $query->result_array();
    }

	public function special_ret($con=null,$data_field=array()) {
        $query =null;
        if ($con) {
            $query = $this->db->query($con,$data_field);
        }
        return $query->result_array();
    }

    public function dataByCountry($year = null, $customerIds = null): array
    {
        $query = "SELECT r.country_name AS Country,
                    SUM(CASE WHEN r.mon = '01' THEN r.counter ELSE 0 END) AS 'Jan',
                    SUM(CASE WHEN r.mon = '02' THEN r.counter ELSE 0 END) AS 'Feb',
                    SUM(CASE WHEN r.mon = '03' THEN r.counter ELSE 0 END) AS 'Mar',
                    SUM(CASE WHEN r.mon = '04' THEN r.counter ELSE 0 END) AS 'Apr',
                    SUM(CASE WHEN r.mon = '05' THEN r.counter ELSE 0 END) AS 'May',
                    SUM(CASE WHEN r.mon = '06' THEN r.counter ELSE 0 END) AS 'Jun',
                    SUM(CASE WHEN r.mon = '07' THEN r.counter ELSE 0 END) AS 'Jul',
                    SUM(CASE WHEN r.mon = '08' THEN r.counter ELSE 0 END) AS 'Aug',
                    SUM(CASE WHEN r.mon = '09' THEN r.counter ELSE 0 END) AS 'Sep',
                    SUM(CASE WHEN r.mon = '10' THEN r.counter ELSE 0 END) AS 'Oct',
                    SUM(CASE WHEN r.mon = '11' THEN r.counter ELSE 0 END) AS 'Now',
                    SUM(CASE WHEN r.mon = '12' THEN r.counter ELSE 0 END) AS 'Dec',
                    SUM(r.counter) AS 'Total'
                  FROM
                      (SELECT tc.country_name, MONTH(t.createdon) AS mon, COUNT(t.id) AS counter
                        FROM tb_orders t
                        INNER JOIN tb_users tu ON t.user_id = tu.id
                        INNER JOIN tb_customers c ON t.customer_id = c.id
                        INNER JOIN tbl_country_master tc ON tu.country_code = tc.country_code
                      WHERE t.status != 0
                        AND t.parent_id = 0
                        AND EXTRACT(YEAR FROM t.createdon) = " . $year;
        if (is_array($customerIds)) {
            $query .= $this->generateFilterForUniqlo($customerIds);
        }
        $query .= " GROUP BY tu.country_code, MONTH(t.createdon)) r
                  GROUP BY r.country_name;";
        $result = $this->db->query($query);
        return $result->num_rows() > 0 ? $result->result_array() : [];
    }

    public function dataByCustomer($year = null, $customerIds = null): array
    {
        $query = "SELECT r.name AS Customer,
                    SUM(CASE WHEN r.mon = '01' THEN r.counter ELSE 0 END) AS 'Jan',
                    SUM(CASE WHEN r.mon = '02' THEN r.counter ELSE 0 END) AS 'Feb',
                    SUM(CASE WHEN r.mon = '03' THEN r.counter ELSE 0 END) AS 'Mar',
                    SUM(CASE WHEN r.mon = '04' THEN r.counter ELSE 0 END) AS 'Apr',
                    SUM(CASE WHEN r.mon = '05' THEN r.counter ELSE 0 END) AS 'May',
                    SUM(CASE WHEN r.mon = '06' THEN r.counter ELSE 0 END) AS 'Jun',
                    SUM(CASE WHEN r.mon = '07' THEN r.counter ELSE 0 END) AS 'Jul',
                    SUM(CASE WHEN r.mon = '08' THEN r.counter ELSE 0 END) AS 'Aug',
                    SUM(CASE WHEN r.mon = '09' THEN r.counter ELSE 0 END) AS 'Sep',
                    SUM(CASE WHEN r.mon = '10' THEN r.counter ELSE 0 END) AS 'Oct',
                    SUM(CASE WHEN r.mon = '11' THEN r.counter ELSE 0 END) AS 'Now',
                    SUM(CASE WHEN r.mon = '12' THEN r.counter ELSE 0 END) AS 'Dec',
                    SUM(r.counter) AS 'Total'
                  FROM
                      (SELECT c.name, MONTH(t.createdon) AS mon, COUNT(t.id) AS counter
                        FROM tb_orders t
                        INNER JOIN tb_users tu ON t.user_id = tu.id
                        INNER JOIN tb_customers c ON t.customer_id = c.id
                      WHERE t.status != 0
                        AND t.parent_id = 0
                        AND EXTRACT(YEAR FROM t.createdon) = " . $year;
        if (is_array($customerIds)) {
            $query .= $this->generateFilterForUniqlo($customerIds);
        }
        $query .= " GROUP BY c.name, MONTH(t.createdon)) r
                  GROUP BY r.name;";
        $result = $this->db->query($query);
        return $result->num_rows() > 0 ? $result->result_array() : [];
    }

    public function generateFilterForUniqlo(array $customerIds): string
    {
        return " AND ( CASE WHEN EXTRACT(YEAR_MONTH FROM  t.createdon) <= 202107
        THEN c.id IN (" . implode(',', $customerIds) . ")
        ELSE t.created_source IN (15, 16) END ) ";
    }

    public function getShipmentStopStatusLists(int $shipmentId, string $timeZone, string $branchCode): array {
        $bindParams = []; $whereCondition = "";
        $bindParams[] = $timeZone;
        if ($branchCode === "INCL") {
            $whereCondition = "ts.shipment_id = ? AND ts.status_code IN ? ";
            $bindParams[] = $shipmentId;
            $bindParams[] = ['0470','0420','1550','0500','0191','2990','2989','0192','2300','RTO','3050','3000','2400','DTO','3051'];
        } else {
            $whereCondition = "ts.shipment_id = ? ";
            $bindParams[] = $shipmentId;
        }
        $getResuls = $this->db->query("
            SELECT ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,?) as createdon,sm.status_name
            FROM tb_stop_status ts
            LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
            LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
            WHERE {$whereCondition}
            GROUP BY ts.id ORDER BY ts.id ASC", $bindParams);
        return $getResuls->num_rows() > 0 ? $getResuls->result_array() : [];
    }
}
