<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Roadlogtosalogmodel extends CI_Model
{


    public function __construct()
    {
        parent::__construct();
    }

    public function getCustomerDetails(int $orderId): array
    {
        $customerDetails = $this->db->query("SELECT o.id,o.order_id,o.customer_id,o.user_id,o.created_source,o.pickup_city,o.delivery_city,o.pickup_address1,o.delivery_address1,c.name,c.gcm_id,c.company_code,c.branch_code,c.phone,c.code,o.company_code AS order_company_code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id=? LIMIT 1", [$orderId]);
        return $customerDetails->num_rows() > 0 ? $customerDetails->row_array() : [];
    }

    public function getOrderReferenceCount(int $orderId): int
    {
        $references = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id = ? AND ((reference_id = 'OT' AND ref_value='PUP') OR (reference_id = 'XSR' AND ref_value!='') AND status=1)", [$orderId]);
        return $references->num_rows() ?? 0;
    }

    public function getOrderDocuments(string $pickupAddress, string $pickupCity, string $deliveryCity, string $orderNumber, int $orderId): object
    {
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $orderDocumentQuery = "SELECT ts.id,ts.latitude,ts.longitude,ts.hash,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath,? as address,? as pickup,? as `drop`,? as order_id
                    FROM tb_pod_uploads ts
                        INNER JOIN tb_document_types dt ON dt.id=ts.doc_type AND ts.stop_type='P'
                    WHERE ts.order_id = ? AND ts.status=1
                    GROUP BY ts.id
                    ORDER BY ts.createdon ASC";
        $orderDocuments = $this->db->query($orderDocumentQuery, [$timeZone, $pickupAddress, $pickupCity, $deliveryCity, $orderNumber, $orderId]);
        return $orderDocuments->num_rows() > 0 ? $orderDocuments : (object)[];
    }

    public function getShipmentStops(int $shipmentId): array
    {
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $shipmentStops = $this->db->query("SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,?) as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=? AND ss.status=? ORDER BY ss.createdon ASC", [$timeZone, $shipmentId, 1]);
        return $shipmentStops->num_rows() > 0 ? $shipmentStops->result_array() : [];
    }

    public function getOrderReferences(int $orderId): array
    {
        $orderReferencesQuery = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
        $orderReferences = $this->db->query($orderReferencesQuery, [$orderId]);
        return $orderReferences->num_rows() > 0 ? $orderReferences->result() : [];
    }

    public function getPickupAndDeliveryStatuses(int $orderId): array
    {
        $this->db->select("o.order_id,o.shift_id,o.trip_id,s.status_code,s.createdon,o.user_id");
        $this->db->from("tb_stop_status s");
        $this->db->join("tb_orders o", "o.id=s.order_id", "LEFT");
        $this->db->where("o.id", $orderId);
        $this->db->where_in("s.status_code", ['0500', '2300']);
        $this->db->where("s.status", 1);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function insertOrUpdateContact(array $contactData): void
    {
        $this->db->select('id');
        $this->db->from('tbl_partner_contacts');
        $this->db->where('partner_id', $contactData['partner_id']);
        $this->db->where('name', $contactData['name']);
        $this->db->group_start();
        $this->db->or_where(['phone' => $contactData['phone'], 'email' => $contactData['email']]);
        $this->db->group_end();
        $this->db->where('status', 1);
        $this->db->order_by('id', "DESC");
        $this->db->limit(1);
        $getResult = $this->db->get();
        $contactId = $getResult->num_rows() > 0 ? $getResult->row()->id : 0;
        if ($contactId > 0) {
            $this->db->set(['name' => $contactData['name'], 'phone' => $contactData['phone'], 'email' => $contactData['email'],])->where(['id' => $contactId])->update('tbl_partner_contacts');
        } else {
            $this->db->insert('tbl_partner_contacts', $contactData);
        }
    }

    public function getCustomerGroupEmailIds(int $customerId): array
    {
        $this->db->select("p.group_email_ids");
        $this->db->from("tbl_party_master p");
        $this->db->join("tb_customers c", "c.partner_id=p.id", "INNER");
        $this->db->where("c.id", $customerId);
        $this->db->where("p.status", 1);
        $this->db->where('p.group_email_ids is NOT NULL', NULL, FALSE);
        $this->db->limit(1);
        $getResult = $this->db->get();
        if($getResult->num_rows() > 0){
            $emailIds = explode(",", $getResult->row()->group_email_ids);
        }
        return $emailIds ?? [];
    }

    public function getSALOGDocumentTypesIds(string $companyCode): array {
        $allDocumentTypesIds = [];
        if (checkAccessConditions('CHECK_SALOG_DOCUMENT_COUNTRY', $companyCode)) {
            $documentTypes = $this->getCompanyWiseSALOGDocsTypes($companyCode);
            if ($documentTypes) {
                $documentTypes = explode(',', $documentTypes);
                array_walk($documentTypes, function(&$value, $key) { $value = 'KN-'.$value; } );
                $getResult = $this->db->select('id')->where_in('document_id', $documentTypes)->get('tb_document_types');
                if ($getResult->num_rows() > 0) {
                    $allDocumentTypesIds = array_column($getResult->result_array(), 'id');
                }
            }
        }
        return $allDocumentTypesIds;
    }

    public function getSALOGSpecificDocumentTypesIds(string $condition): array {
        $allDocumentTypesIds = [];
        $this->load->model('Roadlogtosalogmodel','salog_m');
        $documentTypes = $this->salog_m->getSALOGOrderTypeDocTypes($condition);
        if ($documentTypes) {
            $documentTypes = explode(',', $documentTypes);
            array_walk($documentTypes, function(&$value, $key) { $value = 'KN-'.$value; } );
            $getResult = $this->db->select('id')->where_in('document_id', $documentTypes)->get('tb_document_types');
            if ($getResult->num_rows() > 0) {
                $allDocumentTypesIds = array_column($getResult->result_array(), 'id');
            }
        }
        return $allDocumentTypesIds;
    }

    public function getCompanyWiseSALOGDocsTypes(string $companyCode): string {
        $documentTypes = "";
        $getResult = $this->db->query("SELECT document_types FROM salog_country_wise_document_types WHERE company_code = ? ", [$companyCode]);
        return $getResult->num_rows() > 0 ? $getResult->row()->document_types : "";
    }

    public function deleteExistingSALOGDocs(int $orderId, array $ids = []): int {
        if (!empty($ids) && $this->db->where(['order_id'=>$orderId])->where_in('doc_type',$ids)->delete('tb_pod_uploads')) {
            return 1;
        }
        return 0;
    }

    public function getRecentSALOGOrders(): array {
        $getResults = $this->db->query("
            SELECT
                o.id,
                o.company_code,
                o.branch_code,
                r.ref_value
            FROM
                tb_orders o
            INNER JOIN tb_order_references r ON (o.id = r.order_id)
            WHERE
                o.created_source = ? AND o.createdon > DATE_SUB(NOW(), INTERVAL 20 MINUTE) AND r.reference_id = ?
            ", [5, 'XSR']);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getUpdatedSALOGOrders(): array {
        $getResults = $this->db->query("
            SELECT
                o.id,
                o.company_code,
                o.branch_code,
                r.ref_value
            FROM
                tb_orders o
            INNER JOIN tb_order_references r ON (o.id = r.order_id)
            INNER JOIN salog_updated_orders s ON (o.id = s.order_row_id)
            WHERE
                o.created_source = ? AND r.reference_id = ?
            ", [5, 'XSR']);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getSpecificSALOGDocTypes(): array {
        $getResult = $this->db->query("SELECT `condition` FROM access_conditions WHERE title = ? ", ['DOWNLOAD_SALOG_SPECIFIC_DOCS']);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function checkDocumentDownloadStatus(int $orderId, string $documentType): int {
        $getResult = $this->db->query("
            SELECT
              pu.order_id
            FROM
              `tb_pod_uploads` pu
              INNER JOIN tb_document_types dt ON (dt.id = pu.doc_type)
            WHERE
              pu.order_id = ? AND dt.document_id = ?", [$orderId, 'KN-'.$documentType]);
        return $getResult->num_rows() > 0 ? 1 : 0;
    }

    public function getSALOGOrderRequestType(int $orderId): string {
        $getResult = $this->db->query("SELECT o.ref_value FROM  `tb_order_references` o
            WHERE
              o.order_id = ? AND o.reference_id = ? AND o.ref_value IN ? ORDER BY o.id DESC LIMIT ?", [$orderId, 'SDT',['PUP','DEL'], 1]);
        return $getResult->num_rows() === 1 ? $getResult->row()->ref_value : '';
    }

    public function getSALOGOrderTypeDocTypes(string $DocumentTitle): string {
        $getResult = $this->db->query("SELECT `condition` FROM access_conditions WHERE title = ? ", [$DocumentTitle]);
        return $getResult->num_rows() > 0 ? $getResult->row()->condition : '';
    }

    public function getOrderIdsWithSalogDqAndXsrValue(string $xsr, string $dq): array
    {
        $sql = $this->db->query(
            "SELECT
                  order_id,
                  reference_id,
                  ref_value
                FROM
                  tb_order_references
                WHERE
                  ref_value IN ?
                  and reference_id IN ? AND status = 1"
            ,[[$xsr, $dq], ['DQ', 'XSR']] );
        if ($sql->num_rows() > 0) {
            foreach ($sql->result_array() as $row) {
                $data[$row['order_id']][$row['reference_id']] = $row['ref_value'];
            }
        }
        return $data ?? [];
    }

    public function getCarrierEmailId(string $bookingId): array
    {
        $query = $this->db->query("SELECT v.email FROM tb_vendors v,tb_orders o WHERE o.vendor_id = v.id AND o.order_id = ?", [$bookingId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getCountryTimeZoneByUserId(int $userId): string
    {
        $query = $this->db->query("SELECT c.cntry_timezone FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id= ? AND c.status=1 LIMIT 1", [$userId]);
        return $query->num_rows() > 0 ? $query->row()->cntry_timezone : '';
    }

    public function checkOrderStatus(int $orderId): int
    {
        $statusResult = $this->db->query("SELECT id FROM tb_stop_status WHERE order_id = ? AND status_code='1075'", [$orderId]);
        return $statusResult->num_rows() ?? 0;
    }

    public function getRoadlogOrderDetails(int $orderid, string $documentType): array
    {
        $getResults = $this->db->query("SELECT  o.id,o.order_id,u.country_code,o.company_code,o.branch_code,o.shift_id,o.trip_id,te.`stop_id`,te.`drop_stopid`,o.created_source,d.type_name,o.user_id,p.`imgpath` FROM tb_orders o LEFT JOIN tb_pod_uploads  p ON p.order_id=o.id LEFT JOIN  `tb_document_types` d ON d.id=p.`doc_type` LEFT JOIN tb_users u ON o.user_id=u.id LEFT OUTER JOIN `tb_employee` te ON o.order_id=te.order_id WHERE o.id=? AND p.status=1 AND d.type_name = ?", [$orderid, $documentType]);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }
}
