<?php


class Scheduledjob extends CI_Model
{
    private static $instance;

    /** @var int $id */
    private $id;

    private const TABLE_NAME = 'scheduled_job';

    /**
     * @return Scheduledjob
     */
    public static function &instance(): ScheduledJob
    {
        if (!self::$instance) {
            self::$instance = new ScheduledJob();
        }
        return self::$instance;
    }

    /**
     * @param string $scheduledJobName
     */
    public function setScheduledJobName(string $scheduledJobName): void
    {
        $queryBuilder = $this->db->select('id')->from(self::TABLE_NAME)->where('name', $scheduledJobName);
        $result = $queryBuilder->get()->result();

        if (empty($result)) {
            $this->db->insert(self::TABLE_NAME, ['name' => $scheduledJobName]);
            $this->id = $this->db->insert_id();
        } else {
            $this->id = $result[0]->id;
        }
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }
}
