<?php


class Scheduledjobhistory extends CI_Model
{
    private const TABLE_NAME = 'scheduled_job_history';
    public const STATUS_INIT = 'initilized';
    public const STATUS_RUNNING = 'running';
    public const STATUS_SUCCESS = 'success';
    public const STATUS_FAILED = 'failed';

    /** @var int $id */
    private $id;

    public function createScheduledJobHistory(int $scheduledJobId): self
    {
        if ($scheduledJobId > 0) {
            $this->db->insert(self::TABLE_NAME, ['scheduled_job_id' => $scheduledJobId, "status" => self::STATUS_INIT]);
            $this->id = $this->db->insert_id();
        }

        return $this;
    }

    /**
     * @param string $start_time as "Y-m-d H:i:s"
     * @return bool
     * @throws Exception
     */
    public function setStartTime(string $start_time): bool
    {
        if(!$this->update(["start_time" => $start_time, "status" => self::STATUS_RUNNING])){
            throw new \Exception("ERROR: Scheduledjobhistory::setStartTime | update() went wrong");
        }
        return true;
    }

    /**
     * @param string $end_time as "Y-m-d H:i:s"
     * @param string $status
     * @return bool
     * @throws Exception
     */
    public function setEndTime(string $end_time, string $status = self::STATUS_SUCCESS): bool
    {
        if(!$this->update(["end_time" => $end_time, "status" => $status])){
            throw new \Exception("ERROR: Scheduledjobhistory::setEndTime | update() went wrong");
        }
        return true;
    }

    /**
     * @param array $data
     * @return bool
     */
    private function update(array $data): bool
    {
        return $this->db->where('id', $this->id)->update(self::TABLE_NAME, $data);
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param $before_date
     * @return object
     */
    public function getMaxIdFromOldJobs($before_date): object
    {
        return $this->db->select_max('id')->get_where(self::TABLE_NAME, 'start_time < ' . $this->db->escape($before_date));
    }

    /**
     * @param string $highestId
     * @return bool|int
     * @throws Exception
     */
    public function massdelete(string $highestId): bool
    {
        if (!$this->db->where('id <=', $highestId)->delete(self::TABLE_NAME)) {
            throw new \Exception("ERROR: Scheduledjobhistory::massdelete | massdelete of scheduled job history went wrong");
        }
        return true;
    }
}
