<?php  defined('BASEPATH') OR exit('No direct script access allowed');

class Shippeomodel extends CI_Model
{
    public function updateTrip(string $shipment_id, string $vehicle_id, int $driver_id, string $curdt, string $curtzs, string $stime): bool
    {
        $driverwhr = ['id' => $driver_id, 'status' => 1];
        $chknum = $this->db->select("contact_num")->get_where("tb_truck_drivers", $driverwhr, 1, 0);
        $contact_num = $chknum->row()->contact_num;
        $checkshifts = $this->db->select("id")->get_where(
            "tb_trips",
            [
                'shift_id' => $shipment_id
            ],
            1,
            0
        );
        if ($checkshifts->num_rows() == 0) {
            $triparr = [
                'shift_id' => $shipment_id,
                'vehicle_id' => $vehicle_id,
                'driver_id' => $driver_id,
                'stime' => $stime,
                'start_imei' => $contact_num,
                'splace' => "",
                'eplace' => "",
                'start_reading' => 0,
                'end_reading' => 0,
                'created_on' => $curdt,
                'updated_on' => $curdt,
                'status' => 1,
                'trip_type' => 0,
                'transit_status' => 0,
            ];
            $trip_id = $this->db->insert("tb_trips", $triparr);

            $whr1 = ['shift_id' => $shipment_id, 'vehicle_id' => $vehicle_id, 'status' => 1];
            $chktrips = $this->db->select("id")->get_where("tb_trips", $whr1, 1, 0);
            $trip_id = $chktrips->row()->id;
            $whr = ["shift_id" => $shipment_id,];
            $set = ["trip_id" => $trip_id];
            $upd = $this->db->set($set)->where($whr)->update("tb_orders");

            $where = ['shift_id' => $shipment_id, 'trip_id' => $trip_id];
            $chkorders = $this->db->select("id, order_id")->get_where("tb_orders", $where, 1, 0);
            $chkorders = $chkorders->row();
            $order_id  = $chkorders->id;
            $bookingId = $chkorders->order_id;
            $getActualDate = getdatetimebytimezone(DFLT_TZ, $curdt, $curtzs);
            $driverAcceptanceDate = $getActualDate['datetime'];
            $data = [
                'order_id' => $order_id,
                "shipment_id" => $shipment_id,
                "stop_id" => 0,
                "stop_detail_id" => 0,
                "stop_type" => "",
                "trip_id" => $trip_id,
                "status_id" => 10,
                "latitude" => "",
                "longitude" => "",
                "status" => 1,
                "reason" => "From Admin",
                "vehicle_id" => $vehicle_id,
                "driver_id" => $driver_id,
                "status_code" => '0212',
                "createdon" => $driverAcceptanceDate,
            ];
            $ins = $this->db->insert("tb_stop_status", $data);

            $this->load->library('Standard_status_execution');
            try {
                $statusPayload = [
                    "trip" => $trip_id,
                    "ship" => $shipment_id,
                    "ord_id" => $order_id,
                    "orderid" => $bookingId,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "stop_type" => "P",
                    "timezone" => $curtzs,
                    "sts_date" => $driverAcceptanceDate,
                    "status_code" => "0212"
                ];
                $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
            }

            if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code')))
            {
                $this->load->library('Wechat');
                $this->wechat->orderId = $bookingId;
                $this->wechat->sendNotificationsToWeChat();
            }
            $this->triggerShippeoPairmeanIfOrderExists($shipment_id, $vehicle_id, $driver_id, $curtzs);
        } else {
            $whr = ["id" => $checkshifts->row()->id];
            $set = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id ];
            $this->db->set($set)->where($whr)->update("tb_trips");

            $whr = ["shift_id" => $shipment_id,];
            $set = ["trip_id" => $checkshifts->row()->id];
            $upd = $this->db->set($set)->where($whr)->update("tb_orders");
        }
        return true;
    }

    public function triggerShippeoPairmeanIfOrderExists(string $shipment_id, string $vehicle_id, string $driver_id, string $curtzs): bool
    {
        $chkorders = $this->db->select("id,order_id,trip_id,company_code,branch_code,user_id")->get_where(
            "tb_orders",
            ["shift_id" => $shipment_id],
            1,
            0
        );
        if ($chkorders->row()->trip_id != 0) {
            $postdata = [
                "shipment_id" => $shipment_id,
                "trip_id" => $chkorders->row()->trip_id,
                "driver_id" => $driver_id,
                "stop_id" => 0,
                "order_id" => $chkorders->row()->order_id,
                "inc_id" => 0,
                "pod_type" => '',
                "stop_type" => '',
                "vehicle_id" => $vehicle_id,
                "curtz" => $curtzs,
                "status_code" => '0212',
                "ord_id" => $chkorders->row()->id,
            ];
            $edi_reference = $this->shippeostatusintigration->is_shippeo_order(
                $chkorders->row()->id,
                $chkorders->row()->company_code,
                $chkorders->row()->branch_code
            );
            if ($edi_reference != 0) {
                $stid = 10;
                $stype = "P";
                $sts = $this->shippeostatusintigration->shippeo_event_call(
                    $chkorders->row()->id,
                    $postdata,
                    $curtzs,
                    $stid,
                    $stype,
                    $vehicle_id,
                    $edi_reference,
                    $chkorders->row()->company_code,
                    $chkorders->row()->branch_code,
                    $chkorders->row()->user_id
                );
            }
        }
       return true;
    }

}
