<?php
namespace App\Models;

use App\PodUploads\Constants\DocumentType;
use CI_Model;

class Signature extends CI_Model
{
    private ?object $model;

    public function fetchByOrderId(int $order_id): bool {
        $query = $this->db->query("SELECT *
        FROM tb_pod_uploads
        WHERE
            stop_type ='D'
            AND doc_type= ?
            AND order_id = ?", [
                DocumentType::SIGNATURE, $order_id
        ]);

        $this->model = $query->row();

        return (bool)$query->num_rows();
    }

    public function getHash(): string {
        return $this->model->hash ?? '';
    }

    public function getFilename(): string {
        return $this->model->imgpath ?? '';
    }
}
